/*
 * Decompiled with CFR 0.152.
 */
package cfca.util.api;

import cfca.asn1.parser.ASN1Node;
import cfca.asn1.parser.EnvelopFileParser;
import cfca.internal.tool.ASN1Parser;
import cfca.org.bouncycastle.asn1.ASN1Sequence;
import cfca.org.bouncycastle.asn1.ASN1Set;
import cfca.org.bouncycastle.asn1.DEROctetString;
import cfca.org.bouncycastle.asn1.DERTaggedObject;
import cfca.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.org.bouncycastle.asn1.cms.EnvelopedData;
import cfca.org.bouncycastle.cms.CMSEnvelopedData;
import cfca.org.bouncycastle.util.encoders.Hex;
import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cfca.sm2rsa.common.PKIException;
import cfca.system.Debugger;
import cfca.util.Base64;
import cfca.util.api.EnvelopeRecipientInfo;
import cfca.util.api.PublicKeyType;
import cfca.util.api.StringHelper;
import java.io.File;

public final class EnvelopeHelper {
    static final Logger logger = LoggerFactory.getLogger(EnvelopeHelper.class);

    public static EnvelopeRecipientInfo getEnvelopeMessageRecipient(byte[] base64EnvelopedData) throws PKIException {
        byte[] bEnvelop = null;
        if (base64EnvelopedData == null) {
            throw new PKIException("null not allowed for base64EnvelopedData");
        }
        try {
            bEnvelop = ASN1Parser.isBase64Encode(base64EnvelopedData) ? Base64.decode(base64EnvelopedData) : base64EnvelopedData;
            CMSEnvelopedData cmsEnData = new CMSEnvelopedData(bEnvelop);
            ContentInfo info = cmsEnData.toASN1Structure();
            EnvelopedData enData = EnvelopedData.getInstance(info.getContent());
            ASN1Set receivers = enData.getRecipientInfos();
            return EnvelopeHelper.getRecipientInfo(receivers);
        }
        catch (Exception e) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getEnvelopeMessageRecipient<<<<<<Failure");
            buffer.append("\n base64EnvelopedData: ");
            buffer.append(Debugger.dump(base64EnvelopedData));
            logger.error(buffer.toString());
            logger.error("Failure:", e);
            throw new PKIException("850645", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u4e2d\u7684\u660e\u6587\u5931\u8d25", e);
        }
    }

    public static EnvelopeRecipientInfo getEnvelopeFileRecipient(String envelopedFilePath) throws PKIException {
        if (StringHelper.isEmpty(envelopedFilePath)) {
            throw new PKIException("null not allowed for envelopedFilePath");
        }
        try {
            EnvelopFileParser parser = new EnvelopFileParser(new File(envelopedFilePath));
            parser.parser();
            ASN1Node receiver_node = parser.getReceiver_node();
            ASN1Set receivers = ASN1Set.getInstance(receiver_node.getData());
            return EnvelopeHelper.getRecipientInfo(receivers);
        }
        catch (Exception e) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("getEnvelopeFileRecipient<<<<<<Failure");
            buffer.append("\n envelopedFilePath: ");
            buffer.append(envelopedFilePath);
            logger.error(buffer.toString());
            logger.error("Failure:", e);
            throw new PKIException("850645", "\u89e3\u6790\u6570\u5b57\u4fe1\u5c01\u4e2d\u7684\u660e\u6587\u5931\u8d25", e);
        }
    }

    private static EnvelopeRecipientInfo getRecipientInfo(ASN1Set receivers) throws Exception {
        ASN1Sequence publickeyIdentifier = (ASN1Sequence)receivers.getObjectAt(0);
        DERTaggedObject publickey = (DERTaggedObject)publickeyIdentifier.getObjectAt(1);
        DEROctetString publidkeyiden = (DEROctetString)publickey.getObject();
        String subjectKID = new String(Hex.encode(publidkeyiden.getOctets()));
        ASN1Sequence identifier = (ASN1Sequence)publickeyIdentifier.getObjectAt(2);
        String publicKeyOID = identifier.getObjectAt(0).toString();
        int recipientPublicKeyType = PKCSObjectIdentifiers.SM2_pubKey_encrypt.equals(identifier.getObjectAt(0)) ? PublicKeyType.SM2.keyTypeID : PublicKeyType.RSA.keyTypeID;
        return new EnvelopeRecipientInfo(subjectKID, publicKeyOID, recipientPublicKeyType);
    }
}

