/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.apple.pay;

import cmbc.cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cmbc.cfca.org.bouncycastle.crypto.ExtendedDigest;
import cmbc.cfca.org.bouncycastle.crypto.Signer;
import cmbc.cfca.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cmbc.cfca.org.bouncycastle.crypto.signers.DSADigestSigner;
import cmbc.cfca.org.bouncycastle.crypto.signers.ECDSASigner;
import cmbc.cfca.org.bouncycastle.crypto.util.PublicKeyFactory;
import cmbc.cfca.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import cmbc.cfca.org.bouncycastle.operator.OperatorCreationException;
import cmbc.cfca.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import cmbc.cfca.org.bouncycastle.operator.bc.BcDefaultDigestProvider;
import java.io.IOException;

class BcECDSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    BcECDSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmFinder) {
        this.digestAlgorithmFinder = digestAlgorithmFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier sigAlgId) throws OperatorCreationException {
        AlgorithmIdentifier digAlg = this.digestAlgorithmFinder.find(sigAlgId);
        ExtendedDigest dig = BcDefaultDigestProvider.INSTANCE.get(digAlg);
        return new DSADigestSigner(new ECDSASigner(), dig);
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo publicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(publicKeyInfo);
    }
}

