/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.internal.tool;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileUtil {
    public static byte[] getBytesFromFile(String filePath) throws Exception {
        byte[] keyhex = null;
        BufferedInputStream stream = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filePath);
            stream = new BufferedInputStream(fis);
            int len = stream.available();
            if (len > 0x3700000) {
                throw new IOException("file is too big!");
            }
            keyhex = new byte[len];
            stream.read(keyhex, 0, len);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
        return keyhex;
    }

    public static void writeBytesToFile(byte[] sourceData, String filePath) throws IOException {
        FileOutputStream stream = null;
        try {
            File f = new File(filePath);
            if (!f.exists()) {
                f.createNewFile();
            }
            stream = new FileOutputStream(filePath);
            stream.write(sourceData);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void writeBytesToFile(byte[] data, int offSet, int len, OutputStream os) throws IOException {
        if (os != null) {
            os.write(data, offSet, len);
        }
    }
}

