/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.internal.tool;

import cmbc.cfca.sm2rsa.common.PKIException;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.security.KeyStore;

public class InitKeyStore {
    public static KeyStore initPKCS12KeyStore(byte[] pfxData, String pfxPWD) throws Exception {
        if (pfxData == null) {
            throw new IllegalArgumentException("null not allowed for pfxData");
        }
        KeyStore keystore = null;
        ByteArrayInputStream bis = null;
        try {
            keystore = KeyStore.getInstance("PKCS12");
            char[] nPassword = null;
            nPassword = pfxPWD == null || pfxPWD.trim().equals("") ? null : pfxPWD.toCharArray();
            bis = new ByteArrayInputStream(pfxData);
            keystore.load(bis, nPassword);
            KeyStore keyStore = keystore;
            return keyStore;
        }
        catch (Exception e) {
            throw new PKIException("can not init the PKCS12 keyStore:" + e.getMessage());
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static KeyStore initJKSKeyStore(String jksFilePath, String jksFilePass) throws Exception {
        if (jksFilePath == null) {
            throw new IllegalArgumentException("null not allowed for jksFilePath");
        }
        if (jksFilePass == null) {
            throw new IllegalArgumentException("null not allowed for jksFilePass");
        }
        FileInputStream fin = null;
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            fin = new FileInputStream(jksFilePath);
            char[] password = jksFilePass.toCharArray();
            ks.load(fin, password);
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            throw new PKIException("can not get the JKS keyStore:" + e.getMessage());
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

