/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.cert.ocsp;

import cmbc.cfca.org.bouncycastle.asn1.ASN1Exception;
import cmbc.cfca.org.bouncycastle.asn1.ASN1InputStream;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Primitive;
import cmbc.cfca.org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import cmbc.cfca.org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.asn1.ocsp.OCSPResponse;
import cmbc.cfca.org.bouncycastle.asn1.ocsp.ResponseBytes;
import cmbc.cfca.org.bouncycastle.cert.CertIOException;
import cmbc.cfca.org.bouncycastle.cert.ocsp.BasicOCSPResp;
import cmbc.cfca.org.bouncycastle.cert.ocsp.OCSPException;
import java.io.IOException;

public class OCSPResp {
    private OCSPResponse resp;

    public OCSPResp(OCSPResponse resp) {
        this.resp = resp;
    }

    public OCSPResp(byte[] resp) throws IOException {
        this(new ASN1InputStream(resp));
    }

    private OCSPResp(ASN1InputStream aIn) throws IOException {
        try {
            this.resp = OCSPResponse.getInstance(aIn.readObject());
        }
        catch (IllegalArgumentException e) {
            throw new CertIOException("malformed response: " + e.getMessage(), e);
        }
        catch (ClassCastException e) {
            throw new CertIOException("malformed response: " + e.getMessage(), e);
        }
        catch (ASN1Exception e) {
            throw new CertIOException("malformed response: " + e.getMessage(), e);
        }
    }

    public int getStatus() {
        return this.resp.getResponseStatus().getValue().intValue();
    }

    public Object getResponseObject() throws OCSPException {
        ResponseBytes rb = this.resp.getResponseBytes();
        if (rb == null) {
            return null;
        }
        if (rb.getResponseType().equals(OCSPObjectIdentifiers.id_pkix_ocsp_basic)) {
            try {
                ASN1Primitive obj = ASN1Primitive.fromByteArray(rb.getResponse().getOctets());
                return new BasicOCSPResp(BasicOCSPResponse.getInstance(obj));
            }
            catch (Exception e) {
                throw new OCSPException("problem decoding object: " + e, e);
            }
        }
        return rb.getResponse();
    }

    public byte[] getEncoded() throws IOException {
        return this.resp.getEncoded();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OCSPResp)) {
            return false;
        }
        OCSPResp r = (OCSPResp)o;
        return this.resp.equals(r.resp);
    }

    public int hashCode() {
        return this.resp.hashCode();
    }
}

