/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.cms;

import cmbc.cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cmbc.cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Set;
import cmbc.cfca.org.bouncycastle.asn1.ASN1TaggedObject;
import cmbc.cfca.org.bouncycastle.asn1.BERSequenceGenerator;
import cmbc.cfca.org.bouncycastle.asn1.BERTaggedObject;
import cmbc.cfca.org.bouncycastle.asn1.DERInteger;
import cmbc.cfca.org.bouncycastle.asn1.DERSet;
import cmbc.cfca.org.bouncycastle.asn1.cms.AttributeTable;
import cmbc.cfca.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.asn1.cms.SignerInfo;
import cmbc.cfca.org.bouncycastle.cms.CMSAttributeTableGenerator;
import cmbc.cfca.org.bouncycastle.cms.CMSException;
import cmbc.cfca.org.bouncycastle.cms.CMSProcessable;
import cmbc.cfca.org.bouncycastle.cms.CMSSignedGenerator;
import cmbc.cfca.org.bouncycastle.cms.CMSSignedHelper;
import cmbc.cfca.org.bouncycastle.cms.CMSStreamException;
import cmbc.cfca.org.bouncycastle.cms.CMSUtils;
import cmbc.cfca.org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import cmbc.cfca.org.bouncycastle.cms.SignerInfoGenerator;
import cmbc.cfca.org.bouncycastle.cms.SignerInformation;
import cmbc.cfca.org.bouncycastle.cms.SimpleAttributeTableGenerator;
import cmbc.cfca.org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import cmbc.cfca.org.bouncycastle.operator.ContentSigner;
import cmbc.cfca.org.bouncycastle.operator.OperatorCreationException;
import cmbc.cfca.org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import cmbc.cfca.org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;

public class CMSSignedDataStreamGenerator
extends CMSSignedGenerator {
    private int _bufferSize;

    public CMSSignedDataStreamGenerator() {
    }

    public CMSSignedDataStreamGenerator(SecureRandom rand) {
        super(rand);
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, digestOID, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, Provider sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, digestOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, sigProvider);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, encryptionOID, digestOID, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, Provider sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, encryptionOID, digestOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, sigProvider);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, digestOID, signedAttr, unsignedAttr, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr, Provider sigProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(key, cert, digestOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(signedAttr), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(unsignedAttr), sigProvider);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, encryptionOID, digestOID, signedAttr, unsignedAttr, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr, Provider sigProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(key, cert, encryptionOID, digestOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(signedAttr), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(unsignedAttr), sigProvider);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, digestOID, signedAttrGenerator, unsignedAttrGenerator, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, Provider sigProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(key, cert, this.getEncOID(key, digestOID), digestOID, signedAttrGenerator, unsignedAttrGenerator, sigProvider);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, cert, encryptionOID, digestOID, signedAttrGenerator, unsignedAttrGenerator, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, Provider sigProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(key, cert, encryptionOID, digestOID, signedAttrGenerator, unsignedAttrGenerator, sigProvider, sigProvider);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, digestOID, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, Provider sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, digestOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, sigProvider);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, encryptionOID, digestOID, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, Provider sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, encryptionOID, digestOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), (CMSAttributeTableGenerator)null, sigProvider);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, digestOID, signedAttr, unsignedAttr, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr, Provider sigProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, digestOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(signedAttr), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(unsignedAttr), sigProvider);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, digestOID, signedAttrGenerator, unsignedAttrGenerator, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, Provider sigProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, this.getEncOID(key, digestOID), digestOID, signedAttrGenerator, unsignedAttrGenerator, sigProvider);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, encryptionOID, digestOID, signedAttrGenerator, unsignedAttrGenerator, CMSUtils.getProvider(sigProvider));
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, Provider sigProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.addSigner(key, subjectKeyID, encryptionOID, digestOID, signedAttrGenerator, unsignedAttrGenerator, sigProvider, sigProvider);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, Provider sigProvider, Provider digProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.doAddSigner(key, cert, encryptionOID, digestOID, signedAttrGenerator, unsignedAttrGenerator, sigProvider, digProvider);
    }

    private void doAddSigner(PrivateKey key, Object signerId, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, Provider sigProvider, Provider digProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        JcaContentSignerBuilder signerBuilder;
        String digestName = CMSSignedHelper.INSTANCE.getDigestAlgName(digestOID);
        String signatureName = digestName + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(encryptionOID);
        try {
            signerBuilder = new JcaContentSignerBuilder(signatureName).setSecureRandom(this.rand);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        if (sigProvider != null) {
            signerBuilder.setProvider(sigProvider);
        }
        try {
            JcaDigestCalculatorProviderBuilder calculatorProviderBuilder = new JcaDigestCalculatorProviderBuilder();
            if (digProvider != null && !digProvider.getName().equalsIgnoreCase("SunRsaSign")) {
                calculatorProviderBuilder.setProvider(digProvider);
            }
            JcaSignerInfoGeneratorBuilder builder = new JcaSignerInfoGeneratorBuilder(calculatorProviderBuilder.build());
            builder.setSignedAttributeGenerator(signedAttrGenerator);
            builder.setUnsignedAttributeGenerator(unsignedAttrGenerator);
            try {
                ContentSigner contentSigner = signerBuilder.build(key);
                if (signerId instanceof X509Certificate) {
                    this.addSignerInfoGenerator(builder.build(contentSigner, (X509Certificate)signerId));
                } else {
                    this.addSignerInfoGenerator(builder.build(contentSigner, (byte[])signerId));
                }
            }
            catch (OperatorCreationException e) {
                if (e.getCause() instanceof NoSuchAlgorithmException) {
                    throw (NoSuchAlgorithmException)e.getCause();
                }
                if (e.getCause() instanceof InvalidKeyException) {
                    throw (InvalidKeyException)e.getCause();
                }
            }
        }
        catch (OperatorCreationException e) {
            throw new NoSuchAlgorithmException("unable to create operators: " + e.getMessage());
        }
        catch (CertificateEncodingException e) {
            throw new IllegalStateException("unable to encode certificate");
        }
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGenerator, CMSAttributeTableGenerator unsignedAttrGenerator, Provider sigProvider, Provider digProvider) throws NoSuchAlgorithmException, InvalidKeyException {
        this.doAddSigner(key, subjectKeyID, encryptionOID, digestOID, signedAttrGenerator, unsignedAttrGenerator, sigProvider, digProvider);
    }

    public OutputStream open(OutputStream out) throws IOException {
        return this.open(out, false);
    }

    public OutputStream open(OutputStream out, boolean encapsulate) throws IOException {
        return this.open(CMSObjectIdentifiers.data, out, encapsulate);
    }

    public OutputStream open(OutputStream out, boolean encapsulate, OutputStream dataOutputStream) throws IOException {
        return this.open(CMSObjectIdentifiers.data, out, encapsulate, dataOutputStream);
    }

    public OutputStream open(OutputStream out, String eContentType, boolean encapsulate) throws IOException {
        return this.open(out, eContentType, encapsulate, null);
    }

    public OutputStream open(ASN1ObjectIdentifier eContentType, OutputStream out, boolean encapsulate) throws IOException {
        return this.open(eContentType, out, encapsulate, null);
    }

    public OutputStream open(OutputStream out, String eContentType, boolean encapsulate, OutputStream dataOutputStream) throws IOException {
        return this.open(new ASN1ObjectIdentifier(eContentType), out, encapsulate, dataOutputStream);
    }

    public OutputStream open(ASN1ObjectIdentifier eContentType, OutputStream out, boolean encapsulate, OutputStream dataOutputStream) throws IOException {
        BERSequenceGenerator sGen = new BERSequenceGenerator(out);
        sGen.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator sigGen = new BERSequenceGenerator(sGen.getRawOutputStream(), 0, true);
        sigGen.addObject(this.calculateVersion(eContentType));
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        for (SignerInformation signer : this._signers) {
            digestAlgs.add(CMSSignedHelper.INSTANCE.fixAlgID(signer.getDigestAlgorithmID()));
        }
        for (SignerInfoGenerator signerGen : this.signerGens) {
            digestAlgs.add(signerGen.getDigestAlgorithm());
        }
        sigGen.getRawOutputStream().write(new DERSet(digestAlgs).getEncoded());
        BERSequenceGenerator eiGen = new BERSequenceGenerator(sigGen.getRawOutputStream());
        eiGen.addObject(eContentType);
        OutputStream encapStream = encapsulate ? CMSUtils.createBEROctetOutputStream(eiGen.getRawOutputStream(), 0, true, this._bufferSize) : null;
        OutputStream contentStream = CMSUtils.getSafeTeeOutputStream(dataOutputStream, encapStream);
        OutputStream sigStream = CMSUtils.attachSignersToOutputStream(this.signerGens, contentStream);
        return new CmsSignedDataOutputStream(sigStream, eContentType, sGen, sigGen, eiGen);
    }

    void generate(OutputStream out, String eContentType, boolean encapsulate, OutputStream dataOutputStream, CMSProcessable content) throws CMSException, IOException {
        OutputStream signedOut = this.open(out, eContentType, encapsulate, dataOutputStream);
        if (content != null) {
            content.write(signedOut);
        }
        signedOut.close();
    }

    private DERInteger calculateVersion(ASN1ObjectIdentifier contentOid) {
        boolean otherCert = false;
        boolean otherCrl = false;
        boolean attrCertV1Found = false;
        boolean attrCertV2Found = false;
        if (this.certs != null) {
            for (Object obj : this.certs) {
                if (!(obj instanceof ASN1TaggedObject)) continue;
                ASN1TaggedObject tagged = (ASN1TaggedObject)obj;
                if (tagged.getTagNo() == 1) {
                    attrCertV1Found = true;
                    continue;
                }
                if (tagged.getTagNo() == 2) {
                    attrCertV2Found = true;
                    continue;
                }
                if (tagged.getTagNo() != 3) continue;
                otherCert = true;
            }
        }
        if (otherCert) {
            return new DERInteger(5);
        }
        if (this.crls != null) {
            for (Object obj : this.crls) {
                if (!(obj instanceof ASN1TaggedObject)) continue;
                otherCrl = true;
            }
        }
        if (otherCrl) {
            return new DERInteger(5);
        }
        if (attrCertV2Found) {
            return new DERInteger(4);
        }
        if (attrCertV1Found) {
            return new DERInteger(3);
        }
        if (this.checkForVersion3(this._signers)) {
            return new DERInteger(3);
        }
        if (!CMSObjectIdentifiers.data.equals(contentOid)) {
            return new DERInteger(3);
        }
        return new DERInteger(1);
    }

    private boolean checkForVersion3(List signerInfos) {
        Iterator it = signerInfos.iterator();
        while (it.hasNext()) {
            SignerInfo s = SignerInfo.getInstance(((SignerInformation)it.next()).toASN1Structure());
            if (s.getVersion().getValue().intValue() != 3) continue;
            return true;
        }
        return false;
    }

    private class CmsSignedDataOutputStream
    extends OutputStream {
        private OutputStream _out;
        private ASN1ObjectIdentifier _contentOID;
        private BERSequenceGenerator _sGen;
        private BERSequenceGenerator _sigGen;
        private BERSequenceGenerator _eiGen;

        public CmsSignedDataOutputStream(OutputStream out, ASN1ObjectIdentifier contentOID, BERSequenceGenerator sGen, BERSequenceGenerator sigGen, BERSequenceGenerator eiGen) {
            this._out = out;
            this._contentOID = contentOID;
            this._sGen = sGen;
            this._sigGen = sigGen;
            this._eiGen = eiGen;
        }

        public void write(int b) throws IOException {
            this._out.write(b);
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this._out.write(bytes, off, len);
        }

        public void write(byte[] bytes) throws IOException {
            this._out.write(bytes);
        }

        public void close() throws IOException {
            this._out.close();
            this._eiGen.close();
            CMSSignedDataStreamGenerator.this.digests.clear();
            if (CMSSignedDataStreamGenerator.this.certs.size() != 0) {
                ASN1Set certSet = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this.certs);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 0, certSet).getEncoded());
            }
            if (CMSSignedDataStreamGenerator.this.crls.size() != 0) {
                ASN1Set crlSet = CMSUtils.createBerSetFromList(CMSSignedDataStreamGenerator.this.crls);
                this._sigGen.getRawOutputStream().write(new BERTaggedObject(false, 1, crlSet).getEncoded());
            }
            ASN1EncodableVector signerInfos = new ASN1EncodableVector();
            for (SignerInfoGenerator sigGen : CMSSignedDataStreamGenerator.this.signerGens) {
                try {
                    signerInfos.add(sigGen.generate(this._contentOID));
                    byte[] calculatedDigest = sigGen.getCalculatedDigest();
                    CMSSignedDataStreamGenerator.this.digests.put(sigGen.getDigestAlgorithm().getAlgorithm().getId(), calculatedDigest);
                }
                catch (CMSException e) {
                    throw new CMSStreamException("exception generating signers: " + e.getMessage(), e);
                }
            }
            for (SignerInformation signer : CMSSignedDataStreamGenerator.this._signers) {
                signerInfos.add(signer.toASN1Structure());
            }
            this._sigGen.getRawOutputStream().write(new DERSet(signerInfos).getEncoded());
            this._sigGen.close();
            this._sGen.close();
        }
    }
}

