/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.crypto.util;

import cmbc.cfca.org.bouncycastle.asn1.ASN1Encodable;
import cmbc.cfca.org.bouncycastle.asn1.ASN1InputStream;
import cmbc.cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Primitive;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Sequence;
import cmbc.cfca.org.bouncycastle.asn1.DERInteger;
import cmbc.cfca.org.bouncycastle.asn1.nist.NISTNamedCurves;
import cmbc.cfca.org.bouncycastle.asn1.oiw.ElGamalParameter;
import cmbc.cfca.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.DHParameter;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import cmbc.cfca.org.bouncycastle.asn1.sec.ECPrivateKey;
import cmbc.cfca.org.bouncycastle.asn1.sec.SECNamedCurves;
import cmbc.cfca.org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import cmbc.cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.x509.DSAParameter;
import cmbc.cfca.org.bouncycastle.asn1.x9.X962NamedCurves;
import cmbc.cfca.org.bouncycastle.asn1.x9.X962Parameters;
import cmbc.cfca.org.bouncycastle.asn1.x9.X9ECParameters;
import cmbc.cfca.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cmbc.cfca.org.bouncycastle.crypto.params.DHParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.DSAParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.ECDomainParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.ElGamalParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import cmbc.cfca.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class PrivateKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] privateKeyInfoData) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(privateKeyInfoData)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inStr) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(new ASN1InputStream(inStr).readObject()));
    }

    public static AsymmetricKeyParameter createKey(PrivateKeyInfo keyInfo) throws IOException {
        AlgorithmIdentifier algId = keyInfo.getPrivateKeyAlgorithm();
        if (algId.getAlgorithm().equals(PKCSObjectIdentifiers.rsaEncryption)) {
            RSAPrivateKey keyStructure = RSAPrivateKey.getInstance(keyInfo.parsePrivateKey());
            return new RSAPrivateCrtKeyParameters(keyStructure.getModulus(), keyStructure.getPublicExponent(), keyStructure.getPrivateExponent(), keyStructure.getPrime1(), keyStructure.getPrime2(), keyStructure.getExponent1(), keyStructure.getExponent2(), keyStructure.getCoefficient());
        }
        if (algId.getAlgorithm().equals(PKCSObjectIdentifiers.dhKeyAgreement)) {
            DHParameter params = DHParameter.getInstance(algId.getParameters());
            DERInteger derX = (DERInteger)keyInfo.parsePrivateKey();
            BigInteger lVal = params.getL();
            int l = lVal == null ? 0 : lVal.intValue();
            DHParameters dhParams = new DHParameters(params.getP(), params.getG(), null, l);
            return new DHPrivateKeyParameters(derX.getValue(), dhParams);
        }
        if (algId.getAlgorithm().equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter params = new ElGamalParameter((ASN1Sequence)algId.getParameters());
            DERInteger derX = (DERInteger)keyInfo.parsePrivateKey();
            return new ElGamalPrivateKeyParameters(derX.getValue(), new ElGamalParameters(params.getP(), params.getG()));
        }
        if (algId.getAlgorithm().equals(X9ObjectIdentifiers.id_dsa)) {
            DERInteger derX = (DERInteger)keyInfo.parsePrivateKey();
            ASN1Encodable de = algId.getParameters();
            DSAParameters parameters = null;
            if (de != null) {
                DSAParameter params = DSAParameter.getInstance(de.toASN1Primitive());
                parameters = new DSAParameters(params.getP(), params.getQ(), params.getG());
            }
            return new DSAPrivateKeyParameters(derX.getValue(), parameters);
        }
        if (algId.getAlgorithm().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            X9ECParameters x9;
            X962Parameters params = new X962Parameters((ASN1Primitive)algId.getParameters());
            if (params.isNamedCurve()) {
                ASN1ObjectIdentifier oid = ASN1ObjectIdentifier.getInstance(params.getParameters());
                x9 = X962NamedCurves.getByOID(oid);
                if (x9 == null && (x9 = SECNamedCurves.getByOID(oid)) == null && (x9 = NISTNamedCurves.getByOID(oid)) == null) {
                    x9 = TeleTrusTNamedCurves.getByOID(oid);
                }
            } else {
                x9 = X9ECParameters.getInstance(params.getParameters());
            }
            ECPrivateKey ec = ECPrivateKey.getInstance(keyInfo.parsePrivateKey());
            BigInteger d = ec.getKey();
            ECDomainParameters dParams = new ECDomainParameters(x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
            return new ECPrivateKeyParameters(d, dParams);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }
}

