/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.jcajce.provider.symmetric;

import cmbc.cfca.org.bouncycastle.crypto.CipherKeyGenerator;
import cmbc.cfca.org.bouncycastle.crypto.engines.RijndaelEngine;
import cmbc.cfca.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cmbc.cfca.org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import cmbc.cfca.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cmbc.cfca.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import cmbc.cfca.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class Rijndael {
    private Rijndael() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = Rijndael.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.RIJNDAEL", PREFIX + "$ECB");
            provider.addAlgorithm("KeyGenerator.RIJNDAEL", PREFIX + "$KeyGen");
            provider.addAlgorithm("AlgorithmParameters.RIJNDAEL", PREFIX + "$AlgParams");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "Rijndael IV";
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Rijndael", 192, new CipherKeyGenerator());
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new RijndaelEngine());
        }
    }
}

