/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.math.ec;

import cmbc.cfca.org.bouncycastle.math.ec.AbstractECMultiplier;
import cmbc.cfca.org.bouncycastle.math.ec.ECAlgorithms;
import cmbc.cfca.org.bouncycastle.math.ec.ECCurve;
import cmbc.cfca.org.bouncycastle.math.ec.ECPoint;
import cmbc.cfca.org.bouncycastle.math.ec.ECPointMap;
import cmbc.cfca.org.bouncycastle.math.ec.endo.GLVEndomorphism;
import java.math.BigInteger;

public class GLVMultiplier
extends AbstractECMultiplier {
    protected final ECCurve curve;
    protected final GLVEndomorphism glvEndomorphism;

    public GLVMultiplier(ECCurve curve, GLVEndomorphism glvEndomorphism) {
        if (curve == null || curve.getOrder() == null) {
            throw new IllegalArgumentException("Need curve with known group order");
        }
        this.curve = curve;
        this.glvEndomorphism = glvEndomorphism;
    }

    protected ECPoint multiplyPositive(ECPoint p, BigInteger k) {
        if (!this.curve.equals(p.getCurve())) {
            throw new IllegalStateException();
        }
        BigInteger n = p.getCurve().getOrder();
        BigInteger[] ab = this.glvEndomorphism.decomposeScalar(k.mod(n));
        BigInteger a = ab[0];
        BigInteger b = ab[1];
        ECPointMap pointMap = this.glvEndomorphism.getPointMap();
        if (this.glvEndomorphism.hasEfficientPointMap()) {
            return ECAlgorithms.implShamirsTrickWNaf(p, a, pointMap, b);
        }
        return ECAlgorithms.implShamirsTrickWNaf(p, a, pointMap.map(p), b);
    }
}

