/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.operator.jcajce;

import cmbc.cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cmbc.cfca.org.bouncycastle.jcajce.DefaultJcaJceHelper;
import cmbc.cfca.org.bouncycastle.jcajce.NamedJcaJceHelper;
import cmbc.cfca.org.bouncycastle.jcajce.ProviderJcaJceHelper;
import cmbc.cfca.org.bouncycastle.operator.GenericKey;
import cmbc.cfca.org.bouncycastle.operator.OperatorException;
import cmbc.cfca.org.bouncycastle.operator.SymmetricKeyUnwrapper;
import cmbc.cfca.org.bouncycastle.operator.jcajce.OperatorHelper;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class JceSymmetricKeyUnwrapper
extends SymmetricKeyUnwrapper {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private SecretKey secretKey;

    public JceSymmetricKeyUnwrapper(AlgorithmIdentifier algorithmIdentifier, SecretKey secretKey) {
        super(algorithmIdentifier);
        this.secretKey = secretKey;
    }

    public JceSymmetricKeyUnwrapper setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceSymmetricKeyUnwrapper setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    public GenericKey generateUnwrappedKey(AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedKey) throws OperatorException {
        try {
            Cipher keyCipher = this.helper.createSymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm());
            keyCipher.init(4, this.secretKey);
            return new GenericKey(keyCipher.unwrap(encryptedKey, this.helper.getKeyAlgorithmName(encryptedKeyAlgorithm.getAlgorithm()), 3));
        }
        catch (InvalidKeyException e) {
            throw new OperatorException("key invalid in message.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OperatorException("can't find algorithm.", e);
        }
    }
}

