/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.pkcs;

import cmbc.cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.ASN1OctetString;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Set;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.Attribute;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.CRLBag;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.CertBag;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import cmbc.cfca.org.bouncycastle.asn1.pkcs.SafeBag;
import cmbc.cfca.org.bouncycastle.asn1.x509.Certificate;
import cmbc.cfca.org.bouncycastle.asn1.x509.CertificateList;
import cmbc.cfca.org.bouncycastle.cert.X509CRLHolder;
import cmbc.cfca.org.bouncycastle.cert.X509CertificateHolder;
import cmbc.cfca.org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;

public class PKCS12SafeBag {
    private SafeBag safeBag;

    public PKCS12SafeBag(SafeBag safeBag) {
        this.safeBag = safeBag;
    }

    public SafeBag toASN1Structure() {
        return this.safeBag;
    }

    public ASN1ObjectIdentifier getType() {
        return this.safeBag.getBagId();
    }

    public Attribute[] getAttributes() {
        ASN1Set attrs = this.safeBag.getBagAttributes();
        if (attrs == null) {
            return null;
        }
        Attribute[] attributes = new Attribute[attrs.size()];
        for (int i = 0; i != attrs.size(); ++i) {
            attributes[i] = Attribute.getInstance(attrs.getObjectAt(i));
        }
        return attributes;
    }

    public Object getBagValue() {
        if (this.getType().equals(PKCSObjectIdentifiers.pkcs8ShroudedKeyBag)) {
            return new PKCS8EncryptedPrivateKeyInfo(EncryptedPrivateKeyInfo.getInstance(this.safeBag.getBagValue()));
        }
        if (this.getType().equals(PKCSObjectIdentifiers.certBag)) {
            CertBag certBag = CertBag.getInstance(this.safeBag.getBagValue());
            return new X509CertificateHolder(Certificate.getInstance(ASN1OctetString.getInstance(certBag.getCertValue()).getOctets()));
        }
        if (this.getType().equals(PKCSObjectIdentifiers.keyBag)) {
            return PrivateKeyInfo.getInstance(this.safeBag.getBagValue());
        }
        if (this.getType().equals(PKCSObjectIdentifiers.crlBag)) {
            CRLBag crlBag = CRLBag.getInstance(this.safeBag.getBagValue());
            return new X509CRLHolder(CertificateList.getInstance(ASN1OctetString.getInstance(crlBag.getCRLValue()).getOctets()));
        }
        return this.safeBag.getBagValue();
    }
}

