/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.org.bouncycastle.util.encoders;

import cmbc.cfca.org.bouncycastle.util.encoders.HexEncoder;
import cmbc.cfca.sadk32.org.bouncycastle.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Hex {
    private static byte[] hexTable;

    public static String toHexString(byte[] data) {
        return Hex.toHexString(data, 0, data.length);
    }

    public static String toHexString(byte[] data, int off, int length) {
        byte[] encoded = Hex.encode(data, off, length);
        return Strings.fromByteArray(encoded);
    }

    public static byte[] encode(byte[] data) {
        return Hex.encode(data, 0, data.length);
    }

    public static byte[] encode(byte[] data, int off, int length) {
        HexEncoder encoder = new HexEncoder();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            encoder.encode(data, off, length, bOut);
        }
        catch (IOException e) {
            throw new RuntimeException("exception encoding Hex string: " + e);
        }
        return bOut.toByteArray();
    }

    public static int encode(byte[] data, OutputStream out) throws IOException {
        HexEncoder encoder = new HexEncoder();
        return encoder.encode(data, 0, data.length, out);
    }

    public static int encode(byte[] data, int off, int length, OutputStream out) throws IOException {
        HexEncoder encoder = new HexEncoder();
        return encoder.encode(data, off, length, out);
    }

    public static byte[] decode(byte[] data) {
        HexEncoder encoder = new HexEncoder();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            encoder.decode(data, 0, data.length, bOut);
        }
        catch (IOException e) {
            throw new RuntimeException("exception decoding Hex string: " + e);
        }
        return bOut.toByteArray();
    }

    public static byte[] decode(String data) {
        HexEncoder encoder = new HexEncoder();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            encoder.decode(data, bOut);
        }
        catch (IOException e) {
            throw new RuntimeException("exception decoding Hex string: " + e);
        }
        return bOut.toByteArray();
    }

    public static int decode(String data, OutputStream out) throws IOException {
        HexEncoder encoder = new HexEncoder();
        return encoder.decode(data, out);
    }

    public static boolean isHex(String hex) {
        if (hex == null) {
            return false;
        }
        boolean pass = true;
        char value = '\u0000';
        for (int i = 0; i < hex.length(); ++i) {
            value = hex.charAt(i);
            if (value < '\u0000' || value > '\u007f') {
                pass = false;
                break;
            }
            if (hexTable[value] != -1) continue;
            pass = false;
            break;
        }
        return pass;
    }

    static {
        int i;
        hexTable = new byte[128];
        for (i = 0; i < hexTable.length; ++i) {
            Hex.hexTable[i] = -1;
        }
        for (i = 48; i <= 57; ++i) {
            Hex.hexTable[i] = (byte)i;
        }
        for (i = 65; i <= 70; ++i) {
            Hex.hexTable[i] = (byte)i;
        }
        for (i = 97; i <= 102; ++i) {
            Hex.hexTable[i] = (byte)i;
        }
    }
}

