/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.sm2rsa.common;

import cmbc.cfca.internal.tool.Mechanism_Inside;
import cmbc.cfca.org.bouncycastle.asn1.ASN1Encodable;
import cmbc.cfca.org.bouncycastle.asn1.ASN1EncodableVector;
import cmbc.cfca.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cmbc.cfca.org.bouncycastle.asn1.DERNull;
import cmbc.cfca.org.bouncycastle.asn1.DEROctetString;
import cmbc.cfca.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cmbc.cfca.sadk32.org.bouncycastle.util.Arrays;
import cmbc.cfca.sm2rsa.common.CBCParam;
import cmbc.cfca.sm2rsa.common.PKCSObjectIdentifiers;
import cmbc.cfca.sm2rsa.common.PKIException;
import cmbc.cfca.system.SecureRandoms;
import java.util.HashMap;
import java.util.Map;

public final class SymmetricAlgorithm {
    public static final String RC4 = "RC4";
    public static final String SM4_CBC = "SM4/CBC/PKCS7Padding";
    public static final String SM4_ECB = "SM4/ECB/PKCS7Padding";
    private static final String AES_ECB = "AES/ECB/PKCS7Padding";
    private static final String AES_CBC = "AES/CBC/PKCS7Padding";
    public static final String DESede_CBC = "DESede/CBC/PKCS7Padding";
    public static final String DESede_ECB = "DESede/ECB/PKCS7Padding";
    private static final Map<String, ASN1ObjectIdentifier> MECH_OID = new HashMap<String, ASN1ObjectIdentifier>();

    private SymmetricAlgorithm() {
    }

    public static boolean isValidValue(String symmetricAlgorithm) {
        if (symmetricAlgorithm == null) {
            return false;
        }
        return MECH_OID.containsKey(symmetricAlgorithm);
    }

    public static final SymmetricAlgorithmParameters buildRSASymmetricAlgorithmParameters(String symmetricAlgorithm) throws Exception {
        AlgorithmIdentifier contentEncryptionAlgId;
        Mechanism_Inside contentEncryptionAlg;
        byte[] symmetricKey;
        if (DESede_CBC.equals(symmetricAlgorithm)) {
            byte[] keyAndIv = SecureRandoms.getInstance().genBytes(32);
            symmetricKey = Arrays.copyOfRange(keyAndIv, 0, 24);
            byte[] iv = Arrays.copyOfRange(keyAndIv, 24, 32);
            contentEncryptionAlg = new Mechanism_Inside(symmetricAlgorithm, new CBCParam(iv));
            contentEncryptionAlgId = new AlgorithmIdentifier(MECH_OID.get(symmetricAlgorithm), (ASN1Encodable)new DEROctetString(iv));
        } else if (DESede_ECB.equals(symmetricAlgorithm)) {
            symmetricKey = SecureRandoms.getInstance().genBytes(24);
            contentEncryptionAlg = new Mechanism_Inside(symmetricAlgorithm);
            contentEncryptionAlgId = new AlgorithmIdentifier(MECH_OID.get(symmetricAlgorithm), (ASN1Encodable)new DERNull());
        } else if (RC4.equals(symmetricAlgorithm)) {
            symmetricKey = SecureRandoms.getInstance().genBytes(16);
            contentEncryptionAlg = new Mechanism_Inside(symmetricAlgorithm);
            contentEncryptionAlgId = new AlgorithmIdentifier(MECH_OID.get(symmetricAlgorithm), (ASN1Encodable)new DERNull());
        } else {
            throw new PKIException("can not support this symetric algorithm:" + symmetricAlgorithm);
        }
        return new SymmetricAlgorithmParameters(contentEncryptionAlg, contentEncryptionAlgId, symmetricKey);
    }

    public static final SymmetricAlgorithmParameters buildSM2SymmetricAlgorithmParameters(String symmetricAlgorithm) throws Exception {
        AlgorithmIdentifier contentEncryptionAlgId;
        Mechanism_Inside contentEncryptionAlg;
        byte[] symmetricKey;
        if (SM4_CBC.equals(symmetricAlgorithm)) {
            byte[] keyAndIv = SecureRandoms.getInstance().genBytes(32);
            symmetricKey = Arrays.copyOfRange(keyAndIv, 0, 16);
            byte[] iv = Arrays.copyOfRange(keyAndIv, 16, 32);
            contentEncryptionAlg = new Mechanism_Inside(symmetricAlgorithm, new CBCParam(iv));
            contentEncryptionAlgId = new AlgorithmIdentifier(MECH_OID.get(symmetricAlgorithm), (ASN1Encodable)new DEROctetString(iv));
        } else if (SM4_ECB.equals(symmetricAlgorithm)) {
            symmetricKey = SecureRandoms.getInstance().genBytes(16);
            contentEncryptionAlg = new Mechanism_Inside(symmetricAlgorithm);
            contentEncryptionAlgId = new AlgorithmIdentifier(MECH_OID.get(symmetricAlgorithm), (ASN1Encodable)new DERNull());
        } else {
            throw new PKIException("can not support this symetric algorithm:" + symmetricAlgorithm);
        }
        return new SymmetricAlgorithmParameters(contentEncryptionAlg, contentEncryptionAlgId, symmetricKey);
    }

    static {
        MECH_OID.put(RC4, PKCSObjectIdentifiers.rc4Encryption);
        MECH_OID.put(SM4_CBC, PKCSObjectIdentifiers.SM4_CBC);
        MECH_OID.put(SM4_ECB, PKCSObjectIdentifiers.SM4_ECB);
        MECH_OID.put(AES_ECB, PKCSObjectIdentifiers.AES_CBC);
        MECH_OID.put(AES_CBC, PKCSObjectIdentifiers.AES_ECB);
        MECH_OID.put(DESede_CBC, PKCSObjectIdentifiers.des3CBCEncryption);
        MECH_OID.put(DESede_ECB, PKCSObjectIdentifiers.des3Encryption);
    }

    public static final class SymmetricAlgorithmParameters {
        public final Mechanism_Inside contentEncryptionAlg;
        public final AlgorithmIdentifier contentEncryptionAlgId;
        public final byte[] symmetricKey;
        public ASN1EncodableVector recipientInfos;

        public SymmetricAlgorithmParameters(Mechanism_Inside contentEncryptionAlg, AlgorithmIdentifier contentEncryptionAlgId, byte[] symmetricKey) {
            this.contentEncryptionAlg = contentEncryptionAlg;
            this.contentEncryptionAlgId = contentEncryptionAlgId;
            this.symmetricKey = symmetricKey;
        }
    }
}

