/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.system;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

final class SM2FormatConf {
    static final Logger logger = LoggerFactory.getLogger(SM2FormatConf.class);
    public static final boolean SM2EncryptedOutputRAWC1C2C3;
    public static final boolean SM2DecryptedCompatibleRAWC1C3C2;
    public static final boolean SM2SignedOutputWithoutZ;
    public static final boolean SM2VerifiedWithoutZCompatible;

    SM2FormatConf() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Properties loadFromFile() {
        Properties properties = new Properties();
        InputStream in = null;
        try {
            File primaryFile = new File("/etc/SM2Format.cfg");
            if (primaryFile.exists() && primaryFile.isFile()) {
                logger.debug("Loading SM2Format.cfg from AbsolutePath[have]: " + primaryFile.getAbsolutePath());
                in = new FileInputStream(primaryFile);
            } else {
                logger.debug("Loading SM2Format.cfg from AbsolutePath[none]: " + primaryFile.getAbsolutePath());
                File sencodaryFile = new File("config/SM2Format.cfg");
                if (sencodaryFile.exists() && sencodaryFile.isFile()) {
                    logger.debug("Loading SM2Format.cfg from RelativePath[have]: " + sencodaryFile.getAbsolutePath());
                    in = new FileInputStream(sencodaryFile);
                } else {
                    logger.debug("Loading SM2Format.cfg from AbsolutePath[none]: " + sencodaryFile.getAbsolutePath());
                    logger.debug("Loading SM2Format.cfg from  *.jar/SM2Format.cfg");
                    in = SM2FormatConf.class.getClassLoader().getResourceAsStream("SM2Format.cfg");
                    URL url = SM2FormatConf.class.getClassLoader().getResource("SM2Format.cfg");
                    if (in == null) {
                        logger.debug("Loading SM2Format.cfg from jarFile Failure: " + url);
                    } else {
                        logger.debug("Loading SM2Format.cfg from jarFile Success: " + url);
                    }
                }
            }
        }
        catch (Exception e) {
            in = null;
        }
        if (in == null) {
            logger.debug("Loading SM2Format.cfg failure from:");
            logger.debug("1. From AbsolutePath /etc/SM2Format.cfg");
            logger.debug("2. From RelativePath config/SM2Format.cfg");
            logger.debug("3. From jarFIle  *.jar/SM2Format.cfg");
        } else {
            try {
                properties.load(in);
            }
            catch (Exception e) {
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        return properties;
    }

    private static final boolean booleanFrom(Properties properties, String key, String defValue) {
        return "true".equalsIgnoreCase(properties.getProperty(key, defValue));
    }

    public static final String dump() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n CMBC-SADK CompatibleConfig:");
        buffer.append("\n###############################################");
        buffer.append("\n  SM2EncryptedOutputRAWC1C2C3=");
        buffer.append(SM2EncryptedOutputRAWC1C2C3);
        buffer.append("\n  SM2DecryptedCompatibleRAWC1C3C2=");
        buffer.append(SM2DecryptedCompatibleRAWC1C3C2);
        buffer.append("\n  SM2SignedOutputWithoutZ=");
        buffer.append(SM2SignedOutputWithoutZ);
        buffer.append("\n  SM2VerifiedWithoutZCompatible=");
        buffer.append(SM2VerifiedWithoutZCompatible);
        buffer.append("\n  SM2VerifiedFormatSignedBytes=");
        buffer.append("\n###############################################");
        return buffer.toString();
    }

    static {
        Properties properties = SM2FormatConf.loadFromFile();
        SM2EncryptedOutputRAWC1C2C3 = SM2FormatConf.booleanFrom(properties, "SM2EncryptedOutputRAWC1C2C3", "false");
        SM2DecryptedCompatibleRAWC1C3C2 = SM2FormatConf.booleanFrom(properties, "SM2DecryptedCompatibleRAWC1C3C2", "false");
        SM2SignedOutputWithoutZ = SM2FormatConf.booleanFrom(properties, "SM2SignedOutputWithoutZ", "false");
        SM2VerifiedWithoutZCompatible = SM2FormatConf.booleanFrom(properties, "SM2VerifyCompatibleWithoutZ", "false");
        if (logger.isDebugEnabled()) {
            logger.debug(SM2FormatConf.dump());
        }
    }
}

