/*
 * Decompiled with CFR 0.152.
 */
package cmbc.cfca.x509.certificate;

import cmbc.cfca.sm2rsa.common.PKIException;
import cmbc.cfca.x509.certificate.X509CRL;
import cmbc.cfca.x509.certificate.X509Cert;
import java.io.FileInputStream;

public final class X509CertHelper {
    public static X509Cert parse(byte[] certData) throws PKIException {
        return X509CertHelper.certFrom(certData);
    }

    public static X509Cert parse(String filePath) throws PKIException {
        return X509CertHelper.certFrom(filePath);
    }

    public static X509Cert certFrom(byte[] certData) throws PKIException {
        return new X509Cert(certData);
    }

    public static X509Cert certFrom(String certFilePath) throws PKIException {
        byte[] data = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(certFilePath);
            if (stream.available() < 80) {
                throw new PKIException("850311", "\u8f6c\u6362\u8bc1\u4e66\u5230X509Cert\u5931\u8d25: stream too small");
            }
            if (stream.available() > 1000000) {
                throw new PKIException("850311", "\u8f6c\u6362\u8bc1\u4e66\u5230X509Cert\u5931\u8d25: stream too large, limited by 1000000");
            }
            data = new byte[stream.available()];
            int dLength = 0;
            int rLength = 0;
            while (dLength < data.length) {
                rLength = stream.read(data, dLength, data.length - dLength);
                if (rLength <= 0) continue;
                dLength += rLength;
            }
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new PKIException("850311", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25", ex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
        }
        return new X509Cert(data);
    }

    public static X509CRL crlFrom(byte[] crlData) throws PKIException {
        return new X509CRL(crlData);
    }

    public static X509CRL crlFrom(String crlFilePath) throws PKIException {
        byte[] data = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(crlFilePath);
            if (stream.available() < 80) {
                throw new PKIException("850315", "\u8f6c\u6362\u8bc1\u4e66\u5230X509CRL\u5931\u8d25: stream too small");
            }
            if (stream.available() > 0x20000000) {
                throw new PKIException("850315", "\u8f6c\u6362\u8bc1\u4e66\u5230X509CRL\u5931\u8d25: stream too large, limited by 512M");
            }
            data = new byte[stream.available()];
            int dLength = 0;
            int rLength = 0;
            while (dLength < data.length) {
                rLength = stream.read(data, dLength, data.length - dLength);
                if (rLength <= 0) continue;
                dLength += rLength;
            }
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new PKIException("850315", "\u8f6c\u6362\u8bc1\u4e66\u5230X509CRL\u5931\u8d25", ex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
        }
        return new X509CRL(data);
    }
}

