/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api;

import com.icbc.api.IcbcApiException;
import com.icbc.api.IcbcClient;
import com.icbc.api.IcbcRequest;
import com.icbc.api.IcbcResponse;
import com.icbc.api.internal.apache.http.s;
import com.icbc.api.internal.util.StringUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.internal.util.internal.util.fastjson.JSONObject;
import com.icbc.api.utils.HttpClientUtils;
import com.icbc.api.utils.IcbcEncrypt;
import com.icbc.api.utils.IcbcHashMap;
import com.icbc.api.utils.IcbcSignature;
import com.icbc.api.utils.WebUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultIcbcClient
implements IcbcClient {
    private static final Log logger = LogFactory.getLog(DefaultIcbcClient.class);
    protected String appId;
    protected String privateKey;
    protected String signType = "RSA";
    protected String charset = "UTF-8";
    protected String format = "json";
    protected String icbcPulicKey;
    protected String encryptKey;
    protected String encryptType;
    protected String ca;
    protected String icbc_ca;
    protected boolean icbcCaConsistentChkFlag = false;
    protected String password;
    protected String emSignIp;
    protected String emSignPort;
    protected String emProduct;
    private String zoneNo = null;
    private String refineInfo = null;
    private Map<String, String> headerParams = new HashMap<String, String>();

    public DefaultIcbcClient(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        this.appId = string;
        this.signType = string2;
        this.privateKey = string3;
        this.charset = string4;
        this.format = string5;
        this.icbcPulicKey = string6;
        this.encryptType = string7;
        this.encryptKey = string8;
        this.password = string10;
        this.emSignIp = null;
        this.emSignPort = null;
        this.emProduct = null;
        if (string9 != null && !string9.equals("")) {
            Pattern pattern = Pattern.compile("\\s*|\t");
            Matcher matcher = pattern.matcher(string9);
            string9 = matcher.replaceAll("");
        }
        this.ca = string9;
    }

    public DefaultIcbcClient(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13) {
        this.appId = string;
        this.signType = string2;
        this.privateKey = string3;
        this.charset = string4;
        this.format = string5;
        this.icbcPulicKey = string6;
        this.encryptType = string7;
        this.encryptKey = string8;
        this.password = string10;
        this.emSignIp = string11;
        this.emSignPort = string12;
        this.emProduct = string13;
        if (string9 != null && !string9.equals("")) {
            Pattern pattern = Pattern.compile("\\s*|\t");
            Matcher matcher = pattern.matcher(string9);
            string9 = matcher.replaceAll("");
        }
        this.ca = string9;
    }

    public DefaultIcbcClient(String string, String string2, String string3) {
        this(string, "RSA", string2, "UTF-8", "json", string3, null, null, null, null, null, null, null);
    }

    public DefaultIcbcClient(String string, String string2, String string3, String string4) {
        this(string, string2, string3, "UTF-8", "json", string4, null, null, null, null, null, null, null);
    }

    public DefaultIcbcClient(String string, String string2, String string3, String string4, String string5) {
        this(string, "CA", string2, "UTF-8", "json", string3, null, null, string4, string5, null, null, null);
    }

    public DefaultIcbcClient(String string, String string2, String string3, String string4, String string5, String string6) {
        this(string, "EM", null, "UTF-8", "json", string5, null, null, null, null, string3, string4, string6);
    }

    @Override
    public <T extends IcbcResponse> T execute(IcbcRequest<T> icbcRequest) throws IcbcApiException {
        UUID uUID = UUID.randomUUID();
        String string = uUID.toString().replace("-", "");
        return this.execute(icbcRequest, string);
    }

    @Override
    public <T extends IcbcResponse> T execute(IcbcRequest<T> icbcRequest, String string) throws IcbcApiException {
        return this.execute(icbcRequest, string, "");
    }

    @Override
    public <T extends IcbcResponse> T execute(IcbcRequest<T> icbcRequest, String string, String string2) throws IcbcApiException {
        IcbcHashMap icbcHashMap = this.prepareParams(icbcRequest, string, string2);
        String string3 = null;
        if (icbcRequest.getMethod().equals("GET")) {
            if (this.zoneNo != null) {
                this.headerParams.put("Zone-No", this.zoneNo);
            }
            if (this.refineInfo != null) {
                this.headerParams.put("Apirefined-Info", this.refineInfo);
            }
            string3 = WebUtils.doGet(icbcRequest.getServiceUrl(), (Map<String, String>)icbcHashMap, this.charset, this.headerParams);
        } else if (icbcRequest.getMethod().equals("POST")) {
            if (this.zoneNo != null) {
                this.headerParams.put("Zone-No", this.zoneNo);
            }
            if (this.refineInfo != null) {
                this.headerParams.put("Apirefined-Info", this.refineInfo);
            }
            string3 = WebUtils.doPost(icbcRequest.getServiceUrl(), (Map<String, String>)icbcHashMap, this.charset, this.headerParams);
        } else {
            logger.error((Object)("only support GET or POST, method: " + icbcRequest.getMethod()));
            throw new IcbcApiException("only support GET or POST, method: " + icbcRequest.getMethod());
        }
        T t2 = this.parse(icbcRequest, string3);
        if (t2 == null) {
            logger.error((Object)"response is null.");
            throw new IcbcApiException("response is null.");
        }
        return t2;
    }

    @Override
    public <T extends IcbcResponse> void execute(IcbcRequest<T> icbcRequest, WebUtils.IcbcApiFutureCallback<T> icbcApiFutureCallback) throws IcbcApiException {
        UUID uUID = UUID.randomUUID();
        String string = uUID.toString().replace("-", "");
        this.execute(icbcRequest, string, icbcApiFutureCallback);
    }

    @Override
    public <T extends IcbcResponse> void execute(IcbcRequest<T> icbcRequest, String string, WebUtils.IcbcApiFutureCallback<T> icbcApiFutureCallback) throws IcbcApiException {
        this.execute(icbcRequest, string, null, icbcApiFutureCallback);
    }

    @Override
    public <T extends IcbcResponse> void execute(final IcbcRequest<T> icbcRequest, String string, String string2, final WebUtils.IcbcApiFutureCallback<T> icbcApiFutureCallback) throws IcbcApiException {
        IcbcHashMap icbcHashMap = this.prepareParams(icbcRequest, string, string2);
        WebUtils.IcbcApiFutureCallback<String> icbcApiFutureCallback2 = new WebUtils.IcbcApiFutureCallback<String>(){

            public void a(String string) {
                try {
                    icbcApiFutureCallback.completed(DefaultIcbcClient.this.parse(icbcRequest, string));
                }
                catch (IcbcApiException icbcApiException) {
                    icbcApiFutureCallback.failed(icbcApiException);
                }
            }

            @Override
            public void failed(IcbcApiException icbcApiException) {
                icbcApiFutureCallback.failed(icbcApiException);
            }

            @Override
            public /* synthetic */ void completed(Object object) {
                this.a((String)object);
            }
        };
        if (icbcRequest.getMethod().equals("GET")) {
            WebUtils.doGet(icbcRequest.getServiceUrl(), (Map<String, String>)icbcHashMap, this.charset, icbcApiFutureCallback2);
        } else if (icbcRequest.getMethod().equals("POST")) {
            WebUtils.doPost(icbcRequest.getServiceUrl(), (Map<String, String>)icbcHashMap, this.charset, icbcApiFutureCallback2);
        } else {
            logger.error((Object)("only support GET or POST, method: " + icbcRequest.getMethod()));
            throw new IcbcApiException("only support GET or POST, method: " + icbcRequest.getMethod());
        }
    }

    protected <T extends IcbcResponse> T parse(IcbcRequest<T> icbcRequest, String string) throws IcbcApiException {
        return this.parseJsonWithIcbcSign(icbcRequest, string);
    }

    private <T extends IcbcResponse> T parseJsonWithIcbcSign(IcbcRequest<T> icbcRequest, String string) throws IcbcApiException {
        int n2;
        String string2 = null;
        String string3 = null;
        JSONObject jSONObject = null;
        String string4 = null;
        try {
            jSONObject = JSON.parseObject(string);
            string4 = jSONObject.getString("icbc_ca");
            n2 = string.indexOf("response_biz_content") + "response_biz_content".length() + 2;
            int n3 = string.lastIndexOf(",\"sign\":\"");
            string2 = string.substring(n2, n3);
            string3 = jSONObject.getString("sign");
        }
        catch (Exception exception) {
            logger.error((Object)("response is not format json. respStr :\n" + string), (Throwable)exception);
            throw new IcbcApiException("response is not format json. respStr :\n" + string, exception);
        }
        n2 = 0;
        if ("SM2".equals(this.signType)) {
            n2 = IcbcSignature.verify(string2, this.signType, this.icbcPulicKey, this.charset, string3) ? 1 : 0;
        } else if ("CA-SM-TP".equals(this.signType) || "CA-SM-ICBC".equals(this.signType)) {
            string4 = jSONObject.getString("icbc_ca");
            if (string4 == null || "".equals(string4)) {
                logger.error((Object)"icbc ca info not set.");
            }
            if (string4 != null && !string4.equals(this.icbc_ca)) {
                logger.error((Object)"icbc ca info is not consistent with the gateway.");
                if (this.icbcCaConsistentChkFlag) {
                    throw new IcbcApiException("icbc ca info is not consistent with the gateway. local:" + this.icbc_ca + ",gateway:" + string4);
                }
            }
            n2 = IcbcSignature.verify(string2, this.signType, this.icbcPulicKey, this.charset, string3, this.icbc_ca) ? 1 : 0;
        } else {
            n2 = IcbcSignature.verify(string2, "RSA", this.icbcPulicKey, this.charset, string3) ? 1 : 0;
        }
        if (n2 == 0) {
            logger.error((Object)"icbc sign verify not passed.");
            throw new IcbcApiException("icbc sign verify not passed.");
        }
        if (icbcRequest.isNeedEncrypt()) {
            string2 = IcbcEncrypt.decryptContent(string2.substring(1, string2.length() - 1), this.encryptType, this.encryptKey, this.charset);
        }
        try {
            return (T)((IcbcResponse)JSON.parseObject(string2, icbcRequest.getResponseClass()));
        }
        catch (Exception exception) {
            logger.error((Object)("response can not transform to defined class. response: " + string + " defined class name: " + icbcRequest.getResponseClass().getName()), (Throwable)exception);
            throw new IcbcApiException("response can not transform to defined class. response: " + string + " defined class name: " + icbcRequest.getResponseClass().getName(), exception);
        }
    }

    protected IcbcHashMap prepareParams(IcbcRequest<?> icbcRequest, String string, String string2) throws IcbcApiException {
        String string3;
        String string4 = this.buildBizContentStr(icbcRequest);
        try {
            string3 = new URL(icbcRequest.getServiceUrl()).getPath();
        }
        catch (MalformedURLException malformedURLException) {
            logger.error((Object)("url is not valid. url: " + icbcRequest.getServiceUrl()), (Throwable)malformedURLException);
            throw new IcbcApiException("url is not valid. url: " + icbcRequest.getServiceUrl(), malformedURLException);
        }
        IcbcHashMap icbcHashMap = new IcbcHashMap();
        Map<String, String> map = icbcRequest.getExtraParameters();
        if (map != null) {
            icbcHashMap.putAll(map);
        }
        icbcHashMap.put("app_id", this.appId);
        icbcHashMap.put("sign_type", this.signType);
        icbcHashMap.put("charset", this.charset);
        icbcHashMap.put("format", this.format);
        icbcHashMap.put("ca", this.ca);
        icbcHashMap.put("app_auth_token", string2);
        icbcHashMap.put("msg_id", string);
        Long l2 = System.currentTimeMillis();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        icbcHashMap.put("timestamp", simpleDateFormat.format(new Date(l2)));
        if (icbcRequest.isNeedEncrypt()) {
            if (!StringUtils.areNotEmpty(this.encryptType, this.encryptKey)) {
                logger.error((Object)"request need be encrypted, encrypt type and encrypt key can not be null.");
                throw new IcbcApiException("request need be encrypted, encrypt type and encrypt key can not be null.");
            }
            if (string4 != null) {
                icbcHashMap.put("encrypt_type", this.encryptType);
                icbcHashMap.put("biz_content", IcbcEncrypt.encryptContent(string4, this.encryptType, this.encryptKey, this.charset));
            }
        } else {
            icbcHashMap.put("biz_content", string4);
        }
        String string5 = WebUtils.buildOrderedSignStr(string3, icbcHashMap);
        if (this.signType.equals("CA") || this.signType.equals("RSA") || this.signType.equals("RSA2") || this.signType.equals("SM2") || this.signType.equals("CA-SM-TP") || this.signType.equals("CA-SM-ICBC")) {
            String string6 = IcbcSignature.sign(string5, this.signType, this.privateKey, this.charset, this.password);
            icbcHashMap.put("sign", string6);
        } else if (this.signType.equals("EM")) {
            try {
                String string7 = this.getNCSSign(string5, this.emSignIp, this.emSignPort, this.emProduct);
                icbcHashMap.put("sign", string7);
            }
            catch (IOException iOException) {
                logger.error((Object)"NC\u7b7e\u540d\u8fc7\u7a0b\u53d1\u751f\u9519\u8bef.");
                throw new IcbcApiException("sign failed. emProduct: " + this.emProduct, iOException);
            }
        } else {
            logger.error((Object)"NsignType is not supported.");
        }
        return icbcHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getNCSSign(String string, String string2, String string3, String string4) throws IOException {
        String string5 = null;
        String string6 = "UTF-8";
        InputStreamReader inputStreamReader = null;
        FilterOutputStream filterOutputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String string7;
            URL uRL = new URL("http://" + string2 + ":" + string3);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            if (string4.equals("CFCA")) {
                httpURLConnection.setRequestProperty("Request-Type", "1");
            }
            httpURLConnection.setRequestProperty("Content-Length", String.valueOf(string.getBytes(string6).length));
            httpURLConnection.setRequestProperty("Content-Type", "INFOSEC_SIGN/1.0");
            filterOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
            filterOutputStream.write(string.getBytes(string6));
            ((BufferedOutputStream)filterOutputStream).flush();
            int n2 = httpURLConnection.getResponseCode();
            if (n2 != 200) {
                logger.error((Object)"NC\u53d1\u9001\u5931\u8d25.");
            }
            String string8 = httpURLConnection.getResponseMessage();
            StringBuffer stringBuffer = new StringBuffer("");
            inputStreamReader = new InputStreamReader(httpURLConnection.getInputStream());
            bufferedReader = new BufferedReader(inputStreamReader);
            String string9 = null;
            while ((string9 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string9);
            }
            httpURLConnection.disconnect();
            int n3 = 0;
            int n4 = 0;
            try {
                n3 = stringBuffer.indexOf("<sign>") + 6;
                n4 = stringBuffer.indexOf("</sign>");
            }
            catch (Exception exception) {
                logger.error((Object)"NC\u8fd4\u56de\u5931\u8d25.");
            }
            string5 = string7 = stringBuffer.substring(n3, n4);
        }
        catch (MalformedURLException malformedURLException) {
            logger.error((Object)"NC\u901a\u4fe1\u548c\u7b7e\u540d\u8fc7\u7a0b\u53d1\u751f\u9519\u8bef,\u6216\u8005emport\u7c7b\u578b\u4e0d\u662fCFCA\u6216\u8005NC.");
            malformedURLException.printStackTrace();
        }
        finally {
            filterOutputStream.close();
            inputStreamReader.close();
            bufferedReader.close();
        }
        return string5;
    }

    protected String buildBizContentStr(IcbcRequest<?> icbcRequest) throws IcbcApiException {
        if (icbcRequest.getBizContent() == null) {
            return null;
        }
        if (this.format.equals("json")) {
            return JSON.toJSONString(icbcRequest.getBizContent());
        }
        logger.error((Object)("only support json format, current format is not supported. format: " + this.format));
        throw new IcbcApiException("only support json format, current format is not supported. format: " + this.format);
    }

    @Deprecated
    public String getZoneNo() {
        return this.zoneNo;
    }

    @Deprecated
    public void setZoneNo(String string) {
        this.zoneNo = string;
    }

    public void setProxy(String string, int n2) {
        HttpClientUtils.setProxy(string, n2);
    }

    public void setHttpsProxy(String string, int n2) {
        HttpClientUtils.setHttpsProxy(string, n2);
    }

    public void setProxy(s s2) {
        HttpClientUtils.setProxy(s2);
    }

    public String getRefineInfo() {
        return this.refineInfo;
    }

    public void setRefineInfo(String string) {
        this.refineInfo = string;
    }

    public void setHeaderParam(String string, String string2) {
        this.headerParams.put(string, string2);
    }

    public void setFovaRegion(String string) {
        this.headerParams.put("X-Fova-Region", string);
    }

    public String getIcbc_ca() {
        return this.icbc_ca;
    }

    public void setIcbc_ca(String string) {
        this.icbc_ca = string;
    }

    public boolean isIcbcCaConsistentChkFlag() {
        return this.icbcCaConsistentChkFlag;
    }

    public void setIcbcCaConsistentChkFlag(boolean bl) {
        this.icbcCaConsistentChkFlag = bl;
    }
}

