/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http;

import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.util.Args;
import java.io.Serializable;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class K
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8950662842175091068L;
    protected final String protocol;
    protected final int major;
    protected final int minor;

    public K(String string, int n2, int n3) {
        this.protocol = Args.notNull(string, "Protocol name");
        this.major = Args.notNegative(n2, "Protocol minor version");
        this.minor = Args.notNegative(n3, "Protocol minor version");
    }

    public final String getProtocol() {
        return this.protocol;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public K a(int n2, int n3) {
        if (n2 == this.major && n3 == this.minor) {
            return this;
        }
        return new K(this.protocol, n2, n3);
    }

    public final int hashCode() {
        return this.protocol.hashCode() ^ this.major * 100000 ^ this.minor;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof K)) {
            return false;
        }
        K k2 = (K)object;
        return this.protocol.equals(k2.protocol) && this.major == k2.major && this.minor == k2.minor;
    }

    public boolean a(K k2) {
        return k2 != null && this.protocol.equals(k2.protocol);
    }

    public int b(K k2) {
        Args.notNull(k2, "Protocol version");
        Args.check(this.protocol.equals(k2.protocol), "Versions for different protocols cannot be compared: %s %s", this, k2);
        int n2 = this.getMajor() - k2.getMajor();
        if (n2 == 0) {
            n2 = this.getMinor() - k2.getMinor();
        }
        return n2;
    }

    public final boolean c(K k2) {
        return this.a(k2) && this.b(k2) >= 0;
    }

    public final boolean d(K k2) {
        return this.a(k2) && this.b(k2) <= 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.protocol);
        stringBuilder.append('/');
        stringBuilder.append(Integer.toString(this.major));
        stringBuilder.append('.');
        stringBuilder.append(Integer.toString(this.minor));
        return stringBuilder.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

