/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.e;

import com.icbc.api.internal.apache.http.G;
import com.icbc.api.internal.apache.http.I;
import com.icbc.api.internal.apache.http.annotation.Contract;
import com.icbc.api.internal.apache.http.annotation.ThreadingBehavior;
import com.icbc.api.internal.apache.http.c;
import com.icbc.api.internal.apache.http.g.f;
import com.icbc.api.internal.apache.http.g.n;
import com.icbc.api.internal.apache.http.g.x;
import com.icbc.api.internal.apache.http.h;
import com.icbc.api.internal.apache.http.o;
import com.icbc.api.internal.apache.http.util.Args;
import com.icbc.api.internal.apache.http.util.CharArrayBuffer;
import com.icbc.api.internal.apache.http.util.TextUtils;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class g
implements Serializable {
    private static final long serialVersionUID = -7768694718232371896L;
    public static final g fG = g.h("application/atom+xml", c.ISO_8859_1);
    public static final g fH = g.h("application/x-www-form-urlencoded", c.ISO_8859_1);
    public static final g fI = g.h("application/json", c.UTF_8);
    public static final g fJ = g.h("application/octet-stream", null);
    public static final g fK = g.h("application/svg+xml", c.ISO_8859_1);
    public static final g fL = g.h("application/xhtml+xml", c.ISO_8859_1);
    public static final g fM = g.h("application/xml", c.ISO_8859_1);
    public static final g fN = g.h("multipart/form-data", c.ISO_8859_1);
    public static final g fO = g.h("text/html", c.ISO_8859_1);
    public static final g fP = g.h("text/plain", c.ISO_8859_1);
    public static final g fQ = g.h("text/xml", c.ISO_8859_1);
    public static final g fR = g.h("*/*", null);
    public static final g fS = fP;
    public static final g fT = fJ;
    private final String mimeType;
    private final Charset charset;
    private final G[] fU;

    g(String string, Charset charset) {
        this.mimeType = string;
        this.charset = charset;
        this.fU = null;
    }

    g(String string, Charset charset, G[] gArray) {
        this.mimeType = string;
        this.charset = charset;
        this.fU = gArray;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getParameter(String string) {
        Args.notEmpty(string, "Parameter name");
        if (this.fU == null) {
            return null;
        }
        for (G g2 : this.fU) {
            if (!g2.getName().equalsIgnoreCase(string)) continue;
            return g2.getValue();
        }
        return null;
    }

    public String toString() {
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(64);
        charArrayBuffer.append(this.mimeType);
        if (this.fU != null) {
            charArrayBuffer.append("; ");
            f.us.a(charArrayBuffer, this.fU, false);
        } else if (this.charset != null) {
            charArrayBuffer.append("; charset=");
            charArrayBuffer.append(this.charset.name());
        }
        return charArrayBuffer.toString();
    }

    private static boolean ae(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '\"' && c2 != ',' && c2 != ';') continue;
            return false;
        }
        return true;
    }

    public static g h(String string, Charset charset) {
        String string2 = Args.notBlank(string, "MIME type").toLowerCase(Locale.ROOT);
        Args.check(g.ae(string2), "MIME type may not contain reserved characters");
        return new g(string2, charset);
    }

    public static g af(String string) {
        return new g(string, null);
    }

    public static g m(String string, String string2) throws UnsupportedCharsetException {
        return g.h(string, !TextUtils.isBlank(string2) ? Charset.forName(string2) : null);
    }

    private static g a(h h2, boolean bl) {
        return g.a(h2.getName(), h2.d(), bl);
    }

    private static g a(String string, G[] gArray, boolean bl) {
        Charset charset = null;
        for (G g2 : gArray) {
            if (!g2.getName().equalsIgnoreCase("charset")) continue;
            String string2 = g2.getValue();
            if (TextUtils.isBlank(string2)) break;
            try {
                charset = Charset.forName(string2);
                break;
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                if (!bl) break;
                throw unsupportedCharsetException;
            }
        }
        return new g(string, charset, gArray != null && gArray.length > 0 ? gArray : null);
    }

    public static g a(String string, G ... gArray) throws UnsupportedCharsetException {
        String string2 = Args.notBlank(string, "MIME type").toLowerCase(Locale.ROOT);
        Args.check(g.ae(string2), "MIME type may not contain reserved characters");
        return g.a(string, gArray, true);
    }

    public static g ag(String string) throws I, UnsupportedCharsetException {
        Args.notNull(string, "Content type");
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(string.length());
        charArrayBuffer.append(string);
        x x2 = new x(0, string.length());
        h[] hArray = com.icbc.api.internal.apache.http.g.g.uw.c(charArrayBuffer, x2);
        if (hArray.length > 0) {
            return g.a(hArray[0], true);
        }
        throw new I("Invalid content type: " + string);
    }

    public static g e(o o2) throws I, UnsupportedCharsetException {
        h[] hArray;
        if (o2 == null) {
            return null;
        }
        com.icbc.api.internal.apache.http.g g2 = o2.p();
        if (g2 != null && (hArray = g2.c()).length > 0) {
            return g.a(hArray[0], true);
        }
        return null;
    }

    public static g f(o o2) {
        if (o2 == null) {
            return null;
        }
        com.icbc.api.internal.apache.http.g g2 = o2.p();
        if (g2 != null) {
            try {
                h[] hArray = g2.c();
                if (hArray.length > 0) {
                    return g.a(hArray[0], false);
                }
            }
            catch (I i2) {
                return null;
            }
        }
        return null;
    }

    public static g g(o o2) throws I, UnsupportedCharsetException {
        g g2 = g.e(o2);
        return g2 != null ? g2 : fS;
    }

    public static g h(o o2) throws I, UnsupportedCharsetException {
        g g2 = g.e(o2);
        return g2 != null ? g2 : fS;
    }

    public g d(Charset charset) {
        return g.h(this.getMimeType(), charset);
    }

    public g ah(String string) {
        return g.m(this.getMimeType(), string);
    }

    public g d(G ... gArray) throws UnsupportedCharsetException {
        if (gArray.length == 0) {
            return this;
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (this.fU != null) {
            for (G g2 : this.fU) {
                linkedHashMap.put(g2.getName(), g2.getValue());
            }
        }
        for (G g2 : gArray) {
            linkedHashMap.put(g2.getName(), g2.getValue());
        }
        ArrayList arrayList = new ArrayList(linkedHashMap.size() + 1);
        if (this.charset != null && !linkedHashMap.containsKey("charset")) {
            arrayList.add(new n("charset", this.charset.name()));
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            arrayList.add(new n((String)entry.getKey(), (String)entry.getValue()));
        }
        return g.a(this.getMimeType(), arrayList.toArray(new G[arrayList.size()]), true);
    }
}

