/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.apache.http.nio.util;

import com.icbc.api.internal.apache.http.nio.c;
import com.icbc.api.internal.apache.http.nio.util.ByteBufferAllocator;
import com.icbc.api.internal.apache.http.nio.util.ContentOutputBuffer;
import com.icbc.api.internal.apache.http.nio.util.ExpandableBuffer;
import com.icbc.api.internal.apache.http.nio.util.HeapByteBufferAllocator;
import java.io.IOException;

public class SimpleOutputBuffer
extends ExpandableBuffer
implements ContentOutputBuffer {
    private boolean endOfStream = false;

    public SimpleOutputBuffer(int n2, ByteBufferAllocator byteBufferAllocator) {
        super(n2, byteBufferAllocator);
    }

    public SimpleOutputBuffer(int n2) {
        this(n2, HeapByteBufferAllocator.INSTANCE);
    }

    @Override
    public int produceContent(c c2) throws IOException {
        this.setOutputMode();
        int n2 = c2.write(this.buffer);
        if (!this.hasData() && this.endOfStream) {
            c2.complete();
        }
        return n2;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            return;
        }
        if (this.endOfStream) {
            return;
        }
        this.setInputMode();
        this.ensureCapacity(this.buffer.position() + n3);
        this.buffer.put(byArray, n2, n3);
    }

    public void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            return;
        }
        if (this.endOfStream) {
            return;
        }
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n2) throws IOException {
        if (this.endOfStream) {
            return;
        }
        this.setInputMode();
        this.ensureCapacity(this.capacity() + 1);
        this.buffer.put((byte)n2);
    }

    @Override
    public void reset() {
        super.clear();
        this.endOfStream = false;
    }

    @Override
    public void flush() {
    }

    @Override
    public void writeCompleted() {
        this.endOfStream = true;
    }

    public void shutdown() {
        this.endOfStream = true;
    }
}

