/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.asm;

import com.icbc.api.internal.util.fastjson.asm.MethodCollector;
import com.icbc.api.internal.util.fastjson.asm.TypeCollector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ClassReader {
    public final byte[] b;
    private final int[] items;
    private final String[] strings;
    private final int maxStringLength;
    public final int header;
    private boolean readAnnotations;

    public ClassReader(InputStream inputStream, boolean bl) throws IOException {
        int n2;
        this.readAnnotations = bl;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) != -1) {
            if (n2 <= 0) continue;
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        inputStream.close();
        this.b = byteArrayOutputStream.toByteArray();
        this.items = new int[this.readUnsignedShort(8)];
        int n3 = this.items.length;
        this.strings = new String[n3];
        int n4 = 0;
        n2 = 10;
        for (int i2 = 1; i2 < n3; ++i2) {
            int n5;
            this.items[i2] = n2 + 1;
            switch (this.b[n2]) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    n5 = 5;
                    break;
                }
                case 5: 
                case 6: {
                    n5 = 9;
                    ++i2;
                    break;
                }
                case 15: {
                    n5 = 4;
                    break;
                }
                case 1: {
                    n5 = 3 + this.readUnsignedShort(n2 + 1);
                    if (n5 <= n4) break;
                    n4 = n5;
                    break;
                }
                default: {
                    n5 = 3;
                }
            }
            n2 += n5;
        }
        this.maxStringLength = n4;
        this.header = n2;
    }

    public void accept(TypeCollector typeCollector) {
        int n2;
        int n3;
        int n4;
        char[] cArray = new char[this.maxStringLength];
        int n5 = 0;
        if (this.readAnnotations) {
            n4 = this.getAttributes();
            for (n3 = this.readUnsignedShort(n4); n3 > 0; --n3) {
                String string = this.readUTF8(n4 + 2, cArray);
                if ("RuntimeVisibleAnnotations".equals(string)) {
                    n5 = n4 + 8;
                    break;
                }
                n4 += 6 + this.readInt(n4 + 4);
            }
        }
        n4 = this.header;
        int n6 = this.items[this.readUnsignedShort(n4 + 4)];
        int n7 = this.readUnsignedShort(n4 + 6);
        n4 += 8;
        for (n3 = 0; n3 < n7; ++n3) {
            n4 += 2;
        }
        n6 = n4;
        n3 = this.readUnsignedShort(n6);
        n6 += 2;
        while (n3 > 0) {
            n2 = this.readUnsignedShort(n6 + 6);
            n6 += 8;
            while (n2 > 0) {
                n6 += 6 + this.readInt(n6 + 2);
                --n2;
            }
            --n3;
        }
        n3 = this.readUnsignedShort(n6);
        n6 += 2;
        while (n3 > 0) {
            n2 = this.readUnsignedShort(n6 + 6);
            n6 += 8;
            while (n2 > 0) {
                n6 += 6 + this.readInt(n6 + 2);
                --n2;
            }
            --n3;
        }
        n3 = this.readUnsignedShort(n6);
        n6 += 2;
        while (n3 > 0) {
            n6 += 6 + this.readInt(n6 + 2);
            --n3;
        }
        if (n5 != 0) {
            n6 = n5 + 2;
            for (n3 = this.readUnsignedShort(n5); n3 > 0; --n3) {
                String string = this.readUTF8(n6, cArray);
                typeCollector.visitAnnotation(string);
            }
        }
        n3 = this.readUnsignedShort(n4);
        n4 += 2;
        while (n3 > 0) {
            n2 = this.readUnsignedShort(n4 + 6);
            n4 += 8;
            while (n2 > 0) {
                n4 += 6 + this.readInt(n4 + 2);
                --n2;
            }
            --n3;
        }
        n3 = this.readUnsignedShort(n4);
        n4 += 2;
        while (n3 > 0) {
            n4 = this.readMethod(typeCollector, cArray, n4);
            --n3;
        }
    }

    private int getAttributes() {
        int n2;
        int n3;
        int n4 = this.header + 8 + this.readUnsignedShort(this.header + 6) * 2;
        for (n3 = this.readUnsignedShort(n4); n3 > 0; --n3) {
            for (n2 = this.readUnsignedShort(n4 + 8); n2 > 0; --n2) {
                n4 += 6 + this.readInt(n4 + 12);
            }
            n4 += 8;
        }
        for (n3 = this.readUnsignedShort(n4 += 2); n3 > 0; --n3) {
            for (n2 = this.readUnsignedShort(n4 + 8); n2 > 0; --n2) {
                n4 += 6 + this.readInt(n4 + 12);
            }
            n4 += 8;
        }
        return n4 + 2;
    }

    private int readMethod(TypeCollector typeCollector, char[] cArray, int n2) {
        String string;
        int n3 = this.readUnsignedShort(n2);
        String string2 = this.readUTF8(n2 + 2, cArray);
        String string3 = this.readUTF8(n2 + 4, cArray);
        int n4 = 0;
        int n5 = 0;
        int n6 = this.readUnsignedShort(n2 + 6);
        n2 += 8;
        while (n6 > 0) {
            string = this.readUTF8(n2, cArray);
            int n7 = this.readInt(n2 + 2);
            n2 += 6;
            if (string.equals("Code")) {
                n4 = n2;
            }
            n2 += n7;
            --n6;
        }
        if (n5 != 0) {
            n5 += 2;
            for (n6 = 0; n6 < this.readUnsignedShort(n5); ++n6) {
                n5 += 2;
            }
        }
        MethodCollector methodCollector = typeCollector.visitMethod(n3, string2, string3);
        if (methodCollector != null && n4 != 0) {
            int n8;
            int n9 = this.readInt(n4 + 4);
            int n10 = n4 += 8;
            n4 = n8 = n4 + n9;
            n6 = this.readUnsignedShort(n4);
            n4 += 2;
            while (n6 > 0) {
                n4 += 8;
                --n6;
            }
            int n11 = 0;
            int n12 = 0;
            n6 = this.readUnsignedShort(n4);
            n4 += 2;
            while (n6 > 0) {
                string = this.readUTF8(n4, cArray);
                if (string.equals("LocalVariableTable")) {
                    n11 = n4 + 6;
                } else if (string.equals("LocalVariableTypeTable")) {
                    n12 = n4 + 6;
                }
                n4 += 6 + this.readInt(n4 + 2);
                --n6;
            }
            n4 = n10;
            if (n11 != 0) {
                int n13;
                if (n12 != 0) {
                    n13 = this.readUnsignedShort(n12) * 3;
                    n5 = n12 + 2;
                    int[] nArray = new int[n13];
                    while (n13 > 0) {
                        nArray[--n13] = n5 + 6;
                        nArray[--n13] = this.readUnsignedShort(n5 + 8);
                        nArray[--n13] = this.readUnsignedShort(n5);
                        n5 += 10;
                    }
                }
                n5 = n11 + 2;
                for (n13 = this.readUnsignedShort(n11); n13 > 0; --n13) {
                    int n14 = this.readUnsignedShort(n5 + 8);
                    methodCollector.visitLocalVariable(this.readUTF8(n5 + 4, cArray), n14);
                    n5 += 10;
                }
            }
        }
        return n2;
    }

    private int readUnsignedShort(int n2) {
        byte[] byArray = this.b;
        return (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
    }

    private int readInt(int n2) {
        byte[] byArray = this.b;
        return (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    private String readUTF8(int n2, char[] cArray) {
        int n3 = this.readUnsignedShort(n2);
        String string = this.strings[n3];
        if (string != null) {
            return string;
        }
        n2 = this.items[n3];
        this.strings[n3] = this.readUTF(n2 + 2, this.readUnsignedShort(n2), cArray);
        return this.strings[n3];
    }

    private String readUTF(int n2, int n3, char[] cArray) {
        int n4 = n2 + n3;
        byte[] byArray = this.b;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n2 < n4) {
            int n8 = byArray[n2++];
            switch (n6) {
                case 0: {
                    if ((n8 &= 0xFF) < 128) {
                        cArray[n5++] = (char)n8;
                        break;
                    }
                    if (n8 < 224 && n8 > 191) {
                        n7 = (char)(n8 & 0x1F);
                        n6 = 1;
                        break;
                    }
                    n7 = (char)(n8 & 0xF);
                    n6 = 2;
                    break;
                }
                case 1: {
                    cArray[n5++] = (char)(n7 << 6 | n8 & 0x3F);
                    n6 = 0;
                    break;
                }
                case 2: {
                    n7 = (char)(n7 << 6 | n8 & 0x3F);
                    n6 = 1;
                }
            }
        }
        return new String(cArray, 0, n5);
    }
}

