/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.asm;

import com.icbc.api.internal.util.fastjson.asm.ByteVector;
import com.icbc.api.internal.util.fastjson.asm.MethodWriter;

public class Label {
    int status;
    int position;
    private int referenceCount;
    private int[] srcAndRefPositions;
    static final int FORWARD_REFERENCE_TYPE_MASK = -268435456;
    static final int FORWARD_REFERENCE_HANDLE_MASK = 0xFFFFFFF;
    static final int FORWARD_REFERENCE_TYPE_SHORT = 0x10000000;
    static final int FORWARD_REFERENCE_TYPE_WIDE = 0x20000000;
    int inputStackTop;
    int outputStackMax;
    Label successor;
    Label next;

    void put(MethodWriter methodWriter, ByteVector byteVector, int n2, boolean bl) {
        if ((this.status & 2) == 0) {
            if (bl) {
                this.addReference(n2, byteVector.length, 0x20000000);
                byteVector.putInt(-1);
            } else {
                this.addReference(n2, byteVector.length, 0x10000000);
                byteVector.putShort(-1);
            }
        } else if (bl) {
            byteVector.putInt(this.position - n2);
        } else {
            byteVector.putShort(this.position - n2);
        }
    }

    private void addReference(int n2, int n3, int n4) {
        if (this.srcAndRefPositions == null) {
            this.srcAndRefPositions = new int[6];
        }
        if (this.referenceCount >= this.srcAndRefPositions.length) {
            int[] nArray = new int[this.srcAndRefPositions.length + 6];
            System.arraycopy(this.srcAndRefPositions, 0, nArray, 0, this.srcAndRefPositions.length);
            this.srcAndRefPositions = nArray;
        }
        this.srcAndRefPositions[this.referenceCount++] = n2;
        this.srcAndRefPositions[this.referenceCount++] = n3 | n4;
    }

    void resolve(MethodWriter methodWriter, int n2, byte[] byArray) {
        this.status |= 2;
        this.position = n2;
        int n3 = 0;
        while (n3 < this.referenceCount) {
            int n4 = this.srcAndRefPositions[n3++];
            int n5 = this.srcAndRefPositions[n3++];
            int n6 = n5 & 0xFFFFFFF;
            int n7 = n2 - n4;
            if ((n5 & 0xF0000000) == 0x10000000) {
                byArray[n6++] = (byte)(n7 >>> 8);
                byArray[n6] = (byte)n7;
                continue;
            }
            byArray[n6++] = (byte)(n7 >>> 24);
            byArray[n6++] = (byte)(n7 >>> 16);
            byArray[n6++] = (byte)(n7 >>> 8);
            byArray[n6] = (byte)n7;
        }
    }
}

