/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.asm;

import com.icbc.api.internal.util.fastjson.asm.ByteVector;
import com.icbc.api.internal.util.fastjson.asm.ClassWriter;
import com.icbc.api.internal.util.fastjson.asm.Item;
import com.icbc.api.internal.util.fastjson.asm.Label;
import com.icbc.api.internal.util.fastjson.asm.MethodVisitor;
import com.icbc.api.internal.util.fastjson.asm.Type;

public class MethodWriter
implements MethodVisitor {
    MethodWriter next;
    final ClassWriter cw;
    private int access;
    private final int name;
    private final int desc;
    int exceptionCount;
    int[] exceptions;
    private ByteVector code = new ByteVector();
    private int maxStack;
    private int maxLocals;

    public MethodWriter(ClassWriter classWriter, int n2, String string, String string2, String string3, String[] stringArray) {
        if (classWriter.firstMethod == null) {
            classWriter.firstMethod = this;
        } else {
            classWriter.lastMethod.next = this;
        }
        classWriter.lastMethod = this;
        this.cw = classWriter;
        this.access = n2;
        this.name = classWriter.newUTF8(string);
        this.desc = classWriter.newUTF8(string2);
        if (stringArray != null && stringArray.length > 0) {
            this.exceptionCount = stringArray.length;
            this.exceptions = new int[this.exceptionCount];
            for (int i2 = 0; i2 < this.exceptionCount; ++i2) {
                this.exceptions[i2] = classWriter.newClassItem((String)stringArray[i2]).index;
            }
        }
    }

    @Override
    public void visitInsn(int n2) {
        this.code.putByte(n2);
    }

    @Override
    public void visitIntInsn(int n2, int n3) {
        this.code.put11(n2, n3);
    }

    @Override
    public void visitVarInsn(int n2, int n3) {
        if (n3 < 4 && n2 != 169) {
            int n4 = n2 < 54 ? 26 + (n2 - 21 << 2) + n3 : 59 + (n2 - 54 << 2) + n3;
            this.code.putByte(n4);
        } else if (n3 >= 256) {
            this.code.putByte(196).put12(n2, n3);
        } else {
            this.code.put11(n2, n3);
        }
    }

    @Override
    public void visitTypeInsn(int n2, String string) {
        Item item = this.cw.newClassItem(string);
        this.code.put12(n2, item.index);
    }

    @Override
    public void visitFieldInsn(int n2, String string, String string2, String string3) {
        Item item = this.cw.newFieldItem(string, string2, string3);
        this.code.put12(n2, item.index);
    }

    @Override
    public void visitMethodInsn(int n2, String string, String string2, String string3) {
        boolean bl = n2 == 185;
        Item item = this.cw.newMethodItem(string, string2, string3, bl);
        int n3 = item.intVal;
        if (bl) {
            if (n3 == 0) {
                item.intVal = n3 = Type.getArgumentsAndReturnSizes(string3);
            }
            this.code.put12(185, item.index).put11(n3 >> 2, 0);
        } else {
            this.code.put12(n2, item.index);
        }
    }

    @Override
    public void visitJumpInsn(int n2, Label label) {
        if ((label.status & 2) != 0 && label.position - this.code.length < Short.MIN_VALUE) {
            throw new UnsupportedOperationException();
        }
        this.code.putByte(n2);
        label.put(this, this.code, this.code.length - 1, n2 == 200);
    }

    @Override
    public void visitLabel(Label label) {
        label.resolve(this, this.code.length, this.code.data);
    }

    @Override
    public void visitLdcInsn(Object object) {
        Item item = this.cw.newConstItem(object);
        int n2 = item.index;
        if (item.type == 5 || item.type == 6) {
            this.code.put12(20, n2);
        } else if (n2 >= 256) {
            this.code.put12(19, n2);
        } else {
            this.code.put11(18, n2);
        }
    }

    @Override
    public void visitIincInsn(int n2, int n3) {
        this.code.putByte(132).put11(n2, n3);
    }

    @Override
    public void visitMaxs(int n2, int n3) {
        this.maxStack = n2;
        this.maxLocals = n3;
    }

    @Override
    public void visitEnd() {
    }

    final int getSize() {
        int n2 = 8;
        if (this.code.length > 0) {
            this.cw.newUTF8("Code");
            n2 += 18 + this.code.length + 0;
        }
        if (this.exceptionCount > 0) {
            this.cw.newUTF8("Exceptions");
            n2 += 8 + 2 * this.exceptionCount;
        }
        return n2;
    }

    final void put(ByteVector byteVector) {
        int n2;
        int n3 = 393216;
        byteVector.putShort(this.access & 0xFFF9FFFF).putShort(this.name).putShort(this.desc);
        int n4 = 0;
        if (this.code.length > 0) {
            ++n4;
        }
        if (this.exceptionCount > 0) {
            ++n4;
        }
        byteVector.putShort(n4);
        if (this.code.length > 0) {
            n2 = 12 + this.code.length + 0;
            byteVector.putShort(this.cw.newUTF8("Code")).putInt(n2);
            byteVector.putShort(this.maxStack).putShort(this.maxLocals);
            byteVector.putInt(this.code.length).putByteArray(this.code.data, 0, this.code.length);
            byteVector.putShort(0);
            n4 = 0;
            byteVector.putShort(n4);
        }
        if (this.exceptionCount > 0) {
            byteVector.putShort(this.cw.newUTF8("Exceptions")).putInt(2 * this.exceptionCount + 2);
            byteVector.putShort(this.exceptionCount);
            for (n2 = 0; n2 < this.exceptionCount; ++n2) {
                byteVector.putShort(this.exceptions[n2]);
            }
        }
    }
}

