/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.JSONLexer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicBoolean;

public class BooleanCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static final BooleanCodec instance = new BooleanCodec();

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) throws IOException {
        SerializeWriter serializeWriter = jSONSerializer.out;
        Boolean bl = (Boolean)object;
        if (bl == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullBooleanAsFalse);
            return;
        }
        if (bl.booleanValue()) {
            serializeWriter.write("true");
        } else {
            serializeWriter.write("false");
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        Boolean bl;
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        try {
            if (jSONLexer.token() == 6) {
                jSONLexer.nextToken(16);
                bl = Boolean.TRUE;
            } else if (jSONLexer.token() == 7) {
                jSONLexer.nextToken(16);
                bl = Boolean.FALSE;
            } else if (jSONLexer.token() == 2) {
                int n2 = jSONLexer.intValue();
                jSONLexer.nextToken(16);
                bl = n2 == 1 ? Boolean.TRUE : Boolean.FALSE;
            } else {
                Object object2 = defaultJSONParser.parse();
                if (object2 == null) {
                    return null;
                }
                bl = TypeUtils.castToBoolean(object2);
            }
        }
        catch (Exception exception) {
            throw new JSONException("parseBoolean error, field : " + object, exception);
        }
        if (type == AtomicBoolean.class) {
            return (T)new AtomicBoolean(bl);
        }
        return (T)bl;
    }

    @Override
    public int getFastMatchToken() {
        return 6;
    }
}

