/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

import com.icbc.api.internal.util.fastjson.annotation.JSONField;
import com.icbc.api.internal.util.fastjson.serializer.AfterFilter;
import com.icbc.api.internal.util.fastjson.serializer.BeanContext;
import com.icbc.api.internal.util.fastjson.serializer.BeforeFilter;
import com.icbc.api.internal.util.fastjson.serializer.FieldSerializer;
import com.icbc.api.internal.util.fastjson.serializer.JSONSerializer;
import com.icbc.api.internal.util.fastjson.serializer.LabelFilter;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerialContext;
import com.icbc.api.internal.util.fastjson.serializer.SerializeBeanInfo;
import com.icbc.api.internal.util.fastjson.serializer.SerializeFilter;
import com.icbc.api.internal.util.fastjson.serializer.SerializeFilterable;
import com.icbc.api.internal.util.fastjson.serializer.SerializeWriter;
import com.icbc.api.internal.util.fastjson.serializer.SerializerFeature;
import com.icbc.api.internal.util.fastjson.util.FieldInfo;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import com.icbc.api.internal.util.internal.util.fastjson.PropertyNamingStrategy;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaBeanSerializer
extends SerializeFilterable
implements ObjectSerializer {
    protected final FieldSerializer[] getters;
    protected final FieldSerializer[] sortedGetters;
    protected SerializeBeanInfo beanInfo;
    private volatile transient long[] hashArray;
    private volatile transient short[] hashArrayMapping;

    public JavaBeanSerializer(Class<?> clazz) {
        this(clazz, (Map<String, String>)null);
    }

    public JavaBeanSerializer(Class<?> clazz, String ... stringArray) {
        this(clazz, JavaBeanSerializer.createAliasMap(stringArray));
    }

    static Map<String, String> createAliasMap(String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : stringArray) {
            hashMap.put(string, string);
        }
        return hashMap;
    }

    public Class<?> getType() {
        return this.beanInfo.beanType;
    }

    public JavaBeanSerializer(Class<?> clazz, Map<String, String> map) {
        this(TypeUtils.buildBeanInfo(clazz, map, null));
    }

    public JavaBeanSerializer(SerializeBeanInfo serializeBeanInfo) {
        int n2;
        this.beanInfo = serializeBeanInfo;
        this.sortedGetters = new FieldSerializer[serializeBeanInfo.sortedFields.length];
        for (n2 = 0; n2 < this.sortedGetters.length; ++n2) {
            this.sortedGetters[n2] = new FieldSerializer(serializeBeanInfo.beanType, serializeBeanInfo.sortedFields[n2]);
        }
        if (serializeBeanInfo.fields == serializeBeanInfo.sortedFields) {
            this.getters = this.sortedGetters;
        } else {
            this.getters = new FieldSerializer[serializeBeanInfo.fields.length];
            n2 = 0;
            for (int i2 = 0; i2 < this.getters.length; ++i2) {
                FieldSerializer fieldSerializer = this.getFieldSerializer(serializeBeanInfo.fields[i2].name);
                if (fieldSerializer == null) {
                    n2 = 1;
                    break;
                }
                this.getters[i2] = fieldSerializer;
            }
            if (n2 != 0) {
                System.arraycopy(this.sortedGetters, 0, this.getters, 0, this.sortedGetters.length);
            }
        }
        if (serializeBeanInfo.jsonType != null) {
            for (Class<? extends SerializeFilter> clazz : serializeBeanInfo.jsonType.serialzeFilters()) {
                try {
                    SerializeFilter serializeFilter = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.addFilter(serializeFilter);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void writeDirectNonContext(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) throws IOException {
        this.write(jSONSerializer, object, object2, type, n2);
    }

    public void writeAsArray(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) throws IOException {
        this.write(jSONSerializer, object, object2, type, n2);
    }

    public void writeAsArrayNonContext(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) throws IOException {
        this.write(jSONSerializer, object, object2, type, n2);
    }

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) throws IOException {
        this.write(jSONSerializer, object, object2, type, n2, false);
    }

    public void writeNoneASM(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) throws IOException {
        this.write(jSONSerializer, object, object2, type, n2, false);
    }

    protected void write(JSONSerializer jSONSerializer, Object object, Object object2, Type clazz, int n2, boolean bl) throws IOException {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull();
            return;
        }
        if (this.writeReference(jSONSerializer, object, n2)) {
            return;
        }
        FieldSerializer[] fieldSerializerArray = serializeWriter.sortField ? this.sortedGetters : this.getters;
        SerialContext serialContext = jSONSerializer.context;
        if (!this.beanInfo.beanType.isEnum()) {
            jSONSerializer.setContext(serialContext, object, object2, this.beanInfo.features, n2);
        }
        boolean bl2 = this.isWriteAsArray(jSONSerializer, n2);
        FieldSerializer fieldSerializer = null;
        try {
            Class<?> clazz2;
            Class<?> clazz3;
            char c2;
            char c3 = bl2 ? (char)'[' : '{';
            char c4 = c2 = bl2 ? (char)']' : '}';
            if (!bl) {
                serializeWriter.append(c3);
            }
            if (fieldSerializerArray.length > 0 && serializeWriter.isEnabled(SerializerFeature.PrettyFormat)) {
                jSONSerializer.incrementIndent();
                jSONSerializer.println();
            }
            boolean bl3 = false;
            if (((this.beanInfo.features & SerializerFeature.WriteClassName.mask) != 0 || (n2 & SerializerFeature.WriteClassName.mask) != 0 || jSONSerializer.isWriteClassName(clazz, object)) && clazz3 != (clazz2 = (clazz3 = object.getClass()) != clazz && clazz instanceof WildcardType ? TypeUtils.getClass(clazz) : clazz)) {
                this.writeClassName(jSONSerializer, this.beanInfo.typeKey, object);
                bl3 = true;
            }
            char c5 = bl3 ? (char)',' : '\u0000';
            boolean bl4 = serializeWriter.isEnabled(SerializerFeature.WriteClassName);
            char c6 = this.writeBefore(jSONSerializer, object, c5);
            bl3 = c6 == ',';
            boolean bl5 = serializeWriter.isEnabled(SerializerFeature.SkipTransientField);
            boolean bl6 = serializeWriter.isEnabled(SerializerFeature.IgnoreNonFieldGetter);
            for (int i2 = 0; i2 < fieldSerializerArray.length; ++i2) {
                Class<?> clazz4;
                int n3;
                Object object3;
                List list;
                boolean bl7;
                FieldSerializer fieldSerializer2 = fieldSerializerArray[i2];
                Field field = fieldSerializer2.fieldInfo.field;
                FieldInfo fieldInfo = fieldSerializer2.fieldInfo;
                String string = fieldInfo.name;
                Class<?> clazz5 = fieldInfo.fieldClass;
                boolean bl8 = SerializerFeature.isEnabled(serializeWriter.features, fieldInfo.serialzeFeatures, SerializerFeature.UseSingleQuotes);
                boolean bl9 = bl7 = serializeWriter.quoteFieldNames && !bl8;
                if (bl5 && fieldInfo != null && fieldInfo.fieldTransient || bl6 && field == null) continue;
                boolean bl10 = false;
                if (!this.applyName(jSONSerializer, object, string) || !this.applyLabel(jSONSerializer, fieldInfo.label)) {
                    if (!bl2) continue;
                    bl10 = true;
                }
                if (this.beanInfo.typeKey != null && string.equals(this.beanInfo.typeKey) && jSONSerializer.isWriteClassName(clazz, object)) continue;
                if (bl10) {
                    list = null;
                } else {
                    try {
                        list = fieldSerializer2.getPropertyValueDirect(object);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        fieldSerializer = fieldSerializer2;
                        if (serializeWriter.isEnabled(SerializerFeature.IgnoreErrorGetter)) {
                            list = null;
                        }
                        throw invocationTargetException;
                    }
                }
                if (!this.apply(jSONSerializer, object, string, list)) continue;
                if (clazz5 == String.class && "trim".equals(fieldInfo.format) && list != null) {
                    list = ((String)((Object)list)).trim();
                }
                String string2 = string;
                string2 = this.processKey(jSONSerializer, object, string2, list);
                List list2 = list;
                if ((list = this.processValue(jSONSerializer, fieldSerializer2.fieldContext, object, string, list, n2)) == null) {
                    int n4 = fieldInfo.serialzeFeatures;
                    object3 = fieldInfo.getAnnotation();
                    if (this.beanInfo.jsonType != null) {
                        n4 |= SerializerFeature.of(this.beanInfo.jsonType.serialzeFeatures());
                    }
                    if (object3 != null && !"".equals(object3.defaultValue())) {
                        list = object3.defaultValue();
                    } else if (clazz5 == Boolean.class) {
                        n3 = SerializerFeature.WriteNullBooleanAsFalse.mask;
                        int n5 = n3 | SerializerFeature.WriteMapNullValue.mask;
                        if (!bl2 && (n4 & n5) == 0 && (serializeWriter.features & n5) == 0) continue;
                        if ((n4 & n3) != 0) {
                            list = false;
                        } else if ((serializeWriter.features & n3) != 0 && (n4 & SerializerFeature.WriteMapNullValue.mask) == 0) {
                            list = false;
                        }
                    } else if (clazz5 == String.class) {
                        n3 = SerializerFeature.WriteNullStringAsEmpty.mask;
                        int n6 = n3 | SerializerFeature.WriteMapNullValue.mask;
                        if (!bl2 && (n4 & n6) == 0 && (serializeWriter.features & n6) == 0) continue;
                        if ((n4 & n3) != 0) {
                            list = "";
                        } else if ((serializeWriter.features & n3) != 0 && (n4 & SerializerFeature.WriteMapNullValue.mask) == 0) {
                            list = "";
                        }
                    } else if (Number.class.isAssignableFrom(clazz5)) {
                        n3 = SerializerFeature.WriteNullNumberAsZero.mask;
                        int n7 = n3 | SerializerFeature.WriteMapNullValue.mask;
                        if (!bl2 && (n4 & n7) == 0 && (serializeWriter.features & n7) == 0) continue;
                        if ((n4 & n3) != 0) {
                            list = 0;
                        } else if ((serializeWriter.features & n3) != 0 && (n4 & SerializerFeature.WriteMapNullValue.mask) == 0) {
                            list = 0;
                        }
                    } else if (Collection.class.isAssignableFrom(clazz5)) {
                        n3 = SerializerFeature.WriteNullListAsEmpty.mask;
                        int n8 = n3 | SerializerFeature.WriteMapNullValue.mask;
                        if (!bl2 && (n4 & n8) == 0 && (serializeWriter.features & n8) == 0) continue;
                        if ((n4 & n3) != 0) {
                            list = Collections.emptyList();
                        } else if ((serializeWriter.features & n3) != 0 && (n4 & SerializerFeature.WriteMapNullValue.mask) == 0) {
                            list = Collections.emptyList();
                        }
                    } else if (!bl2 && !fieldSerializer2.writeNull && !serializeWriter.isEnabled(SerializerFeature.WriteMapNullValue.mask) && (n4 & SerializerFeature.WriteMapNullValue.mask) == 0) continue;
                }
                if (list != null && (serializeWriter.notWriteDefaultValue || (fieldInfo.serialzeFeatures & SerializerFeature.NotWriteDefaultValue.mask) != 0 || (this.beanInfo.features & SerializerFeature.NotWriteDefaultValue.mask) != 0) && ((clazz4 = fieldInfo.fieldClass) == Byte.TYPE && list instanceof Byte && (Byte)((Object)list) == 0 || clazz4 == Short.TYPE && list instanceof Short && (Short)((Object)list) == 0 || clazz4 == Integer.TYPE && list instanceof Integer && (Integer)((Object)list) == 0 || clazz4 == Long.TYPE && list instanceof Long && (Long)((Object)list) == 0L || clazz4 == Float.TYPE && list instanceof Float && ((Float)((Object)list)).floatValue() == 0.0f || clazz4 == Double.TYPE && list instanceof Double && (Double)((Object)list) == 0.0 || clazz4 == Boolean.TYPE && list instanceof Boolean && !((Boolean)((Object)list)).booleanValue())) continue;
                if (bl3) {
                    if (fieldInfo.unwrapped && list instanceof Map && ((Map)((Object)list)).size() == 0) continue;
                    serializeWriter.write(44);
                    if (serializeWriter.isEnabled(SerializerFeature.PrettyFormat)) {
                        jSONSerializer.println();
                    }
                }
                if (string2 != string) {
                    if (!bl2) {
                        serializeWriter.writeFieldName(string2, true);
                    }
                    jSONSerializer.write(list);
                } else if (list2 != list) {
                    if (!bl2) {
                        fieldSerializer2.writePrefix(jSONSerializer);
                    }
                    jSONSerializer.write(list);
                } else {
                    if (!bl2) {
                        boolean bl11;
                        boolean bl12 = Map.class.isAssignableFrom(clazz5);
                        boolean bl13 = bl11 = !clazz5.isPrimitive() && !clazz5.getName().startsWith("java.") || clazz5 == Object.class;
                        if (bl4 || !fieldInfo.unwrapped || !bl12 && !bl11) {
                            if (bl7) {
                                serializeWriter.write(fieldInfo.name_chars, 0, fieldInfo.name_chars.length);
                            } else {
                                fieldSerializer2.writePrefix(jSONSerializer);
                            }
                        }
                    }
                    if (!bl2) {
                        JSONField jSONField = fieldInfo.getAnnotation();
                        if (clazz5 == String.class && (jSONField == null || jSONField.serializeUsing() == Void.class)) {
                            if (list == null) {
                                int n9 = fieldSerializer2.features;
                                if (this.beanInfo.jsonType != null) {
                                    n9 |= SerializerFeature.of(this.beanInfo.jsonType.serialzeFeatures());
                                }
                                if ((serializeWriter.features & SerializerFeature.WriteNullStringAsEmpty.mask) != 0 && (n9 & SerializerFeature.WriteMapNullValue.mask) == 0) {
                                    serializeWriter.writeString("");
                                } else if ((n9 & SerializerFeature.WriteNullStringAsEmpty.mask) != 0) {
                                    serializeWriter.writeString("");
                                } else {
                                    serializeWriter.writeNull();
                                }
                            } else {
                                object3 = (String)((Object)list);
                                if (bl8) {
                                    serializeWriter.writeStringWithSingleQuote((String)object3);
                                } else {
                                    serializeWriter.writeStringWithDoubleQuote((String)object3, '\u0000');
                                }
                            }
                        } else {
                            if (fieldInfo.unwrapped && list instanceof Map && ((Map)((Object)list)).size() == 0) {
                                bl3 = false;
                                continue;
                            }
                            fieldSerializer2.writeValue(jSONSerializer, list);
                        }
                    } else {
                        fieldSerializer2.writeValue(jSONSerializer, list);
                    }
                }
                boolean bl14 = false;
                if (fieldInfo.unwrapped && list instanceof Map) {
                    object3 = (Map)((Object)list);
                    if (object3.size() == 0) {
                        bl14 = true;
                    } else if (!jSONSerializer.isEnabled(SerializerFeature.WriteMapNullValue)) {
                        n3 = 0;
                        for (Object v2 : object3.values()) {
                            if (v2 == null) continue;
                            n3 = 1;
                            break;
                        }
                        if (n3 == 0) {
                            bl14 = true;
                        }
                    }
                }
                if (bl14) continue;
                bl3 = true;
            }
            this.writeAfter(jSONSerializer, object, bl3 ? (char)',' : '\u0000');
            if (fieldSerializerArray.length > 0 && serializeWriter.isEnabled(SerializerFeature.PrettyFormat)) {
                jSONSerializer.decrementIdent();
                jSONSerializer.println();
            }
            if (!bl) {
                serializeWriter.append(c2);
            }
        }
        catch (Exception exception) {
            Object object4;
            String string = "write javaBean error, fastjson version 1.2.70";
            if (object != null) {
                string = string + ", class " + object.getClass().getName();
            }
            if (object2 != null) {
                string = string + ", fieldName : " + object2;
            } else if (fieldSerializer != null && fieldSerializer.fieldInfo != null) {
                object4 = fieldSerializer.fieldInfo;
                string = ((FieldInfo)object4).method != null ? string + ", method : " + ((FieldInfo)object4).method.getName() : string + ", fieldName : " + fieldSerializer.fieldInfo.name;
            }
            if (exception.getMessage() != null) {
                string = string + ", " + exception.getMessage();
            }
            object4 = null;
            if (exception instanceof InvocationTargetException) {
                object4 = exception.getCause();
            }
            if (object4 == null) {
                object4 = exception;
            }
            throw new JSONException(string, (Throwable)object4);
        }
        finally {
            jSONSerializer.context = serialContext;
        }
    }

    protected void writeClassName(JSONSerializer jSONSerializer, String string, Object object) {
        if (string == null) {
            string = jSONSerializer.config.typeKey;
        }
        jSONSerializer.out.writeFieldName(string, false);
        String string2 = this.beanInfo.typeName;
        if (string2 == null) {
            Class<?> clazz = object.getClass();
            if (TypeUtils.isProxy(clazz)) {
                clazz = clazz.getSuperclass();
            }
            string2 = clazz.getName();
        }
        jSONSerializer.write(string2);
    }

    public boolean writeReference(JSONSerializer jSONSerializer, Object object, int n2) {
        SerialContext serialContext = jSONSerializer.context;
        int n3 = SerializerFeature.DisableCircularReferenceDetect.mask;
        if (serialContext == null || (serialContext.features & n3) != 0 || (n2 & n3) != 0) {
            return false;
        }
        if (jSONSerializer.references != null && jSONSerializer.references.containsKey(object)) {
            jSONSerializer.writeReference(object);
            return true;
        }
        return false;
    }

    protected boolean isWriteAsArray(JSONSerializer jSONSerializer) {
        return this.isWriteAsArray(jSONSerializer, 0);
    }

    protected boolean isWriteAsArray(JSONSerializer jSONSerializer, int n2) {
        int n3 = SerializerFeature.BeanToArray.mask;
        return (this.beanInfo.features & n3) != 0 || jSONSerializer.out.beanToArray || (n2 & n3) != 0;
    }

    public Object getFieldValue(Object object, String string) {
        FieldSerializer fieldSerializer = this.getFieldSerializer(string);
        if (fieldSerializer == null) {
            throw new JSONException("field not found. " + string);
        }
        try {
            return fieldSerializer.getPropertyValue(object);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new JSONException("getFieldValue error." + string, invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JSONException("getFieldValue error." + string, illegalAccessException);
        }
    }

    public Object getFieldValue(Object object, String string, long l2, boolean bl) {
        FieldSerializer fieldSerializer = this.getFieldSerializer(l2);
        if (fieldSerializer == null) {
            if (bl) {
                throw new JSONException("field not found. " + string);
            }
            return null;
        }
        try {
            return fieldSerializer.getPropertyValue(object);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new JSONException("getFieldValue error." + string, invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JSONException("getFieldValue error." + string, illegalAccessException);
        }
    }

    public FieldSerializer getFieldSerializer(String string) {
        if (string == null) {
            return null;
        }
        int n2 = 0;
        int n3 = this.sortedGetters.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            String string2 = this.sortedGetters[n4].fieldInfo.name;
            int n5 = string2.compareTo(string);
            if (n5 < 0) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > 0) {
                n3 = n4 - 1;
                continue;
            }
            return this.sortedGetters[n4];
        }
        return null;
    }

    public FieldSerializer getFieldSerializer(long l2) {
        int n2;
        int n3;
        String string;
        int n4;
        int n5;
        PropertyNamingStrategy[] propertyNamingStrategyArray = null;
        if (this.hashArray == null) {
            propertyNamingStrategyArray = PropertyNamingStrategy.values();
            long[] lArray = new long[this.sortedGetters.length * propertyNamingStrategyArray.length];
            n5 = 0;
            for (n4 = 0; n4 < this.sortedGetters.length; ++n4) {
                string = this.sortedGetters[n4].fieldInfo.name;
                lArray[n5++] = TypeUtils.fnv1a_64(string);
                for (n3 = 0; n3 < propertyNamingStrategyArray.length; ++n3) {
                    String string2 = propertyNamingStrategyArray[n3].translate(string);
                    if (string.equals(string2)) continue;
                    lArray[n5++] = TypeUtils.fnv1a_64(string2);
                }
            }
            Arrays.sort(lArray, 0, n5);
            this.hashArray = new long[n5];
            System.arraycopy(lArray, 0, this.hashArray, 0, n5);
        }
        if ((n2 = Arrays.binarySearch(this.hashArray, l2)) < 0) {
            return null;
        }
        if (this.hashArrayMapping == null) {
            if (propertyNamingStrategyArray == null) {
                propertyNamingStrategyArray = PropertyNamingStrategy.values();
            }
            short[] sArray = new short[this.hashArray.length];
            Arrays.fill(sArray, (short)-1);
            for (n4 = 0; n4 < this.sortedGetters.length; ++n4) {
                string = this.sortedGetters[n4].fieldInfo.name;
                n3 = Arrays.binarySearch(this.hashArray, TypeUtils.fnv1a_64(string));
                if (n3 >= 0) {
                    sArray[n3] = (short)n4;
                }
                for (int i2 = 0; i2 < propertyNamingStrategyArray.length; ++i2) {
                    int n6;
                    String string3 = propertyNamingStrategyArray[i2].translate(string);
                    if (string.equals(string3) || (n6 = Arrays.binarySearch(this.hashArray, TypeUtils.fnv1a_64(string3))) < 0) continue;
                    sArray[n6] = (short)n4;
                }
            }
            this.hashArrayMapping = sArray;
        }
        if ((n5 = this.hashArrayMapping[n2]) != -1) {
            return this.sortedGetters[n5];
        }
        return null;
    }

    public List<Object> getFieldValues(Object object) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.sortedGetters.length);
        for (FieldSerializer fieldSerializer : this.sortedGetters) {
            arrayList.add(fieldSerializer.getPropertyValue(object));
        }
        return arrayList;
    }

    public List<Object> getObjectFieldValues(Object object) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.sortedGetters.length);
        for (FieldSerializer fieldSerializer : this.sortedGetters) {
            Class<?> clazz = fieldSerializer.fieldInfo.fieldClass;
            if (clazz.isPrimitive() || clazz.getName().startsWith("java.lang.")) continue;
            arrayList.add(fieldSerializer.getPropertyValue(object));
        }
        return arrayList;
    }

    public int getSize(Object object) throws Exception {
        int n2 = 0;
        for (FieldSerializer fieldSerializer : this.sortedGetters) {
            Object object2 = fieldSerializer.getPropertyValueDirect(object);
            if (object2 == null) continue;
            ++n2;
        }
        return n2;
    }

    public Set<String> getFieldNames(Object object) throws Exception {
        HashSet<String> hashSet = new HashSet<String>();
        for (FieldSerializer fieldSerializer : this.sortedGetters) {
            Object object2 = fieldSerializer.getPropertyValueDirect(object);
            if (object2 == null) continue;
            hashSet.add(fieldSerializer.fieldInfo.name);
        }
        return hashSet;
    }

    public Map<String, Object> getFieldValuesMap(Object object) throws Exception {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(this.sortedGetters.length);
        boolean bl = true;
        FieldInfo fieldInfo = null;
        for (FieldSerializer fieldSerializer : this.sortedGetters) {
            bl = SerializerFeature.isEnabled(fieldSerializer.features, SerializerFeature.SkipTransientField);
            fieldInfo = fieldSerializer.fieldInfo;
            if (bl && fieldInfo != null && fieldInfo.fieldTransient) continue;
            if (fieldSerializer.fieldInfo.unwrapped) {
                Object object2 = fieldSerializer.getPropertyValue(object);
                Object object3 = JSON.toJSON(object2);
                if (object3 instanceof Map) {
                    linkedHashMap.putAll((Map)object3);
                    continue;
                }
                linkedHashMap.put(fieldSerializer.fieldInfo.name, fieldSerializer.getPropertyValue(object));
                continue;
            }
            linkedHashMap.put(fieldSerializer.fieldInfo.name, fieldSerializer.getPropertyValue(object));
        }
        return linkedHashMap;
    }

    protected BeanContext getBeanContext(int n2) {
        return this.sortedGetters[n2].fieldContext;
    }

    protected Type getFieldType(int n2) {
        return this.sortedGetters[n2].fieldInfo.fieldType;
    }

    protected char writeBefore(JSONSerializer jSONSerializer, Object object, char c2) {
        if (jSONSerializer.beforeFilters != null) {
            for (BeforeFilter beforeFilter : jSONSerializer.beforeFilters) {
                c2 = beforeFilter.writeBefore(jSONSerializer, object, c2);
            }
        }
        if (this.beforeFilters != null) {
            for (BeforeFilter beforeFilter : this.beforeFilters) {
                c2 = beforeFilter.writeBefore(jSONSerializer, object, c2);
            }
        }
        return c2;
    }

    protected char writeAfter(JSONSerializer jSONSerializer, Object object, char c2) {
        if (jSONSerializer.afterFilters != null) {
            for (AfterFilter afterFilter : jSONSerializer.afterFilters) {
                c2 = afterFilter.writeAfter(jSONSerializer, object, c2);
            }
        }
        if (this.afterFilters != null) {
            for (AfterFilter afterFilter : this.afterFilters) {
                c2 = afterFilter.writeAfter(jSONSerializer, object, c2);
            }
        }
        return c2;
    }

    protected boolean applyLabel(JSONSerializer jSONSerializer, String string) {
        if (jSONSerializer.labelFilters != null) {
            for (LabelFilter labelFilter : jSONSerializer.labelFilters) {
                if (labelFilter.apply(string)) continue;
                return false;
            }
        }
        if (this.labelFilters != null) {
            for (LabelFilter labelFilter : this.labelFilters) {
                if (labelFilter.apply(string)) continue;
                return false;
            }
        }
        return true;
    }
}

