/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.serializer;

public enum SerializerFeature {
    QuoteFieldNames,
    UseSingleQuotes,
    WriteMapNullValue,
    WriteEnumUsingToString,
    WriteEnumUsingName,
    UseISO8601DateFormat,
    WriteNullListAsEmpty,
    WriteNullStringAsEmpty,
    WriteNullNumberAsZero,
    WriteNullBooleanAsFalse,
    SkipTransientField,
    SortField,
    WriteTabAsSpecial,
    PrettyFormat,
    WriteClassName,
    DisableCircularReferenceDetect,
    WriteSlashAsSpecial,
    BrowserCompatible,
    WriteDateUseDateFormat,
    NotWriteRootClassName,
    DisableCheckSpecialChar,
    BeanToArray,
    WriteNonStringKeyAsString,
    NotWriteDefaultValue,
    BrowserSecure,
    IgnoreNonFieldGetter,
    WriteNonStringValueAsString,
    IgnoreErrorGetter,
    WriteBigDecimalAsPlain,
    MapSortField;

    public final int mask = 1 << this.ordinal();
    public static final SerializerFeature[] EMPTY;
    public static final int WRITE_MAP_NULL_FEATURES;

    public final int getMask() {
        return this.mask;
    }

    public static boolean isEnabled(int n2, SerializerFeature serializerFeature) {
        return (n2 & serializerFeature.mask) != 0;
    }

    public static boolean isEnabled(int n2, int n3, SerializerFeature serializerFeature) {
        int n4 = serializerFeature.mask;
        return (n2 & n4) != 0 || (n3 & n4) != 0;
    }

    public static int config(int n2, SerializerFeature serializerFeature, boolean bl) {
        n2 = bl ? (n2 |= serializerFeature.mask) : (n2 &= ~serializerFeature.mask);
        return n2;
    }

    public static int of(SerializerFeature[] serializerFeatureArray) {
        if (serializerFeatureArray == null) {
            return 0;
        }
        int n2 = 0;
        for (SerializerFeature serializerFeature : serializerFeatureArray) {
            n2 |= serializerFeature.mask;
        }
        return n2;
    }

    static {
        EMPTY = new SerializerFeature[0];
        WRITE_MAP_NULL_FEATURES = WriteMapNullValue.getMask() | WriteNullBooleanAsFalse.getMask() | WriteNullListAsEmpty.getMask() | WriteNullNumberAsZero.getMask() | WriteNullStringAsEmpty.getMask();
    }
}

