/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.util;

import com.icbc.api.internal.util.fastjson.util.UTF8Decoder;
import java.lang.ref.SoftReference;
import java.nio.charset.CharsetDecoder;

public class ThreadLocalCache {
    public static final int CHARS_CACH_INIT_SIZE = 1024;
    public static final int CHARS_CACH_INIT_SIZE_EXP = 10;
    public static final int CHARS_CACH_MAX_SIZE = 131072;
    public static final int CHARS_CACH_MAX_SIZE_EXP = 17;
    private static final ThreadLocal<SoftReference<char[]>> charsBufLocal = new ThreadLocal();
    private static final ThreadLocal<CharsetDecoder> decoderLocal = new ThreadLocal();
    public static final int BYTES_CACH_INIT_SIZE = 1024;
    public static final int BYTES_CACH_INIT_SIZE_EXP = 10;
    public static final int BYTES_CACH_MAX_SIZE = 131072;
    public static final int BYTES_CACH_MAX_SIZE_EXP = 17;
    private static final ThreadLocal<SoftReference<byte[]>> bytesBufLocal = new ThreadLocal();

    public static CharsetDecoder getUTF8Decoder() {
        CharsetDecoder charsetDecoder = decoderLocal.get();
        if (charsetDecoder == null) {
            charsetDecoder = new UTF8Decoder();
            decoderLocal.set(charsetDecoder);
        }
        return charsetDecoder;
    }

    public static void clearChars() {
        charsBufLocal.set(null);
    }

    public static char[] getChars(int n2) {
        SoftReference<char[]> softReference = charsBufLocal.get();
        if (softReference == null) {
            return ThreadLocalCache.allocate(n2);
        }
        char[] cArray = softReference.get();
        if (cArray == null) {
            return ThreadLocalCache.allocate(n2);
        }
        if (cArray.length < n2) {
            cArray = ThreadLocalCache.allocate(n2);
        }
        return cArray;
    }

    private static char[] allocate(int n2) {
        if (n2 > 131072) {
            return new char[n2];
        }
        int n3 = ThreadLocalCache.getAllocateLengthExp(10, 17, n2);
        char[] cArray = new char[n3];
        charsBufLocal.set(new SoftReference<char[]>(cArray));
        return cArray;
    }

    private static int getAllocateLengthExp(int n2, int n3, int n4) {
        assert (1 << n3 >= n4);
        int n5 = n4 >>> n2;
        if (n5 <= 0) {
            return 1 << n2;
        }
        return 1 << 32 - Integer.numberOfLeadingZeros(n4 - 1);
    }

    public static void clearBytes() {
        bytesBufLocal.set(null);
    }

    public static byte[] getBytes(int n2) {
        SoftReference<byte[]> softReference = bytesBufLocal.get();
        if (softReference == null) {
            return ThreadLocalCache.allocateBytes(n2);
        }
        byte[] byArray = softReference.get();
        if (byArray == null) {
            return ThreadLocalCache.allocateBytes(n2);
        }
        if (byArray.length < n2) {
            byArray = ThreadLocalCache.allocateBytes(n2);
        }
        return byArray;
    }

    private static byte[] allocateBytes(int n2) {
        if (n2 > 131072) {
            return new byte[n2];
        }
        int n3 = ThreadLocalCache.getAllocateLengthExp(10, 17, n2);
        byte[] byArray = new byte[n3];
        bytesBufLocal.set(new SoftReference<byte[]>(byArray));
        return byArray;
    }
}

