/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.fastjson.util;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class UTF8Decoder
extends CharsetDecoder {
    private static final Charset charset = Charset.forName("UTF-8");

    public UTF8Decoder() {
        super(charset, 1.0f, 1.0f);
    }

    private static boolean isNotContinuation(int n2) {
        return (n2 & 0xC0) != 128;
    }

    private static boolean isMalformed2(int n2, int n3) {
        return (n2 & 0x1E) == 0 || (n3 & 0xC0) != 128;
    }

    private static boolean isMalformed3(int n2, int n3, int n4) {
        return n2 == -32 && (n3 & 0xE0) == 128 || (n3 & 0xC0) != 128 || (n4 & 0xC0) != 128;
    }

    private static boolean isMalformed4(int n2, int n3, int n4) {
        return (n2 & 0xC0) != 128 || (n3 & 0xC0) != 128 || (n4 & 0xC0) != 128;
    }

    private static CoderResult lookupN(ByteBuffer byteBuffer, int n2) {
        for (int i2 = 1; i2 < n2; ++i2) {
            if (!UTF8Decoder.isNotContinuation(byteBuffer.get())) continue;
            return CoderResult.malformedForLength(i2);
        }
        return CoderResult.malformedForLength(n2);
    }

    public static CoderResult malformedN(ByteBuffer byteBuffer, int n2) {
        switch (n2) {
            case 1: {
                byte by = byteBuffer.get();
                if (by >> 2 == -2) {
                    if (byteBuffer.remaining() < 4) {
                        return CoderResult.UNDERFLOW;
                    }
                    return UTF8Decoder.lookupN(byteBuffer, 5);
                }
                if (by >> 1 == -2) {
                    if (byteBuffer.remaining() < 5) {
                        return CoderResult.UNDERFLOW;
                    }
                    return UTF8Decoder.lookupN(byteBuffer, 6);
                }
                return CoderResult.malformedForLength(1);
            }
            case 2: {
                return CoderResult.malformedForLength(1);
            }
            case 3: {
                byte by = byteBuffer.get();
                byte by2 = byteBuffer.get();
                return CoderResult.malformedForLength(by == -32 && (by2 & 0xE0) == 128 || UTF8Decoder.isNotContinuation(by2) ? 1 : 2);
            }
            case 4: {
                int n3 = byteBuffer.get() & 0xFF;
                int n4 = byteBuffer.get() & 0xFF;
                if (n3 > 244 || n3 == 240 && (n4 < 144 || n4 > 191) || n3 == 244 && (n4 & 0xF0) != 128 || UTF8Decoder.isNotContinuation(n4)) {
                    return CoderResult.malformedForLength(1);
                }
                if (UTF8Decoder.isNotContinuation(byteBuffer.get())) {
                    return CoderResult.malformedForLength(2);
                }
                return CoderResult.malformedForLength(3);
            }
        }
        throw new IllegalStateException();
    }

    private static CoderResult malformed(ByteBuffer byteBuffer, int n2, CharBuffer charBuffer, int n3, int n4) {
        byteBuffer.position(n2 - byteBuffer.arrayOffset());
        CoderResult coderResult = UTF8Decoder.malformedN(byteBuffer, n4);
        byteBuffer.position(n2);
        charBuffer.position(n3);
        return coderResult;
    }

    private static CoderResult xflow(Buffer buffer, int n2, int n3, Buffer buffer2, int n4, int n5) {
        buffer.position(n2);
        buffer2.position(n4);
        return n5 == 0 || n3 - n2 < n5 ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
    }

    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.limit();
        char[] cArray = charBuffer.array();
        int n4 = charBuffer.arrayOffset() + charBuffer.position();
        int n5 = charBuffer.arrayOffset() + charBuffer.limit();
        int n6 = n4 + Math.min(n3 - n2, n5 - n4);
        while (n4 < n6 && byArray[n2] >= 0) {
            cArray[n4++] = (char)byArray[n2++];
        }
        while (n2 < n3) {
            byte by;
            byte by2;
            byte by3 = byArray[n2];
            if (by3 >= 0) {
                if (n4 >= n5) {
                    return UTF8Decoder.xflow(byteBuffer, n2, n3, charBuffer, n4, 1);
                }
                cArray[n4++] = (char)by3;
                ++n2;
                continue;
            }
            if (by3 >> 5 == -2) {
                if (n3 - n2 < 2 || n4 >= n5) {
                    return UTF8Decoder.xflow(byteBuffer, n2, n3, charBuffer, n4, 2);
                }
                by2 = byArray[n2 + 1];
                if (UTF8Decoder.isMalformed2(by3, by2)) {
                    return UTF8Decoder.malformed(byteBuffer, n2, charBuffer, n4, 2);
                }
                cArray[n4++] = (char)(by3 << 6 ^ by2 ^ 0xF80);
                n2 += 2;
                continue;
            }
            if (by3 >> 4 == -2) {
                if (n3 - n2 < 3 || n4 >= n5) {
                    return UTF8Decoder.xflow(byteBuffer, n2, n3, charBuffer, n4, 3);
                }
                by2 = byArray[n2 + 1];
                by = byArray[n2 + 2];
                if (UTF8Decoder.isMalformed3(by3, by2, by)) {
                    return UTF8Decoder.malformed(byteBuffer, n2, charBuffer, n4, 3);
                }
                cArray[n4++] = (char)(by3 << 12 ^ by2 << 6 ^ by ^ 0x1F80);
                n2 += 3;
                continue;
            }
            if (by3 >> 3 == -2) {
                if (n3 - n2 < 4 || n5 - n4 < 2) {
                    return UTF8Decoder.xflow(byteBuffer, n2, n3, charBuffer, n4, 4);
                }
                by2 = byArray[n2 + 1];
                by = byArray[n2 + 2];
                byte by4 = byArray[n2 + 3];
                int n7 = (by3 & 7) << 18 | (by2 & 0x3F) << 12 | (by & 0x3F) << 6 | by4 & 0x3F;
                if (UTF8Decoder.isMalformed4(by2, by, by4) || n7 < 65536 || n7 > 0x10FFFF) {
                    return UTF8Decoder.malformed(byteBuffer, n2, charBuffer, n4, 4);
                }
                cArray[n4++] = (char)(0xD800 | n7 - 65536 >> 10 & 0x3FF);
                cArray[n4++] = (char)(0xDC00 | n7 - 65536 & 0x3FF);
                n2 += 4;
                continue;
            }
            return UTF8Decoder.malformed(byteBuffer, n2, charBuffer, n4, 1);
        }
        return UTF8Decoder.xflow(byteBuffer, n2, n3, charBuffer, n4, 0);
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        return this.decodeArrayLoop(byteBuffer, charBuffer);
    }
}

