/*
 * Decompiled with CFR 0.152.
 */
package com.icbc.api.internal.util.internal.util.fastjson;

import com.icbc.api.internal.util.fastjson.parser.DefaultJSONParser;
import com.icbc.api.internal.util.fastjson.parser.Feature;
import com.icbc.api.internal.util.fastjson.parser.JSONLexerBase;
import com.icbc.api.internal.util.fastjson.parser.ParserConfig;
import com.icbc.api.internal.util.fastjson.parser.deserializer.FieldDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.icbc.api.internal.util.fastjson.parser.deserializer.ObjectDeserializer;
import com.icbc.api.internal.util.fastjson.serializer.FieldSerializer;
import com.icbc.api.internal.util.fastjson.serializer.JavaBeanSerializer;
import com.icbc.api.internal.util.fastjson.serializer.ObjectSerializer;
import com.icbc.api.internal.util.fastjson.serializer.SerializeConfig;
import com.icbc.api.internal.util.fastjson.util.IOUtils;
import com.icbc.api.internal.util.fastjson.util.TypeUtils;
import com.icbc.api.internal.util.internal.util.fastjson.JSON;
import com.icbc.api.internal.util.internal.util.fastjson.JSONArray;
import com.icbc.api.internal.util.internal.util.fastjson.JSONAware;
import com.icbc.api.internal.util.internal.util.fastjson.JSONException;
import com.icbc.api.internal.util.internal.util.fastjson.JSONObject;
import com.icbc.api.internal.util.internal.util.fastjson.JSONPathException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSONPath
implements JSONAware {
    private static ConcurrentMap<String, JSONPath> pathCache = new ConcurrentHashMap<String, JSONPath>(128, 0.75f, 1);
    private final String path;
    private Segment[] segments;
    private boolean hasRefSegment;
    private SerializeConfig serializeConfig;
    private ParserConfig parserConfig;
    static final long SIZE = 5614464919154503228L;
    static final long LENGTH = -1580386065683472715L;

    public JSONPath(String string) {
        this(string, SerializeConfig.getGlobalInstance(), ParserConfig.getGlobalInstance());
    }

    public JSONPath(String string, SerializeConfig serializeConfig, ParserConfig parserConfig) {
        if (string == null || string.length() == 0) {
            throw new JSONPathException("json-path can not be null or empty");
        }
        this.path = string;
        this.serializeConfig = serializeConfig;
        this.parserConfig = parserConfig;
    }

    protected void init() {
        if (this.segments != null) {
            return;
        }
        if ("*".equals(this.path)) {
            this.segments = new Segment[]{WildCardSegment.instance};
        } else {
            JSONPathParser jSONPathParser = new JSONPathParser(this.path);
            this.segments = jSONPathParser.explain();
            this.hasRefSegment = jSONPathParser.hasRefSegment;
        }
    }

    public boolean isRef() {
        this.init();
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            Segment segment = this.segments[i2];
            Class<?> clazz = segment.getClass();
            if (clazz == ArrayAccessSegment.class || clazz == PropertySegment.class) continue;
            return false;
        }
        return true;
    }

    public Object eval(Object object) {
        if (object == null) {
            return null;
        }
        this.init();
        Object object2 = object;
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            Segment segment = this.segments[i2];
            object2 = segment.eval(this, object, object2);
        }
        return object2;
    }

    public Object extract(DefaultJSONParser defaultJSONParser) {
        if (defaultJSONParser == null) {
            return null;
        }
        this.init();
        if (this.hasRefSegment) {
            Object object = defaultJSONParser.parse();
            return this.eval(object);
        }
        if (this.segments.length == 0) {
            return defaultJSONParser.parse();
        }
        Context context = null;
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            boolean bl;
            boolean bl2;
            Segment segment = this.segments[i2];
            boolean bl3 = bl2 = i2 == this.segments.length - 1;
            if (context != null && context.object != null) {
                context.object = segment.eval(this, null, context.object);
                continue;
            }
            if (!bl2) {
                Segment segment2 = this.segments[i2 + 1];
                bl = segment instanceof PropertySegment && ((PropertySegment)segment).deep && (segment2 instanceof ArrayAccessSegment || segment2 instanceof MultiIndexSegment || segment2 instanceof MultiPropertySegment || segment2 instanceof SizeSegment || segment2 instanceof PropertySegment || segment2 instanceof FilterSegment) ? true : (segment2 instanceof ArrayAccessSegment && ((ArrayAccessSegment)segment2).index < 0 ? true : (segment2 instanceof FilterSegment ? true : segment instanceof WildCardSegment));
            } else {
                bl = true;
            }
            context = new Context(context, bl);
            segment.extract(this, defaultJSONParser, context);
        }
        return context.object;
    }

    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        this.init();
        Object object2 = object;
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            Object object3 = object2;
            if ((object2 = this.segments[i2].eval(this, object, object2)) == null) {
                return false;
            }
            if (object2 != Collections.EMPTY_LIST || !(object3 instanceof List)) continue;
            return ((List)object3).contains(object2);
        }
        return true;
    }

    public boolean containsValue(Object object, Object object2) {
        Object object3 = this.eval(object);
        if (object3 == object2) {
            return true;
        }
        if (object3 == null) {
            return false;
        }
        if (object3 instanceof Iterable) {
            for (Object t2 : (Iterable)object3) {
                if (!JSONPath.eq(t2, object2)) continue;
                return true;
            }
            return false;
        }
        return JSONPath.eq(object3, object2);
    }

    public int size(Object object) {
        if (object == null) {
            return -1;
        }
        this.init();
        Object object2 = object;
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            object2 = this.segments[i2].eval(this, object, object2);
        }
        return this.evalSize(object2);
    }

    public Set<?> keySet(Object object) {
        if (object == null) {
            return null;
        }
        this.init();
        Object object2 = object;
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            object2 = this.segments[i2].eval(this, object, object2);
        }
        return this.evalKeySet(object2);
    }

    public void arrayAdd(Object object, Object ... objectArray) {
        Object object2;
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        if (object == null) {
            return;
        }
        this.init();
        Object object3 = object;
        Object object4 = null;
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            if (i2 == this.segments.length - 1) {
                object4 = object3;
            }
            object3 = this.segments[i2].eval(this, object, object3);
        }
        Object object5 = object3;
        if (object5 == null) {
            throw new JSONPathException("value not found in path " + this.path);
        }
        if (object5 instanceof Collection) {
            Collection collection = (Collection)object5;
            for (Object object6 : objectArray) {
                collection.add(object6);
            }
            return;
        }
        Class<?> clazz = object5.getClass();
        if (clazz.isArray()) {
            int n2 = Array.getLength(object5);
            object2 = Array.newInstance(clazz.getComponentType(), n2 + objectArray.length);
            System.arraycopy(object5, 0, object2, 0, n2);
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                Array.set(object2, n2 + i3, objectArray[i3]);
            }
        } else {
            throw new JSONException("unsupported array put operation. " + clazz);
        }
        Object object7 = object2;
        Segment segment = this.segments[this.segments.length - 1];
        if (segment instanceof PropertySegment) {
            object2 = (PropertySegment)segment;
            ((PropertySegment)object2).setValue(this, object4, object7);
            return;
        }
        if (segment instanceof ArrayAccessSegment) {
            ((ArrayAccessSegment)segment).setValue(this, object4, object7);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object object) {
        Object object2;
        Object object3;
        Segment segment;
        if (object == null) {
            return false;
        }
        this.init();
        Object object4 = object;
        Object object5 = null;
        Segment segment2 = this.segments[this.segments.length - 1];
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            if (i2 == this.segments.length - 1) {
                object5 = object4;
                break;
            }
            segment = this.segments[i2];
            if (i2 == this.segments.length - 2 && segment2 instanceof FilterSegment && segment instanceof PropertySegment) {
                PropertySegment propertySegment;
                object3 = (FilterSegment)segment2;
                if (object4 instanceof List) {
                    propertySegment = (PropertySegment)segment;
                    object2 = (List)object4;
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        Object e2 = iterator.next();
                        Object object6 = propertySegment.eval(this, object, e2);
                        if (object6 instanceof Iterable) {
                            ((FilterSegment)object3).remove(this, object, object6);
                            continue;
                        }
                        if (!(object6 instanceof Map) || !((FilterSegment)object3).filter.apply(this, object, object4, object6)) continue;
                        iterator.remove();
                    }
                    return true;
                }
                if (object4 instanceof Map) {
                    propertySegment = (PropertySegment)segment;
                    object2 = propertySegment.eval(this, object, object4);
                    if (object2 == null) {
                        return false;
                    }
                    if (object2 instanceof Map && ((FilterSegment)object3).filter.apply(this, object, object4, object2)) {
                        propertySegment.remove(this, object4);
                        return true;
                    }
                }
            }
            if ((object4 = segment.eval(this, object, object4)) == null) break;
        }
        if (object5 == null) {
            return false;
        }
        if (segment2 instanceof PropertySegment) {
            PropertySegment propertySegment = (PropertySegment)segment2;
            if (object5 instanceof Collection && this.segments.length > 1 && ((segment = this.segments[this.segments.length - 2]) instanceof RangeSegment || segment instanceof MultiIndexSegment)) {
                object3 = (Collection)object5;
                boolean bl = false;
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    Object e3 = object2.next();
                    boolean bl2 = propertySegment.remove(this, e3);
                    if (!bl2) continue;
                    bl = true;
                }
                return bl;
            }
            return propertySegment.remove(this, object5);
        }
        if (segment2 instanceof ArrayAccessSegment) {
            return ((ArrayAccessSegment)segment2).remove(this, object5);
        }
        if (segment2 instanceof FilterSegment) {
            FilterSegment filterSegment = (FilterSegment)segment2;
            return filterSegment.remove(this, object, object5);
        }
        throw new UnsupportedOperationException();
    }

    public boolean set(Object object, Object object2) {
        return this.set(object, object2, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean set(Object object, Object object2, boolean bl) {
        Segment segment;
        if (object == null) {
            return false;
        }
        this.init();
        Object object3 = object;
        Object object4 = null;
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            Object object5;
            object4 = object3;
            segment = this.segments[i2];
            if ((object3 = segment.eval(this, object, object3)) != null) continue;
            Segment segment2 = null;
            if (i2 < this.segments.length - 1) {
                segment2 = this.segments[i2 + 1];
            }
            Object object6 = null;
            if (segment2 instanceof PropertySegment) {
                object5 = null;
                Class<?> clazz = null;
                if (segment instanceof PropertySegment) {
                    String string = ((PropertySegment)segment).propertyName;
                    Class<?> clazz2 = object4.getClass();
                    JavaBeanDeserializer javaBeanDeserializer = this.getJavaBeanDeserializer(clazz2);
                    if (javaBeanDeserializer != null) {
                        FieldDeserializer fieldDeserializer = javaBeanDeserializer.getFieldDeserializer(string);
                        clazz = fieldDeserializer.fieldInfo.fieldClass;
                        object5 = this.getJavaBeanDeserializer(clazz);
                    }
                }
                if (object5 != null) {
                    if (((JavaBeanDeserializer)object5).beanInfo.defaultConstructor == null) return false;
                    object6 = ((JavaBeanDeserializer)object5).createInstance(null, clazz);
                } else {
                    object6 = new JSONObject();
                }
            } else if (segment2 instanceof ArrayAccessSegment) {
                object6 = new JSONArray();
            }
            if (object6 == null) break;
            if (segment instanceof PropertySegment) {
                object5 = (PropertySegment)segment;
                ((PropertySegment)object5).setValue(this, object4, object6);
                object3 = object6;
                continue;
            }
            if (!(segment instanceof ArrayAccessSegment)) break;
            object5 = (ArrayAccessSegment)segment;
            ((ArrayAccessSegment)object5).setValue(this, object4, object6);
            object3 = object6;
        }
        if (object4 == null) {
            return false;
        }
        Segment segment3 = this.segments[this.segments.length - 1];
        if (segment3 instanceof PropertySegment) {
            segment = (PropertySegment)segment3;
            ((PropertySegment)segment).setValue(this, object4, object2);
            return true;
        }
        if (!(segment3 instanceof ArrayAccessSegment)) throw new UnsupportedOperationException();
        return ((ArrayAccessSegment)segment3).setValue(this, object4, object2);
    }

    public static Object eval(Object object, String string) {
        JSONPath jSONPath = JSONPath.compile(string);
        return jSONPath.eval(object);
    }

    public static int size(Object object, String string) {
        JSONPath jSONPath = JSONPath.compile(string);
        Object object2 = jSONPath.eval(object);
        return jSONPath.evalSize(object2);
    }

    public static Set<?> keySet(Object object, String string) {
        JSONPath jSONPath = JSONPath.compile(string);
        Object object2 = jSONPath.eval(object);
        return jSONPath.evalKeySet(object2);
    }

    public static boolean contains(Object object, String string) {
        if (object == null) {
            return false;
        }
        JSONPath jSONPath = JSONPath.compile(string);
        return jSONPath.contains(object);
    }

    public static boolean containsValue(Object object, String string, Object object2) {
        JSONPath jSONPath = JSONPath.compile(string);
        return jSONPath.containsValue(object, object2);
    }

    public static void arrayAdd(Object object, String string, Object ... objectArray) {
        JSONPath jSONPath = JSONPath.compile(string);
        jSONPath.arrayAdd(object, objectArray);
    }

    public static boolean set(Object object, String string, Object object2) {
        JSONPath jSONPath = JSONPath.compile(string);
        return jSONPath.set(object, object2);
    }

    public static boolean remove(Object object, String string) {
        JSONPath jSONPath = JSONPath.compile(string);
        return jSONPath.remove(object);
    }

    public static JSONPath compile(String string) {
        if (string == null) {
            throw new JSONPathException("jsonpath can not be null");
        }
        JSONPath jSONPath = (JSONPath)pathCache.get(string);
        if (jSONPath == null) {
            jSONPath = new JSONPath(string);
            if (pathCache.size() < 1024) {
                pathCache.putIfAbsent(string, jSONPath);
                jSONPath = (JSONPath)pathCache.get(string);
            }
        }
        return jSONPath;
    }

    public static Object read(String string, String string2) {
        return JSONPath.compile(string2).eval(JSON.parse(string));
    }

    public static Object extract(String string, String string2, ParserConfig parserConfig, int n2, Feature ... featureArray) {
        DefaultJSONParser defaultJSONParser = new DefaultJSONParser(string, parserConfig, n2 |= Feature.OrderedField.mask);
        JSONPath jSONPath = JSONPath.compile(string2);
        Object object = jSONPath.extract(defaultJSONParser);
        defaultJSONParser.lexer.close();
        return object;
    }

    public static Object extract(String string, String string2) {
        return JSONPath.extract(string, string2, ParserConfig.global, JSON.DEFAULT_PARSER_FEATURE, new Feature[0]);
    }

    public static Map<String, Object> paths(Object object) {
        return JSONPath.paths(object, SerializeConfig.globalInstance);
    }

    public static Map<String, Object> paths(Object object, SerializeConfig serializeConfig) {
        IdentityHashMap<Object, String> identityHashMap = new IdentityHashMap<Object, String>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        JSONPath.paths(identityHashMap, hashMap, "/", object, serializeConfig);
        return hashMap;
    }

    private static void paths(Map<Object, String> map, Map<String, Object> map2, String string, Object object, SerializeConfig serializeConfig) {
        int n2;
        Class<?> clazz;
        if (object == null) {
            return;
        }
        String string2 = map.put(object, string);
        if (string2 != null) {
            clazz = object.getClass();
            int n3 = n2 = clazz == String.class || clazz == Boolean.class || clazz == Character.class || clazz == UUID.class || clazz.isEnum() || object instanceof Number || object instanceof Date ? 1 : 0;
            if (n2 == 0) {
                return;
            }
        }
        map2.put(string, object);
        if (object instanceof Map) {
            clazz = (Map)object;
            for (Map.Entry entry : clazz.entrySet()) {
                Map.Entry entry2 = entry;
                Object k2 = entry2.getKey();
                if (!(k2 instanceof String)) continue;
                String string3 = string.equals("/") ? "/" + k2 : string + "/" + k2;
                JSONPath.paths(map, map2, string3, entry2.getValue(), serializeConfig);
            }
            return;
        }
        if (object instanceof Collection) {
            clazz = (Collection)object;
            n2 = 0;
            Iterator iterator = clazz.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                String string4 = string.equals("/") ? "/" + n2 : string + "/" + n2;
                JSONPath.paths(map, map2, string4, e2, serializeConfig);
                ++n2;
            }
            return;
        }
        clazz = object.getClass();
        if (clazz.isArray()) {
            n2 = Array.getLength(object);
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object2 = Array.get(object, i2);
                String string5 = string.equals("/") ? "/" + i2 : string + "/" + i2;
                JSONPath.paths(map, map2, string5, object2, serializeConfig);
            }
            return;
        }
        if (ParserConfig.isPrimitive2(clazz) || clazz.isEnum()) {
            return;
        }
        ObjectSerializer objectSerializer = serializeConfig.getObjectWriter(clazz);
        if (objectSerializer instanceof JavaBeanSerializer) {
            JavaBeanSerializer javaBeanSerializer = (JavaBeanSerializer)objectSerializer;
            try {
                Map<String, Object> map3 = javaBeanSerializer.getFieldValuesMap(object);
                for (Map.Entry<String, Object> entry : map3.entrySet()) {
                    String string6 = entry.getKey();
                    if (!(string6 instanceof String)) continue;
                    String string7 = string.equals("/") ? "/" + string6 : string + "/" + string6;
                    JSONPath.paths(map, map2, string7, entry.getValue(), serializeConfig);
                }
            }
            catch (Exception exception) {
                throw new JSONException("toJSON error", exception);
            }
            return;
        }
    }

    public String getPath() {
        return this.path;
    }

    static int compare(Object object, Object object2) {
        if (object.getClass() == object2.getClass()) {
            return ((Comparable)object).compareTo(object2);
        }
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = object2.getClass();
        if (clazz == BigDecimal.class) {
            if (clazz2 == Integer.class) {
                object2 = new BigDecimal((Integer)object2);
            } else if (clazz2 == Long.class) {
                object2 = new BigDecimal((Long)object2);
            } else if (clazz2 == Float.class) {
                object2 = new BigDecimal(((Float)object2).floatValue());
            } else if (clazz2 == Double.class) {
                object2 = new BigDecimal((Double)object2);
            }
        } else if (clazz == Long.class) {
            if (clazz2 == Integer.class) {
                object2 = new Long(((Integer)object2).intValue());
            } else if (clazz2 == BigDecimal.class) {
                object = new BigDecimal((Long)object);
            } else if (clazz2 == Float.class) {
                object = new Float(((Long)object).longValue());
            } else if (clazz2 == Double.class) {
                object = new Double(((Long)object).longValue());
            }
        } else if (clazz == Integer.class) {
            if (clazz2 == Long.class) {
                object = new Long(((Integer)object).intValue());
            } else if (clazz2 == BigDecimal.class) {
                object = new BigDecimal((Integer)object);
            } else if (clazz2 == Float.class) {
                object = new Float(((Integer)object).intValue());
            } else if (clazz2 == Double.class) {
                object = new Double(((Integer)object).intValue());
            }
        } else if (clazz == Double.class) {
            if (clazz2 == Integer.class) {
                object2 = new Double(((Integer)object2).intValue());
            } else if (clazz2 == Long.class) {
                object2 = new Double(((Long)object2).longValue());
            } else if (clazz2 == Float.class) {
                object2 = new Double(((Float)object2).floatValue());
            }
        } else if (clazz == Float.class) {
            if (clazz2 == Integer.class) {
                object2 = new Float(((Integer)object2).intValue());
            } else if (clazz2 == Long.class) {
                object2 = new Float(((Long)object2).longValue());
            } else if (clazz2 == Double.class) {
                object = new Double(((Float)object).floatValue());
            }
        }
        return ((Comparable)object).compareTo(object2);
    }

    protected Object getArrayItem(Object object, int n2) {
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (n2 >= 0) {
                if (n2 < list.size()) {
                    return list.get(n2);
                }
                return null;
            }
            if (Math.abs(n2) <= list.size()) {
                return list.get(list.size() + n2);
            }
            return null;
        }
        if (object.getClass().isArray()) {
            int n3 = Array.getLength(object);
            if (n2 >= 0) {
                if (n2 < n3) {
                    return Array.get(object, n2);
                }
                return null;
            }
            if (Math.abs(n2) <= n3) {
                return Array.get(object, n3 + n2);
            }
            return null;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            Object v2 = map.get(n2);
            if (v2 == null) {
                v2 = map.get(Integer.toString(n2));
            }
            return v2;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            int n4 = 0;
            for (Object e2 : collection) {
                if (n4 == n2) {
                    return e2;
                }
                ++n4;
            }
            return null;
        }
        if (n2 == 0) {
            return object;
        }
        throw new UnsupportedOperationException();
    }

    public boolean setArrayItem(JSONPath jSONPath, Object object, int n2, Object object2) {
        if (object instanceof List) {
            List list = (List)object;
            if (n2 >= 0) {
                list.set(n2, object2);
            } else {
                list.set(list.size() + n2, object2);
            }
            return true;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            int n3 = Array.getLength(object);
            if (n2 >= 0) {
                if (n2 < n3) {
                    Array.set(object, n2, object2);
                }
            } else if (Math.abs(n2) <= n3) {
                Array.set(object, n3 + n2, object2);
            }
            return true;
        }
        throw new JSONPathException("unsupported set operation." + clazz);
    }

    public boolean removeArrayItem(JSONPath jSONPath, Object object, int n2) {
        if (object instanceof List) {
            List list = (List)object;
            if (n2 >= 0) {
                if (n2 >= list.size()) {
                    return false;
                }
                list.remove(n2);
            } else {
                int n3 = list.size() + n2;
                if (n3 < 0) {
                    return false;
                }
                list.remove(n3);
            }
            return true;
        }
        Class<?> clazz = object.getClass();
        throw new JSONPathException("unsupported set operation." + clazz);
    }

    protected Collection<Object> getPropertyValues(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        JavaBeanSerializer javaBeanSerializer = this.getJavaBeanSerializer(clazz);
        if (javaBeanSerializer != null) {
            try {
                return javaBeanSerializer.getFieldValues(object);
            }
            catch (Exception exception) {
                throw new JSONPathException("jsonpath error, path " + this.path, exception);
            }
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return map.values();
        }
        if (object instanceof Collection) {
            return (Collection)object;
        }
        throw new UnsupportedOperationException();
    }

    protected void deepGetPropertyValues(Object object, List<Object> list) {
        Class<?> clazz = object.getClass();
        JavaBeanSerializer javaBeanSerializer = this.getJavaBeanSerializer(clazz);
        Collection<Object> collection = null;
        if (javaBeanSerializer != null) {
            try {
                collection = javaBeanSerializer.getFieldValues(object);
            }
            catch (Exception exception) {
                throw new JSONPathException("jsonpath error, path " + this.path, exception);
            }
        } else if (object instanceof Map) {
            Map map = (Map)object;
            collection = map.values();
        } else if (object instanceof Collection) {
            collection = (Collection)object;
        }
        if (collection != null) {
            for (Object e2 : collection) {
                if (e2 == null || ParserConfig.isPrimitive2(e2.getClass())) {
                    list.add(e2);
                    continue;
                }
                this.deepGetPropertyValues(e2, list);
            }
            return;
        }
        throw new UnsupportedOperationException(clazz.getName());
    }

    static boolean eq(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object.getClass() == object2.getClass()) {
            return object.equals(object2);
        }
        if (object instanceof Number) {
            if (object2 instanceof Number) {
                return JSONPath.eqNotNull((Number)object, (Number)object2);
            }
            return false;
        }
        return object.equals(object2);
    }

    static boolean eqNotNull(Number number, Number number2) {
        Number number3;
        Class<?> clazz = number.getClass();
        boolean bl = JSONPath.isInt(clazz);
        Class<?> clazz2 = number2.getClass();
        boolean bl2 = JSONPath.isInt(clazz2);
        if (number instanceof BigDecimal) {
            number3 = (BigDecimal)number;
            if (bl2) {
                return ((BigDecimal)number3).equals(BigDecimal.valueOf(TypeUtils.longExtractValue(number2)));
            }
        }
        if (bl) {
            if (bl2) {
                return number.longValue() == number2.longValue();
            }
            if (number2 instanceof BigInteger) {
                number3 = (BigInteger)number;
                BigInteger bigInteger = BigInteger.valueOf(number.longValue());
                return bigInteger.equals(number3);
            }
        }
        if (bl2 && number instanceof BigInteger) {
            number3 = (BigInteger)number;
            BigInteger bigInteger = BigInteger.valueOf(TypeUtils.longExtractValue(number2));
            return ((BigInteger)number3).equals(bigInteger);
        }
        boolean bl3 = JSONPath.isDouble(clazz);
        boolean bl4 = JSONPath.isDouble(clazz2);
        if (bl3 && bl4 || bl3 && bl2 || bl4 && bl) {
            return number.doubleValue() == number2.doubleValue();
        }
        return false;
    }

    protected static boolean isDouble(Class<?> clazz) {
        return clazz == Float.class || clazz == Double.class;
    }

    protected static boolean isInt(Class<?> clazz) {
        return clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class;
    }

    protected Object getPropertyValue(Object object, String string, long l2) {
        long l3;
        long l4;
        Class<?> clazz;
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            try {
                object = clazz = JSON.parseObject((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (object instanceof Map) {
            clazz = (Map)object;
            Object object2 = clazz.get(string);
            if (object2 == null && (5614464919154503228L == l2 || -1580386065683472715L == l2)) {
                object2 = clazz.size();
            }
            return object2;
        }
        clazz = object.getClass();
        JavaBeanSerializer javaBeanSerializer = this.getJavaBeanSerializer(clazz);
        if (javaBeanSerializer != null) {
            try {
                return javaBeanSerializer.getFieldValue(object, string, l2, false);
            }
            catch (Exception exception) {
                throw new JSONPathException("jsonpath error, path " + this.path + ", segement " + string, exception);
            }
        }
        if (object instanceof List) {
            List list = (List)object;
            if (5614464919154503228L == l2 || -1580386065683472715L == l2) {
                return list.size();
            }
            JSONArray jSONArray = null;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Object e2 = list.get(i2);
                if (e2 == list) {
                    if (jSONArray == null) {
                        jSONArray = new JSONArray(list.size());
                    }
                    jSONArray.add(e2);
                    continue;
                }
                Object object3 = this.getPropertyValue(e2, string, l2);
                if (object3 instanceof Collection) {
                    Collection collection = (Collection)object3;
                    if (jSONArray == null) {
                        jSONArray = new JSONArray(list.size());
                    }
                    jSONArray.addAll(collection);
                    continue;
                }
                if (object3 == null) continue;
                if (jSONArray == null) {
                    jSONArray = new JSONArray(list.size());
                }
                jSONArray.add(object3);
            }
            if (jSONArray == null) {
                jSONArray = Collections.emptyList();
            }
            return jSONArray;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            if (5614464919154503228L == l2 || -1580386065683472715L == l2) {
                return objectArray.length;
            }
            JSONArray jSONArray = new JSONArray(objectArray.length);
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                Object object4 = objectArray[i3];
                if (object4 == objectArray) {
                    jSONArray.add(object4);
                    continue;
                }
                Object object5 = this.getPropertyValue(object4, string, l2);
                if (object5 instanceof Collection) {
                    Collection collection = (Collection)object5;
                    jSONArray.addAll(collection);
                    continue;
                }
                if (object5 == null) continue;
                jSONArray.add(object5);
            }
            return jSONArray;
        }
        if (object instanceof Enum) {
            l4 = -4270347329889690746L;
            l3 = -1014497654951707614L;
            Enum enum_ = (Enum)object;
            if (-4270347329889690746L == l2) {
                return enum_.name();
            }
            if (-1014497654951707614L == l2) {
                return enum_.ordinal();
            }
        }
        if (object instanceof Calendar) {
            l4 = 8963398325558730460L;
            l3 = -811277319855450459L;
            long l5 = -3851359326990528739L;
            long l6 = 4647432019745535567L;
            long l7 = 6607618197526598121L;
            long l8 = -6586085717218287427L;
            Calendar calendar = (Calendar)object;
            if (8963398325558730460L == l2) {
                return calendar.get(1);
            }
            if (-811277319855450459L == l2) {
                return calendar.get(2);
            }
            if (-3851359326990528739L == l2) {
                return calendar.get(5);
            }
            if (4647432019745535567L == l2) {
                return calendar.get(11);
            }
            if (6607618197526598121L == l2) {
                return calendar.get(12);
            }
            if (-6586085717218287427L == l2) {
                return calendar.get(13);
            }
        }
        return null;
    }

    protected void deepScan(Object object, String string, List<Object> list) {
        if (object == null) {
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                Object v2 = entry.getValue();
                if (string.equals(entry.getKey())) {
                    if (v2 instanceof Collection) {
                        list.addAll((Collection)v2);
                        continue;
                    }
                    list.add(v2);
                    continue;
                }
                if (v2 == null || ParserConfig.isPrimitive2(v2.getClass())) continue;
                this.deepScan(v2, string, list);
            }
            return;
        }
        if (object instanceof Collection) {
            for (Object e2 : (Collection)object) {
                if (ParserConfig.isPrimitive2(e2.getClass())) continue;
                this.deepScan(e2, string, list);
            }
            return;
        }
        Class<?> clazz = object.getClass();
        JavaBeanSerializer javaBeanSerializer = this.getJavaBeanSerializer(clazz);
        if (javaBeanSerializer != null) {
            try {
                FieldSerializer fieldSerializer = javaBeanSerializer.getFieldSerializer(string);
                if (fieldSerializer != null) {
                    try {
                        Object object2 = fieldSerializer.getPropertyValueDirect(object);
                        list.add(object2);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new JSONException("getFieldValue error." + string, invocationTargetException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new JSONException("getFieldValue error." + string, illegalAccessException);
                    }
                    return;
                }
                List<Object> list2 = javaBeanSerializer.getFieldValues(object);
                for (Object object3 : list2) {
                    this.deepScan(object3, string, list);
                }
                return;
            }
            catch (Exception exception) {
                throw new JSONPathException("jsonpath error, path " + this.path + ", segement " + string, exception);
            }
        }
        if (object instanceof List) {
            List list3 = (List)object;
            for (int i2 = 0; i2 < list3.size(); ++i2) {
                Object e3 = list3.get(i2);
                this.deepScan(e3, string, list);
            }
            return;
        }
    }

    protected void deepSet(Object object, String string, long l2, Object object2) {
        if (object == null) {
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (map.containsKey(string)) {
                Object v2 = map.get(string);
                map.put(string, object2);
                return;
            }
            for (Object v3 : map.values()) {
                this.deepSet(v3, string, l2, object2);
            }
            return;
        }
        Class<?> clazz = object.getClass();
        JavaBeanDeserializer javaBeanDeserializer = this.getJavaBeanDeserializer(clazz);
        if (javaBeanDeserializer != null) {
            try {
                FieldDeserializer fieldDeserializer = javaBeanDeserializer.getFieldDeserializer(string);
                if (fieldDeserializer != null) {
                    fieldDeserializer.setValue(object, object2);
                    return;
                }
                JavaBeanSerializer javaBeanSerializer = this.getJavaBeanSerializer(clazz);
                List<Object> list = javaBeanSerializer.getObjectFieldValues(object);
                for (Object object3 : list) {
                    this.deepSet(object3, string, l2, object2);
                }
                return;
            }
            catch (Exception exception) {
                throw new JSONPathException("jsonpath error, path " + this.path + ", segement " + string, exception);
            }
        }
        if (object instanceof List) {
            List list = (List)object;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Object e2 = list.get(i2);
                this.deepSet(e2, string, l2, object2);
            }
            return;
        }
    }

    protected boolean setPropertyValue(Object object, String string, long l2, Object object2) {
        if (object instanceof Map) {
            ((Map)object).put(string, object2);
            return true;
        }
        if (object instanceof List) {
            for (Object e2 : (List)object) {
                if (e2 == null) continue;
                this.setPropertyValue(e2, string, l2, object2);
            }
            return true;
        }
        ObjectDeserializer objectDeserializer = this.parserConfig.getDeserializer(object.getClass());
        JavaBeanDeserializer javaBeanDeserializer = null;
        if (objectDeserializer instanceof JavaBeanDeserializer) {
            javaBeanDeserializer = (JavaBeanDeserializer)objectDeserializer;
        }
        if (javaBeanDeserializer != null) {
            FieldDeserializer fieldDeserializer = javaBeanDeserializer.getFieldDeserializer(l2);
            if (fieldDeserializer == null) {
                return false;
            }
            if (object2 != null && object2.getClass() != fieldDeserializer.fieldInfo.fieldClass) {
                object2 = TypeUtils.cast(object2, fieldDeserializer.fieldInfo.fieldType, this.parserConfig);
            }
            fieldDeserializer.setValue(object, object2);
            return true;
        }
        throw new UnsupportedOperationException();
    }

    protected boolean removePropertyValue(Object object, String string, boolean bl) {
        if (object instanceof Map) {
            boolean bl2;
            Object v2 = ((Map)object).remove(string);
            boolean bl3 = bl2 = v2 != null;
            if (bl) {
                for (Object v3 : ((Map)object).values()) {
                    this.removePropertyValue(v3, string, bl);
                }
            }
            return bl2;
        }
        ObjectDeserializer objectDeserializer = this.parserConfig.getDeserializer(object.getClass());
        JavaBeanDeserializer javaBeanDeserializer = null;
        if (objectDeserializer instanceof JavaBeanDeserializer) {
            javaBeanDeserializer = (JavaBeanDeserializer)objectDeserializer;
        }
        if (javaBeanDeserializer != null) {
            FieldDeserializer fieldDeserializer = javaBeanDeserializer.getFieldDeserializer(string);
            boolean bl4 = false;
            if (fieldDeserializer != null) {
                fieldDeserializer.setValue(object, null);
                bl4 = true;
            }
            if (bl) {
                Collection<Object> collection = this.getPropertyValues(object);
                for (Object object2 : collection) {
                    if (object2 == null) continue;
                    this.removePropertyValue(object2, string, bl);
                }
            }
            return bl4;
        }
        if (bl) {
            return false;
        }
        throw new UnsupportedOperationException();
    }

    protected JavaBeanSerializer getJavaBeanSerializer(Class<?> clazz) {
        JavaBeanSerializer javaBeanSerializer = null;
        ObjectSerializer objectSerializer = this.serializeConfig.getObjectWriter(clazz);
        if (objectSerializer instanceof JavaBeanSerializer) {
            javaBeanSerializer = (JavaBeanSerializer)objectSerializer;
        }
        return javaBeanSerializer;
    }

    protected JavaBeanDeserializer getJavaBeanDeserializer(Class<?> clazz) {
        JavaBeanDeserializer javaBeanDeserializer = null;
        ObjectDeserializer objectDeserializer = this.parserConfig.getDeserializer(clazz);
        if (objectDeserializer instanceof JavaBeanDeserializer) {
            javaBeanDeserializer = (JavaBeanDeserializer)objectDeserializer;
        }
        return javaBeanDeserializer;
    }

    int evalSize(Object object) {
        if (object == null) {
            return -1;
        }
        if (object instanceof Collection) {
            return ((Collection)object).size();
        }
        if (object instanceof Object[]) {
            return ((Object[])object).length;
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object);
        }
        if (object instanceof Map) {
            int n2 = 0;
            for (Object v2 : ((Map)object).values()) {
                if (v2 == null) continue;
                ++n2;
            }
            return n2;
        }
        JavaBeanSerializer javaBeanSerializer = this.getJavaBeanSerializer(object.getClass());
        if (javaBeanSerializer == null) {
            return -1;
        }
        try {
            return javaBeanSerializer.getSize(object);
        }
        catch (Exception exception) {
            throw new JSONPathException("evalSize error : " + this.path, exception);
        }
    }

    Set<?> evalKeySet(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Map) {
            return ((Map)object).keySet();
        }
        if (object instanceof Collection || object instanceof Object[] || object.getClass().isArray()) {
            return null;
        }
        JavaBeanSerializer javaBeanSerializer = this.getJavaBeanSerializer(object.getClass());
        if (javaBeanSerializer == null) {
            return null;
        }
        try {
            return javaBeanSerializer.getFieldNames(object);
        }
        catch (Exception exception) {
            throw new JSONPathException("evalKeySet error : " + this.path, exception);
        }
    }

    @Override
    public String toJSONString() {
        return JSON.toJSONString(this.path);
    }

    public static Object reserveToArray(Object object, String ... stringArray) {
        JSONArray jSONArray = new JSONArray();
        if (stringArray == null || stringArray.length == 0) {
            return jSONArray;
        }
        for (String string : stringArray) {
            JSONPath jSONPath = JSONPath.compile(string);
            jSONPath.init();
            Object object2 = jSONPath.eval(object);
            jSONArray.add(object2);
        }
        return jSONArray;
    }

    public static Object reserveToObject(Object object, String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return object;
        }
        JSONObject jSONObject = new JSONObject(true);
        for (String string : stringArray) {
            Object object2;
            JSONPath jSONPath = JSONPath.compile(string);
            jSONPath.init();
            Segment segment = jSONPath.segments[jSONPath.segments.length - 1];
            if (!(segment instanceof PropertySegment) || (object2 = jSONPath.eval(object)) == null) continue;
            jSONPath.set(jSONObject, object2);
        }
        return jSONObject;
    }

    static class FilterGroup
    implements Filter {
        private boolean and;
        private List<Filter> fitlers = new ArrayList<Filter>(2);

        public FilterGroup(Filter filter, Filter filter2, boolean bl) {
            this.fitlers.add(filter);
            this.fitlers.add(filter2);
            this.and = bl;
        }

        @Override
        public boolean apply(JSONPath jSONPath, Object object, Object object2, Object object3) {
            if (this.and) {
                for (Filter filter : this.fitlers) {
                    if (filter.apply(jSONPath, object, object2, object3)) continue;
                    return false;
                }
                return true;
            }
            for (Filter filter : this.fitlers) {
                if (!filter.apply(jSONPath, object, object2, object3)) continue;
                return true;
            }
            return false;
        }
    }

    static interface Filter {
        public boolean apply(JSONPath var1, Object var2, Object var3, Object var4);
    }

    public static class FilterSegment
    implements Segment {
        private final Filter filter;

        public FilterSegment(Filter filter) {
            this.filter = filter;
        }

        @Override
        public Object eval(JSONPath jSONPath, Object object, Object object2) {
            if (object2 == null) {
                return null;
            }
            JSONArray jSONArray = new JSONArray();
            if (object2 instanceof Iterable) {
                for (Object t2 : (Iterable)object2) {
                    if (!this.filter.apply(jSONPath, object, object2, t2)) continue;
                    jSONArray.add(t2);
                }
                return jSONArray;
            }
            if (this.filter.apply(jSONPath, object, object2, object2)) {
                return object2;
            }
            return null;
        }

        @Override
        public void extract(JSONPath jSONPath, DefaultJSONParser defaultJSONParser, Context context) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(JSONPath jSONPath, Object object, Object object2) {
            if (object2 == null) {
                return false;
            }
            if (object2 instanceof Iterable) {
                Iterator iterator = ((Iterable)object2).iterator();
                while (iterator.hasNext()) {
                    Object t2 = iterator.next();
                    if (!this.filter.apply(jSONPath, object, object2, t2)) continue;
                    iterator.remove();
                }
                return true;
            }
            return false;
        }
    }

    static enum Operator {
        EQ,
        NE,
        GT,
        GE,
        LT,
        LE,
        LIKE,
        NOT_LIKE,
        RLIKE,
        NOT_RLIKE,
        IN,
        NOT_IN,
        BETWEEN,
        NOT_BETWEEN,
        And,
        Or,
        REG_MATCH;

    }

    static class RegMatchSegement
    implements Filter {
        private final String propertyName;
        private final long propertyNameHash;
        private final Pattern pattern;
        private final Operator op;

        public RegMatchSegement(String string, Pattern pattern, Operator operator) {
            this.propertyName = string;
            this.propertyNameHash = TypeUtils.fnv1a_64(string);
            this.pattern = pattern;
            this.op = operator;
        }

        @Override
        public boolean apply(JSONPath jSONPath, Object object, Object object2, Object object3) {
            Object object4 = jSONPath.getPropertyValue(object3, this.propertyName, this.propertyNameHash);
            if (object4 == null) {
                return false;
            }
            String string = object4.toString();
            Matcher matcher = this.pattern.matcher(string);
            return matcher.matches();
        }
    }

    static class StringOpSegement
    implements Filter {
        private final String propertyName;
        private final long propertyNameHash;
        private final String value;
        private final Operator op;

        public StringOpSegement(String string, String string2, Operator operator) {
            this.propertyName = string;
            this.propertyNameHash = TypeUtils.fnv1a_64(string);
            this.value = string2;
            this.op = operator;
        }

        @Override
        public boolean apply(JSONPath jSONPath, Object object, Object object2, Object object3) {
            Object object4 = jSONPath.getPropertyValue(object3, this.propertyName, this.propertyNameHash);
            if (this.op == Operator.EQ) {
                return this.value.equals(object4);
            }
            if (this.op == Operator.NE) {
                return !this.value.equals(object4);
            }
            if (object4 == null) {
                return false;
            }
            int n2 = this.value.compareTo(object4.toString());
            if (this.op == Operator.GE) {
                return n2 <= 0;
            }
            if (this.op == Operator.GT) {
                return n2 < 0;
            }
            if (this.op == Operator.LE) {
                return n2 >= 0;
            }
            if (this.op == Operator.LT) {
                return n2 > 0;
            }
            return false;
        }
    }

    static class RlikeSegement
    implements Filter {
        private final String propertyName;
        private final long propertyNameHash;
        private final Pattern pattern;
        private final boolean not;

        public RlikeSegement(String string, String string2, boolean bl) {
            this.propertyName = string;
            this.propertyNameHash = TypeUtils.fnv1a_64(string);
            this.pattern = Pattern.compile(string2);
            this.not = bl;
        }

        @Override
        public boolean apply(JSONPath jSONPath, Object object, Object object2, Object object3) {
            Object object4 = jSONPath.getPropertyValue(object3, this.propertyName, this.propertyNameHash);
            if (object4 == null) {
                return false;
            }
            String string = object4.toString();
            Matcher matcher = this.pattern.matcher(string);
            boolean bl = matcher.matches();
            if (this.not) {
                bl = !bl;
            }
            return bl;
        }
    }

    static class MatchSegement
    implements Filter {
        private final String propertyName;
        private final long propertyNameHash;
        private final String startsWithValue;
        private final String endsWithValue;
        private final String[] containsValues;
        private final int minLength;
        private final boolean not;

        public MatchSegement(String string, String string2, String string3, String[] stringArray, boolean bl) {
            this.propertyName = string;
            this.propertyNameHash = TypeUtils.fnv1a_64(string);
            this.startsWithValue = string2;
            this.endsWithValue = string3;
            this.containsValues = stringArray;
            this.not = bl;
            int n2 = 0;
            if (string2 != null) {
                n2 += string2.length();
            }
            if (string3 != null) {
                n2 += string3.length();
            }
            if (stringArray != null) {
                for (String string4 : stringArray) {
                    n2 += string4.length();
                }
            }
            this.minLength = n2;
        }

        @Override
        public boolean apply(JSONPath jSONPath, Object object, Object object2, Object object3) {
            Object object4 = jSONPath.getPropertyValue(object3, this.propertyName, this.propertyNameHash);
            if (object4 == null) {
                return false;
            }
            String string = object4.toString();
            if (string.length() < this.minLength) {
                return this.not;
            }
            int n2 = 0;
            if (this.startsWithValue != null) {
                if (!string.startsWith(this.startsWithValue)) {
                    return this.not;
                }
                n2 += this.startsWithValue.length();
            }
            if (this.containsValues != null) {
                for (String string2 : this.containsValues) {
                    int n3 = string.indexOf(string2, n2);
                    if (n3 == -1) {
                        return this.not;
                    }
                    n2 = n3 + string2.length();
                }
            }
            if (this.endsWithValue != null && !string.endsWith(this.endsWithValue)) {
                return this.not;
            }
            return !this.not;
        }
    }

    static class RefOpSegement
    implements Filter {
        private final String propertyName;
        private final Segment refSgement;
        private final Operator op;
        private final long propertyNameHash;

        public RefOpSegement(String string, Segment segment, Operator operator) {
            this.propertyName = string;
            this.refSgement = segment;
            this.op = operator;
            this.propertyNameHash = TypeUtils.fnv1a_64(string);
        }

        @Override
        public boolean apply(JSONPath jSONPath, Object object, Object object2, Object object3) {
            Object object4 = jSONPath.getPropertyValue(object3, this.propertyName, this.propertyNameHash);
            if (object4 == null) {
                return false;
            }
            if (!(object4 instanceof Number)) {
                return false;
            }
            Object object5 = this.refSgement.eval(jSONPath, object, object);
            if (object5 instanceof Integer || object5 instanceof Long || object5 instanceof Short || object5 instanceof Byte) {
                long l2 = TypeUtils.longExtractValue((Number)object5);
                if (object4 instanceof Integer || object4 instanceof Long || object4 instanceof Short || object4 instanceof Byte) {
                    long l3 = TypeUtils.longExtractValue((Number)object4);
                    switch (this.op) {
                        case EQ: {
                            return l3 == l2;
                        }
                        case NE: {
                            return l3 != l2;
                        }
                        case GE: {
                            return l3 >= l2;
                        }
                        case GT: {
                            return l3 > l2;
                        }
                        case LE: {
                            return l3 <= l2;
                        }
                        case LT: {
                            return l3 < l2;
                        }
                    }
                } else if (object4 instanceof BigDecimal) {
                    BigDecimal bigDecimal = BigDecimal.valueOf(l2);
                    int n2 = bigDecimal.compareTo((BigDecimal)object4);
                    switch (this.op) {
                        case EQ: {
                            return n2 == 0;
                        }
                        case NE: {
                            return n2 != 0;
                        }
                        case GE: {
                            return 0 >= n2;
                        }
                        case GT: {
                            return 0 > n2;
                        }
                        case LE: {
                            return 0 <= n2;
                        }
                        case LT: {
                            return 0 < n2;
                        }
                    }
                    return false;
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    static class DoubleOpSegement
    implements Filter {
        private final String propertyName;
        private final double value;
        private final Operator op;
        private final long propertyNameHash;

        public DoubleOpSegement(String string, double d2, Operator operator) {
            this.propertyName = string;
            this.value = d2;
            this.op = operator;
            this.propertyNameHash = TypeUtils.fnv1a_64(string);
        }

        @Override
        public boolean apply(JSONPath jSONPath, Object object, Object object2, Object object3) {
            Object object4 = jSONPath.getPropertyValue(object3, this.propertyName, this.propertyNameHash);
            if (object4 == null) {
                return false;
            }
            if (!(object4 instanceof Number)) {
                return false;
            }
            double d2 = ((Number)object4).doubleValue();
            switch (this.op) {
                case EQ: {
                    return d2 == this.value;
                }
                case NE: {
                    return d2 != this.value;
                }
                case GE: {
                    return d2 >= this.value;
                }
                case GT: {
                    return d2 > this.value;
                }
                case LE: {
                    return d2 <= this.value;
                }
                case LT: {
                    return d2 < this.value;
                }
            }
            return false;
        }
    }

    static class IntOpSegement
    implements Filter {
        private final String propertyName;
        private final long propertyNameHash;
        private final long value;
        private final Operator op;
        private BigDecimal valueDecimal;
        private Float valueFloat;
        private Double valueDouble;

        public IntOpSegement(String string, long l2, Operator operator) {
            this.propertyName = string;
            this.propertyNameHash = TypeUtils.fnv1a_64(string);
            this.value = l2;
            this.op = operator;
        }

        @Override
        public boolean apply(JSONPath jSONPath, Object object, Object object2, Object object3) {
            Object object4 = jSONPath.getPropertyValue(object3, this.propertyName, this.propertyNameHash);
            if (object4 == null) {
                return false;
            }
            if (!(object4 instanceof Number)) {
                return false;
            }
            if (object4 instanceof BigDecimal) {
                if (this.valueDecimal == null) {
                    this.valueDecimal = BigDecimal.valueOf(this.value);
                }
                int n2 = this.valueDecimal.compareTo((BigDecimal)object4);
                switch (this.op) {
                    case EQ: {
                        return n2 == 0;
                    }
                    case NE: {
                        return n2 != 0;
                    }
                    case GE: {
                        return 0 >= n2;
                    }
                    case GT: {
                        return 0 > n2;
                    }
                    case LE: {
                        return 0 <= n2;
                    }
                    case LT: {
                        return 0 < n2;
                    }
                }
                return false;
            }
            if (object4 instanceof Float) {
                if (this.valueFloat == null) {
                    this.valueFloat = Float.valueOf(this.value);
                }
                int n3 = this.valueFloat.compareTo((Float)object4);
                switch (this.op) {
                    case EQ: {
                        return n3 == 0;
                    }
                    case NE: {
                        return n3 != 0;
                    }
                    case GE: {
                        return 0 >= n3;
                    }
                    case GT: {
                        return 0 > n3;
                    }
                    case LE: {
                        return 0 <= n3;
                    }
                    case LT: {
                        return 0 < n3;
                    }
                }
                return false;
            }
            if (object4 instanceof Double) {
                if (this.valueDouble == null) {
                    this.valueDouble = this.value;
                }
                int n4 = this.valueDouble.compareTo((Double)object4);
                switch (this.op) {
                    case EQ: {
                        return n4 == 0;
                    }
                    case NE: {
                        return n4 != 0;
                    }
                    case GE: {
                        return 0 >= n4;
                    }
                    case GT: {
                        return 0 > n4;
                    }
                    case LE: {
                        return 0 <= n4;
                    }
                    case LT: {
                        return 0 < n4;
                    }
                }
                return false;
            }
            long l2 = TypeUtils.longExtractValue((Number)object4);
            switch (this.op) {
                case EQ: {
                    return l2 == this.value;
                }
                case NE: {
                    return l2 != this.value;
                }
                case GE: {
                    return l2 >= this.value;
                }
                case GT: {
                    return l2 > this.value;
                }
                case LE: {
                    return l2 <= this.value;
                }
                case LT: {
                    return l2 < this.value;
                }
            }
            return false;
        }
    }

    static class StringInSegement
    implements Filter {
        private final String propertyName;
        private final long propertyNameHash;
        private final String[] values;
        private final boolean not;

        public StringInSegement(String string, String[] stringArray, boolean bl) {
            this.propertyName = string;
            this.propertyNameHash = TypeUtils.fnv1a_64(string);
            this.values = stringArray;
            this.not = bl;
        }

        @Override
        public boolean apply(JSONPath jSONPath, Object object, Object object2, Object object3) {
            Object object4 = jSONPath.getPropertyValue(object3, this.propertyName, this.propertyNameHash);
            for (String string : this.values) {
                if (string == object4) {
                    return !this.not;
                }
                if (string == null || !string.equals(object4)) continue;
                return !this.not;
            }
            return this.not;
        }
    }

    static class IntObjInSegement
    implements Filter {
        private final String propertyName;
        private final long propertyNameHash;
        private final Long[] values;
        private final boolean not;

        public IntObjInSegement(String string, Long[] longArray, boolean bl) {
            this.propertyName = string;
            this.propertyNameHash = TypeUtils.fnv1a_64(string);
            this.values = longArray;
            this.not = bl;
        }

        @Override
        public boolean apply(JSONPath jSONPath, Object object, Object object2, Object object3) {
            Object object4 = jSONPath.getPropertyValue(object3, this.propertyName, this.propertyNameHash);
            if (object4 == null) {
                for (Long l2 : this.values) {
                    if (l2 != null) continue;
                    return !this.not;
                }
                return this.not;
            }
            if (object4 instanceof Number) {
                long l3 = TypeUtils.longExtractValue((Number)object4);
                for (Long l4 : this.values) {
                    if (l4 == null || l4 != l3) continue;
                    return !this.not;
                }
            }
            return this.not;
        }
    }

    static class IntBetweenSegement
    implements Filter {
        private final String propertyName;
        private final long propertyNameHash;
        private final long startValue;
        private final long endValue;
        private final boolean not;

        public IntBetweenSegement(String string, long l2, long l3, boolean bl) {
            this.propertyName = string;
            this.propertyNameHash = TypeUtils.fnv1a_64(string);
            this.startValue = l2;
            this.endValue = l3;
            this.not = bl;
        }

        @Override
        public boolean apply(JSONPath jSONPath, Object object, Object object2, Object object3) {
            long l2;
            Object object4 = jSONPath.getPropertyValue(object3, this.propertyName, this.propertyNameHash);
            if (object4 == null) {
                return false;
            }
            if (object4 instanceof Number && (l2 = TypeUtils.longExtractValue((Number)object4)) >= this.startValue && l2 <= this.endValue) {
                return !this.not;
            }
            return this.not;
        }
    }

    static class IntInSegement
    implements Filter {
        private final String propertyName;
        private final long propertyNameHash;
        private final long[] values;
        private final boolean not;

        public IntInSegement(String string, long[] lArray, boolean bl) {
            this.propertyName = string;
            this.propertyNameHash = TypeUtils.fnv1a_64(string);
            this.values = lArray;
            this.not = bl;
        }

        @Override
        public boolean apply(JSONPath jSONPath, Object object, Object object2, Object object3) {
            Object object4 = jSONPath.getPropertyValue(object3, this.propertyName, this.propertyNameHash);
            if (object4 == null) {
                return false;
            }
            if (object4 instanceof Number) {
                long l2 = TypeUtils.longExtractValue((Number)object4);
                for (long l3 : this.values) {
                    if (l3 != l2) continue;
                    return !this.not;
                }
            }
            return this.not;
        }
    }

    static class ValueSegment
    implements Filter {
        private final String propertyName;
        private final long propertyNameHash;
        private final Object value;
        private boolean eq = true;

        public ValueSegment(String string, Object object, boolean bl) {
            if (object == null) {
                throw new IllegalArgumentException("value is null");
            }
            this.propertyName = string;
            this.propertyNameHash = TypeUtils.fnv1a_64(string);
            this.value = object;
            this.eq = bl;
        }

        @Override
        public boolean apply(JSONPath jSONPath, Object object, Object object2, Object object3) {
            Object object4 = jSONPath.getPropertyValue(object3, this.propertyName, this.propertyNameHash);
            boolean bl = this.value.equals(object4);
            if (!this.eq) {
                bl = !bl;
            }
            return bl;
        }
    }

    static class NullSegement
    implements Filter {
        private final String propertyName;
        private final long propertyNameHash;

        public NullSegement(String string) {
            this.propertyName = string;
            this.propertyNameHash = TypeUtils.fnv1a_64(string);
        }

        @Override
        public boolean apply(JSONPath jSONPath, Object object, Object object2, Object object3) {
            Object object4 = jSONPath.getPropertyValue(object3, this.propertyName, this.propertyNameHash);
            return object4 == null;
        }
    }

    static class NotNullSegement
    implements Filter {
        private final String propertyName;
        private final long propertyNameHash;

        public NotNullSegement(String string) {
            this.propertyName = string;
            this.propertyNameHash = TypeUtils.fnv1a_64(string);
        }

        @Override
        public boolean apply(JSONPath jSONPath, Object object, Object object2, Object object3) {
            Object object4 = jSONPath.getPropertyValue(object3, this.propertyName, this.propertyNameHash);
            return object4 != null;
        }
    }

    static class RangeSegment
    implements Segment {
        private final int start;
        private final int end;
        private final int step;

        public RangeSegment(int n2, int n3, int n4) {
            this.start = n2;
            this.end = n3;
            this.step = n4;
        }

        @Override
        public Object eval(JSONPath jSONPath, Object object, Object object2) {
            int n2;
            int n3 = SizeSegment.instance.eval(jSONPath, object, object2);
            int n4 = this.end >= 0 ? this.end : this.end + n3;
            int n5 = (n4 - (n2 = this.start >= 0 ? this.start : this.start + n3)) / this.step + 1;
            if (n5 == -1) {
                return null;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(n5);
            for (int i2 = n2; i2 <= n4 && i2 < n3; i2 += this.step) {
                Object object3 = jSONPath.getArrayItem(object2, i2);
                arrayList.add(object3);
            }
            return arrayList;
        }

        @Override
        public void extract(JSONPath jSONPath, DefaultJSONParser defaultJSONParser, Context context) {
            throw new UnsupportedOperationException();
        }
    }

    static class MultiIndexSegment
    implements Segment {
        private final int[] indexes;

        public MultiIndexSegment(int[] nArray) {
            this.indexes = nArray;
        }

        @Override
        public Object eval(JSONPath jSONPath, Object object, Object object2) {
            JSONArray jSONArray = new JSONArray(this.indexes.length);
            for (int i2 = 0; i2 < this.indexes.length; ++i2) {
                Object object3 = jSONPath.getArrayItem(object2, this.indexes[i2]);
                jSONArray.add(object3);
            }
            return jSONArray;
        }

        @Override
        public void extract(JSONPath jSONPath, DefaultJSONParser defaultJSONParser, Context context) {
            Object object;
            if (context.eval && (object = defaultJSONParser.parse()) instanceof List) {
                int[] nArray = new int[this.indexes.length];
                System.arraycopy(this.indexes, 0, nArray, 0, nArray.length);
                boolean bl = nArray[0] >= 0;
                List list = (List)object;
                if (bl) {
                    for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                        if (Arrays.binarySearch(nArray, i2) >= 0) continue;
                        list.remove(i2);
                    }
                    context.object = list;
                    return;
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    static class ArrayAccessSegment
    implements Segment {
        private final int index;

        public ArrayAccessSegment(int n2) {
            this.index = n2;
        }

        @Override
        public Object eval(JSONPath jSONPath, Object object, Object object2) {
            return jSONPath.getArrayItem(object2, this.index);
        }

        public boolean setValue(JSONPath jSONPath, Object object, Object object2) {
            return jSONPath.setArrayItem(jSONPath, object, this.index, object2);
        }

        public boolean remove(JSONPath jSONPath, Object object) {
            return jSONPath.removeArrayItem(jSONPath, object, this.index);
        }

        @Override
        public void extract(JSONPath jSONPath, DefaultJSONParser defaultJSONParser, Context context) {
            JSONLexerBase jSONLexerBase = (JSONLexerBase)defaultJSONParser.lexer;
            if (jSONLexerBase.seekArrayToItem(this.index) && context.eval) {
                context.object = defaultJSONParser.parse();
            }
        }
    }

    static class WildCardSegment
    implements Segment {
        private boolean deep;
        public static final WildCardSegment instance = new WildCardSegment(false);
        public static final WildCardSegment instance_deep = new WildCardSegment(true);

        private WildCardSegment(boolean bl) {
            this.deep = bl;
        }

        @Override
        public Object eval(JSONPath jSONPath, Object object, Object object2) {
            if (!this.deep) {
                return jSONPath.getPropertyValues(object2);
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            jSONPath.deepGetPropertyValues(object2, arrayList);
            return arrayList;
        }

        @Override
        public void extract(JSONPath jSONPath, DefaultJSONParser defaultJSONParser, Context context) {
            if (context.eval) {
                Object object = defaultJSONParser.parse();
                if (this.deep) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    jSONPath.deepGetPropertyValues(object, arrayList);
                    context.object = arrayList;
                    return;
                }
                if (object instanceof JSONObject) {
                    Collection<Object> collection = ((JSONObject)object).values();
                    JSONArray jSONArray = new JSONArray(collection.size());
                    for (Object object2 : collection) {
                        jSONArray.add(object2);
                    }
                    context.object = jSONArray;
                    return;
                }
                if (object instanceof JSONArray) {
                    context.object = object;
                    return;
                }
            }
            throw new JSONException("TODO");
        }
    }

    static class MultiPropertySegment
    implements Segment {
        private final String[] propertyNames;
        private final long[] propertyNamesHash;

        public MultiPropertySegment(String[] stringArray) {
            this.propertyNames = stringArray;
            this.propertyNamesHash = new long[stringArray.length];
            for (int i2 = 0; i2 < this.propertyNamesHash.length; ++i2) {
                this.propertyNamesHash[i2] = TypeUtils.fnv1a_64(stringArray[i2]);
            }
        }

        @Override
        public Object eval(JSONPath jSONPath, Object object, Object object2) {
            ArrayList<Object> arrayList = new ArrayList<Object>(this.propertyNames.length);
            for (int i2 = 0; i2 < this.propertyNames.length; ++i2) {
                Object object3 = jSONPath.getPropertyValue(object2, this.propertyNames[i2], this.propertyNamesHash[i2]);
                arrayList.add(object3);
            }
            return arrayList;
        }

        @Override
        public void extract(JSONPath jSONPath, DefaultJSONParser defaultJSONParser, Context context) {
            int n2;
            JSONArray jSONArray;
            JSONLexerBase jSONLexerBase = (JSONLexerBase)defaultJSONParser.lexer;
            if (context.object == null) {
                jSONArray = new JSONArray();
                context.object = jSONArray;
            } else {
                jSONArray = (JSONArray)context.object;
            }
            for (n2 = jSONArray.size(); n2 < this.propertyNamesHash.length; ++n2) {
                jSONArray.add((Object)null);
            }
            do {
                Object object;
                n2 = jSONLexerBase.seekObjectToField(this.propertyNamesHash);
                int n3 = jSONLexerBase.matchStat;
                if (n3 != 3) break;
                switch (jSONLexerBase.token()) {
                    case 2: {
                        object = jSONLexerBase.integerValue();
                        jSONLexerBase.nextToken(16);
                        break;
                    }
                    case 3: {
                        object = jSONLexerBase.decimalValue();
                        jSONLexerBase.nextToken(16);
                        break;
                    }
                    case 4: {
                        object = jSONLexerBase.stringVal();
                        jSONLexerBase.nextToken(16);
                        break;
                    }
                    default: {
                        object = defaultJSONParser.parse();
                    }
                }
                jSONArray.set(n2, object);
            } while (jSONLexerBase.token() == 16);
        }
    }

    static class PropertySegment
    implements Segment {
        private final String propertyName;
        private final long propertyNameHash;
        private final boolean deep;

        public PropertySegment(String string, boolean bl) {
            this.propertyName = string;
            this.propertyNameHash = TypeUtils.fnv1a_64(string);
            this.deep = bl;
        }

        @Override
        public Object eval(JSONPath jSONPath, Object object, Object object2) {
            if (this.deep) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                jSONPath.deepScan(object2, this.propertyName, arrayList);
                return arrayList;
            }
            return jSONPath.getPropertyValue(object2, this.propertyName, this.propertyNameHash);
        }

        @Override
        public void extract(JSONPath jSONPath, DefaultJSONParser defaultJSONParser, Context context) {
            int n2;
            JSONLexerBase jSONLexerBase = (JSONLexerBase)defaultJSONParser.lexer;
            if (this.deep && context.object == null) {
                context.object = new JSONArray();
            }
            if (jSONLexerBase.token() == 14) {
                JSONArray jSONArray;
                block36: {
                    if ("*".equals(this.propertyName)) {
                        return;
                    }
                    jSONLexerBase.nextToken();
                    jSONArray = this.deep ? (JSONArray)context.object : new JSONArray();
                    block19: while (true) {
                        switch (jSONLexerBase.token()) {
                            case 12: {
                                if (this.deep) {
                                    this.extract(jSONPath, defaultJSONParser, context);
                                    break;
                                }
                                int n3 = jSONLexerBase.seekObjectToField(this.propertyNameHash, this.deep);
                                if (n3 == 3) {
                                    Object object;
                                    switch (jSONLexerBase.token()) {
                                        case 2: {
                                            object = jSONLexerBase.integerValue();
                                            jSONLexerBase.nextToken();
                                            break;
                                        }
                                        case 4: {
                                            object = jSONLexerBase.stringVal();
                                            jSONLexerBase.nextToken();
                                            break;
                                        }
                                        default: {
                                            object = defaultJSONParser.parse();
                                        }
                                    }
                                    jSONArray.add(object);
                                    if (jSONLexerBase.token() == 13) {
                                        jSONLexerBase.nextToken();
                                        continue block19;
                                    }
                                    jSONLexerBase.skipObject(false);
                                    break;
                                }
                                if (n3 == -1) continue block19;
                                if (this.deep) {
                                    throw new UnsupportedOperationException(jSONLexerBase.info());
                                }
                                jSONLexerBase.skipObject(false);
                                break;
                            }
                            case 14: {
                                if (this.deep) {
                                    this.extract(jSONPath, defaultJSONParser, context);
                                    break;
                                }
                                jSONLexerBase.skipObject(false);
                                break;
                            }
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: {
                                jSONLexerBase.nextToken();
                                break;
                            }
                        }
                        if (jSONLexerBase.token() == 15) break block36;
                        if (jSONLexerBase.token() != 16) break;
                        jSONLexerBase.nextToken();
                    }
                    throw new JSONException("illegal json : " + jSONLexerBase.info());
                }
                jSONLexerBase.nextToken();
                if (!this.deep && jSONArray.size() > 0) {
                    context.object = jSONArray;
                }
                return;
            }
            if (!this.deep) {
                int n4 = jSONLexerBase.seekObjectToField(this.propertyNameHash, this.deep);
                if (n4 == 3 && context.eval) {
                    Object object;
                    switch (jSONLexerBase.token()) {
                        case 2: {
                            object = jSONLexerBase.integerValue();
                            jSONLexerBase.nextToken(16);
                            break;
                        }
                        case 3: {
                            object = jSONLexerBase.decimalValue();
                            jSONLexerBase.nextToken(16);
                            break;
                        }
                        case 4: {
                            object = jSONLexerBase.stringVal();
                            jSONLexerBase.nextToken(16);
                            break;
                        }
                        default: {
                            object = defaultJSONParser.parse();
                        }
                    }
                    if (context.eval) {
                        context.object = object;
                    }
                }
                return;
            }
            while ((n2 = jSONLexerBase.seekObjectToField(this.propertyNameHash, this.deep)) != -1) {
                if (n2 == 3) {
                    Object object;
                    if (!context.eval) continue;
                    switch (jSONLexerBase.token()) {
                        case 2: {
                            object = jSONLexerBase.integerValue();
                            jSONLexerBase.nextToken(16);
                            break;
                        }
                        case 3: {
                            object = jSONLexerBase.decimalValue();
                            jSONLexerBase.nextToken(16);
                            break;
                        }
                        case 4: {
                            object = jSONLexerBase.stringVal();
                            jSONLexerBase.nextToken(16);
                            break;
                        }
                        default: {
                            object = defaultJSONParser.parse();
                        }
                    }
                    if (!context.eval) continue;
                    if (context.object instanceof List) {
                        List list = (List)context.object;
                        if (list.size() == 0 && object instanceof List) {
                            context.object = object;
                            continue;
                        }
                        list.add(object);
                        continue;
                    }
                    context.object = object;
                    continue;
                }
                if (n2 != 1 && n2 != 2) continue;
                this.extract(jSONPath, defaultJSONParser, context);
            }
        }

        public void setValue(JSONPath jSONPath, Object object, Object object2) {
            if (this.deep) {
                jSONPath.deepSet(object, this.propertyName, this.propertyNameHash, object2);
            } else {
                jSONPath.setPropertyValue(object, this.propertyName, this.propertyNameHash, object2);
            }
        }

        public boolean remove(JSONPath jSONPath, Object object) {
            return jSONPath.removePropertyValue(object, this.propertyName, this.deep);
        }
    }

    static class KeySetSegment
    implements Segment {
        public static final KeySetSegment instance = new KeySetSegment();

        KeySetSegment() {
        }

        @Override
        public Object eval(JSONPath jSONPath, Object object, Object object2) {
            return jSONPath.evalKeySet(object2);
        }

        @Override
        public void extract(JSONPath jSONPath, DefaultJSONParser defaultJSONParser, Context context) {
            throw new UnsupportedOperationException();
        }
    }

    static class MinSegment
    implements Segment {
        public static final MinSegment instance = new MinSegment();

        MinSegment() {
        }

        @Override
        public Object eval(JSONPath jSONPath, Object object, Object object2) {
            Object var4_4 = null;
            if (object2 instanceof Collection) {
                for (Object e2 : (Collection)object2) {
                    if (e2 == null) continue;
                    if (var4_4 == null) {
                        var4_4 = e2;
                        continue;
                    }
                    if (JSONPath.compare(var4_4, e2) <= 0) continue;
                    var4_4 = e2;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            return var4_4;
        }

        @Override
        public void extract(JSONPath jSONPath, DefaultJSONParser defaultJSONParser, Context context) {
            throw new UnsupportedOperationException();
        }
    }

    static class MaxSegment
    implements Segment {
        public static final MaxSegment instance = new MaxSegment();

        MaxSegment() {
        }

        @Override
        public Object eval(JSONPath jSONPath, Object object, Object object2) {
            Object var4_4 = null;
            if (object2 instanceof Collection) {
                for (Object e2 : (Collection)object2) {
                    if (e2 == null) continue;
                    if (var4_4 == null) {
                        var4_4 = e2;
                        continue;
                    }
                    if (JSONPath.compare(var4_4, e2) >= 0) continue;
                    var4_4 = e2;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            return var4_4;
        }

        @Override
        public void extract(JSONPath jSONPath, DefaultJSONParser defaultJSONParser, Context context) {
            throw new UnsupportedOperationException();
        }
    }

    static class SizeSegment
    implements Segment {
        public static final SizeSegment instance = new SizeSegment();

        SizeSegment() {
        }

        @Override
        public Integer eval(JSONPath jSONPath, Object object, Object object2) {
            return jSONPath.evalSize(object2);
        }

        @Override
        public void extract(JSONPath jSONPath, DefaultJSONParser defaultJSONParser, Context context) {
            throw new UnsupportedOperationException();
        }
    }

    static interface Segment {
        public Object eval(JSONPath var1, Object var2, Object var3);

        public void extract(JSONPath var1, DefaultJSONParser var2, Context var3);
    }

    static class JSONPathParser {
        private final String path;
        private int pos;
        private char ch;
        private int level;
        private boolean hasRefSegment;
        private static final String strArrayRegex = "'\\s*,\\s*'";
        private static final Pattern strArrayPatternx = Pattern.compile("'\\s*,\\s*'");

        public JSONPathParser(String string) {
            this.path = string;
            this.next();
        }

        void next() {
            this.ch = this.path.charAt(this.pos++);
        }

        char getNextChar() {
            return this.path.charAt(this.pos);
        }

        boolean isEOF() {
            return this.pos >= this.path.length();
        }

        Segment readSegement() {
            if (this.level == 0 && this.path.length() == 1) {
                if (JSONPathParser.isDigitFirst(this.ch)) {
                    int n2 = this.ch - 48;
                    return new ArrayAccessSegment(n2);
                }
                if (this.ch >= 'a' && this.ch <= 'z' || this.ch >= 'A' && this.ch <= 'Z') {
                    return new PropertySegment(Character.toString(this.ch), false);
                }
            }
            while (!this.isEOF()) {
                this.skipWhitespace();
                if (this.ch == '$') {
                    this.next();
                    continue;
                }
                if (this.ch == '.' || this.ch == '/') {
                    char c2 = this.ch;
                    boolean bl = false;
                    this.next();
                    if (c2 == '.' && this.ch == '.') {
                        this.next();
                        bl = true;
                        if (this.path.length() > this.pos + 3 && this.ch == '[' && this.path.charAt(this.pos) == '*' && this.path.charAt(this.pos + 1) == ']' && this.path.charAt(this.pos + 2) == '.') {
                            this.next();
                            this.next();
                            this.next();
                            this.next();
                        }
                    }
                    if (this.ch == '*') {
                        if (!this.isEOF()) {
                            this.next();
                        }
                        return bl ? WildCardSegment.instance_deep : WildCardSegment.instance;
                    }
                    if (JSONPathParser.isDigitFirst(this.ch)) {
                        return this.parseArrayAccess(false);
                    }
                    String string = this.readName();
                    if (this.ch == '(') {
                        this.next();
                        if (this.ch == ')') {
                            if (!this.isEOF()) {
                                this.next();
                            }
                            if ("size".equals(string) || "length".equals(string)) {
                                return SizeSegment.instance;
                            }
                            if ("max".equals(string)) {
                                return MaxSegment.instance;
                            }
                            if ("min".equals(string)) {
                                return MinSegment.instance;
                            }
                            if ("keySet".equals(string)) {
                                return KeySetSegment.instance;
                            }
                            throw new JSONPathException("not support jsonpath : " + this.path);
                        }
                        throw new JSONPathException("not support jsonpath : " + this.path);
                    }
                    return new PropertySegment(string, bl);
                }
                if (this.ch == '[') {
                    return this.parseArrayAccess(true);
                }
                if (this.level == 0) {
                    String string = this.readName();
                    return new PropertySegment(string, false);
                }
                throw new JSONPathException("not support jsonpath : " + this.path);
            }
            return null;
        }

        public final void skipWhitespace() {
            while (this.ch <= ' ' && (this.ch == ' ' || this.ch == '\r' || this.ch == '\n' || this.ch == '\t' || this.ch == '\f' || this.ch == '\b')) {
                this.next();
            }
        }

        Segment parseArrayAccess(boolean bl) {
            Object object = this.parseArrayAccessFilter(bl);
            if (object instanceof Segment) {
                return (Segment)object;
            }
            return new FilterSegment((Filter)object);
        }

        Object parseArrayAccessFilter(boolean bl) {
            if (bl) {
                this.accept('[');
            }
            boolean bl2 = false;
            int n2 = 0;
            if (this.ch == '?') {
                this.next();
                this.accept('(');
                ++n2;
                while (this.ch == '(') {
                    this.next();
                    ++n2;
                }
                bl2 = true;
            }
            if (bl2 || IOUtils.firstIdentifier(this.ch) || Character.isJavaIdentifierStart(this.ch) || this.ch == '\\' || this.ch == '@') {
                String string;
                boolean bl3 = false;
                if (this.ch == '@') {
                    this.next();
                    this.accept('.');
                    bl3 = true;
                }
                String string2 = this.readName();
                this.skipWhitespace();
                if (bl2 && this.ch == ')') {
                    this.next();
                    Filter filter = new NotNullSegement(string2);
                    while (this.ch == ' ') {
                        this.next();
                    }
                    if (this.ch == '&' || this.ch == '|') {
                        filter = this.filterRest(filter);
                    }
                    if (bl) {
                        this.accept(']');
                    }
                    return filter;
                }
                if (bl && this.ch == ']') {
                    this.next();
                    Filter filter = new NotNullSegement(string2);
                    while (this.ch == ' ') {
                        this.next();
                    }
                    if (this.ch == '&' || this.ch == '|') {
                        filter = this.filterRest(filter);
                    }
                    this.accept(')');
                    if (bl2) {
                        this.accept(')');
                    }
                    if (bl) {
                        this.accept(']');
                    }
                    return filter;
                }
                Operator operator = this.readOp();
                this.skipWhitespace();
                if (operator == Operator.BETWEEN || operator == Operator.NOT_BETWEEN) {
                    boolean bl4 = operator == Operator.NOT_BETWEEN;
                    Object object = this.readValue();
                    String string3 = this.readName();
                    if (!"and".equalsIgnoreCase(string3)) {
                        throw new JSONPathException(this.path);
                    }
                    Object object2 = this.readValue();
                    if (object == null || object2 == null) {
                        throw new JSONPathException(this.path);
                    }
                    if (JSONPath.isInt(object.getClass()) && JSONPath.isInt(object2.getClass())) {
                        IntBetweenSegement intBetweenSegement = new IntBetweenSegement(string2, TypeUtils.longExtractValue((Number)object), TypeUtils.longExtractValue((Number)object2), bl4);
                        return intBetweenSegement;
                    }
                    throw new JSONPathException(this.path);
                }
                if (operator == Operator.IN || operator == Operator.NOT_IN) {
                    Object object;
                    Object object3;
                    boolean bl5 = operator == Operator.NOT_IN;
                    this.accept('(');
                    JSONArray jSONArray = new JSONArray();
                    Object object4 = this.readValue();
                    jSONArray.add(object4);
                    while (true) {
                        this.skipWhitespace();
                        if (this.ch != ',') break;
                        this.next();
                        object4 = this.readValue();
                        jSONArray.add(object4);
                    }
                    boolean bl6 = true;
                    boolean bl7 = true;
                    boolean bl8 = true;
                    for (Object object5 : jSONArray) {
                        if (object5 == null) {
                            if (!bl6) continue;
                            bl6 = false;
                            continue;
                        }
                        object3 = object5.getClass();
                        if (bl6 && object3 != Byte.class && object3 != Short.class && object3 != Integer.class && object3 != Long.class) {
                            bl6 = false;
                            bl7 = false;
                        }
                        if (!bl8 || object3 == String.class) continue;
                        bl8 = false;
                    }
                    if (jSONArray.size() == 1 && jSONArray.get(0) == null) {
                        object = bl5 ? new NotNullSegement(string2) : new NullSegement(string2);
                        while (this.ch == ' ') {
                            this.next();
                        }
                        if (this.ch == '&' || this.ch == '|') {
                            object = this.filterRest((Filter)object);
                        }
                        this.accept(')');
                        if (bl2) {
                            this.accept(')');
                        }
                        if (bl) {
                            this.accept(']');
                        }
                        return object;
                    }
                    if (bl6) {
                        if (jSONArray.size() == 1) {
                            long l2 = TypeUtils.longExtractValue((Number)jSONArray.get(0));
                            object3 = bl5 ? Operator.NE : Operator.EQ;
                            Filter filter = new IntOpSegement(string2, l2, (Operator)((Object)object3));
                            while (this.ch == ' ') {
                                this.next();
                            }
                            if (this.ch == '&' || this.ch == '|') {
                                filter = this.filterRest(filter);
                            }
                            this.accept(')');
                            if (bl2) {
                                this.accept(')');
                            }
                            if (bl) {
                                this.accept(']');
                            }
                            return filter;
                        }
                        object = new long[jSONArray.size()];
                        for (int i2 = 0; i2 < ((Long[])object).length; ++i2) {
                            object[i2] = TypeUtils.longExtractValue((Number)jSONArray.get(i2));
                        }
                        Filter filter = new IntInSegement(string2, (long[])object, bl5);
                        while (this.ch == ' ') {
                            this.next();
                        }
                        if (this.ch == '&' || this.ch == '|') {
                            filter = this.filterRest(filter);
                        }
                        this.accept(')');
                        if (bl2) {
                            this.accept(')');
                        }
                        if (bl) {
                            this.accept(']');
                        }
                        return filter;
                    }
                    if (bl8) {
                        Object object5;
                        if (jSONArray.size() == 1) {
                            object = (String)jSONArray.get(0);
                            object5 = bl5 ? Operator.NE : Operator.EQ;
                            object3 = new StringOpSegement(string2, (String)object, (Operator)((Object)object5));
                            while (this.ch == ' ') {
                                this.next();
                            }
                            if (this.ch == '&' || this.ch == '|') {
                                object3 = this.filterRest((Filter)object3);
                            }
                            this.accept(')');
                            if (bl2) {
                                this.accept(')');
                            }
                            if (bl) {
                                this.accept(']');
                            }
                            return object3;
                        }
                        object = new String[jSONArray.size()];
                        jSONArray.toArray((T[])object);
                        object5 = new StringInSegement(string2, (String[])object, bl5);
                        while (this.ch == ' ') {
                            this.next();
                        }
                        if (this.ch == '&' || this.ch == '|') {
                            object5 = this.filterRest((Filter)object5);
                        }
                        this.accept(')');
                        if (bl2) {
                            this.accept(')');
                        }
                        if (bl) {
                            this.accept(']');
                        }
                        return object5;
                    }
                    if (bl7) {
                        object = new Long[jSONArray.size()];
                        for (int i3 = 0; i3 < ((Long[])object).length; ++i3) {
                            object3 = (Number)jSONArray.get(i3);
                            if (object3 == null) continue;
                            object[i3] = TypeUtils.longExtractValue(object3);
                        }
                        Filter filter = new IntObjInSegement(string2, (Long[])object, bl5);
                        while (this.ch == ' ') {
                            this.next();
                        }
                        if (this.ch == '&' || this.ch == '|') {
                            filter = this.filterRest(filter);
                        }
                        this.accept(')');
                        if (bl2) {
                            this.accept(')');
                        }
                        if (bl) {
                            this.accept(']');
                        }
                        return filter;
                    }
                    throw new UnsupportedOperationException();
                }
                if (this.ch == '\'' || this.ch == '\"') {
                    String string4 = this.readString();
                    Filter filter = null;
                    if (operator == Operator.RLIKE) {
                        filter = new RlikeSegement(string2, string4, false);
                    } else if (operator == Operator.NOT_RLIKE) {
                        filter = new RlikeSegement(string2, string4, true);
                    } else if (operator == Operator.LIKE || operator == Operator.NOT_LIKE) {
                        while (string4.indexOf("%%") != -1) {
                            string4 = string4.replaceAll("%%", "%");
                        }
                        boolean bl9 = operator == Operator.NOT_LIKE;
                        int n3 = string4.indexOf(37);
                        if (n3 == -1) {
                            operator = operator == Operator.LIKE ? Operator.EQ : Operator.NE;
                            filter = new StringOpSegement(string2, string4, operator);
                        } else {
                            String[] stringArray = string4.split("%");
                            String string5 = null;
                            String string6 = null;
                            String[] stringArray2 = null;
                            if (n3 == 0) {
                                if (string4.charAt(string4.length() - 1) == '%') {
                                    stringArray2 = new String[stringArray.length - 1];
                                    System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
                                } else {
                                    string6 = stringArray[stringArray.length - 1];
                                    if (stringArray.length > 2) {
                                        stringArray2 = new String[stringArray.length - 2];
                                        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
                                    }
                                }
                            } else if (string4.charAt(string4.length() - 1) == '%') {
                                if (stringArray.length == 1) {
                                    string5 = stringArray[0];
                                } else {
                                    stringArray2 = stringArray;
                                }
                            } else if (stringArray.length == 1) {
                                string5 = stringArray[0];
                            } else if (stringArray.length == 2) {
                                string5 = stringArray[0];
                                string6 = stringArray[1];
                            } else {
                                string5 = stringArray[0];
                                string6 = stringArray[stringArray.length - 1];
                                stringArray2 = new String[stringArray.length - 2];
                                System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
                            }
                            filter = new MatchSegement(string2, string5, string6, stringArray2, bl9);
                        }
                    } else {
                        filter = new StringOpSegement(string2, string4, operator);
                    }
                    while (this.ch == ' ') {
                        this.next();
                    }
                    if (this.ch == '&' || this.ch == '|') {
                        filter = this.filterRest(filter);
                    }
                    if (bl2) {
                        this.accept(')');
                    }
                    if (bl) {
                        this.accept(']');
                    }
                    return filter;
                }
                if (JSONPathParser.isDigitFirst(this.ch)) {
                    long l3 = this.readLongValue();
                    double d2 = 0.0;
                    if (this.ch == '.') {
                        d2 = this.readDoubleValue(l3);
                    }
                    Filter filter = d2 == 0.0 ? new IntOpSegement(string2, l3, operator) : new DoubleOpSegement(string2, d2, operator);
                    while (this.ch == ' ') {
                        this.next();
                    }
                    if (n2 > 1 && this.ch == ')') {
                        this.next();
                        --n2;
                    }
                    if (this.ch == '&' || this.ch == '|') {
                        filter = this.filterRest(filter);
                    }
                    if (bl2) {
                        --n2;
                        this.accept(')');
                    }
                    if (bl) {
                        this.accept(']');
                    }
                    return filter;
                }
                if (this.ch == '$') {
                    Segment segment = this.readSegement();
                    RefOpSegement refOpSegement = new RefOpSegement(string2, segment, operator);
                    this.hasRefSegment = true;
                    while (this.ch == ' ') {
                        this.next();
                    }
                    if (bl2) {
                        this.accept(')');
                    }
                    if (bl) {
                        this.accept(']');
                    }
                    return refOpSegement;
                }
                if (this.ch == '/') {
                    int n4 = 0;
                    StringBuilder stringBuilder = new StringBuilder();
                    while (true) {
                        this.next();
                        if (this.ch == '/') {
                            this.next();
                            if (this.ch != 'i') break;
                            this.next();
                            n4 |= 2;
                            break;
                        }
                        if (this.ch == '\\') {
                            this.next();
                            stringBuilder.append(this.ch);
                            continue;
                        }
                        stringBuilder.append(this.ch);
                    }
                    Pattern pattern = Pattern.compile(stringBuilder.toString(), n4);
                    RegMatchSegement regMatchSegement = new RegMatchSegement(string2, pattern, operator);
                    if (bl2) {
                        this.accept(')');
                    }
                    if (bl) {
                        this.accept(']');
                    }
                    return regMatchSegement;
                }
                if (this.ch == 'n') {
                    String string7 = this.readName();
                    if ("null".equals(string7)) {
                        Filter filter = null;
                        if (operator == Operator.EQ) {
                            filter = new NullSegement(string2);
                        } else if (operator == Operator.NE) {
                            filter = new NotNullSegement(string2);
                        }
                        if (filter != null) {
                            while (this.ch == ' ') {
                                this.next();
                            }
                            if (this.ch == '&' || this.ch == '|') {
                                filter = this.filterRest(filter);
                            }
                        }
                        if (bl2) {
                            this.accept(')');
                        }
                        this.accept(']');
                        if (filter != null) {
                            return filter;
                        }
                        throw new UnsupportedOperationException();
                    }
                } else if (this.ch == 't') {
                    String string8 = this.readName();
                    if ("true".equals(string8)) {
                        Filter filter = null;
                        if (operator == Operator.EQ) {
                            filter = new ValueSegment(string2, Boolean.TRUE, true);
                        } else if (operator == Operator.NE) {
                            filter = new ValueSegment(string2, Boolean.TRUE, false);
                        }
                        if (filter != null) {
                            while (this.ch == ' ') {
                                this.next();
                            }
                            if (this.ch == '&' || this.ch == '|') {
                                filter = this.filterRest(filter);
                            }
                        }
                        if (bl2) {
                            this.accept(')');
                        }
                        this.accept(']');
                        if (filter != null) {
                            return filter;
                        }
                        throw new UnsupportedOperationException();
                    }
                } else if (this.ch == 'f' && "false".equals(string = this.readName())) {
                    Filter filter = null;
                    if (operator == Operator.EQ) {
                        filter = new ValueSegment(string2, Boolean.FALSE, true);
                    } else if (operator == Operator.NE) {
                        filter = new ValueSegment(string2, Boolean.FALSE, false);
                    }
                    if (filter != null) {
                        while (this.ch == ' ') {
                            this.next();
                        }
                        if (this.ch == '&' || this.ch == '|') {
                            filter = this.filterRest(filter);
                        }
                    }
                    if (bl2) {
                        this.accept(')');
                    }
                    this.accept(']');
                    if (filter != null) {
                        return filter;
                    }
                    throw new UnsupportedOperationException();
                }
                throw new UnsupportedOperationException();
            }
            int n5 = this.pos - 1;
            char c2 = this.ch;
            while (this.ch != ']' && this.ch != '/' && !this.isEOF() && (this.ch != '.' || bl2 || bl2 || c2 == '\'')) {
                if (this.ch == '\\') {
                    this.next();
                }
                this.next();
            }
            int n6 = bl ? this.pos - 1 : (this.ch == '/' || this.ch == '.' ? this.pos - 1 : this.pos);
            String string = this.path.substring(n5, n6);
            if (string.indexOf("\\.") != -1) {
                String string9;
                if (c2 == '\'' && string.length() > 2 && string.charAt(string.length() - 1) == c2) {
                    string9 = string.substring(1, string.length() - 1);
                } else {
                    string9 = string.replaceAll("\\\\\\.", "\\.");
                    if (string9.indexOf("\\-") != -1) {
                        string9 = string9.replaceAll("\\\\-", "-");
                    }
                }
                if (bl2) {
                    this.accept(')');
                }
                return new PropertySegment(string9, false);
            }
            Segment segment = this.buildArraySegement(string);
            if (bl && !this.isEOF()) {
                this.accept(']');
            }
            return segment;
        }

        Filter filterRest(Filter filter) {
            boolean bl;
            boolean bl2 = bl = this.ch == '&';
            if (this.ch == '&' && this.getNextChar() == '&' || this.ch == '|' && this.getNextChar() == '|') {
                this.next();
                this.next();
                boolean bl3 = false;
                if (this.ch == '(') {
                    bl3 = true;
                    this.next();
                }
                while (this.ch == ' ') {
                    this.next();
                }
                Filter filter2 = (Filter)this.parseArrayAccessFilter(false);
                filter = new FilterGroup(filter, filter2, bl);
                if (bl3 && this.ch == ')') {
                    this.next();
                }
            }
            return filter;
        }

        protected long readLongValue() {
            int n2 = this.pos - 1;
            if (this.ch == '+' || this.ch == '-') {
                this.next();
            }
            while (this.ch >= '0' && this.ch <= '9') {
                this.next();
            }
            int n3 = this.pos - 1;
            String string = this.path.substring(n2, n3);
            long l2 = Long.parseLong(string);
            return l2;
        }

        protected double readDoubleValue(long l2) {
            int n2 = this.pos - 1;
            this.next();
            while (this.ch >= '0' && this.ch <= '9') {
                this.next();
            }
            int n3 = this.pos - 1;
            String string = this.path.substring(n2, n3);
            double d2 = Double.parseDouble(string);
            return d2 += (double)l2;
        }

        protected Object readValue() {
            this.skipWhitespace();
            if (JSONPathParser.isDigitFirst(this.ch)) {
                return this.readLongValue();
            }
            if (this.ch == '\"' || this.ch == '\'') {
                return this.readString();
            }
            if (this.ch == 'n') {
                String string = this.readName();
                if ("null".equals(string)) {
                    return null;
                }
                throw new JSONPathException(this.path);
            }
            throw new UnsupportedOperationException();
        }

        static boolean isDigitFirst(char c2) {
            return c2 == '-' || c2 == '+' || c2 >= '0' && c2 <= '9';
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected Operator readOp() {
            Operator operator = null;
            if (this.ch == '=') {
                this.next();
                if (this.ch == '~') {
                    this.next();
                    operator = Operator.REG_MATCH;
                } else if (this.ch == '=') {
                    this.next();
                    operator = Operator.EQ;
                } else {
                    operator = Operator.EQ;
                }
            } else if (this.ch == '!') {
                this.next();
                this.accept('=');
                operator = Operator.NE;
            } else if (this.ch == '<') {
                this.next();
                if (this.ch == '=') {
                    this.next();
                    operator = Operator.LE;
                } else {
                    operator = Operator.LT;
                }
            } else if (this.ch == '>') {
                this.next();
                if (this.ch == '=') {
                    this.next();
                    operator = Operator.GE;
                } else {
                    operator = Operator.GT;
                }
            }
            if (operator != null) return operator;
            String string = this.readName();
            if ("not".equalsIgnoreCase(string)) {
                this.skipWhitespace();
                string = this.readName();
                if ("like".equalsIgnoreCase(string)) {
                    return Operator.NOT_LIKE;
                }
                if ("rlike".equalsIgnoreCase(string)) {
                    return Operator.NOT_RLIKE;
                }
                if ("in".equalsIgnoreCase(string)) {
                    return Operator.NOT_IN;
                }
                if (!"between".equalsIgnoreCase(string)) throw new UnsupportedOperationException();
                return Operator.NOT_BETWEEN;
            }
            if ("nin".equalsIgnoreCase(string)) {
                return Operator.NOT_IN;
            }
            if ("like".equalsIgnoreCase(string)) {
                return Operator.LIKE;
            }
            if ("rlike".equalsIgnoreCase(string)) {
                return Operator.RLIKE;
            }
            if ("in".equalsIgnoreCase(string)) {
                return Operator.IN;
            }
            if (!"between".equalsIgnoreCase(string)) throw new UnsupportedOperationException();
            return Operator.BETWEEN;
        }

        String readName() {
            this.skipWhitespace();
            if (this.ch != '\\' && !Character.isJavaIdentifierStart(this.ch)) {
                throw new JSONPathException("illeal jsonpath syntax. " + this.path);
            }
            StringBuilder stringBuilder = new StringBuilder();
            while (!this.isEOF()) {
                if (this.ch == '\\') {
                    this.next();
                    stringBuilder.append(this.ch);
                    if (this.isEOF()) {
                        return stringBuilder.toString();
                    }
                    this.next();
                    continue;
                }
                boolean bl = Character.isJavaIdentifierPart(this.ch);
                if (!bl) break;
                stringBuilder.append(this.ch);
                this.next();
            }
            if (this.isEOF() && Character.isJavaIdentifierPart(this.ch)) {
                stringBuilder.append(this.ch);
            }
            return stringBuilder.toString();
        }

        String readString() {
            char c2 = this.ch;
            this.next();
            int n2 = this.pos - 1;
            while (this.ch != c2 && !this.isEOF()) {
                this.next();
            }
            String string = this.path.substring(n2, this.isEOF() ? this.pos : this.pos - 1);
            this.accept(c2);
            return string;
        }

        void accept(char c2) {
            if (this.ch != c2) {
                throw new JSONPathException("expect '" + c2 + ", but '" + this.ch + "'");
            }
            if (!this.isEOF()) {
                this.next();
            }
        }

        public Segment[] explain() {
            Segment[] segmentArray;
            if (this.path == null || this.path.length() == 0) {
                throw new IllegalArgumentException();
            }
            Segment[] segmentArray2 = new Segment[8];
            while ((segmentArray = this.readSegement()) != null) {
                Segment[] segmentArray3;
                if (segmentArray instanceof PropertySegment && !((PropertySegment)(segmentArray3 = (Segment[])segmentArray)).deep && ((PropertySegment)segmentArray3).propertyName.equals("*")) continue;
                if (this.level == segmentArray2.length) {
                    segmentArray3 = new Segment[this.level * 3 / 2];
                    System.arraycopy(segmentArray2, 0, segmentArray3, 0, this.level);
                    segmentArray2 = segmentArray3;
                }
                segmentArray2[this.level++] = segmentArray;
            }
            if (this.level == segmentArray2.length) {
                return segmentArray2;
            }
            segmentArray = new Segment[this.level];
            System.arraycopy(segmentArray2, 0, segmentArray, 0, this.level);
            return segmentArray;
        }

        Segment buildArraySegement(String string) {
            int n2 = string.length();
            char c2 = string.charAt(0);
            char c3 = string.charAt(n2 - 1);
            int n3 = string.indexOf(44);
            if (string.length() > 2 && c2 == '\'' && c3 == '\'') {
                String string2 = string.substring(1, n2 - 1);
                if (n3 == -1 || !strArrayPatternx.matcher(string).find()) {
                    return new PropertySegment(string2, false);
                }
                String[] stringArray = string2.split(strArrayRegex);
                return new MultiPropertySegment(stringArray);
            }
            int n4 = string.indexOf(58);
            if (n3 == -1 && n4 == -1) {
                if (TypeUtils.isNumber(string)) {
                    try {
                        int n5 = Integer.parseInt(string);
                        return new ArrayAccessSegment(n5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return new PropertySegment(string, false);
                    }
                }
                if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
                    string = string.substring(1, string.length() - 1);
                }
                return new PropertySegment(string, false);
            }
            if (n3 != -1) {
                String[] stringArray = string.split(",");
                int[] nArray = new int[stringArray.length];
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    nArray[i2] = Integer.parseInt(stringArray[i2]);
                }
                return new MultiIndexSegment(nArray);
            }
            if (n4 != -1) {
                int n6;
                String[] stringArray = string.split(":");
                int[] nArray = new int[stringArray.length];
                for (n6 = 0; n6 < stringArray.length; ++n6) {
                    String string3 = stringArray[n6];
                    if (string3.length() == 0) {
                        if (n6 == 0) {
                            nArray[n6] = 0;
                            continue;
                        }
                        throw new UnsupportedOperationException();
                    }
                    nArray[n6] = Integer.parseInt(string3);
                }
                n6 = nArray[0];
                int n7 = nArray.length > 1 ? nArray[1] : -1;
                int n8 = nArray.length == 3 ? nArray[2] : 1;
                if (n7 >= 0 && n7 < n6) {
                    throw new UnsupportedOperationException("end must greater than or equals start. start " + n6 + ",  end " + n7);
                }
                if (n8 <= 0) {
                    throw new UnsupportedOperationException("step must greater than zero : " + n8);
                }
                return new RangeSegment(n6, n7, n8);
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class Context {
        final Context parent;
        final boolean eval;
        Object object;

        public Context(Context context, boolean bl) {
            this.parent = context;
            this.eval = bl;
        }
    }
}

