/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.algorithm.common;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCS7AuthHelper;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.util.BigIntegerUtil;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.cms.Attribute;
import cfca.sadk.org.bouncycastle.asn1.cms.AttributeTable;
import cfca.sadk.org.bouncycastle.asn1.cms.CMSAttributes;
import cfca.sadk.org.bouncycastle.asn1.cms.Time;
import cfca.sadk.org.bouncycastle.asn1.pkcs.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SignedData;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SignerInfo;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x509.Certificate;
import cfca.sadk.signature.PKCS7PackageFacade;
import cfca.sadk.signature.rsa.RSASignUtil;
import cfca.sadk.signature.sm2.SM2SignerInfo;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.util.Base64;
import cfca.sadk.util.HashUtil;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;

public class PKCS7SignedData {
    private Session session = null;
    private SignedData signedData = null;

    public PKCS7SignedData(Session session) {
        this.session = session;
    }

    public byte[] packageSignedData(boolean ifAttach, String contentType, byte[] sourceData, byte[] encryptData, Mechanism digestAlgorithm, X509Cert[] receiverCerts) throws PKIException {
        try {
            return PKCS7PackageFacade.packageSignedData(ifAttach, contentType, sourceData, encryptData, digestAlgorithm, receiverCerts);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("build signedData failure", e);
        }
    }

    public void loadDERData(byte[] data) throws PKIException {
        ASN1Sequence seq;
        if (data == null || data.length == 0) {
            throw new PKIException("PKCS7SignedData encoding required not  be null");
        }
        if (!ASN1Parser.isDERSequence(data)) {
            throw new PKIException("PKCS7SignedData encoding required DERSequence");
        }
        try {
            seq = ASN1Sequence.getInstance(data);
        }
        catch (Exception e) {
            throw new PKIException("PKCS7SignedData decoding failure", e);
        }
        this.load(seq);
    }

    public void loadBase64(byte[] data) throws PKIException {
        ASN1Sequence seq;
        if (data == null || data.length == 0) {
            throw new PKIException("PKCS7SignedData encoding required not  be null");
        }
        byte[] encoding = null;
        if (ASN1Parser.isDERSequence(data)) {
            encoding = data;
        } else {
            try {
                encoding = Base64.decode(data);
            }
            catch (Exception e) {
                throw new PKIException("PKCS7SignedData encoding required base64", e);
            }
        }
        try {
            seq = ASN1Sequence.getInstance(encoding);
        }
        catch (Exception e) {
            throw new PKIException("PKCS7SignedData decoding failure", e);
        }
        this.load(seq);
    }

    private final void load(ASN1Sequence seq) throws PKIException {
        SignedData sd = null;
        try {
            ContentInfo contentInfo = ContentInfo.getInstance(seq);
            sd = SignedData.getInstance(contentInfo.getContent());
        }
        catch (Exception e) {
            throw new PKIException(PKIException.PARSE_P7_SIGNEDDATA_ERR, "PKCS7SignedData decoding failure", e);
        }
        this.signedData = sd;
    }

    public SignedData getSignedData() {
        return this.signedData;
    }

    public boolean verifyP7SignedDataAttach() throws PKIException {
        byte[] sourceData = this.getSourceData();
        ASN1Set aset = this.signedData.getSignerInfos();
        if (this.isSM2Cert()) {
            return this.verifySM2SignerInfo((byte[])sourceData.clone(), true, null, aset, null);
        }
        return this.verifyRSASignerInfo((byte[])sourceData.clone(), aset, null);
    }

    public byte[] getSourceData() throws PKIException {
        ContentInfo contentInfo = this.signedData.getContentInfo();
        byte[] sourceData = null;
        if (contentInfo.getContentType().equals(PKCSObjectIdentifiers.data) || contentInfo.getContentType().equals(PKCSObjectIdentifiers.id_ct_TSTInfo) || contentInfo.getContentType().equals(PKCSObjectIdentifiers.sm2Data)) {
            if (contentInfo.getContent() == null) {
                throw new PKIException(PKIException.PARSE_P7_SIGNEDDATA_ERR, PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, new Exception("no sourceData to be verify."));
            }
            sourceData = ((ASN1OctetString)contentInfo.getContent()).getOctets();
        } else {
            sourceData = ASN1Parser.parseDERObj2Bytes(contentInfo.getContent().toASN1Primitive());
        }
        return (byte[])sourceData.clone();
    }

    private boolean verifySignerInfoByFile(InputStream sourceFileStream, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            boolean verifyResult = false;
            if (signerEnumer.hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR, PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR_DES);
                }
                ASN1ObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm();
                if (!(encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption) || encryptionId.equals(PKCSObjectIdentifiers.md5WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption))) {
                    throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_SIGNED_ALG_SIGNANDENVELOP_ERR_DES);
                }
                ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
                Mechanism signM = Mechanisms.signMechanismRSAFrom(digestId);
                if (signM == null) {
                    throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_SIGNED_ALG_SIGNANDENVELOP_ERR_DES);
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] signature = signerInfo.getEncryptedDigest().getOctets();
                ASN1Set authAttributes = signerInfo.getAuthenticatedAttributes();
                verifyResult = RSASignUtil.verifySignFile(signM, pubKey, sourceFileStream, signature, authAttributes, this.session);
            }
            return verifyResult;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.PARSE_P7_SIGNEDDATA_ERR, PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, ex);
        }
    }

    private boolean verifyRSASignerInfo(byte[] content, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            boolean verifyResult = false;
            if (signerEnumer.hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR, PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR_DES);
                }
                ASN1ObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm();
                if (!(encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption) || encryptionId.equals(PKCSObjectIdentifiers.md5WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption))) {
                    throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_SIGNED_ALG_SIGNANDENVELOP_ERR_DES);
                }
                ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
                Mechanism signM = Mechanisms.signMechanismRSAFrom(digestId);
                if (signM == null) {
                    throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_SIGNED_ALG_SIGNANDENVELOP_ERR_DES);
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] signature = signerInfo.getEncryptedDigest().getOctets();
                ASN1Set authAttributes = signerInfo.getAuthenticatedAttributes();
                verifyResult = RSASignUtil.verifySignData(signM, pubKey, content, signature, authAttributes, this.session);
            }
            return verifyResult;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.PARSE_P7_SIGNEDDATA_ERR, PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, ex);
        }
    }

    private boolean verifySM2SignerInfoByFile(InputStream sourceFileStream, boolean ifZValue, byte[] userId, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            boolean verifyResult = false;
            if (signerEnumer.hasMoreElements()) {
                SM2SignerInfo signerInfo = SM2SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSM2SignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR, PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR_DES);
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] r = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
                byte[] s = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
                byte[] signature = new byte[64];
                System.arraycopy(r, 0, signature, 0, 32);
                System.arraycopy(s, 0, signature, 32, 32);
                ASN1Set authAttributes = signerInfo.getAuthenticatedAttributes();
                if (authAttributes == null) {
                    verifyResult = this.session.verify(Mechanisms.M_SM3_SM2, pubKey, sourceFileStream, signature);
                } else {
                    byte[] contentDigest = HashUtil.SM3HashFileWithoutZValue(sourceFileStream, this.session);
                    verifyResult = PKCS7AuthHelper.sm2VerifySignAuthAttr(contentDigest, authAttributes, this.session, pubKey, signature);
                }
            }
            return verifyResult;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.PARSE_SM2_SIGNEDDATA_ERR, PKIException.VERIFY_SM2_SIGNEDDATA_ERR_DES, ex);
        }
    }

    private boolean verifySM2SignerInfo(byte[] content, boolean ifZValue, byte[] userId, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            boolean verifyResult = false;
            if (signerEnumer.hasMoreElements()) {
                SM2SignerInfo signerInfo = SM2SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSM2SignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR, PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR_DES);
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] r = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
                byte[] s = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
                byte[] signature = new byte[64];
                System.arraycopy(r, 0, signature, 0, 32);
                System.arraycopy(s, 0, signature, 32, 32);
                ASN1Set authAttributes = signerInfo.getAuthenticatedAttributes();
                if (authAttributes != null) {
                    byte[] contentDigest = HashUtil.SM3HashData(content, this.session);
                    verifyResult = PKCS7AuthHelper.sm2VerifySignAuthAttr(contentDigest, authAttributes, this.session, pubKey, signature);
                } else {
                    verifyResult = this.session.verify(Mechanisms.M_SM3_SM2, pubKey, content, signature);
                }
            }
            return verifyResult;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.PARSE_SM2_SIGNEDDATA_ERR, PKIException.VERIFY_SM2_SIGNEDDATA_ERR_DES, ex);
        }
    }

    private boolean isSM2Cert() {
        ASN1Set certSet = this.signedData.getCertificates();
        Certificate certStru = Certificate.getInstance(certSet.getObjectAt(0));
        return new X509Cert(certStru).isSM2Cert();
    }

    private X509Cert[] getSignerCerts() throws PKIException {
        ASN1Set certSet = this.signedData.getCertificates();
        X509Cert[] signerCerts = new X509Cert[certSet.size()];
        for (int i = 0; i < certSet.size(); ++i) {
            Certificate certStru = Certificate.getInstance(certSet.getObjectAt(i));
            signerCerts[i] = new X509Cert(certStru);
        }
        return signerCerts;
    }

    public X509Cert getSignerX509Cert() throws PKIException {
        X509Cert signerCerts = null;
        ASN1Set certSet = this.signedData.getCertificates();
        Certificate certStru = Certificate.getInstance(certSet.getObjectAt(0));
        signerCerts = new X509Cert(certStru);
        return signerCerts;
    }

    private X509Cert getSignerCert(X509Cert[] certs, IssuerAndSerialNumber issuerAndSN) throws PKIException {
        String issuer = issuerAndSN.getName().toString();
        BigInteger sn = issuerAndSN.getCertificateSerialNumber().getValue();
        for (int i = 0; i < certs.length; ++i) {
            X500Name tmpIssuer = certs[i].getIssuerX500Name();
            BigInteger tmpSN = certs[i].getSerialNumber();
            if (!tmpIssuer.toString().equals(issuer) || tmpSN.compareTo(sn) != 0) continue;
            return certs[i];
        }
        return null;
    }

    private X509Cert getSM2SignerCert(X509Cert[] certs, IssuerAndSerialNumber issuerAndSN) throws PKIException {
        String issuer = issuerAndSN.getName().toString();
        BigInteger sn = issuerAndSN.getCertificateSerialNumber().getValue();
        for (int i = 0; i < certs.length; ++i) {
            X500Name tmpIssuer = certs[i].getIssuerX500Name();
            BigInteger tmpSN = certs[i].getSerialNumber();
            if (!tmpIssuer.toString().equals(issuer) || tmpSN.compareTo(sn) != 0) continue;
            return certs[i];
        }
        return null;
    }

    public boolean verifyP7SignedData(InputStream sourceFileStream) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        if (this.isSM2Cert()) {
            return this.verifySM2SignerInfoByFile(sourceFileStream, true, null, aset, null);
        }
        return this.verifySignerInfoByFile(sourceFileStream, aset, null);
    }

    public boolean verifyP7SignedData(byte[] sourceData) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        if (this.isSM2Cert()) {
            return this.verifySM2SignerInfo(sourceData, true, null, aset, null);
        }
        return this.verifyRSASignerInfo(sourceData, aset, null);
    }

    private byte[] getSM2Signature() throws PKIException {
        ASN1Set signerInfos = this.signedData.getSignerInfos();
        Enumeration signerEnumer = signerInfos.getObjects();
        if (signerEnumer.hasMoreElements()) {
            SM2SignerInfo signerInfo = SM2SignerInfo.getInstance(signerEnumer.nextElement());
            byte[] r = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
            byte[] s = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
            byte[] signature = new byte[64];
            System.arraycopy(r, 0, signature, 0, 32);
            System.arraycopy(s, 0, signature, 32, 32);
            return signature;
        }
        throw new PKIException("can not get SM2SignerInfo object!!!");
    }

    public byte[] getSignature() throws PKIException {
        if (this.isSM2Cert()) {
            return this.getSM2Signature();
        }
        ASN1Set signerInfos = this.signedData.getSignerInfos();
        Enumeration signerEnumer = signerInfos.getObjects();
        if (signerEnumer.hasMoreElements()) {
            SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
            return signerInfo.getEncryptedDigest().getOctets();
        }
        throw new PKIException("can not get SignerInfo object!!!");
    }

    public String getDigestAlgorithm() throws PKIException {
        if (this.isSM2Cert()) {
            return "SM3";
        }
        ASN1Set signerInfos = this.signedData.getSignerInfos();
        Enumeration signerEnumer = signerInfos.getObjects();
        String signM = null;
        if (signerEnumer.hasMoreElements()) {
            SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
            ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
            signM = Mechanisms.getDigestAlgorithmName(digestId);
            if (signM == null) {
                throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_SIGNED_ALG_SIGNANDENVELOP_ERR_DES);
            }
            return signM;
        }
        throw new PKIException("can not get SignerInfo object!!!");
    }

    public boolean verifySM2SignedData(InputStream sourceStream, boolean ifZValue, byte[] userId) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        if (ifZValue) {
            if (userId != null) {
                return this.verifySM2SignerInfoByFile(sourceStream, true, (byte[])userId.clone(), aset, null);
            }
            return this.verifySM2SignerInfoByFile(sourceStream, true, null, aset, null);
        }
        return this.verifySM2SignerInfoByFile(sourceStream, false, null, aset, null);
    }

    public boolean verifySM2SignedData(byte[] sourceData, boolean ifZValue, byte[] userId) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        if (ifZValue) {
            if (userId != null) {
                return this.verifySM2SignerInfo((byte[])sourceData.clone(), true, (byte[])userId.clone(), aset, null);
            }
            return this.verifySM2SignerInfo((byte[])sourceData.clone(), true, null, aset, null);
        }
        return this.verifySM2SignerInfo((byte[])sourceData.clone(), false, null, aset, null);
    }

    public boolean verifyP7SignedDataByHash(byte[] digest) throws PKIException {
        ASN1Set aset = this.signedData.getSignerInfos();
        if (this.isSM2Cert()) {
            return this.verifySM2SignerInfoByHash(digest, aset, null);
        }
        return this.verifySignerInfoByHash(digest, aset, null);
    }

    private boolean verifySignerInfoByHash(byte[] digest, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            boolean verifyResult = false;
            if (signerEnumer.hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR, PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR_DES);
                }
                ASN1ObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm();
                if (!(encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption) || encryptionId.equals(PKCSObjectIdentifiers.md5WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption))) {
                    throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_SIGNED_ALG_SIGNANDENVELOP_ERR_DES);
                }
                ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
                Mechanism signM = Mechanisms.signMechanismRSAFrom(digestId);
                if (signM == null) {
                    throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_SIGNED_ALG_SIGNANDENVELOP_ERR_DES);
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] signature = signerInfo.getEncryptedDigest().getOctets();
                ASN1Set authAttributes = signerInfo.getAuthenticatedAttributes();
                verifyResult = authAttributes == null ? this.session.verifyByHash(signM, pubKey, digest, signature) : PKCS7AuthHelper.rsaVerifySignAuthAttr(signM, digest, authAttributes, this.session, pubKey, signature);
            }
            return verifyResult;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.PARSE_P7_SIGNEDDATA_ERR, PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, ex);
        }
    }

    private boolean verifySM2SignerInfoByHash(byte[] digest, ASN1Set signerInfos, X509Cert[] certs) throws PKIException {
        try {
            if (certs == null) {
                certs = this.getSignerCerts();
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            boolean verifyResult = false;
            if (signerEnumer.hasMoreElements()) {
                SM2SignerInfo signerInfo = SM2SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSM2SignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR, PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR_DES);
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] r = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
                byte[] s = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
                byte[] signature = new byte[64];
                System.arraycopy(r, 0, signature, 0, 32);
                System.arraycopy(s, 0, signature, 32, 32);
                ASN1Set authAttributes = signerInfo.getAuthenticatedAttributes();
                verifyResult = authAttributes == null ? this.session.verifyByHash(Mechanisms.M_SM3_SM2, pubKey, digest, signature) : PKCS7AuthHelper.sm2VerifySignAuthAttr(digest, authAttributes, this.session, pubKey, signature);
            }
            return verifyResult;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.PARSE_SM2_SIGNEDDATA_ERR, PKIException.VERIFY_SM2_SIGNEDDATA_ERR_DES, ex);
        }
    }

    public final String getSignTime() throws PKIException {
        ASN1Set signerInfos;
        String signTimeText = null;
        if (this.signedData != null && (signerInfos = this.signedData.getSignerInfos()) != null) {
            Enumeration signerEnumer = signerInfos.getObjects();
            if (signerEnumer.hasMoreElements()) {
                AttributeTable attributeTable;
                Attribute signTimeAttr;
                boolean hasSignTimeAttr;
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                ASN1Set signedAttributeSet = signerInfo.getAuthenticatedAttributes();
                if (signedAttributeSet != null && (hasSignTimeAttr = this.hasSignTime(signTimeAttr = (attributeTable = new AttributeTable(signedAttributeSet)).get(CMSAttributes.signingTime)))) {
                    Time time = Time.getInstance(signTimeAttr.getAttrValues().getObjectAt(0).toASN1Primitive());
                    Date signTimeDate = time.getDate();
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    signTimeText = format.format(signTimeDate);
                }
            } else {
                throw new PKIException("getSignTime failed: can not get SignerInfo");
            }
        }
        return signTimeText;
    }

    private final boolean hasSignTime(Attribute signTimeAttr) {
        boolean hasSignTime = false;
        if (signTimeAttr != null) {
            hasSignTime = signTimeAttr.getAttrValues() != null && signTimeAttr.getAttrValues().size() > 0;
        }
        return hasSignTime;
    }
}

