/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card;

import cfca.sadk.algorithm.common.GenKeyAttribute;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.DeviceInfo;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.StreamEncryptChecker;
import cfca.sadk.lib.crypto.card.CardConf;
import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.CardLibParams;
import cfca.sadk.lib.crypto.card.DigestInfoHelper;
import cfca.sadk.lib.crypto.card.IECCCard;
import cfca.sadk.lib.crypto.card.IRSACard;
import cfca.sadk.lib.crypto.card.ISM2Card;
import cfca.sadk.lib.crypto.card.SM2Key;
import cfca.sadk.lib.crypto.card.c200.C200SM2Card;
import cfca.sadk.lib.crypto.card.c200.ECCHelper;
import cfca.sadk.lib.crypto.card.dummy.DummyECCCard;
import cfca.sadk.lib.crypto.card.dummy.DummyRSACard;
import cfca.sadk.lib.crypto.card.dummy.DummySM2Card;
import cfca.sadk.lib.crypto.jni.JNISoftLib;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Cipher;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import cfca.sadk.system.CompatibleAlgorithm;
import cfca.sadk.system.CompatibleConfig;
import cfca.sadk.system.FileHelper;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.util.HashUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class CardLib
implements Session {
    final int BUFFSIZE = 16384;
    final ISM2Card sm2Card;
    final IRSACard rsaCard;
    final IECCCard eccCard;
    final Session softLib;
    final CardLibParams cardParams;
    final boolean isC200Card;

    public CardLib(CardLibParams cardParams) throws PKIException {
        LoggerManager.systemLogger.info("CardLib constructor startup with param=" + cardParams);
        this.softLib = JNISoftLib.INSTANCE();
        if (cardParams == null) {
            throw new PKIException("CardLib constructor failure with cardParams is null");
        }
        this.cardParams = cardParams;
        CardConf ini = new CardConf(cardParams.getCardIniPath());
        Object sm2InitParams = cardParams.getSm2CardInitParams();
        if (sm2InitParams == null) {
            sm2InitParams = ini.getSM2CardInfo();
        }
        if (ini.sm2cardImplClass != null) {
            ISM2Card sm2Card = null;
            try {
                LoggerManager.systemLogger.info("CardLib config sm2cardImplClass=" + ini.sm2cardImplClass);
                sm2Card = (ISM2Card)Class.forName(ini.sm2cardImplClass).newInstance();
                sm2Card.initLib(sm2InitParams);
                LoggerManager.systemLogger.info("CardLib constructor startup with sm2Card=" + sm2Card);
                this.sm2Card = sm2Card;
                this.isC200Card = sm2Card instanceof C200SM2Card;
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("CardLib constructor sm2Card failure with " + ini.sm2cardImplClass, (Throwable)e);
                throw new PKIException("CardLib constructor sm2Card failure with " + ini.sm2cardImplClass, e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("CardLib constructor sm2Card failure with " + ini.sm2cardImplClass, e);
                throw new PKIException("CardLib constructor sm2Card failure with " + ini.sm2cardImplClass, e);
            }
        } else {
            this.sm2Card = new DummySM2Card();
            this.isC200Card = false;
        }
        LoggerManager.systemLogger.info("CardLib config sm2cardImplClass=" + this.sm2Card + ",isC200Card=" + this.isC200Card);
        if (ini.ecccardImplClass != null) {
            IECCCard eccCard = null;
            try {
                LoggerManager.systemLogger.info("CardLib config ecccardImplClass=" + ini.ecccardImplClass);
                eccCard = (IECCCard)Class.forName(ini.ecccardImplClass).newInstance();
                eccCard.initLib(sm2InitParams);
                LoggerManager.systemLogger.info("CardLib constructor startup with eccCard=" + eccCard);
                this.eccCard = eccCard;
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("CardLib constructor eccCard failure with " + ini.ecccardImplClass, (Throwable)e);
                throw new PKIException("CardLib constructor eccCard failure with " + ini.ecccardImplClass, e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("CardLib constructor eccCard failure with " + ini.ecccardImplClass, e);
                throw new PKIException("CardLib constructor eccCard failure with " + ini.ecccardImplClass, e);
            }
        } else {
            this.eccCard = new DummyECCCard();
        }
        LoggerManager.systemLogger.info("CardLib config ecccardImplClass=" + this.eccCard);
        if (ini.rsacardImplClass != null) {
            IRSACard rsaCard = null;
            Object rsaInitParams = cardParams.getRsaCardInitParams();
            try {
                LoggerManager.systemLogger.info("CardLib config rsacardImplClass=" + ini.rsacardImplClass);
                rsaCard = (IRSACard)Class.forName(ini.rsacardImplClass).newInstance();
                rsaCard.initLib(rsaInitParams);
                LoggerManager.systemLogger.info("CardLib constructor startup with rsaCard=" + rsaCard);
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("CardLib constructor rsaCard failure with " + ini.rsacardImplClass, (Throwable)e);
                throw new PKIException("CardLib constructor rsaCard failure with " + ini.rsacardImplClass, e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("CardLib constructor rsaCard failure with " + ini.rsacardImplClass, e);
                throw new PKIException("CardLib constructor rsaCard failure with " + ini.rsacardImplClass, e);
            }
            this.rsaCard = rsaCard;
        } else {
            this.rsaCard = new DummyRSACard();
        }
        LoggerManager.systemLogger.info("CardLib config rsacardImplClass=" + this.rsaCard);
    }

    public final synchronized void unloadLib() {
        Object param;
        LoggerManager.systemLogger.info("CardLib unloadLib");
        if (this.sm2Card != null) {
            try {
                param = null;
                if (this.cardParams != null) {
                    param = this.cardParams.getSm2CardInitParams();
                }
                LoggerManager.systemLogger.info("CardLib sm2Card unInitLib");
                this.sm2Card.unInitLib(param);
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("CardLib unloadSM2Lib failure", (Throwable)e);
            }
        }
        if (this.rsaCard != null) {
            try {
                param = null;
                if (this.cardParams != null) {
                    param = this.cardParams.getRsaCardInitParams();
                }
                LoggerManager.systemLogger.info("CardLib rsaCard unInitLib");
                this.rsaCard.unInitLib(param);
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("CardLib unloadRSALib failure", (Throwable)e);
            }
        }
    }

    public final Key generateKey(Mechanism mechanism) throws PKIException {
        return this.softLib.generateKey(mechanism);
    }

    public final Key generateKey(Mechanism mechanism, byte[] keyData) throws PKIException {
        return this.softLib.generateKey(mechanism, keyData);
    }

    public final KeyPair generateKeyPair(Mechanism mechanism, int keyLength) throws PKIException {
        KeyPair keypair;
        block13: {
            int keyUsage;
            int keyIndex;
            boolean isExport;
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("GenerateKeyPair >>>>>>running");
                buffer.append("\n mechanism: ");
                buffer.append(SADKDebugger.dump(mechanism));
                buffer.append("\n keyLength: " + keyLength);
                LoggerManager.debugLogger.debug(buffer.toString());
            }
            keypair = null;
            Object param = mechanism.getParam();
            if (param == null) {
                isExport = true;
                keyIndex = -1;
                keyUsage = 0;
            } else if (param instanceof GenKeyAttribute) {
                GenKeyAttribute attr = (GenKeyAttribute)param;
                isExport = attr.isExport;
                keyIndex = attr.keyNum;
                keyUsage = attr.keyUsage;
            } else {
                isExport = true;
                keyIndex = -1;
                keyUsage = 0;
            }
            try {
                if (this.isSM2Type(mechanism)) {
                    keypair = this.sm2Card.generateKeyPair(isExport, keyIndex, keyUsage);
                    break block13;
                }
                if (this.isECCType(mechanism)) {
                    String curveName = mechanism.getCurveName();
                    if ("prime256v1".equals(curveName)) {
                        keypair = this.eccCard.generateKeyPair(isExport, keyIndex, keyUsage);
                        break block13;
                    }
                    throw new PKIException("GenerateKeyPair failure: invalid curveName=" + curveName);
                }
                if (this.isRSAType(mechanism)) {
                    keypair = this.rsaCard.generateKeyPair(isExport, keyLength, keyIndex, keyUsage);
                    break block13;
                }
                throw new PKIException("GenerateKeyPair failure: invalid mechanism=" + mechanism);
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("GenerateKeyPair <<<<<<Failure", (Throwable)e);
                throw new PKIException("GenerateKeyPair failure", e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("GenerateKeyPair <<<<<<Failure", e);
                throw new PKIException("GenerateKeyPair failure", e);
            }
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("GenerateKeyPair <<<<<<Finished: \n" + SADKDebugger.dump(keypair));
        }
        return keypair;
    }

    public final byte[] signByHash(Mechanism mechanism, PrivateKey priKey, byte[] hashValue) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("signByHash >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(priKey));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            HashUtil.checkHashLength(mechanism, hashValue);
            byte[] signData = null;
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                byte[] sm3HashValue = this.confirmSM3HashValueLength(hashValue);
                signData = this.confirmSM2SignValueLength(this.sm2Card.signByHash(priKey, sm3HashValue));
            } else if (Mechanisms.isECDSA(mechanism)) {
                byte[] cardSignData = this.eccCard.signByHash(priKey, hashValue);
                signData = ECCHelper.encodeToStdAsn1(32, cardSignData);
            } else {
                byte[] digestInfoBytes = DigestInfoHelper.buildDigestInfo(mechanism, hashValue);
                signData = this.rsaCard.signByHash(priKey, digestInfoBytes);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("signByHash <<<<<<Finished: signData=" + SADKDebugger.dump(signData));
            }
            return signData;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("signByHash <<<<<<Failure", (Throwable)e);
            throw new PKIException("signByHash failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("signByHash <<<<<<Failure", e);
            throw new PKIException("signByHash failure: " + e.getMessage(), e);
        }
    }

    public final boolean verifyByHash(Mechanism mechanism, PublicKey pubKey, byte[] hashValue, byte[] signData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("verifyByHash >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n PublicKey: ");
            buffer.append(SADKDebugger.dump(pubKey));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            buffer.append("\n signData: ");
            buffer.append(SADKDebugger.dump(signData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            boolean verifyResult;
            HashUtil.checkHashLength(mechanism, hashValue);
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                byte[] sm3HashValue = this.confirmSM3HashValueLength(hashValue);
                byte[] sm2SignValue = this.confirmSM2SignWithRawRS(signData);
                verifyResult = this.sm2Card.verifyByHash(pubKey, sm3HashValue, sm2SignValue);
            } else if (Mechanisms.isECDSA(mechanism)) {
                byte[] signValue = ECCHelper.encodeToStdAsn1(32, signData);
                verifyResult = this.eccCard.verifyByHash(pubKey, hashValue, signValue);
            } else {
                byte[] digestInfoBytes = DigestInfoHelper.buildDigestInfo(mechanism, hashValue);
                verifyResult = this.rsaCard.verifyByHash(pubKey, digestInfoBytes, signData);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("verifyByHash <<<<<<Finished: verifyResult=" + verifyResult);
            }
            return verifyResult;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("verifyByHash <<<<<<Failure", (Throwable)e);
            throw new PKIException("verifyByHash failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("verifyByHash <<<<<<Failure", e);
            throw new PKIException("verifyByHash failure: " + e.getMessage(), e);
        }
    }

    public final byte[] sign(Mechanism mechanism, PrivateKey priKey, byte[] sourceData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("sign message >>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(priKey));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] signData = null;
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                if (!(priKey instanceof SM2Key)) {
                    throw new CardException("sign required SM2Key");
                }
                SM2Key cardKey = (SM2Key)((Object)priKey);
                byte[] sm3HashValue = this.confirmSM3HashValueLength(DigestInfoHelper.hashSM3Digest(cardKey, sourceData));
                signData = this.confirmSM2SignValueLength(this.sm2Card.signByHash(priKey, sm3HashValue));
            } else if (Mechanisms.isECDSA(mechanism)) {
                byte[] hashValue = HashUtil.RSAHashMessageByJNI(sourceData, mechanism, false);
                signData = this.eccCard.signByHash(priKey, hashValue);
            } else {
                byte[] digestInfoBytes = DigestInfoHelper.hashDigestInfo(mechanism, sourceData);
                signData = this.rsaCard.signByHash(priKey, digestInfoBytes);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("sign message <<<<<<Finished: signData=" + SADKDebugger.dump(signData));
            }
            return signData;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("sign message <<<<<<Failure", (Throwable)e);
            throw new PKIException("sign message failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("sign message <<<<<<Failure", e);
            throw new PKIException("sign message failure: " + e.getMessage(), e);
        }
    }

    public final byte[] sign(Mechanism mechanism, PrivateKey priKey, InputStream sourceStream) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("sign stream >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(priKey));
            buffer.append("\n sourceStream: ");
            buffer.append(SADKDebugger.dump(sourceStream));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] signData = null;
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                if (!(priKey instanceof SM2Key)) {
                    throw new CardException("sign required SM2Key");
                }
                SM2Key cardKey = (SM2Key)((Object)priKey);
                byte[] sm3HashValue = this.confirmSM3HashValueLength(DigestInfoHelper.hashSM3Digest(cardKey, sourceStream));
                signData = this.confirmSM2SignValueLength(this.sm2Card.signByHash(priKey, sm3HashValue));
            } else {
                byte[] digestInfoBytes = DigestInfoHelper.hashDigestInfo(mechanism, sourceStream);
                signData = this.rsaCard.signByHash(priKey, digestInfoBytes);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("sign stream <<<<<<Finished: signData=" + SADKDebugger.dump(signData));
            }
            return signData;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("sign stream <<<<<<Failure", (Throwable)e);
            throw new PKIException("sign stream failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("sign stream <<<<<<Failure", e);
            throw new PKIException("sign stream failure: " + e.getMessage(), e);
        }
    }

    public final boolean verify(Mechanism mechanism, PublicKey pubKey, byte[] sourceData, byte[] signData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("verify message >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n PublicKey: ");
            buffer.append(SADKDebugger.dump(pubKey));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            buffer.append("\n signData: ");
            buffer.append(SADKDebugger.dump(signData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            boolean verifyResult = false;
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                if (!(pubKey instanceof SM2Key)) {
                    throw new CardException("sign required SM2Key");
                }
                SM2Key cardKey = (SM2Key)((Object)pubKey);
                byte[] sm2SignValue = this.confirmSM2SignWithRawRS(signData);
                byte[] sm3HashValue = this.confirmSM3HashValueLength(DigestInfoHelper.hashSM3Digest(cardKey, sourceData));
                verifyResult = this.sm2Card.verifyByHash(pubKey, sm3HashValue, sm2SignValue);
                boolean compatibleWithoutZ = CompatibleAlgorithm.isCompatibleSM2WithoutZ();
                if (compatibleWithoutZ && !verifyResult) {
                    byte[] sm3HashWithoutZ = this.confirmSM3HashValueLength(DigestInfoHelper.hashSM3Digest(null, sourceData));
                    verifyResult = this.sm2Card.verifyByHash(pubKey, sm3HashWithoutZ, sm2SignValue);
                }
            } else if (Mechanisms.isECDSA(mechanism)) {
                byte[] hashValue = HashUtil.RSAHashMessageByJNI(sourceData, mechanism, false);
                verifyResult = this.eccCard.verifyByHash(pubKey, hashValue, signData);
            } else {
                byte[] digestInfoBytes = DigestInfoHelper.hashDigestInfo(mechanism, sourceData);
                verifyResult = this.rsaCard.verifyByHash(pubKey, digestInfoBytes, signData);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("verify message <<<<<<Finished: verifyResult=" + verifyResult);
            }
            return verifyResult;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("verify message <<<<<<Failure", (Throwable)e);
            throw new PKIException("verify message failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("verify message <<<<<<Failure", e);
            throw new PKIException("verify message failure: " + e.getMessage(), e);
        }
    }

    public final boolean verify(Mechanism mechanism, PublicKey pubKey, InputStream sourceStream, byte[] signData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("sign stream >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n PublicKey: ");
            buffer.append(SADKDebugger.dump(pubKey));
            buffer.append("\n sourceStream: ");
            buffer.append(SADKDebugger.dump(sourceStream));
            buffer.append("\n signData: ");
            buffer.append(SADKDebugger.dump(signData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            boolean verifyResult = false;
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                if (!(pubKey instanceof SM2Key)) {
                    throw new CardException("sign required SM2Key");
                }
                SM2Key cardKey = (SM2Key)((Object)pubKey);
                byte[] sm2SignValue = this.confirmSM2SignWithRawRS(signData);
                byte[] sm3HashValue = this.confirmSM3HashValueLength(DigestInfoHelper.hashSM3Digest(cardKey, sourceStream));
                verifyResult = this.sm2Card.verifyByHash(pubKey, sm3HashValue, sm2SignValue);
                boolean compatibleWithoutZ = CompatibleAlgorithm.isCompatibleSM2WithoutZ();
                if (compatibleWithoutZ && !verifyResult) {
                    byte[] sm3HashWithoutZ = this.confirmSM3HashValueLength(DigestInfoHelper.hashSM3Digest(null, sourceStream));
                    verifyResult = this.sm2Card.verifyByHash(pubKey, sm3HashWithoutZ, sm2SignValue);
                }
            } else {
                byte[] digestInfoBytes = DigestInfoHelper.hashDigestInfo(mechanism, sourceStream);
                verifyResult = this.rsaCard.verifyByHash(pubKey, digestInfoBytes, signData);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("verify stream <<<<<<Finished: verifyResult=" + verifyResult);
            }
            return verifyResult;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("verify stream <<<<<<Failure", (Throwable)e);
            throw new PKIException("verify stream failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("verify stream <<<<<<Failure", e);
            throw new PKIException("verify stream failure: " + e.getMessage(), e);
        }
    }

    public final byte[] encrypt(Mechanism mechanism, Key key, byte[] sourceData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("encrypt message >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n Key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] encryptData = null;
            if (this.isSM2Type(mechanism)) {
                if (!(key instanceof PublicKey)) {
                    throw new PKIException("encrypt failure: required PublicKey");
                }
                encryptData = this.confirmSM2EncryptDataLength(this.sm2Card.encrypt((PublicKey)key, sourceData), sourceData);
            } else if (this.isRSAType(mechanism)) {
                if (!(key instanceof RSAPublicKey)) {
                    throw new PKIException("encrypt failure: required RSAPublicKey");
                }
                encryptData = this.rsaCard.encrypt((RSAPublicKey)key, sourceData);
            } else {
                encryptData = this.softLib.encrypt(mechanism, key, sourceData);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("encrypt message <<<<<<Finished: encryptData=" + SADKDebugger.dump(encryptData));
            }
            return encryptData;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("encrypt message <<<<<<Failure", (Throwable)e);
            throw new PKIException("encrypt message failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("encrypt message <<<<<<Failure", e);
            throw new PKIException("encrypt message failure: " + e.getMessage(), e);
        }
    }

    public final byte[] decrypt(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("decrypt message >>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n Key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        try {
            byte[] decryptData = null;
            if (this.isSM2Type(mechanism)) {
                if (!(key instanceof PrivateKey)) {
                    throw new PKIException("decrypt failure: required PrivateKey");
                }
                decryptData = this.trySM2Decrypt(mechanism, (PrivateKey)key, encryptData);
            } else if (this.isRSAType(mechanism)) {
                if (!(key instanceof RSAPrivateKey)) {
                    throw new PKIException("decrypt failure: required RSAPrivateKey");
                }
                decryptData = this.rsaCard.decrypt((RSAPrivateKey)key, encryptData);
            } else {
                decryptData = this.softLib.decrypt(mechanism, key, encryptData);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("decrypt message <<<<<<Finished: decryptData=" + SADKDebugger.dump(decryptData));
            }
            return decryptData;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("decrypt message <<<<<<Failure", (Throwable)e);
            throw new PKIException("decrypt message failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("decrypt message <<<<<<Failure", e);
            throw new PKIException("decrypt message failure: " + e.getMessage(), e);
        }
    }

    public final void encrypt(Mechanism mechanism, Key key, InputStream in, OutputStream out) throws PKIException {
        Object buffer;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            buffer = new StringBuilder();
            ((StringBuilder)buffer).append("encrypt stream>>>>>>Running");
            ((StringBuilder)buffer).append("\n mechanism: ");
            ((StringBuilder)buffer).append(SADKDebugger.dump(mechanism));
            ((StringBuilder)buffer).append("\n in: ");
            ((StringBuilder)buffer).append(SADKDebugger.dump(in));
            ((StringBuilder)buffer).append("\n out: ");
            ((StringBuilder)buffer).append(SADKDebugger.dump(out));
            LoggerManager.debugLogger.debug(((StringBuilder)buffer).toString());
        }
        try {
            StreamEncryptChecker.checkAllowedKeyType(key);
            if (this.isSM2Type(mechanism)) {
                int rLength;
                try {
                    buffer = new byte[8192];
                    rLength = in.read((byte[])buffer);
                }
                catch (Exception e) {
                    throw new PKIException("encrypt stream failure: file read error", e);
                }
                if (rLength > 4096) {
                    throw new PKIException("encrypt stream failure: message more than 4096");
                }
                byte[] sourceData = new byte[rLength];
                System.arraycopy(buffer, 0, sourceData, 0, sourceData.length);
                byte[] encryptData = this.confirmSM2EncryptDataLength(this.sm2Card.encrypt((PublicKey)key, sourceData), sourceData);
                try {
                    out.write(encryptData, 0, encryptData.length);
                }
                catch (Exception e) {
                    throw new PKIException("encrypt stream failure: file write error", e);
                }
            }
            if (this.isRSAType(mechanism)) {
                if (!(key instanceof RSAPublicKey)) {
                    throw new PKIException("encrypt failure: required RSAPublicKey");
                }
                byte[] sourceData = FileHelper.read(in);
                byte[] encryptData = this.rsaCard.encrypt((RSAPublicKey)key, sourceData);
                out.write(encryptData, 0, encryptData.length);
            } else {
                this.softLib.encrypt(mechanism, key, in, out);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("encrypt stream<<<<<<Finished");
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("encrypt stream<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("encrypt stream<<<<<<Failure", e);
            throw new PKIException("encrypt stream failure: " + e.getMessage(), e);
        }
    }

    public final void decrypt(Mechanism mechanism, Key key, InputStream in, OutputStream out) throws PKIException {
        Object buffer;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            buffer = new StringBuilder();
            ((StringBuilder)buffer).append("decrypt stream >>>>>>running");
            ((StringBuilder)buffer).append("\n mechanism: ");
            ((StringBuilder)buffer).append(SADKDebugger.dump(mechanism));
            ((StringBuilder)buffer).append("\n in: ");
            ((StringBuilder)buffer).append(SADKDebugger.dump(in));
            ((StringBuilder)buffer).append("\n out: ");
            ((StringBuilder)buffer).append(SADKDebugger.dump(out));
            LoggerManager.debugLogger.debug(((StringBuilder)buffer).toString());
        }
        try {
            StreamEncryptChecker.checkAllowedKeyType(key);
            if (this.isSM2Type(mechanism)) {
                int rLength;
                try {
                    buffer = new byte[8192];
                    rLength = in.read((byte[])buffer);
                }
                catch (Exception e) {
                    throw new PKIException("decrypt stream failure: file read error", e);
                }
                if (rLength > 5120) {
                    throw new PKIException("decrypt stream failure: message more than 5120");
                }
                byte[] encryptData = new byte[rLength];
                System.arraycopy(buffer, 0, encryptData, 0, encryptData.length);
                byte[] decryptData = this.trySM2Decrypt(mechanism, (PrivateKey)key, encryptData);
                try {
                    out.write(decryptData, 0, decryptData.length);
                }
                catch (Exception e) {
                    throw new PKIException("decrypt stream failure: file write error", e);
                }
            }
            if (this.isRSAType(mechanism)) {
                if (!(key instanceof RSAPrivateKey)) {
                    throw new PKIException("decrypt failure: required RSAPrivateKey");
                }
                byte[] encryptData = FileHelper.read(in);
                byte[] decryptData = this.rsaCard.decrypt((RSAPrivateKey)key, encryptData);
                out.write(decryptData, 0, decryptData.length);
            } else {
                this.softLib.decrypt(mechanism, key, in, out);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("decrypt stream<<<<<<Finished");
            }
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("decrypt stream<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("decrypt stream<<<<<<Failure", e);
            throw new PKIException("decrypt stream failure: " + e.getMessage(), e);
        }
    }

    public final Provider getProvider() {
        return this.softLib.getProvider();
    }

    public final String getProviderName() {
        return this.softLib.getProviderName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isSM2Type(Mechanism mechanism) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("isSM2Type::>>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean convertFlag = false;
        try {
            convertFlag = mechanism == null || mechanism.getMechanismType() == null ? false : mechanism.getMechanismType().toUpperCase().indexOf("SM2") != -1;
        }
        finally {
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("isSM2Type::<<<<<<Finished: convertFlag=" + convertFlag);
            }
        }
        return convertFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isRSAType(Mechanism mechanism) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("isRSAType::>>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean convertFlag = false;
        try {
            convertFlag = mechanism == null || mechanism.getMechanismType() == null ? false : mechanism.getMechanismType().toUpperCase().indexOf("RSA") != -1;
        }
        finally {
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("isRSAType::<<<<<<Finished: convertFlag=" + convertFlag);
            }
        }
        return convertFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isECCType(Mechanism mechanism) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("isECCType::>>>>>>running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean convertFlag = false;
        try {
            convertFlag = mechanism == null || mechanism.getMechanismType() == null ? false : mechanism.getMechanismType().toUpperCase().indexOf("ECC") != -1;
        }
        finally {
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("isECCType::<<<<<<Finished: convertFlag=" + convertFlag);
            }
        }
        return convertFlag;
    }

    final byte[] trySM2Decrypt(Mechanism mechanism, PrivateKey privateKey, byte[] encryptData) throws PKIException, CardException {
        if (encryptData == null || encryptData.length < 96) {
            throw new PKIException("SM2Decrypt Failure with encryptData shortage");
        }
        byte[] decryptBytes = null;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("SM2Decrypt::>>>>>>running");
            buffer.append("\n cardKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        int cardRAWC1C3C2Format = 4;
        if (ASN1SM2Cipher.isASN1EncryptType(encryptData)) {
            LoggerManager.debugLogger.debug("SM2Decrypt::::::::ASN1(C1C3C2): Running");
            byte[] cardEncryptData = new ASN1SM2Cipher(encryptData, 1).getEncryptedBytes(4);
            decryptBytes = this.SM2CardDecrypt(privateKey, cardEncryptData);
            LoggerManager.debugLogger.debug("SM2Decrypt::::::::ASN1(C1C3C2): Finished");
        } else {
            try {
                LoggerManager.debugLogger.debug("SM2Decrypt:::::::: RAW(C1C3C2): Running");
                byte[] cardEncryptData = encryptData;
                decryptBytes = this.SM2CardDecrypt(privateKey, cardEncryptData);
                LoggerManager.debugLogger.debug("SM2Decrypt:::::::: RAW(C1C3C2): Finished");
            }
            catch (Exception e) {
                LoggerManager.debugLogger.debug("SM2Decrypt:::::::: RAW(C1C2C3): Running");
                byte[] cardEncryptData = new ASN1SM2Cipher(encryptData, 16).getEncryptedBytes(4);
                decryptBytes = this.SM2CardDecrypt(privateKey, cardEncryptData);
                LoggerManager.debugLogger.debug("SM2Decrypt:::::::: RAW(C1C2C3): Finished");
            }
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("SM2Decrypt::<<<<<<Finished: decryptBytes=" + SADKDebugger.dump(decryptBytes));
        }
        return decryptBytes;
    }

    final byte[] SM2CardDecrypt(PrivateKey privateKey, byte[] sm2EncryptData) throws PKIException, CardException {
        if (sm2EncryptData == null || sm2EncryptData.length < 96) {
            throw new PKIException("SM2Decrypt Failure with sm2EncryptData shortage");
        }
        byte[] decryptBytes = this.sm2Card.decrypt(privateKey, sm2EncryptData);
        return decryptBytes;
    }

    private final byte[] confirmSM3HashValueLength(byte[] sm3HashValue) throws CardException {
        if (sm3HashValue == null || sm3HashValue.length == 0) {
            throw new CardException("Missing SM3HashValue");
        }
        if (sm3HashValue.length != 32) {
            throw new CardException("Require SM3HashValueLength=32");
        }
        return sm3HashValue;
    }

    private final byte[] confirmSM2SignWithRawRS(byte[] sm2SignValue) throws CardException {
        if (sm2SignValue == null || sm2SignValue.length == 0) {
            throw new CardException("SM2SignValue missing");
        }
        if (sm2SignValue.length < 64) {
            throw new CardException("SM2SignValue less than 64");
        }
        byte[] rawRSSignValue = null;
        if (sm2SignValue != null && sm2SignValue.length == 64) {
            rawRSSignValue = sm2SignValue;
        } else if (ASN1SM2Signature.isASN1SignType(sm2SignValue)) {
            ASN1SM2Signature signature = new ASN1SM2Signature(sm2SignValue);
            rawRSSignValue = new byte[64];
            System.arraycopy(BigIntegers.asUnsignedByteArray(32, signature.getR().getPositiveValue()), 0, rawRSSignValue, 0, 32);
            System.arraycopy(BigIntegers.asUnsignedByteArray(32, signature.getS().getPositiveValue()), 0, rawRSSignValue, 32, 32);
        } else {
            throw new CardException("SM2Signature data is null or neither asn1 nor 64 bytes!");
        }
        return rawRSSignValue;
    }

    private final byte[] confirmSM2SignValueLength(byte[] sm2SignValue) throws CardException {
        if (sm2SignValue == null || sm2SignValue.length == 0) {
            throw new CardException("SM2SignValue missing");
        }
        if (sm2SignValue.length != 64) {
            throw new CardException("SM2SignValue not equal with 64");
        }
        return sm2SignValue;
    }

    private final byte[] confirmSM2EncryptDataLength(byte[] encryptData, byte[] sourceData) throws CardException {
        if (sourceData == null || sourceData.length == 0) {
            throw new CardException("Missing sourceData");
        }
        if (encryptData == null || encryptData.length == 0) {
            throw new CardException("Missing encryptData");
        }
        if (encryptData.length - sourceData.length != 96) {
            throw new CardException("Require encryptDataLength-sourceDatalength=96<<<<<<" + encryptData.length + "," + sourceData.length + ">>>>>>");
        }
        ASN1SM2Cipher asn1 = new ASN1SM2Cipher(encryptData, 4);
        byte[] outEncryptData = asn1.getEncryptedBytes(CompatibleConfig.SM2OutputFormatEncryptedBytes);
        return outEncryptData;
    }

    public final PublicKey exportEncPublicKey() throws PKIException {
        PublicKey pubKey = null;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("exportEncPublicKey >>>>>>running");
        }
        try {
            pubKey = this.sm2Card.expoertEncPublicKey();
        }
        catch (CardException e) {
            LoggerManager.exceptionLogger.error("exportEncPublicKey <<<<<<Failure", (Throwable)e);
            throw new PKIException("exportEncPublicKey failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("exportEncPublicKey <<<<<<Failure", e);
            throw new PKIException("exportEncPublicKey failure", e);
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("exportEncPublicKey <<<<<<Finished: \n");
        }
        return pubKey;
    }

    public final boolean importSM2KeyPair(byte[] encryptKeyData, int CKID) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("importSM2KeyPair >>>>>>running");
            buffer.append("\n encryptKeyData: ");
            buffer.append(SADKDebugger.dump(encryptKeyData));
            buffer.append("\n CKID: " + CKID);
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean result = false;
        try {
            if (encryptKeyData == null || encryptKeyData.length != 192) {
                throw new PKIException("importSM2KeyPair failure encryptKeyData is not 192 bytes!");
            }
            result = this.sm2Card.importSM2KeyPair(encryptKeyData, CKID);
        }
        catch (CardException e) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("importSM2KeyPair <<<<<<Failure");
            buffer.append("\n encryptKeyData: ");
            buffer.append(SADKDebugger.dump(encryptKeyData));
            buffer.append("\n CKID: " + CKID);
            LoggerManager.exceptionLogger.error(buffer.toString(), (Throwable)e);
            throw new PKIException("importSM2KeyPair failure", e);
        }
        catch (Throwable e) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("importSM2KeyPair <<<<<<Failure");
            buffer.append("\n encryptKeyData: ");
            buffer.append(SADKDebugger.dump(encryptKeyData));
            buffer.append("\n CKID: " + CKID);
            LoggerManager.exceptionLogger.error(buffer.toString(), e);
            throw new PKIException("importSM2KeyPair failure", e);
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("importSM2KeyPair <<<<<<Finished: \n");
        }
        return result;
    }

    public final boolean isC200Card() {
        return this.isC200Card;
    }

    public final String getDeviceName() {
        return "JCARD_LIB";
    }

    public final int getDeviceType() {
        return 3;
    }

    public boolean checkIdleTest() throws PKIException {
        int checkIdleError = 0;
        try {
            if (this.sm2Card != null && !this.sm2Card.checkIdleTest()) {
                LoggerManager.exceptionLogger.error("checkIdleTest[sm2Card] <<<<<<Failure");
                ++checkIdleError;
            }
        }
        catch (CardException e) {
            LoggerManager.exceptionLogger.error("checkIdleTest[sm2Card] <<<<<<Failure", (Throwable)e);
            throw new PKIException("checkIdleTest[sm2Card] failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("checkIdleTest[sm2Card] <<<<<<Failure", e);
            throw new PKIException("checkIdleTest[sm2Card] failure", e);
        }
        try {
            if (this.eccCard != null && !this.eccCard.checkIdleTest()) {
                LoggerManager.exceptionLogger.error("checkIdleTest[eccCard] <<<<<<Failure");
                ++checkIdleError;
            }
        }
        catch (CardException e) {
            LoggerManager.exceptionLogger.error("checkIdleTest[eccCard] <<<<<<Failure", (Throwable)e);
            throw new PKIException("checkIdleTest[eccCard] failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("checkIdleTest[eccCard] <<<<<<Failure", e);
            throw new PKIException("checkIdleTest[eccCard] failure", e);
        }
        try {
            if (this.rsaCard != null && !this.rsaCard.checkIdleTest()) {
                LoggerManager.exceptionLogger.error("checkIdleTest[rsaCard] <<<<<<Failure");
                ++checkIdleError;
            }
        }
        catch (CardException e) {
            LoggerManager.exceptionLogger.error("checkIdleTest[rsaCard] <<<<<<Failure", (Throwable)e);
            throw new PKIException("checkIdleTest[rsaCard] failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("checkIdleTest[rsaCard] <<<<<<Failure", e);
            throw new PKIException("checkIdleTest[rsaCard] failure", e);
        }
        return checkIdleError == 0;
    }

    public final boolean useJniNativeOperation() throws PKIException {
        return true;
    }

    public DeviceInfo[] getDeviceInfos() throws PKIException {
        return null;
    }
}

