/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.c200r;

import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.CardParameterException;
import cfca.sadk.lib.crypto.card.c200r.C200ExternalRSAPrivateKey;
import cfca.sadk.lib.crypto.card.c200r.C200InternalRSAPrivateKey;
import cfca.sadk.lib.crypto.card.c200r.C200RSAInvalidKey;
import cfca.sadk.lib.crypto.card.c200r.C200RSAKey;
import cfca.sadk.lib.crypto.card.c200r.C200RSAPublicKey;
import cfca.sadk.lib.crypto.card.c200r.RSARefPrivateKeyParams;
import cfca.sadk.lib.crypto.card.c200r.RSARefPublicKeyParams;
import cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public final class C200RSAKeyUtil {
    private C200RSAKeyUtil() {
    }

    public static C200RSAKey buildC200RSAPrivateKey(PrivateKey privateKey) throws CardException {
        C200RSAKey privKey;
        if (privateKey instanceof C200ExternalRSAPrivateKey) {
            privKey = (C200ExternalRSAPrivateKey)privateKey;
        } else if (privateKey instanceof C200InternalRSAPrivateKey) {
            privKey = (C200InternalRSAPrivateKey)privateKey;
        } else if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey crtKey = (RSAPrivateCrtKey)privateKey;
            boolean valid = C200RSAKeyUtil.isValidRSAPrivateCrtKey(crtKey);
            if (valid) {
                byte[] keyData = C200RSAKeyUtil.buildExternalKeyData(crtKey);
                privKey = new C200ExternalRSAPrivateKey(keyData);
            } else {
                privKey = C200RSAInvalidKey.INSTANCE;
            }
        } else if (privateKey instanceof RSAPrivateKey) {
            privKey = C200RSAInvalidKey.INSTANCE;
        } else {
            throw new CardException("C200RSACard decrypt failure: not support key: " + privateKey.getClass());
        }
        return privKey;
    }

    public static C200RSAKey buildC200RSAPublicKey(PublicKey publicKey) throws CardException {
        C200RSAPublicKey pubKey;
        if (publicKey instanceof C200RSAPublicKey) {
            pubKey = (C200RSAPublicKey)publicKey;
        } else if (publicKey instanceof RSAPublicKey) {
            byte[] keyData = C200RSAKeyUtil.buildExternalKeyData((RSAPublicKey)publicKey);
            pubKey = C200RSAPublicKey.buildExtervalSoftKey(keyData);
        } else {
            throw new CardException("C200RSACard verifyByHash failure: not support key: " + publicKey.getClass());
        }
        return pubKey;
    }

    private static byte[] buildExternalKeyData(RSAPublicKey publicKey) throws CardException {
        if (publicKey == null) {
            throw new CardParameterException("buildExternalKeyData failure: missing publicKey");
        }
        RSAKeyParameters params = new RSAKeyParameters(false, publicKey.getModulus(), publicKey.getPublicExponent());
        RSARefPublicKeyParams keyParameters = new RSARefPublicKeyParams(params);
        return (byte[])keyParameters.keyData.clone();
    }

    private static final byte[] buildExternalKeyData(RSAPrivateCrtKey privateKey) throws CardException {
        if (privateKey == null) {
            throw new CardParameterException("buildExternalKeyData failure: missing privateKey");
        }
        RSAPrivateCrtKeyParameters params = new RSAPrivateCrtKeyParameters(privateKey.getModulus(), privateKey.getPublicExponent(), privateKey.getPrivateExponent(), privateKey.getPrimeP(), privateKey.getPrimeQ(), privateKey.getPrimeExponentP(), privateKey.getPrimeExponentQ(), privateKey.getCrtCoefficient());
        RSARefPrivateKeyParams keyParameters = new RSARefPrivateKeyParams(params);
        return (byte[])keyParameters.keyData.clone();
    }

    private static boolean isValidRSAPrivateCrtKey(RSAPrivateCrtKey crtKey) {
        boolean isValidRSAPrivateCrtKey;
        if (crtKey == null) {
            isValidRSAPrivateCrtKey = false;
        } else {
            int modulusBitsLengthLimited = 4096;
            int exponentBitsLengthLimited = 32;
            BigInteger n = crtKey.getModulus();
            BigInteger e = crtKey.getPublicExponent();
            int modulusBitsLength = 7 + n.bitLength() >> 3 << 3;
            int othersBitsLength = modulusBitsLength >> 1;
            BigInteger d = crtKey.getPrivateExponent();
            isValidRSAPrivateCrtKey = C200RSAKeyUtil.checkBitLength(n, 4096) && C200RSAKeyUtil.checkBitLength(e, 32) && C200RSAKeyUtil.checkBitLength(d, 4096) && C200RSAKeyUtil.checkBitLength(crtKey.getPrimeP(), othersBitsLength) && C200RSAKeyUtil.checkBitLength(crtKey.getPrimeQ(), othersBitsLength) && C200RSAKeyUtil.checkBitLength(crtKey.getPrimeExponentP(), othersBitsLength) && C200RSAKeyUtil.checkBitLength(crtKey.getPrimeExponentQ(), othersBitsLength) && C200RSAKeyUtil.checkBitLength(crtKey.getCrtCoefficient(), othersBitsLength);
        }
        return isValidRSAPrivateCrtKey;
    }

    private static boolean checkBitLength(BigInteger x, int bitLengthLimited) {
        int bitLength;
        boolean isValidParameter = x == null ? false : (bitLength = x.bitLength()) > 0 && bitLength <= bitLengthLimited;
        return isValidParameter;
    }
}

