/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2HashZValue;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.algorithm.sm2.SM3Digest;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.jni.JNIDigest;
import cfca.sadk.lib.crypto.jni.JNISM2;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.DigestInfo;
import cfca.sadk.org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.system.Environments;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.system.logging.LoggerManager;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Hashtable;

public class HashUtil {
    private static final int buffersize = 65536;
    public static final Hashtable<String, ASN1ObjectIdentifier> ALGOIDMAP;

    public static byte[] SM3HashData(byte[] sourceData, Session session) throws PKIException {
        return HashUtil.SM3HashData(sourceData, null, session, false);
    }

    public static byte[] SM3HashData(byte[] sourceData, SM2PublicKey sm2PublicKey, Session session, boolean withZ) throws PKIException {
        byte[] hashValue;
        if (withZ) {
            if (sm2PublicKey == null) {
                throw new PKIException("SM3Hash Failure: the sm2PublicKey is null!");
            }
            hashValue = HashUtil.isJniLib(session) ? HashUtil.SM2HashMessageByJNIWithZValue(SM2Params.getDefaultuserid(), sourceData, sm2PublicKey.getPubX(), sm2PublicKey.getPubY()) : HashUtil.SM2HashMessageByBCWithZValue(SM2Params.getDefaultuserid(), sourceData, sm2PublicKey.getPubXByInt(), sm2PublicKey.getPubYByInt());
        } else {
            hashValue = HashUtil.isJniLib(session) ? HashUtil.SM2HashMessageByJNIWithoutZValue(sourceData) : HashUtil.SM2HashMessageByBCWithoutZValue(sourceData);
        }
        return hashValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] SM2HashMessageByJNIWithoutZValue(byte[] sourceData) throws PKIException {
        byte[] byArray;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("HashUtil@SM2HashMessageByJNIWithoutZValue>>>>>>Running: " + HashUtil.length(sourceData));
        }
        JNIDigest hash = null;
        try {
            try {
                hash = HashUtil.jniInstanceEngine(922);
                byte[] hashValue = HashUtil.hashData(sourceData, hash);
                hash = null;
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("HashUtil@SM2HashMessageByJNIWithoutZValue>>>>>>Finished!hashValue=" + Hex.toHexString(hashValue));
                }
                byArray = hashValue;
                Object var5_7 = null;
            }
            catch (PKIException e) {
                LoggerManager.exceptionLogger.error("HashUtil@SM2HashMessageByJNIWithoutZValue failed", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("HashUtil@SM2HashMessageByJNIWithoutZValue failed", (Throwable)e);
                throw new PKIException("HashUtil@SM2HashMessageByJNIWithoutZValue failed", e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("HashUtil@SM2HashMessageByJNIWithoutZValue failed", e);
                throw new PKIException("HashUtil@SM2HashMessageByJNIWithoutZValue failed", e);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            JNIDigest.destroy(hash);
            throw throwable;
        }
        JNIDigest.destroy(hash);
        return byArray;
    }

    public static byte[] SM3HashDataWithZValue(byte[] sourceData, SM2PublicKey sm2PublicKey, Session session) throws Exception {
        if (sm2PublicKey == null) {
            throw new PKIException("SM3HashDataWithZValue Failure: the sm2PublicKey is null!");
        }
        byte[] hashValue = HashUtil.isJniLib(session) ? HashUtil.SM2HashMessageByJNIWithZValue(SM2Params.getDefaultuserid(), sourceData, sm2PublicKey.getPubX(), sm2PublicKey.getPubY()) : HashUtil.SM2HashMessageByBCWithZValue(SM2Params.getDefaultuserid(), sourceData, sm2PublicKey.getPubXByInt(), sm2PublicKey.getPubYByInt());
        return hashValue;
    }

    public static byte[] SM3HashDataWithoutZValue(byte[] sourceData, Session session) throws Exception {
        byte[] hashValue = HashUtil.isJniLib(session) ? HashUtil.SM2HashMessageByJNIWithoutZValue(sourceData) : HashUtil.SM2HashMessageByBCWithoutZValue(sourceData);
        return hashValue;
    }

    public static byte[] SM3HashFileWithZValue(InputStream sourceStream, SM2PublicKey sm2PublicKey, Session session) throws Exception {
        if (sm2PublicKey == null) {
            throw new PKIException("SM3HashFileWithZValue Failure: the sm2PublicKey is null!");
        }
        byte[] hashValue = HashUtil.isJniLib(session) ? HashUtil.SM2HashFileByJNIWithZValue(SM2Params.getDefaultuserid(), sourceStream, sm2PublicKey.getPubX(), sm2PublicKey.getPubY()) : HashUtil.SM2HashFileByBCWithZValue(SM2Params.getDefaultuserid(), sourceStream, sm2PublicKey.getPubXByInt(), sm2PublicKey.getPubYByInt());
        return hashValue;
    }

    public static byte[] SM3HashFileWithoutZValue(InputStream sourceStream, Session session) throws Exception {
        byte[] hashValue = HashUtil.isJniLib(session) ? HashUtil.SM2HashFileByJNIWithoutZValue(sourceStream) : HashUtil.SM2HashFileByBCWithoutZValue(sourceStream);
        return hashValue;
    }

    public static byte[] RSAHashData(byte[] sourceData, Mechanism mechanism, Session session, boolean ifDEREncoding) throws Exception {
        byte[] hashValue = HashUtil.isJniLib(session) ? HashUtil.RSAHashMessageByJNI(sourceData, mechanism, ifDEREncoding) : HashUtil.RSAHashMessageByBC(sourceData, mechanism, ifDEREncoding);
        return hashValue;
    }

    public static byte[] RSAHashFile(InputStream sourceStream, Mechanism mechanism, Session session, boolean ifDEREncoding) throws Exception {
        byte[] hashValue = HashUtil.isJniLib(session) ? HashUtil.RSAHashFileByJNI(sourceStream, mechanism, ifDEREncoding) : HashUtil.RSAHashFileByBC(sourceStream, mechanism, ifDEREncoding);
        return hashValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] RSAHashMessageByBC(byte[] sourceData, Mechanism mechanism, boolean ifDEREncoding) throws PKIException {
        byte[] byArray;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("RSAHashMessageByBC>>>>>>Running: mechanism=" + mechanism + "," + HashUtil.length(sourceData));
        }
        try {
            try {
                if (sourceData == null) {
                    throw new PKIException("RSAHashMessage Failure: the source data is null or empty!");
                }
                Digest hash = HashUtil.getDigestByBC(mechanism);
                byte[] hashValue = HashUtil.hashData(sourceData, hash);
                if (ifDEREncoding) {
                    hashValue = HashUtil.EncodedHashValue(mechanism, hashValue);
                }
                byArray = hashValue;
                Object var7_8 = null;
            }
            catch (PKIException e) {
                LoggerManager.exceptionLogger.error("RSAHashMessageByBC<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("RSAHashMessageByBC<<<<<<Failure", e);
                throw new PKIException("RSAHashMessage Failure: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!LoggerManager.debugLogger.isDebugEnabled()) throw throwable;
            LoggerManager.debugLogger.debug("RSAHashMessageByBC<<<<<<Finished");
            throw throwable;
        }
        if (!LoggerManager.debugLogger.isDebugEnabled()) return byArray;
        LoggerManager.debugLogger.debug("RSAHashMessageByBC<<<<<<Finished");
        return byArray;
    }

    public static byte[] RSAHashMessageByJNI(byte[] sourceData, Mechanism mechanism, boolean ifDEREncoding) throws Exception {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("HashUtil@RSAHashMessageByJNI>>>>>>Running: " + HashUtil.length(sourceData));
        }
        try {
            JNIDigest hash = HashUtil.jniInstanceEngine(mechanism);
            byte[] hashValue = HashUtil.hashData(sourceData, hash);
            if (ifDEREncoding) {
                hashValue = HashUtil.EncodedHashValue(mechanism, hashValue);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("HashUtil@RSAHashMessageByJNI>>>>>>Finished!hashValue=" + Hex.toHexString(hashValue));
            }
            return hashValue;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("HashUtil@RSAHashMessageByJNI failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("HashUtil@RSAHashMessageByJNI failed", (Throwable)e);
            throw new PKIException("HashUtil@RSAHashMessageByJNI failed", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("HashUtil@RSAHashMessageByJNI failed", e);
            throw new PKIException("HashUtil@RSAHashMessageByJNI failed", e);
        }
    }

    public static byte[] RSAHashFileByBC(InputStream sourceStream, Mechanism mechanism, boolean ifDEREncoding) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("HashUtil@RSAHashFileByBC>>>>>>Running: " + HashUtil.length(sourceStream));
        }
        try {
            Digest hash = HashUtil.javaInstanceEngine(mechanism);
            byte[] hashValue = HashUtil.hashFile(sourceStream, hash);
            if (ifDEREncoding) {
                hashValue = HashUtil.EncodedHashValue(mechanism, hashValue);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("HashUtil@RSAHashFileByBC>>>>>>Finished!hashValue=" + Hex.toHexString(hashValue));
            }
            return hashValue;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("HashUtil@RSAHashFileByBC failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("HashUtil@RSAHashFileByBC failed", (Throwable)e);
            throw new PKIException("HashUtil@RSAHashFileByBC failed", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("HashUtil@RSAHashFileByBC failed", e);
            throw new PKIException("HashUtil@RSAHashFileByBC failed", e);
        }
    }

    public static byte[] RSAHashFileByJNI(InputStream sourceStream, Mechanism mechanism, boolean ifDEREncoding) throws Exception {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("HashUtil@RSAHashFileByJNI>>>>>>Running: " + HashUtil.length(sourceStream));
        }
        try {
            JNIDigest hash = HashUtil.jniInstanceEngine(mechanism);
            byte[] hashValue = HashUtil.hashFile(sourceStream, hash);
            if (ifDEREncoding) {
                hashValue = HashUtil.EncodedHashValue(mechanism, hashValue);
            }
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("HashUtil@RSAHashFileByJNI>>>>>>Finished!hashValue=" + Hex.toHexString(hashValue));
            }
            return hashValue;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("HashUtil@RSAHashFileByJNI failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("HashUtil@RSAHashFileByJNI failed", (Throwable)e);
            throw new PKIException("HashUtil@RSAHashFileByJNI failed", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("HashUtil@RSAHashFileByJNI failed", e);
            throw new PKIException("HashUtil@RSAHashFileByJNI failed", e);
        }
    }

    public static byte[] SM2HashMessageByBCWithoutZValue(byte[] sourceData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("HashUtil@SM2HashMessageByBCWithoutZValue>>>>>>Running: " + HashUtil.length(sourceData));
        }
        try {
            SM3Digest hash = new SM3Digest();
            byte[] hashValue = HashUtil.hashData(sourceData, hash);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("HashUtil@SM2HashMessageByBCWithoutZValue>>>>>>Finished!hashValue=" + Hex.toHexString(hashValue));
            }
            return hashValue;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("HashUtil@SM2HashMessageByBCWithoutZValue failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("HashUtil@SM2HashMessageByBCWithoutZValue failed", (Throwable)e);
            throw new PKIException("HashUtil@SM2HashMessageByBCWithoutZValue failed", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("HashUtil@SM2HashMessageByBCWithoutZValue failed", e);
            throw new PKIException("HashUtil@SM2HashMessageByBCWithoutZValue failed", e);
        }
    }

    public static byte[] SM2HashFileByBCWithoutZValue(InputStream sourceStream) throws Exception {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("HashUtil@SM2HashFileByBCWithoutZValue>>>>>>Running: " + HashUtil.length(sourceStream));
        }
        try {
            SM3Digest hash = new SM3Digest();
            byte[] hashValue = HashUtil.hashFile(sourceStream, hash);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("HashUtil@SM2HashFileByBCWithoutZValue>>>>>>Finished!hashValue=" + Hex.toHexString(hashValue));
            }
            return hashValue;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("HashUtil@SM2HashFileByBCWithoutZValue failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("HashUtil@SM2HashFileByBCWithoutZValue failed", (Throwable)e);
            throw new PKIException("HashUtil@SM2HashFileByBCWithoutZValue failed", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("HashUtil@SM2HashFileByBCWithoutZValue failed", e);
            throw new PKIException("HashUtil@SM2HashFileByBCWithoutZValue failed", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] SM2HashFileByJNIWithoutZValue(InputStream sourceStream) throws Exception {
        byte[] byArray;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("HashUtil@SM2HashFileByJNIWithoutZValue>>>>>>Running: " + HashUtil.length(sourceStream));
        }
        JNIDigest hash = null;
        try {
            try {
                hash = HashUtil.jniInstanceEngine(922);
                byte[] hashValue = HashUtil.hashFile(sourceStream, hash);
                hash = null;
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("HashUtil@SM2HashFileByJNIWithoutZValue>>>>>>Finished!hashValue=" + Hex.toHexString(hashValue));
                }
                byArray = hashValue;
                Object var5_7 = null;
            }
            catch (PKIException e) {
                LoggerManager.exceptionLogger.error("HashUtil@SM2HashFileByJNIWithoutZValue failed", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("HashUtil@SM2HashFileByJNIWithoutZValue failed", (Throwable)e);
                throw new PKIException("HashUtil@SM2HashFileByJNIWithoutZValue failed", e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("HashUtil@SM2HashFileByJNIWithoutZValue failed", e);
                throw new PKIException("HashUtil@SM2HashFileByJNIWithoutZValue failed", e);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            JNIDigest.destroy(hash);
            throw throwable;
        }
        JNIDigest.destroy(hash);
        return byArray;
    }

    public static byte[] SM2HashMessageByBCWithZValue(byte[] sourceData, BigInteger pubX, BigInteger pubY) throws PKIException {
        return HashUtil.SM2HashMessageByBCWithZValue(SM2Params.getDefaultuserid(), sourceData, pubX, pubY);
    }

    public static byte[] SM2HashMessageByJNIWithZValue(byte[] sourceData, byte[] pubX, byte[] pubY) throws PKIException {
        return HashUtil.SM2HashMessageByJNIWithZValue(SM2Params.getDefaultuserid(), sourceData, pubX, pubY);
    }

    public static byte[] SM2HashFileByBCWithZValue(InputStream sourceStream, BigInteger pubX, BigInteger pubY) throws PKIException {
        return HashUtil.SM2HashFileByBCWithZValue(SM2Params.getDefaultuserid(), sourceStream, pubX, pubY);
    }

    public static byte[] SM2HashFileByJNIWithZValue(InputStream sourceStream, byte[] pubX, byte[] pubY) throws PKIException {
        return HashUtil.SM2HashFileByJNIWithZValue(SM2Params.getDefaultuserid(), sourceStream, pubX, pubY);
    }

    public static byte[] SM2HashMessageByBCWithZValue(byte[] userId, byte[] sourceData, BigInteger pubX, BigInteger pubY) throws PKIException {
        byte[] byArray;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("SM2HashMessageByBCWithZValue>>>>>>Running: " + HashUtil.length(sourceData));
        }
        try {
            if (sourceData == null || sourceData.length == 0) {
                throw new PKIException("SM2HashMessageByBCWithZValue Failure: the source data is null or empty!");
            }
            byte[] hashValue = new byte[32];
            byte[] z = SM2HashZValue.getZa(pubX, pubY, userId);
            SM3Digest digest = new SM3Digest();
            digest.update(z, 0, z.length);
            digest.update(sourceData, 0, sourceData.length);
            digest.doFinal(hashValue, 0);
            byArray = hashValue;
            Object var9_9 = null;
        }
        catch (Throwable e) {
            try {
                LoggerManager.exceptionLogger.error("SM2HashMessageByBCWithZValue<<<<<<Failure", e);
                throw new PKIException("SM2HashMessageByBCWithZValue Failure: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                block7: {
                    Object var9_10 = null;
                    if (!LoggerManager.debugLogger.isDebugEnabled()) break block7;
                    LoggerManager.debugLogger.debug("SM2HashMessageByBCWithZValue<<<<<<Finished");
                }
                throw throwable;
            }
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("SM2HashMessageByBCWithZValue<<<<<<Finished");
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] SM2HashMessageByJNIWithZValue(byte[] userId, byte[] sourceData, byte[] pubX, byte[] pubY) throws PKIException {
        byte[] byArray;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("SM2HashMessageByJNIWithZValue>>>>>>Running: " + HashUtil.length(sourceData));
        }
        JNIDigest hash = null;
        try {
            try {
                byte[] zvalue = HashUtil.jniBuildZ(pubX, pubY, userId);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("HashUtil@SM2HashMessageByJNIWithZValue>>>>>>zvalue: " + Hex.toHexString(zvalue));
                }
                hash = HashUtil.jniInstanceEngine(922);
                hash.update(zvalue, 0, zvalue.length);
                byte[] hashValue = HashUtil.hashData(sourceData, hash);
                hash = null;
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("HashUtil@SM2HashMessageByJNIWithZValue>>>>>>Finished!hashValue=" + Hex.toHexString(hashValue));
                }
                byArray = hashValue;
                Object var9_11 = null;
            }
            catch (PKIException e) {
                LoggerManager.exceptionLogger.error("HashUtil@SM2HashMessageByJNIWithZValue failed", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("HashUtil@SM2HashMessageByJNIWithZValue failed", (Throwable)e);
                throw new PKIException("HashUtil@SM2HashMessageByJNIWithZValue failed", e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("HashUtil@SM2HashMessageByJNIWithZValue failed", e);
                throw new PKIException("HashUtil@SM2HashMessageByJNIWithZValue failed", e);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            JNIDigest.destroy(hash);
            throw throwable;
        }
        JNIDigest.destroy(hash);
        return byArray;
    }

    public static byte[] SM2HashFileByBCWithZValue(byte[] userId, InputStream sourceStream, BigInteger pubX, BigInteger pubY) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("HashUtil@SM2HashFileByBCWithZValue>>>>>>Running: " + HashUtil.length(sourceStream));
        }
        try {
            byte[] zvalue = HashUtil.javaBuildZ(pubX, pubY, userId);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("HashUtil@SM2HashFileByBCWithZValue>>>>>>zvalue: " + Hex.toHexString(zvalue));
            }
            SM3Digest hash = new SM3Digest();
            hash.update(zvalue, 0, zvalue.length);
            byte[] hashValue = HashUtil.hashFile(sourceStream, hash);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("HashUtil@SM2HashFileByBCWithZValue>>>>>>Finished!hashValue=" + Hex.toHexString(hashValue));
            }
            return hashValue;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("HashUtil@SM2HashFileByBCWithZValue failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("HashUtil@SM2HashFileByBCWithZValue failed", (Throwable)e);
            throw new PKIException("HashUtil@SM2HashFileByBCWithZValue failed", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("HashUtil@SM2HashFileByBCWithZValue failed", e);
            throw new PKIException("HashUtil@SM2HashFileByBCWithZValue failed", e);
        }
    }

    private static final byte[] EncodedHashValue(Mechanism mechanism, byte[] hash) throws Exception {
        try {
            AlgorithmIdentifier algId = Mechanisms.getDigestAlgIdentifier(mechanism);
            if (algId == null) {
                algId = HashUtil.getRIPEMDIdentifier(mechanism);
            }
            if (algId == null) {
                throw new Exception("EncodedHashValue with invalid digest mechanism: " + mechanism);
            }
            DigestInfo dInfo = new DigestInfo(algId, hash);
            return dInfo.getEncoded("DER");
        }
        catch (IOException e) {
            throw new Exception("EncodedHashValue Failure", e);
        }
    }

    private static final AlgorithmIdentifier getRIPEMDIdentifier(Mechanism mechanism) {
        ASN1ObjectIdentifier oid = null;
        if (mechanism == null || mechanism.getMechanismType() == null) {
            oid = null;
        } else {
            String type = mechanism.getMechanismType().toUpperCase();
            if (type.equals("RIPEMD128")) {
                oid = TeleTrusTObjectIdentifiers.ripemd128;
            } else if (type.equals("RIPEMD160")) {
                oid = TeleTrusTObjectIdentifiers.ripemd160;
            } else if (type.equals("RIPEMD256")) {
                oid = TeleTrusTObjectIdentifiers.ripemd256;
            }
        }
        AlgorithmIdentifier digestAlgIdentifier = null;
        if (oid != null) {
            digestAlgIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1, DERNull.INSTANCE);
        }
        return digestAlgIdentifier;
    }

    private static Digest getDigestByBC(Mechanism mechanism) throws Exception {
        Digest engine = Mechanisms.getDigest(mechanism);
        if (engine == null) {
            throw new Exception("DigestByBC: can not support this algorithm:" + mechanism);
        }
        return engine;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] SM2HashFileByJNIWithZValue(byte[] userId, InputStream sourceStream, byte[] pubX, byte[] pubY) throws PKIException {
        byte[] byArray;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("HashUtil@SM2HashFileByJNIWithZValue>>>>>>Running: " + HashUtil.length(sourceStream));
        }
        JNIDigest hash = null;
        try {
            try {
                byte[] zvalue = HashUtil.jniBuildZ(pubX, pubY, userId);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("HashUtil@SM2HashFileByJNIWithZValue>>>>>>zvalue: " + Hex.toHexString(zvalue));
                }
                hash = HashUtil.jniInstanceEngine(922);
                hash.update(zvalue, 0, zvalue.length);
                byte[] hashValue = HashUtil.hashFile(sourceStream, hash);
                hash = null;
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("HashUtil@SM2HashFileByJNIWithZValue>>>>>>Finished!hashValue=" + Hex.toHexString(hashValue));
                }
                byArray = hashValue;
                Object var9_11 = null;
            }
            catch (PKIException e) {
                LoggerManager.exceptionLogger.error("HashUtil@SM2HashFileByJNIWithZValue failed", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("HashUtil@SM2HashFileByJNIWithZValue failed", (Throwable)e);
                throw new PKIException("HashUtil@SM2HashFileByJNIWithZValue failed", e);
            }
            catch (Throwable e) {
                LoggerManager.exceptionLogger.error("HashUtil@SM2HashFileByJNIWithZValue failed", e);
                throw new PKIException("HashUtil@SM2HashFileByJNIWithZValue failed", e);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            JNIDigest.destroy(hash);
            throw throwable;
        }
        JNIDigest.destroy(hash);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final byte[] hashFile(InputStream sourceFileStream, Digest hash) throws PKIException {
        if (sourceFileStream == null) {
            throw new PKIException("HashUtil@hashFile source stream is null!");
        }
        if (hash == null) {
            throw new PKIException("HashUtil@hashFile hash is null!");
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug(String.format("HashUtil@hashFile>>>>>>Running: length=%s,hash=%s,algorithm=%s", HashUtil.length(sourceFileStream), hash, hash.getAlgorithmName()));
        }
        BufferedInputStream bufferedReader = null;
        byte[] hashValue = new byte[hash.getDigestSize()];
        try {
            try {
                bufferedReader = new BufferedInputStream(sourceFileStream, 65536);
                int streamLength = bufferedReader.available();
                if (streamLength == -1) {
                    throw new PKIException("HashUtil@hashFile source stream is null!");
                }
                if (streamLength > 0) {
                    byte[] buffer = new byte[65536];
                    int rLength = bufferedReader.read(buffer);
                    if (rLength == -1) {
                        throw new PKIException("HashUtil@hashFile source stream read=-1!");
                    }
                    long datLength = 0L;
                    do {
                        if (rLength < 65536) {
                            hash.update(buffer, 0, rLength);
                            datLength += (long)rLength;
                            break;
                        }
                        hash.update(buffer, 0, buffer.length);
                        datLength += (long)buffer.length;
                    } while ((rLength = bufferedReader.read(buffer)) != -1);
                    if (datLength < (long)streamLength && datLength != (long)streamLength) {
                        throw new PKIException("HashUtil@hashFile source datLength->" + datLength + "!=" + streamLength);
                    }
                }
                hash.doFinal(hashValue, 0);
            }
            catch (PKIException e) {
                throw new PKIException("HashUtil@hashFile failed for " + hash.getAlgorithmName(), e);
            }
            catch (Exception e) {
                throw new PKIException("HashUtil@hashFile failed for " + hash.getAlgorithmName(), e);
            }
            catch (Throwable e) {
                throw new PKIException("HashUtil@hashFile failed for " + hash.getAlgorithmName(), e);
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("HashUtil@hashFile<<<<<<Finished for " + hash.getAlgorithmName());
            }
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new PKIException("HashUtil@hashFile failed when closed for " + hash.getAlgorithmName(), e);
            }
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("HashUtil@hashFile<<<<<<Finished for " + hash.getAlgorithmName());
        }
        if (bufferedReader == null) return hashValue;
        try {}
        catch (Exception e) {
            throw new PKIException("HashUtil@hashFile failed when closed for " + hash.getAlgorithmName(), e);
        }
        bufferedReader.close();
        return hashValue;
    }

    private static final byte[] hashData(byte[] data, Digest hash) throws PKIException {
        if (hash == null) {
            throw new PKIException("HashUtil@hashData hash is null!");
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug(String.format("HashUtil@hashData>>>>>>Running: length=%s,hash=%s,algorithm=%s", data.length, hash, hash.getAlgorithmName()));
        }
        byte[] hashValue = new byte[hash.getDigestSize()];
        try {
            if (data != null) {
                hash.update(data, 0, data.length);
            }
            hash.doFinal(hashValue, 0);
        }
        catch (Exception e) {
            throw new PKIException("HashUtil@hashData failed for " + hash.getAlgorithmName(), e);
        }
        catch (Throwable e) {
            throw new PKIException("HashUtil@hashData failed for " + hash.getAlgorithmName(), e);
        }
        return hashValue;
    }

    private static Digest javaInstanceEngine(Mechanism mechanism) throws PKIException {
        Digest engine = Mechanisms.getDigest(mechanism);
        if (engine == null) {
            throw new PKIException("HashUtil soft can not support this algorithm:" + mechanism);
        }
        return engine;
    }

    private static JNIDigest jniInstanceEngine(Mechanism mechanism) throws PKIException {
        int hashID = Mechanisms.getHashID(mechanism);
        if (hashID == 0) {
            throw new PKIException("HashUtil jni can not support this algorithm:" + mechanism);
        }
        return HashUtil.jniInstanceEngine(hashID);
    }

    private static JNIDigest jniInstanceEngine(int hashID) throws PKIException {
        return new JNIDigest(hashID);
    }

    private static byte[] jniBuildZ(byte[] pubX, byte[] pubY, byte[] userId) throws PKIException {
        if (pubX == null || pubX.length != 32) {
            throw new PKIException("HashUtil jni calculateZValue failed: pubXLength required 32");
        }
        if (pubY == null || pubY.length != 32) {
            throw new PKIException("HashUtil jni calculateZValue failed: pubYLength required 32");
        }
        byte[] hashValue = new byte[32];
        try {
            byte[] id = userId == null ? SM2Params.getDefaultuserid() : userId;
            JNISM2.calculateZValue(pubX, pubY, id, hashValue);
        }
        catch (Exception e) {
            throw new PKIException("HashUtil jni calculateZValue failed", e);
        }
        catch (Throwable e) {
            throw new PKIException("HashUtil jni calculateZValue failed", e);
        }
        return hashValue;
    }

    private static byte[] javaBuildZ(BigInteger pubX, BigInteger pubY, byte[] userId) throws PKIException {
        byte[] hashValue;
        if (pubX == null) {
            throw new PKIException("HashUtil java calculateZValue failed: pubX not null");
        }
        if (pubY == null) {
            throw new PKIException("HashUtil java calculateZValue failed: pubY not null");
        }
        try {
            byte[] id = userId == null ? SM2Params.getDefaultuserid() : userId;
            hashValue = SM2HashZValue.getZa(pubX, pubY, id);
        }
        catch (Exception e) {
            throw new PKIException("HashUtil java calculateZValue failed", e);
        }
        catch (Throwable e) {
            throw new PKIException("HashUtil java calculateZValue failed", e);
        }
        return hashValue;
    }

    private static String length(InputStream stream) {
        String length;
        if (stream == null) {
            length = "length=none";
        } else {
            try {
                length = "length=" + stream.available();
            }
            catch (Exception e) {
                length = "length=unknown";
            }
        }
        return length;
    }

    private static String length(byte[] message) {
        String length = message == null ? "length=none" : "length=" + message.length;
        return length;
    }

    private static boolean isJniLib(Session session) {
        return session != null && session.getDeviceType() == 1;
    }

    public static boolean checkHashLength(Mechanism mechanism, byte[] hashValue) throws Exception {
        boolean match = true;
        if (mechanism != null && hashValue != null) {
            int hashLength = Mechanisms.hashLength(mechanism);
            if (hashLength < 0) {
                throw new IllegalArgumentException("invalid hash mechanism: " + mechanism);
            }
            boolean bl = match = hashValue.length == hashLength;
            if (!match) {
                throw new IllegalArgumentException(String.format("hashLength=%d mechanism not match %s", hashValue.length, mechanism.getMechanismType()));
            }
        }
        return match;
    }

    static {
        Environments.environments();
        ALGOIDMAP = new Hashtable();
        ALGOIDMAP.put("RIPEMD128", TeleTrusTObjectIdentifiers.ripemd128);
        ALGOIDMAP.put("RIPEMD160", TeleTrusTObjectIdentifiers.ripemd160);
        ALGOIDMAP.put("RIPEMD256", TeleTrusTObjectIdentifiers.ripemd256);
        ALGOIDMAP.put("SHA-1", X509ObjectIdentifiers.id_SHA1);
        ALGOIDMAP.put("sha1WithRSAEncryption", X509ObjectIdentifiers.id_SHA1);
        ALGOIDMAP.put("SHA-256", NISTObjectIdentifiers.id_sha256);
        ALGOIDMAP.put("sha256WithRSAEncryption", NISTObjectIdentifiers.id_sha256);
        ALGOIDMAP.put("SHA-384", NISTObjectIdentifiers.id_sha384);
        ALGOIDMAP.put("SHA-512", NISTObjectIdentifiers.id_sha512);
        ALGOIDMAP.put("sha512WithRSAEncryption", NISTObjectIdentifiers.id_sha512);
        ALGOIDMAP.put("MD2", PKCSObjectIdentifiers.md2);
        ALGOIDMAP.put("MD4", PKCSObjectIdentifiers.md4);
        ALGOIDMAP.put("MD5", PKCSObjectIdentifiers.md5);
        ALGOIDMAP.put("md5WithRSAEncryption", PKCSObjectIdentifiers.md5);
        ALGOIDMAP.put("SM3", PKCSObjectIdentifiers.sm3);
    }
}

