/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCS7SignedData;
import cfca.sadk.algorithm.common.PKCS7SignedFile;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.util.BigIntegerUtil;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import cfca.sadk.org.bouncycastle.util.Strings;
import cfca.sadk.system.Environments;
import cfca.sadk.system.FileHelper;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;

public class Signature {
    static final int sourceFileLoadLimitedLength = 10240;
    private X509Cert signCert = null;
    private String digestAlgorithm = null;
    private byte[] signature = null;
    private byte[] sourceData = null;
    private final boolean outputBase64SignResult;

    public Signature() {
        this.outputBase64SignResult = true;
    }

    public Signature(boolean outputBase64SignResult) {
        this.outputBase64SignResult = outputBase64SignResult;
    }

    public X509Cert getSignerX509CertFromP7SignData(byte[] p7SignedData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("getSignerX509CertFromP7SignData>>>>>>Running");
        }
        try {
            PKCS7SignedData pkcs7SignedData = this.GetPKCS7From(p7SignedData, null);
            X509Cert x509Cert = pkcs7SignedData.getSignerX509Cert();
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("getSignerX509CertFromP7SignData<<<<<<Finished");
            }
            return x509Cert;
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("getSignerX509CertFromP7SignData<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            LoggerManager.exceptionLogger.error("getSignerX509CertFromP7SignData<<<<Failure", (Throwable)e);
            throw e;
        }
    }

    public byte[] getContentFromP7SignData(byte[] p7SignedData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("getContentFromP7SignData>>>>>>Running");
        }
        try {
            PKCS7SignedData pkcs7SignedData = this.GetPKCS7From(p7SignedData, null);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("getContentFromP7SignData<<<<<<Finished");
            }
            return pkcs7SignedData.getSourceData();
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("getContentFromP7SignData<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            LoggerManager.exceptionLogger.error("getContentFromP7SignData<<<<Failure", (Throwable)e);
            throw e;
        }
    }

    public String getDigestAlgorithmFromP7SignData(byte[] p7SignedData) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("getDigestAlgorithmFromP7SignData>>>>>>Running");
        }
        try {
            PKCS7SignedData pkcs7SignedData = this.GetPKCS7From(p7SignedData, null);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("getDigestAlgorithmFromP7SignData<<<<<<Finished");
            }
            return pkcs7SignedData.getDigestAlgorithm();
        }
        catch (PKIException e) {
            LoggerManager.exceptionLogger.error("getDigestAlgorithmFromP7SignData<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            LoggerManager.exceptionLogger.error("getDigestAlgorithmFromP7SignData<<<<Failure", (Throwable)e);
            throw e;
        }
    }

    public byte[] getSourceData() {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("getSourceData<<<<<<Finished: sourceData=" + SADKDebugger.dump(this.sourceData));
        }
        return this.sourceData;
    }

    public byte[] getSignature() {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("getSignature<<<<<<Finished: signature=" + SADKDebugger.dump(this.signature));
        }
        return this.signature;
    }

    public String getDigestAlgorithm() {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("getDigestAlgorithm<<<<<<Finished: digestAlgorithm=" + SADKDebugger.dump(this.digestAlgorithm));
        }
        return this.digestAlgorithm;
    }

    public X509Cert getSignerCert() {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("getSignerCert<<<<<<Finished: signCert=" + SADKDebugger.dump(this.signCert));
        }
        return this.signCert;
    }

    private final byte[] SM2RStoASN1(byte[] signData, String signAlg) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("SM2RStoASN1::>>>>>>Running: signData=" + SADKDebugger.dump(signData));
        }
        boolean sm2Flag = this.isSM2(signAlg);
        byte[] outBytes = null;
        if (sm2Flag && signData != null && signData.length == 64) {
            try {
                byte[] R32Bytes = new byte[32];
                byte[] S32Bytes = new byte[32];
                System.arraycopy(signData, 0, R32Bytes, 0, 32);
                System.arraycopy(signData, 32, S32Bytes, 0, 32);
                ASN1EncodableVector rsV = new ASN1EncodableVector();
                rsV.add(BigIntegers.fromByteArray(R32Bytes, 32));
                rsV.add(BigIntegers.fromByteArray(S32Bytes, 32));
                DERSequence rsSequence = new DERSequence(rsV);
                outBytes = rsSequence.getEncoded();
            }
            catch (Exception e) {
                LoggerManager.exceptionLogger.error("SM2RStoASN1::<<<<<<Failure(SM2Signature Encoded Failure): signData=" + SADKDebugger.dump(signData), (Throwable)e);
                throw new PKIException("SM2Signature Encoded Failure", e);
            }
        } else {
            outBytes = signData;
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("SM2RStoASN1::<<<<<<Finished: outBytes=" + SADKDebugger.dump(outBytes));
        }
        return outBytes;
    }

    private final byte[] SM2ASN1toRS(byte[] asn1SM2RSValue) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("SM2ASN1toRS::>>>>>>Running: asn1SM2RSValue=" + SADKDebugger.dump(asn1SM2RSValue));
        }
        try {
            ASN1Sequence sequence = ASN1Sequence.getInstance(asn1SM2RSValue);
            ASN1Integer R = (ASN1Integer)sequence.getObjectAt(0);
            ASN1Integer S = (ASN1Integer)sequence.getObjectAt(1);
            byte[] R32Bytes = BigIntegerUtil.asUnsigned32ByteArray(R.getPositiveValue());
            byte[] S32Bytes = BigIntegerUtil.asUnsigned32ByteArray(S.getPositiveValue());
            byte[] SM2RS64Bytes = new byte[64];
            System.arraycopy(R32Bytes, 0, SM2RS64Bytes, 0, 32);
            System.arraycopy(S32Bytes, 0, SM2RS64Bytes, 32, 32);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("SM2ASN1toRS::<<<<<<Finished: SM2RS64Bytes=" + SADKDebugger.dump(SM2RS64Bytes));
            }
            return SM2RS64Bytes;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("SM2ASN1toRS::<<<<<<Failure(SM2Signature Decoded Failure): asn1SM2RSValue=" + SADKDebugger.dump(asn1SM2RSValue), (Throwable)e);
            throw new PKIException("SM2Signature Decoded Failure", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] p1SignByHash(String signAlg, byte[] hashValue, PrivateKey privateKey, Session session) throws PKIException {
        byte[] byArray;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p1SignByHash>>>>>>Running");
            buffer.append("\n signAlg: ");
            buffer.append(SADKDebugger.dump(signAlg));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            buffer.append("\n PrivateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            try {
                byte[] signData = session.signByHash(new Mechanism(signAlg), privateKey, hashValue);
                byte[] binarySignValue = this.SM2RStoASN1(signData, signAlg);
                byte[] base64SignValue = this.outputSignResult(binarySignValue);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("p1SignByHash<<<<<<Finished");
                }
                byArray = base64SignValue;
                Object var11_13 = null;
                if (!isFailed) return byArray;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p1SignByHash<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p1SignByHash<<<<<<Failure", e);
                throw new PKIException("p1SignByHash Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("p1SignByHash>>>>>>Running");
            buffer.append("\n signAlg: ");
            buffer.append(SADKDebugger.dump(signAlg));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            buffer.append("\n PrivateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return byArray;
        StringBuffer buffer = new StringBuffer();
        buffer.append("p1SignByHash>>>>>>Running");
        buffer.append("\n signAlg: ");
        buffer.append(SADKDebugger.dump(signAlg));
        buffer.append("\n hashValue: ");
        buffer.append(SADKDebugger.dump(hashValue));
        buffer.append("\n PrivateKey: ");
        buffer.append(SADKDebugger.dump(privateKey));
        buffer.append("\n session: ");
        buffer.append(SADKDebugger.dump(session));
        LoggerManager.exceptionLogger.error(buffer.toString());
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] p7SignByHash(String signAlg, byte[] hashValue, PrivateKey privateKey, X509Cert signCert, Session session) throws PKIException {
        byte[] byArray;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7SignByHash>>>>>>Running");
            buffer.append("\n signAlg: ");
            buffer.append(SADKDebugger.dump(signAlg));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            buffer.append("\n PrivateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n signCert: ");
            buffer.append(SADKDebugger.dump(signCert));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            try {
                PKCS7SignedData p7 = new PKCS7SignedData(session);
                X509Cert[] certs = new X509Cert[]{signCert};
                Mechanism mechanism = new Mechanism(signAlg);
                byte[] binarySignValue = session.signByHash(new Mechanism(signAlg), privateKey, hashValue);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("p7SignByHash::::::: binarySignValue=" + SADKDebugger.dump(binarySignValue));
                }
                byte[] binaryP7SignedBytes = p7.packageSignedData(false, null, null, binarySignValue, mechanism, certs);
                byte[] base64P7SignedBytes = this.outputSignResult(binaryP7SignedBytes);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("p7SignByHash<<<<<<Finished");
                }
                byArray = base64P7SignedBytes;
                Object var15_17 = null;
                if (!isFailed) return byArray;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p7SignByHash<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p7SignByHash<<<<<<Failure", e);
                throw new PKIException("p7SignByHash Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7SignByHash>>>>>>Running");
            buffer.append("\n signAlg: ");
            buffer.append(SADKDebugger.dump(signAlg));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            buffer.append("\n PrivateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n signCert: ");
            buffer.append(SADKDebugger.dump(signCert));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return byArray;
        StringBuffer buffer = new StringBuffer();
        buffer.append("p7SignByHash>>>>>>Running");
        buffer.append("\n signAlg: ");
        buffer.append(SADKDebugger.dump(signAlg));
        buffer.append("\n hashValue: ");
        buffer.append(SADKDebugger.dump(hashValue));
        buffer.append("\n PrivateKey: ");
        buffer.append(SADKDebugger.dump(privateKey));
        buffer.append("\n signCert: ");
        buffer.append(SADKDebugger.dump(signCert));
        buffer.append("\n session: ");
        buffer.append(SADKDebugger.dump(session));
        LoggerManager.exceptionLogger.error(buffer.toString());
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean p1VerifyByHash(String signAlg, byte[] hashValue, byte[] base64P1SignedData, PublicKey publicKey, Session session) throws PKIException {
        boolean bl;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p1VerifyByHash>>>>>>Running");
            buffer.append("\n signAlg: ");
            buffer.append(SADKDebugger.dump(signAlg));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            buffer.append("\n base64P1SignedData: ");
            buffer.append(SADKDebugger.dump(base64P1SignedData));
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            try {
                boolean verifyResult;
                byte[] binarySignValue = this.GetP1SignatureValue(publicKey, signAlg, base64P1SignedData);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("p1VerifyByHash::::::: binarySignValue=" + SADKDebugger.dump(binarySignValue));
                }
                if (!(verifyResult = session.verifyByHash(new Mechanism(signAlg), publicKey, hashValue, binarySignValue))) {
                    isFailed = true;
                }
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("p1VerifyByHash<<<<<<Finished: verifyResult=" + verifyResult);
                }
                bl = verifyResult;
                Object var11_13 = null;
                if (!isFailed) return bl;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p1VerifyByHash<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p1VerifyByHash<<<<<<Failure", e);
                throw new PKIException("p1VerifyByHash Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("p1VerifyByHash>>>>>>Running");
            buffer.append("\n signAlg: ");
            buffer.append(SADKDebugger.dump(signAlg));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            buffer.append("\n base64P1SignedData: ");
            buffer.append(SADKDebugger.dump(base64P1SignedData));
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return bl;
        StringBuffer buffer = new StringBuffer();
        buffer.append("p1VerifyByHash>>>>>>Running");
        buffer.append("\n signAlg: ");
        buffer.append(SADKDebugger.dump(signAlg));
        buffer.append("\n hashValue: ");
        buffer.append(SADKDebugger.dump(hashValue));
        buffer.append("\n base64P1SignedData: ");
        buffer.append(SADKDebugger.dump(base64P1SignedData));
        buffer.append("\n publicKey: ");
        buffer.append(SADKDebugger.dump(publicKey));
        buffer.append("\n session: ");
        buffer.append(SADKDebugger.dump(session));
        LoggerManager.exceptionLogger.error(buffer.toString());
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean p7VerifyByHash(byte[] hashValue, byte[] base64P7SignedData, Session session) throws PKIException {
        boolean bl;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7VerifyByHash>>>>>>Running");
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            buffer.append("\n base64P7SignedData: ");
            buffer.append(SADKDebugger.dump(base64P7SignedData));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            try {
                PKCS7SignedData pkcs7SignedData = this.GetPKCS7From(base64P7SignedData, session);
                this.GetDataFrom(pkcs7SignedData, false);
                boolean verifyResult = pkcs7SignedData.verifyP7SignedDataByHash(hashValue);
                if (!verifyResult) {
                    isFailed = true;
                }
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("p7VerifyByHash<<<<<<Finished: verifyResult=" + verifyResult);
                }
                bl = verifyResult;
                Object var9_11 = null;
                if (!isFailed) return bl;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p7VerifyByHash<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p7VerifyByHash<<<<<<Failure", e);
                throw new PKIException("p7VerifyByHash Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7VerifyByHash>>>>>>Running");
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            buffer.append("\n base64P7SignedData: ");
            buffer.append(SADKDebugger.dump(base64P7SignedData));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return bl;
        StringBuffer buffer = new StringBuffer();
        buffer.append("p7VerifyByHash>>>>>>Running");
        buffer.append("\n hashValue: ");
        buffer.append(SADKDebugger.dump(hashValue));
        buffer.append("\n base64P7SignedData: ");
        buffer.append(SADKDebugger.dump(base64P7SignedData));
        buffer.append("\n session: ");
        buffer.append(SADKDebugger.dump(session));
        LoggerManager.exceptionLogger.error(buffer.toString());
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] p1SignMessage(String signAlg, byte[] sourceData, PrivateKey privateKey, Session session) throws PKIException {
        byte[] byArray;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p1SignMessage>>>>>>Running");
            buffer.append("\n signAlg: ");
            buffer.append(SADKDebugger.dump(signAlg));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            buffer.append("\n PrivateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            try {
                byte[] signData = session.sign(new Mechanism(signAlg), privateKey, sourceData);
                byte[] binarySignValue = this.SM2RStoASN1(signData, signAlg);
                byte[] base64SignValue = this.outputSignResult(binarySignValue);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("p1SignMessage<<<<<<Finished");
                }
                byArray = base64SignValue;
                Object var11_13 = null;
                if (!isFailed) return byArray;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p1SignMessage<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p1SignMessage<<<<<<Failure", e);
                throw new PKIException("p1SignMessage Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("p1SignMessage>>>>>>Running");
            buffer.append("\n signAlg: ");
            buffer.append(SADKDebugger.dump(signAlg));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            buffer.append("\n PrivateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return byArray;
        StringBuffer buffer = new StringBuffer();
        buffer.append("p1SignMessage>>>>>>Running");
        buffer.append("\n signAlg: ");
        buffer.append(SADKDebugger.dump(signAlg));
        buffer.append("\n sourceData: ");
        buffer.append(SADKDebugger.dump(sourceData));
        buffer.append("\n PrivateKey: ");
        buffer.append(SADKDebugger.dump(privateKey));
        buffer.append("\n session: ");
        buffer.append(SADKDebugger.dump(session));
        LoggerManager.exceptionLogger.error(buffer.toString());
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] p1SignFile(String signAlg, String sourceFilePath, PrivateKey privateKey, Session session) throws PKIException {
        byte[] byArray;
        boolean isFailed;
        block12: {
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("p1SignFile>>>>>>Running");
                buffer.append("\n signAlg: ");
                buffer.append(SADKDebugger.dump(signAlg));
                buffer.append("\n sourceFilePath: ");
                buffer.append(SADKDebugger.dump(sourceFilePath));
                buffer.append("\n PrivateKey: ");
                buffer.append(SADKDebugger.dump(privateKey));
                buffer.append("\n session: ");
                buffer.append(SADKDebugger.dump(session));
                LoggerManager.debugLogger.debug(buffer.toString());
            }
            isFailed = false;
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(sourceFilePath);
                    byte[] signData = session.sign(new Mechanism(signAlg), privateKey, fis);
                    byte[] binarySignValue = this.SM2RStoASN1(signData, signAlg);
                    byte[] base64SignValue = this.outputSignResult(binarySignValue);
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("p1SignFile<<<<<<Finished");
                    }
                    byArray = base64SignValue;
                    Object var12_14 = null;
                    if (fis == null) break block12;
                }
                catch (PKIException e) {
                    isFailed = true;
                    LoggerManager.exceptionLogger.error("p1SignFile<<<<<<Failure", (Throwable)e);
                    throw e;
                }
                catch (Throwable e) {
                    isFailed = true;
                    LoggerManager.exceptionLogger.error("p1SignFile<<<<<<Failure", e);
                    throw new PKIException("p1SignFile Failure", e);
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (fis != null) {
                    try {
                        ((InputStream)fis).close();
                    }
                    catch (Exception e) {
                        throw new PKIException("p1SignFile Failure", e);
                    }
                }
                if (!isFailed) throw throwable;
                if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
                StringBuffer buffer = new StringBuffer();
                buffer.append("p1SignFile>>>>>>Running");
                buffer.append("\n signAlg: ");
                buffer.append(SADKDebugger.dump(signAlg));
                buffer.append("\n sourceFilePath: ");
                buffer.append(SADKDebugger.dump(sourceFilePath));
                buffer.append("\n PrivateKey: ");
                buffer.append(SADKDebugger.dump(privateKey));
                buffer.append("\n session: ");
                buffer.append(SADKDebugger.dump(session));
                LoggerManager.exceptionLogger.error(buffer.toString());
                throw throwable;
            }
            try {}
            catch (Exception e) {
                throw new PKIException("p1SignFile Failure", e);
            }
            ((InputStream)fis).close();
        }
        if (!isFailed) return byArray;
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return byArray;
        StringBuffer buffer = new StringBuffer();
        buffer.append("p1SignFile>>>>>>Running");
        buffer.append("\n signAlg: ");
        buffer.append(SADKDebugger.dump(signAlg));
        buffer.append("\n sourceFilePath: ");
        buffer.append(SADKDebugger.dump(sourceFilePath));
        buffer.append("\n PrivateKey: ");
        buffer.append(SADKDebugger.dump(privateKey));
        buffer.append("\n session: ");
        buffer.append(SADKDebugger.dump(session));
        LoggerManager.exceptionLogger.error(buffer.toString());
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] p7SignMessageAttach(String signAlg, byte[] sourceData, PrivateKey privateKey, X509Cert signCert, Session session) throws PKIException {
        byte[] byArray;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7SignMessageAttach>>>>>>Running");
            buffer.append("\n signAlg: ");
            buffer.append(SADKDebugger.dump(signAlg));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n signCert: ");
            buffer.append(SADKDebugger.dump(signCert));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            try {
                PKCS7SignedData p7 = new PKCS7SignedData(session);
                X509Cert[] certs = new X509Cert[]{signCert};
                Mechanism mechanism = new Mechanism(signAlg);
                byte[] binarySignValue = session.sign(mechanism, privateKey, sourceData);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("p7SignMessageAttach::::::: binarySignValue=" + SADKDebugger.dump(binarySignValue));
                }
                byte[] binary7SignedBytes = p7.packageSignedData(true, null, sourceData, binarySignValue, mechanism, certs);
                byte[] base64P7SignedBytes = this.outputSignResult(binary7SignedBytes);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("p7SignMessageAttach<<<<<<Finished");
                }
                byArray = base64P7SignedBytes;
                Object var15_17 = null;
                if (!isFailed) return byArray;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p7SignMessageAttach<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p7SignMessageAttach<<<<<<Failure", e);
                throw new PKIException("p7SignMessageAttach Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7SignMessageAttach>>>>>>Running");
            buffer.append("\n signAlg: ");
            buffer.append(SADKDebugger.dump(signAlg));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n signCert: ");
            buffer.append(SADKDebugger.dump(signCert));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return byArray;
        StringBuffer buffer = new StringBuffer();
        buffer.append("p7SignMessageAttach>>>>>>Running");
        buffer.append("\n signAlg: ");
        buffer.append(SADKDebugger.dump(signAlg));
        buffer.append("\n sourceData: ");
        buffer.append(SADKDebugger.dump(sourceData));
        buffer.append("\n privateKey: ");
        buffer.append(SADKDebugger.dump(privateKey));
        buffer.append("\n signCert: ");
        buffer.append(SADKDebugger.dump(signCert));
        buffer.append("\n session: ");
        buffer.append(SADKDebugger.dump(session));
        LoggerManager.exceptionLogger.error(buffer.toString());
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] p7SignMessageDetach(String signAlg, byte[] sourceData, PrivateKey privateKey, X509Cert signCert, Session session) throws PKIException {
        byte[] byArray;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7SignMessageDetach>>>>>>Running");
            buffer.append("\n signAlg: ");
            buffer.append(SADKDebugger.dump(signAlg));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n signCert: ");
            buffer.append(SADKDebugger.dump(signCert));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            try {
                PKCS7SignedData p7 = new PKCS7SignedData(session);
                X509Cert[] certs = new X509Cert[]{signCert};
                Mechanism mechanism = new Mechanism(signAlg);
                byte[] binarySignValue = session.sign(mechanism, privateKey, sourceData);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("p7SignMessageAttach::::::: binarySignValue=" + SADKDebugger.dump(binarySignValue));
                }
                byte[] binary7SignedBytes = p7.packageSignedData(false, null, sourceData, binarySignValue, mechanism, certs);
                byte[] base64P7SignedBytes = this.outputSignResult(binary7SignedBytes);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("p7SignMessageAttach<<<<<<Finished");
                }
                byArray = base64P7SignedBytes;
                Object var15_17 = null;
                if (!isFailed) return byArray;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p7SignMessageDetach<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p7SignMessageDetach<<<<<<Failure", e);
                throw new PKIException("p7SignMessageDetach Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7SignMessageDetach>>>>>>Running");
            buffer.append("\n signAlg: ");
            buffer.append(SADKDebugger.dump(signAlg));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n signCert: ");
            buffer.append(SADKDebugger.dump(signCert));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return byArray;
        StringBuffer buffer = new StringBuffer();
        buffer.append("p7SignMessageDetach>>>>>>Running");
        buffer.append("\n signAlg: ");
        buffer.append(SADKDebugger.dump(signAlg));
        buffer.append("\n sourceData: ");
        buffer.append(SADKDebugger.dump(sourceData));
        buffer.append("\n privateKey: ");
        buffer.append(SADKDebugger.dump(privateKey));
        buffer.append("\n signCert: ");
        buffer.append(SADKDebugger.dump(signCert));
        buffer.append("\n session: ");
        buffer.append(SADKDebugger.dump(session));
        LoggerManager.exceptionLogger.error(buffer.toString());
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void p7SignFileAttach(String signAlg, String sourceFilePath, String outSignedFilePath, PrivateKey privateKey, X509Cert signCert, Session session) throws PKIException {
        boolean isFailed;
        block14: {
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("p7SignFileAttach>>>>>>Running");
                buffer.append("\n signAlg: ");
                buffer.append(SADKDebugger.dump(signAlg));
                buffer.append("\n sourceFilePath: ");
                buffer.append(SADKDebugger.dump(sourceFilePath));
                buffer.append("\n outSignedFilePath: ");
                buffer.append(SADKDebugger.dump(outSignedFilePath));
                buffer.append("\n privateKey: ");
                buffer.append(SADKDebugger.dump(privateKey));
                buffer.append("\n signCert: ");
                buffer.append(SADKDebugger.dump(signCert));
                buffer.append("\n session: ");
                buffer.append(SADKDebugger.dump(session));
                LoggerManager.debugLogger.debug(buffer.toString());
            }
            isFailed = false;
            FileInputStream fis = null;
            if (signCert == null) {
                throw new PKIException("signCert is null");
            }
            try {
                try {
                    fis = new FileInputStream(sourceFilePath);
                    PKCS7SignedFile p7 = new PKCS7SignedFile(session);
                    X509Cert[] certs = new X509Cert[]{signCert};
                    Mechanism mechanism = new Mechanism(signAlg);
                    byte[] binarySignValue = session.sign(mechanism, privateKey, fis);
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("p7SignFileAttach::::::: binarySignValue=" + SADKDebugger.dump(binarySignValue));
                    }
                    p7.packageSignedFile(sourceFilePath, outSignedFilePath, binarySignValue, mechanism, certs);
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("p7SignFileAttach<<<<<<Finished: outSignedFilePath=" + SADKDebugger.dump(outSignedFilePath));
                    }
                }
                catch (PKIException e) {
                    isFailed = true;
                    LoggerManager.exceptionLogger.error("p7SignFileAttach<<<<<<Failure", (Throwable)e);
                    throw e;
                }
                catch (Throwable e) {
                    isFailed = true;
                    LoggerManager.exceptionLogger.error("p7SignFileAttach<<<<<<Failure", e);
                    throw new PKIException("p7SignFileAttach Failure", e);
                }
                Object var14_16 = null;
                if (fis == null) break block14;
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {
                        throw new PKIException("p7SignFileAttach Failure", e);
                    }
                }
                if (!isFailed) throw throwable;
                if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
                StringBuffer buffer = new StringBuffer();
                buffer.append("p7SignFileAttach>>>>>>Running");
                buffer.append("\n signAlg: ");
                buffer.append(SADKDebugger.dump(signAlg));
                buffer.append("\n sourceFilePath: ");
                buffer.append(SADKDebugger.dump(sourceFilePath));
                buffer.append("\n outSignedFilePath: ");
                buffer.append(SADKDebugger.dump(outSignedFilePath));
                buffer.append("\n privateKey: ");
                buffer.append(SADKDebugger.dump(privateKey));
                buffer.append("\n signCert: ");
                buffer.append(SADKDebugger.dump(signCert));
                buffer.append("\n session: ");
                buffer.append(SADKDebugger.dump(session));
                LoggerManager.exceptionLogger.error(buffer.toString());
                throw throwable;
            }
            try {}
            catch (Exception e) {
                throw new PKIException("p7SignFileAttach Failure", e);
            }
            fis.close();
        }
        if (!isFailed) return;
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return;
        StringBuffer buffer = new StringBuffer();
        buffer.append("p7SignFileAttach>>>>>>Running");
        buffer.append("\n signAlg: ");
        buffer.append(SADKDebugger.dump(signAlg));
        buffer.append("\n sourceFilePath: ");
        buffer.append(SADKDebugger.dump(sourceFilePath));
        buffer.append("\n outSignedFilePath: ");
        buffer.append(SADKDebugger.dump(outSignedFilePath));
        buffer.append("\n privateKey: ");
        buffer.append(SADKDebugger.dump(privateKey));
        buffer.append("\n signCert: ");
        buffer.append(SADKDebugger.dump(signCert));
        buffer.append("\n session: ");
        buffer.append(SADKDebugger.dump(session));
        LoggerManager.exceptionLogger.error(buffer.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] p7SignFileDetach(String signAlg, String sourceFilePath, PrivateKey privateKey, X509Cert signCert, Session session) throws PKIException {
        byte[] byArray;
        boolean isFailed;
        block14: {
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("p7SignFileDetach>>>>>>Running");
                buffer.append("\n signAlg: ");
                buffer.append(SADKDebugger.dump(signAlg));
                buffer.append("\n sourceFilePath: ");
                buffer.append(SADKDebugger.dump(sourceFilePath));
                buffer.append("\n privateKey: ");
                buffer.append(SADKDebugger.dump(privateKey));
                buffer.append("\n signCert: ");
                buffer.append(SADKDebugger.dump(signCert));
                buffer.append("\n session: ");
                buffer.append(SADKDebugger.dump(session));
                LoggerManager.debugLogger.debug(buffer.toString());
            }
            if (signCert == null) {
                throw new PKIException("signCert is null");
            }
            isFailed = false;
            InputStream is = null;
            try {
                try {
                    PKCS7SignedData p7 = new PKCS7SignedData(session);
                    X509Cert[] certs = new X509Cert[]{signCert};
                    Mechanism mechanism = new Mechanism(signAlg);
                    is = new FileInputStream(sourceFilePath);
                    byte[] binarySignValue = session.sign(mechanism, privateKey, is);
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("p7SignFileDetach::::::: binarySignValue=" + SADKDebugger.dump(binarySignValue));
                    }
                    byte[] binary7SignedBytes = p7.packageSignedData(false, null, null, binarySignValue, mechanism, certs);
                    byte[] base64P7SignedBytes = this.outputSignResult(binary7SignedBytes);
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("p7SignFileDetach<<<<<<Finished");
                    }
                    byArray = base64P7SignedBytes;
                    Object var16_18 = null;
                    if (is == null) break block14;
                }
                catch (PKIException e) {
                    isFailed = true;
                    LoggerManager.exceptionLogger.error("p7SignFileDetach<<<<<<Failure", (Throwable)e);
                    throw e;
                }
                catch (Throwable e) {
                    isFailed = true;
                    LoggerManager.exceptionLogger.error("p7SignFileDetach<<<<<<Failure", e);
                    throw new PKIException("p7SignFileDetach Failure", e);
                }
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        throw new PKIException("p7SignFileDetach Failure", e);
                    }
                }
                if (!isFailed) throw throwable;
                if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
                StringBuffer buffer = new StringBuffer();
                buffer.append("p7SignFileDetach>>>>>>Running");
                buffer.append("\n signAlg: ");
                buffer.append(SADKDebugger.dump(signAlg));
                buffer.append("\n sourceFilePath: ");
                buffer.append(SADKDebugger.dump(sourceFilePath));
                buffer.append("\n privateKey: ");
                buffer.append(SADKDebugger.dump(privateKey));
                buffer.append("\n signCert: ");
                buffer.append(SADKDebugger.dump(signCert));
                buffer.append("\n session: ");
                buffer.append(SADKDebugger.dump(session));
                LoggerManager.exceptionLogger.error(buffer.toString());
                throw throwable;
            }
            try {}
            catch (Exception e) {
                throw new PKIException("p7SignFileDetach Failure", e);
            }
            is.close();
        }
        if (!isFailed) return byArray;
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return byArray;
        StringBuffer buffer = new StringBuffer();
        buffer.append("p7SignFileDetach>>>>>>Running");
        buffer.append("\n signAlg: ");
        buffer.append(SADKDebugger.dump(signAlg));
        buffer.append("\n sourceFilePath: ");
        buffer.append(SADKDebugger.dump(sourceFilePath));
        buffer.append("\n privateKey: ");
        buffer.append(SADKDebugger.dump(privateKey));
        buffer.append("\n signCert: ");
        buffer.append(SADKDebugger.dump(signCert));
        buffer.append("\n session: ");
        buffer.append(SADKDebugger.dump(session));
        LoggerManager.exceptionLogger.error(buffer.toString());
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean p1VerifyMessage(String signAlg, byte[] sourceData, byte[] base64P1SignedData, PublicKey publicKey, Session session) throws PKIException {
        boolean bl;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p1VerifyMessage>>>>>>Running");
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            buffer.append("\n base64P1SignedData: ");
            buffer.append(SADKDebugger.dump(base64P1SignedData));
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            try {
                boolean verifyResult;
                byte[] binarySignValue = this.GetP1SignatureValue(publicKey, signAlg, base64P1SignedData);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("p1VerifyMessage::::::: binarySignValue=" + SADKDebugger.dump(binarySignValue));
                }
                if (!(verifyResult = session.verify(new Mechanism(signAlg), publicKey, sourceData, binarySignValue))) {
                    isFailed = true;
                }
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("p1VerifyMessage<<<<<<Finished: verifyResult=" + verifyResult);
                }
                bl = verifyResult;
                Object var11_13 = null;
                if (!isFailed) return bl;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p1VerifyMessage<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p1VerifyMessage<<<<<<Failure", e);
                throw new PKIException("p1VerifyMessage Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("p1VerifyMessage>>>>>>Running");
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            buffer.append("\n base64P1SignedData: ");
            buffer.append(SADKDebugger.dump(base64P1SignedData));
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return bl;
        StringBuffer buffer = new StringBuffer();
        buffer.append("p1VerifyMessage>>>>>>Running");
        buffer.append("\n sourceData: ");
        buffer.append(SADKDebugger.dump(sourceData));
        buffer.append("\n base64P1SignedData: ");
        buffer.append(SADKDebugger.dump(base64P1SignedData));
        buffer.append("\n publicKey: ");
        buffer.append(SADKDebugger.dump(publicKey));
        buffer.append("\n session: ");
        buffer.append(SADKDebugger.dump(session));
        LoggerManager.exceptionLogger.error(buffer.toString());
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean p1VerifyFile(String signAlg, String sourceFilePath, byte[] base64P1SignedData, PublicKey publicKey, Session session) throws PKIException {
        boolean bl;
        boolean isFailed;
        block14: {
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("p1VerifyMessage>>>>>>Running");
                buffer.append("\n sourceFilePath: ");
                buffer.append(SADKDebugger.dump(sourceFilePath));
                buffer.append("\n base64P1SignedData: ");
                buffer.append(SADKDebugger.dump(base64P1SignedData));
                buffer.append("\n publicKey: ");
                buffer.append(SADKDebugger.dump(publicKey));
                buffer.append("\n session: ");
                buffer.append(SADKDebugger.dump(session));
                LoggerManager.debugLogger.debug(buffer.toString());
            }
            isFailed = false;
            FileInputStream is = null;
            try {
                try {
                    boolean verifyResult;
                    is = new FileInputStream(sourceFilePath);
                    byte[] binarySignValue = this.GetP1SignatureValue(publicKey, signAlg, base64P1SignedData);
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("p1VerifyFile::::::: binarySignValue=" + SADKDebugger.dump(binarySignValue));
                    }
                    if (!(verifyResult = session.verify(new Mechanism(signAlg), publicKey, is, binarySignValue))) {
                        isFailed = true;
                    }
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("p1VerifyFile<<<<<<Finished: verifyResult=" + verifyResult);
                    }
                    bl = verifyResult;
                    Object var12_14 = null;
                    if (is == null) break block14;
                }
                catch (PKIException e) {
                    isFailed = true;
                    LoggerManager.exceptionLogger.error("p1VerifyFile<<<<<<Failure", (Throwable)e);
                    throw e;
                }
                catch (Throwable e) {
                    isFailed = true;
                    LoggerManager.exceptionLogger.error("p1VerifyFile<<<<<<Failure", e);
                    throw new PKIException("p1VerifyFile Failure", e);
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception e) {
                        throw new PKIException("p1VerifyFile Failure", e);
                    }
                }
                if (!isFailed) throw throwable;
                if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
                StringBuffer buffer = new StringBuffer();
                buffer.append("p1VerifyMessage>>>>>>Running");
                buffer.append("\n sourceFilePath: ");
                buffer.append(SADKDebugger.dump(sourceFilePath));
                buffer.append("\n base64P1SignedData: ");
                buffer.append(SADKDebugger.dump(base64P1SignedData));
                buffer.append("\n publicKey: ");
                buffer.append(SADKDebugger.dump(publicKey));
                buffer.append("\n session: ");
                buffer.append(SADKDebugger.dump(session));
                LoggerManager.exceptionLogger.error(buffer.toString());
                throw throwable;
            }
            try {}
            catch (Exception e) {
                throw new PKIException("p1VerifyFile Failure", e);
            }
            ((InputStream)is).close();
        }
        if (!isFailed) return bl;
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return bl;
        StringBuffer buffer = new StringBuffer();
        buffer.append("p1VerifyMessage>>>>>>Running");
        buffer.append("\n sourceFilePath: ");
        buffer.append(SADKDebugger.dump(sourceFilePath));
        buffer.append("\n base64P1SignedData: ");
        buffer.append(SADKDebugger.dump(base64P1SignedData));
        buffer.append("\n publicKey: ");
        buffer.append(SADKDebugger.dump(publicKey));
        buffer.append("\n session: ");
        buffer.append(SADKDebugger.dump(session));
        LoggerManager.exceptionLogger.error(buffer.toString());
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean p7VerifyMessageAttach(byte[] base64P7SignedData, Session session) throws PKIException {
        boolean bl;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7VerifyMessageAttach>>>>>>Running");
            buffer.append("\n base64P7SignedData: ");
            buffer.append(SADKDebugger.dump(base64P7SignedData));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            try {
                PKCS7SignedData pkcs7SignedData = this.GetPKCS7From(base64P7SignedData, session);
                this.GetDataFrom(pkcs7SignedData, true);
                boolean verifyResult = pkcs7SignedData.verifyP7SignedDataAttach();
                if (!verifyResult) {
                    isFailed = true;
                }
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("p7VerifyMessageAttach<<<<<<Finished: verifyResult=" + verifyResult);
                }
                bl = verifyResult;
                Object var8_10 = null;
                if (!isFailed) return bl;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p7VerifyMessageAttach<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p7VerifyMessageAttach<<<<<<Failure", e);
                throw new PKIException("p7VerifyMessageAttach Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7VerifyMessageAttach>>>>>>Running");
            buffer.append("\n base64P7SignedData: ");
            buffer.append(SADKDebugger.dump(base64P7SignedData));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return bl;
        StringBuffer buffer = new StringBuffer();
        buffer.append("p7VerifyMessageAttach>>>>>>Running");
        buffer.append("\n base64P7SignedData: ");
        buffer.append(SADKDebugger.dump(base64P7SignedData));
        buffer.append("\n session: ");
        buffer.append(SADKDebugger.dump(session));
        LoggerManager.exceptionLogger.error(buffer.toString());
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean p7VerifyMessageDetach(byte[] sourceData, byte[] base64P7SignedData, Session session) throws PKIException {
        boolean bl;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7VerifyMessageDetach>>>>>>Running");
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            buffer.append("\n base64P7SignedData: ");
            buffer.append(SADKDebugger.dump(base64P7SignedData));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            try {
                PKCS7SignedData pkcs7SignedData = this.GetPKCS7From(base64P7SignedData, session);
                this.GetDataFrom(pkcs7SignedData, false);
                boolean verifyResult = pkcs7SignedData.verifyP7SignedData(sourceData);
                if (!verifyResult) {
                    isFailed = true;
                }
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("p7VerifyMessageDetach<<<<<<Finished: verifyResult=" + verifyResult);
                }
                bl = verifyResult;
                Object var9_11 = null;
                if (!isFailed) return bl;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p7VerifyMessageDetach<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p7VerifyMessageDetach<<<<<<Failure", e);
                throw new PKIException("p7VerifyMessageDetach Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7VerifyMessageDetach>>>>>>Running");
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            buffer.append("\n base64P7SignedData: ");
            buffer.append(SADKDebugger.dump(base64P7SignedData));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return bl;
        StringBuffer buffer = new StringBuffer();
        buffer.append("p7VerifyMessageDetach>>>>>>Running");
        buffer.append("\n sourceData: ");
        buffer.append(SADKDebugger.dump(sourceData));
        buffer.append("\n base64P7SignedData: ");
        buffer.append(SADKDebugger.dump(base64P7SignedData));
        buffer.append("\n session: ");
        buffer.append(SADKDebugger.dump(session));
        LoggerManager.exceptionLogger.error(buffer.toString());
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean p7VerifyFileAttach(String signedFilePath, String outSourceFilePath, Session session) throws PKIException {
        boolean bl;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7VerifyFileAttach>>>>>>Running");
            buffer.append("\n signedFilePath: ");
            buffer.append(SADKDebugger.dump(signedFilePath));
            buffer.append("\n outSourceFilePath: ");
            buffer.append(SADKDebugger.dump(outSourceFilePath));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.debugLogger.debug(buffer.toString());
        }
        boolean isFailed = false;
        try {
            try {
                PKCS7SignedFile pkcs7SignedFile = new PKCS7SignedFile(session);
                boolean verifyResult = pkcs7SignedFile.verifyP7SignedFile(signedFilePath, outSourceFilePath);
                if (!verifyResult) {
                    isFailed = true;
                }
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("p7VerifyFileAttach:::::: verifyResult=" + verifyResult);
                }
                this.GetDataFrom(pkcs7SignedFile, outSourceFilePath);
                if (LoggerManager.debugLogger.isDebugEnabled()) {
                    LoggerManager.debugLogger.debug("p7VerifyFileAttach<<<<<<Finished: verifyResult=" + verifyResult);
                }
                bl = verifyResult;
                Object var9_11 = null;
                if (!isFailed) return bl;
            }
            catch (PKIException e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p7VerifyFileAttach<<<<<<Failure", (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                isFailed = true;
                LoggerManager.exceptionLogger.error("p7VerifyFileAttach<<<<<<Failure", e);
                throw new PKIException("p7VerifyFileAttach Failure", e);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!isFailed) throw throwable;
            if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
            StringBuffer buffer = new StringBuffer();
            buffer.append("p7VerifyFileAttach>>>>>>Running");
            buffer.append("\n signedFilePath: ");
            buffer.append(SADKDebugger.dump(signedFilePath));
            buffer.append("\n outSourceFilePath: ");
            buffer.append(SADKDebugger.dump(outSourceFilePath));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            LoggerManager.exceptionLogger.error(buffer.toString());
            throw throwable;
        }
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return bl;
        StringBuffer buffer = new StringBuffer();
        buffer.append("p7VerifyFileAttach>>>>>>Running");
        buffer.append("\n signedFilePath: ");
        buffer.append(SADKDebugger.dump(signedFilePath));
        buffer.append("\n outSourceFilePath: ");
        buffer.append(SADKDebugger.dump(outSourceFilePath));
        buffer.append("\n session: ");
        buffer.append(SADKDebugger.dump(session));
        LoggerManager.exceptionLogger.error(buffer.toString());
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean p7VerifyFileDetach(String sourceFilePath, byte[] base64P7SignedData, Session session) throws PKIException {
        boolean bl;
        boolean isFailed;
        block13: {
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("p7VerifyFileDetach>>>>>>Running");
                buffer.append("\n sourceFilePath: ");
                buffer.append(SADKDebugger.dump(sourceFilePath));
                buffer.append("\n base64P7SignedData: ");
                buffer.append(SADKDebugger.dump(base64P7SignedData));
                buffer.append("\n session: ");
                buffer.append(SADKDebugger.dump(session));
                LoggerManager.debugLogger.debug(buffer.toString());
            }
            isFailed = false;
            InputStream is = null;
            try {
                try {
                    PKCS7SignedData pkcs7SignedData = this.GetPKCS7From(base64P7SignedData, session);
                    this.GetDataFrom(pkcs7SignedData, false);
                    is = new FileInputStream(sourceFilePath);
                    boolean verifyResult = pkcs7SignedData.verifyP7SignedData(is);
                    if (!verifyResult) {
                        isFailed = true;
                    }
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("p7VerifyFileDetach<<<<<<Finished: verifyResult=" + verifyResult);
                    }
                    bl = verifyResult;
                    Object var10_12 = null;
                    if (is == null) break block13;
                }
                catch (PKIException e) {
                    isFailed = true;
                    LoggerManager.exceptionLogger.error("p7VerifyFileDetach<<<<<<Failure", (Throwable)e);
                    throw e;
                }
                catch (Throwable e) {
                    isFailed = true;
                    LoggerManager.exceptionLogger.error("p7VerifyFileDetach<<<<<<Failure", e);
                    throw new PKIException("p7VerifyFileDetach Failure", e);
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        throw new PKIException("p7VerifyFileDetach Failure", e);
                    }
                }
                if (!isFailed) throw throwable;
                if (!LoggerManager.exceptionLogger.isErrorEnabled()) throw throwable;
                StringBuffer buffer = new StringBuffer();
                buffer.append("p7VerifyFileDetach>>>>>>Running");
                buffer.append("\n sourceFilePath: ");
                buffer.append(SADKDebugger.dump(sourceFilePath));
                buffer.append("\n base64P7SignedData: ");
                buffer.append(SADKDebugger.dump(base64P7SignedData));
                buffer.append("\n session: ");
                buffer.append(SADKDebugger.dump(session));
                LoggerManager.exceptionLogger.error(buffer.toString());
                throw throwable;
            }
            try {}
            catch (Exception e) {
                throw new PKIException("p7VerifyFileDetach Failure", e);
            }
            is.close();
        }
        if (!isFailed) return bl;
        if (!LoggerManager.exceptionLogger.isErrorEnabled()) return bl;
        StringBuffer buffer = new StringBuffer();
        buffer.append("p7VerifyFileDetach>>>>>>Running");
        buffer.append("\n sourceFilePath: ");
        buffer.append(SADKDebugger.dump(sourceFilePath));
        buffer.append("\n base64P7SignedData: ");
        buffer.append(SADKDebugger.dump(base64P7SignedData));
        buffer.append("\n session: ");
        buffer.append(SADKDebugger.dump(session));
        LoggerManager.exceptionLogger.error(buffer.toString());
        return bl;
    }

    public String getTimeFromTimeStamp(byte[] base64P7SignedData) throws PKIException {
        if (base64P7SignedData == null || base64P7SignedData.length == 0) {
            throw new PKIException("base64P7SignedData is null/length==0");
        }
        String signTime = null;
        try {
            PKCS7SignedData p7 = new PKCS7SignedData(BCSoftLib.INSTANCE());
            p7.loadBase64(base64P7SignedData);
            signTime = p7.getSignTime();
        }
        catch (Exception e) {
            if (LoggerManager.exceptionLogger.isErrorEnabled()) {
                int derSequeceTag = 48;
                String signDataText = base64P7SignedData[0] == 48 ? Base64.toBase64String(base64P7SignedData) : Strings.fromByteArray(base64P7SignedData);
                LoggerManager.exceptionLogger.error("GetSignTime from PKCS7SignedData failed, PKCS7SignedData={}", (Object)signDataText, (Object)e);
            }
            throw new PKIException("GetSignTime from PKCS7SignedData failed", e);
        }
        return signTime;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final byte[] GetP1SignatureValue(PublicKey publicKey, String signAlg, byte[] signedData) throws PKIException {
        byte[] outSignatureBytes;
        block20: {
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("GetP1SignatureValue::>>>>>>Running");
                buffer.append("\n signAlg: " + signAlg);
                buffer.append("\n signedData: ");
                buffer.append(SADKDebugger.dump(signedData));
                LoggerManager.debugLogger.debug(buffer.toString());
            }
            boolean isFailed = false;
            try {
                try {
                    block19: {
                        String algorithm;
                        block23: {
                            block24: {
                                block22: {
                                    if (publicKey == null) {
                                        throw new PKIException("Required parameters publicKey");
                                    }
                                    if (signAlg == null) {
                                        throw new PKIException("Required parameters signAlg");
                                    }
                                    if (signedData == null || signedData.length == 0) {
                                        throw new PKIException("Required parameters signedData");
                                    }
                                    outSignatureBytes = null;
                                    algorithm = signAlg.toUpperCase();
                                    if (algorithm.indexOf("RSA") < 0) break block22;
                                    int baseLength = publicKey instanceof RSAPublicKey ? (7 + ((RSAPublicKey)publicKey).getModulus().bitLength()) / 8 : 64;
                                    outSignatureBytes = signedData.length % baseLength == 0 ? signedData : Base64.decode(signedData);
                                    break block19;
                                }
                                if (!this.isSM2(algorithm)) break block23;
                                if (signedData.length < 64) {
                                    throw new PKIException("Invalid signatureValue:  signedData shortage=" + SADKDebugger.dump(signedData));
                                }
                                if (signedData.length != 64) break block24;
                                outSignatureBytes = signedData;
                                break block19;
                            }
                            if (signedData.length <= 72 && ASN1Parser.isDERSequence(signedData)) {
                                outSignatureBytes = this.SM2ASN1toRS(signedData);
                                break block19;
                            } else {
                                byte[] encoding = Base64.decode(signedData);
                                if (encoding.length == 64) {
                                    outSignatureBytes = encoding;
                                    break block19;
                                } else {
                                    if (!ASN1Parser.isDERSequence(encoding)) {
                                        throw new PKIException("Invalid signatureValue: required binary or base64, signedData=" + SADKDebugger.dump(signedData));
                                    }
                                    outSignatureBytes = this.SM2ASN1toRS(encoding);
                                }
                            }
                            break block19;
                        }
                        if (!this.isECC(algorithm)) {
                            throw new PKIException("Invalid signatureAlgorithm: " + signAlg);
                        }
                        outSignatureBytes = Base64.decode(signedData);
                    }
                    Object var9_12 = null;
                    if (!isFailed) break block20;
                }
                catch (PKIException e) {
                    isFailed = true;
                    LoggerManager.exceptionLogger.error("GetP1SignatureValue::<<<<Failure", (Throwable)e);
                    throw e;
                }
                catch (Exception e) {
                    isFailed = true;
                    LoggerManager.exceptionLogger.error("GetP1SignatureValue::<<<<Failure,Invalid base64SignatureValue=" + SADKDebugger.dump(signedData), (Throwable)e);
                    throw new PKIException("Invalid base64SignatureValue");
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                if (isFailed && LoggerManager.exceptionLogger.isErrorEnabled()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("GetP1SignatureValue::>>>>>>Running");
                    buffer.append("\n signAlg: " + signAlg);
                    buffer.append("\n signedData: ");
                    buffer.append(SADKDebugger.dump(signedData));
                    LoggerManager.exceptionLogger.error(buffer.toString());
                }
                throw throwable;
            }
            if (LoggerManager.exceptionLogger.isErrorEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("GetP1SignatureValue::>>>>>>Running");
                buffer.append("\n signAlg: " + signAlg);
                buffer.append("\n signedData: ");
                buffer.append(SADKDebugger.dump(signedData));
                LoggerManager.exceptionLogger.error(buffer.toString());
            }
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("GetP1SignatureValue::<<<<<<Finished: outSignatureBytes=" + SADKDebugger.dump(outSignatureBytes));
        }
        return outSignatureBytes;
    }

    private final PKCS7SignedData GetPKCS7From(byte[] p7SignedData, Session session) throws PKIException {
        PKCS7SignedData pKCS7SignedData;
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("GetPKCS7From::>>>>>>Running: p7SignedData=" + SADKDebugger.dump(p7SignedData));
        }
        boolean isFailed = false;
        try {
            PKCS7SignedData pkcs7SignedData = new PKCS7SignedData(session);
            pkcs7SignedData.loadBase64(p7SignedData);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("GetPKCS7From::<<<<<<Finished");
            }
            pKCS7SignedData = pkcs7SignedData;
            Object var7_7 = null;
        }
        catch (PKIException e) {
            try {
                isFailed = true;
                LoggerManager.exceptionLogger.error("GetPKCS7From::<<<<<<Failure: p7SignedData=" + SADKDebugger.dump(p7SignedData), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var7_8 = null;
                    if (!isFailed || !LoggerManager.exceptionLogger.isErrorEnabled()) break block7;
                    LoggerManager.exceptionLogger.error("GetPKCS7From::>>>>>>Running: p7SignedData=" + SADKDebugger.dump(p7SignedData));
                }
                throw throwable;
            }
        }
        if (isFailed && LoggerManager.exceptionLogger.isErrorEnabled()) {
            LoggerManager.exceptionLogger.error("GetPKCS7From::>>>>>>Running: p7SignedData=" + SADKDebugger.dump(p7SignedData));
        }
        return pKCS7SignedData;
    }

    private final void GetDataFrom(PKCS7SignedData pkcs7SignedData, boolean readSourceFlag) throws PKIException {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("GetDataFrom::>>>>>>Running");
        }
        this.signCert = pkcs7SignedData.getSignerX509Cert();
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("GetDataFrom::::::::signCert=" + SADKDebugger.dump(this.signCert));
        }
        this.digestAlgorithm = pkcs7SignedData.getDigestAlgorithm();
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("GetDataFrom::::::::digestAlgorithm=" + SADKDebugger.dump(this.digestAlgorithm));
        }
        this.signature = pkcs7SignedData.getSignature();
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("GetDataFrom::::::::signature=" + SADKDebugger.dump(this.signature));
        }
        if (readSourceFlag) {
            this.sourceData = pkcs7SignedData.getSourceData();
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("GetDataFrom::::::::sourceData=" + SADKDebugger.dump(this.sourceData));
            }
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("GetDataFrom::<<<<<<Finished");
        }
    }

    private final void GetDataFrom(PKCS7SignedFile pkcs7SignedFile, String outSourceFilePath) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("GetDataFrom::>>>>>>Running");
        }
        this.signCert = pkcs7SignedFile.getSignerX509Cert();
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("GetDataFrom::::::::signCert=" + SADKDebugger.dump(this.signCert));
        }
        this.digestAlgorithm = pkcs7SignedFile.getDigestAlgorithm();
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("GetDataFrom::::::::digestAlgorithm=" + SADKDebugger.dump(this.digestAlgorithm));
        }
        this.signature = pkcs7SignedFile.getSignature();
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("GetDataFrom::::::::signature=" + SADKDebugger.dump(this.signature));
        }
        if (outSourceFilePath != null) {
            try {
                long fileLength;
                File sourceFilePath = new File(outSourceFilePath);
                if (sourceFilePath.exists() && sourceFilePath.isFile() && (fileLength = sourceFilePath.length()) < 10240L) {
                    this.sourceData = FileHelper.read(sourceFilePath.getAbsolutePath());
                    if (LoggerManager.debugLogger.isDebugEnabled()) {
                        LoggerManager.debugLogger.debug("GetDataFrom::::::::sourceData=" + SADKDebugger.dump(this.sourceData));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("GetDataFrom::<<<<<<Finished");
        }
    }

    final byte[] outputSignResult(byte[] binarySignValue) {
        if (LoggerManager.debugLogger.isDebugEnabled()) {
            LoggerManager.debugLogger.debug("outputSignResult::>>>>>>Running: binarySignValue=" + SADKDebugger.dump(binarySignValue));
        }
        byte[] signValueResult = null;
        if (this.outputBase64SignResult) {
            signValueResult = Base64.encode(binarySignValue);
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("outputSignResult::<<<<<<Finished: base64SignValue=" + SADKDebugger.dumpBase64(signValueResult));
            }
        } else {
            signValueResult = binarySignValue;
            if (LoggerManager.debugLogger.isDebugEnabled()) {
                LoggerManager.debugLogger.debug("outputSignResult::<<<<<<Finished: binarySignValue=" + SADKDebugger.dump(signValueResult));
            }
        }
        return signValueResult;
    }

    final boolean isSM2(String signAlg) {
        boolean sm2Flag = false;
        if (signAlg != null) {
            sm2Flag = signAlg.toUpperCase().indexOf("SM2") >= 0;
        }
        return sm2Flag;
    }

    final boolean isECC(String signAlg) {
        boolean eccFlag = false;
        if (signAlg != null) {
            eccFlag = signAlg.toUpperCase().indexOf("EC") >= 0;
        }
        return eccFlag;
    }

    static {
        Environments.environments();
    }
}

