/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.x509.certificate;

import cfca.sadk.algorithm.common.GMObjectIdentifiers;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.org.bouncycastle.crypto.ExtendedDigest;
import cfca.sadk.org.bouncycastle.crypto.digests.MD5Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA256Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA384Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA512Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum CRLSignType {
    md5WithRSA("md5WithRSAEncryption", PKCSObjectIdentifiers.md5WithRSAEncryption.getId()),
    sha1WithRSA("sha1WithRSAEncryption", PKCSObjectIdentifiers.sha1WithRSAEncryption.getId()),
    sha256WithRSA("sha256WithRSAEncryption", PKCSObjectIdentifiers.sha256WithRSAEncryption.getId()),
    sha384WithRSA("sha384WithRSAEncryption", PKCSObjectIdentifiers.sha384WithRSAEncryption.getId()),
    sha512WithRSA("sha512WithRSAEncryption", PKCSObjectIdentifiers.sha512WithRSAEncryption.getId()),
    sha1WithECDSA("sha1WithECDSAEncryption", PKCSObjectIdentifiers.sha1WithECEncryption.getId()),
    sha256WithECDSA("sha256WithECDSAEncryption", PKCSObjectIdentifiers.sha256WithECEncryption.getId()),
    sha384WithECDSA("sha384WithECDSAEncryption", PKCSObjectIdentifiers.sha384WithECEncryption.getId()),
    sha512WithECDSA("sha512WithECDSAEncryption", PKCSObjectIdentifiers.sha512WithECEncryption.getId()),
    sm3WithSM2("sm3WithSM2Encryption", GMObjectIdentifiers.SM3WithSM2Encryption.getId());

    final String signAlgName;
    final String oid;
    private static final Map<String, CRLSignType> CRL_SIGN_TYPES;

    private CRLSignType(String signAlgName, String oid) {
        this.signAlgName = signAlgName;
        this.oid = oid;
    }

    static final String getSignType(String oid) throws PKIException {
        CRLSignType value = CRL_SIGN_TYPES.get(oid);
        if (value == null) {
            throw new PKIException("CrlFile verify failure when invalid signatureAlgorithm --> " + oid);
        }
        return value.signAlgName;
    }

    static final Digest getDigestEngine(String oid) throws PKIException {
        CRLSignType value = CRL_SIGN_TYPES.get(oid);
        if (value == null) {
            throw new PKIException("CrlFile verify failure when invalid signatureAlgorithm --> " + oid);
        }
        ExtendedDigest engine = null;
        switch (value) {
            case md5WithRSA: {
                engine = new MD5Digest();
                break;
            }
            case sha1WithRSA: 
            case sha1WithECDSA: {
                engine = new SHA1Digest();
                break;
            }
            case sha256WithRSA: 
            case sha256WithECDSA: {
                engine = new SHA256Digest();
                break;
            }
            case sha384WithRSA: 
            case sha384WithECDSA: {
                engine = new SHA384Digest();
                break;
            }
            case sha512WithRSA: 
            case sha512WithECDSA: {
                engine = new SHA512Digest();
                break;
            }
            case sm3WithSM2: {
                engine = new SM3Digest();
                break;
            }
            default: {
                throw new PKIException("CrlFile verify failure when invalid signatureAlgorithm --> " + oid);
            }
        }
        return engine;
    }

    private static final Map<String, CRLSignType> cacheCRLSignTypes() {
        CRLSignType[] values = CRLSignType.values();
        ConcurrentHashMap<String, CRLSignType> mapping = new ConcurrentHashMap<String, CRLSignType>(values.length << 1);
        for (CRLSignType value : values) {
            mapping.put(value.signAlgName, value);
            mapping.put(value.oid, value);
        }
        return mapping;
    }

    static {
        CRL_SIGN_TYPES = CRLSignType.cacheCRLSignTypes();
    }
}

