/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.FipsUtils;
import org.bouncycastle.jsse.provider.ProvSSLEngine;
import org.bouncycastle.jsse.provider.ProvSSLServerSocketFactory;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvSSLSocketFactory;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoProvider;

class ProvSSLContextSpi
extends SSLContextSpi {
    private static final Map<String, Integer> SUPPORTED_CIPHERSUITE_MAP = ProvSSLContextSpi.createSupportedCipherSuiteMap();
    private static final Map<String, Integer> SUPPORTED_CIPHERSUITE_MAP_FIPS = ProvSSLContextSpi.createSupportedCipherSuiteMapFips(SUPPORTED_CIPHERSUITE_MAP);
    private static final Map<String, ProtocolVersion> supportedProtocols = ProvSSLContextSpi.createSupportedProtocols();
    private static final List<String> DEFAULT_CIPHERSUITE_LIST = ProvSSLContextSpi.createDefaultCipherSuiteList(SUPPORTED_CIPHERSUITE_MAP.keySet());
    private static final List<String> DEFAULT_CIPHERSUITE_LIST_FIPS = ProvSSLContextSpi.createDefaultCipherSuiteListFips(DEFAULT_CIPHERSUITE_LIST);
    protected final boolean isInFipsMode;
    protected final TlsCryptoProvider cryptoProvider;
    protected final String[] defaultProtocols;
    protected final Map<String, Integer> supportedCipherSuites;
    protected final List<String> defaultCipherSuites;
    protected boolean initialized = false;
    private TlsCrypto crypto;
    private X509KeyManager km;
    private X509KeyManager encKm;
    private X509TrustManager tm;
    private ProvSSLSessionContext clientSessionContext;
    private ProvSSLSessionContext serverSessionContext;

    private static List<String> createDefaultCipherSuiteList(Set<String> supportedCipherSuiteSet) {
        ArrayList<String> cs = new ArrayList<String>();
        cs.add("TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256");
        cs.add("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");
        cs.add("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256");
        cs.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384");
        cs.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256");
        cs.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA");
        cs.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA");
        cs.add("TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256");
        cs.add("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384");
        cs.add("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        cs.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384");
        cs.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256");
        cs.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA");
        cs.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");
        cs.add("TLS_RSA_WITH_AES_256_GCM_SHA384");
        cs.add("TLS_RSA_WITH_AES_128_GCM_SHA256");
        cs.add("TLS_RSA_WITH_AES_256_CBC_SHA256");
        cs.add("TLS_RSA_WITH_AES_128_CBC_SHA256");
        cs.add("TLS_RSA_WITH_AES_256_CBC_SHA");
        cs.add("TLS_RSA_WITH_AES_128_CBC_SHA");
        cs.add("TLS_ECDHE_WITH_SM4_SM3");
        cs.add("TLS_ECC_WITH_SM4_SM3");
        cs.retainAll(supportedCipherSuiteSet);
        cs.trimToSize();
        return Collections.unmodifiableList(cs);
    }

    private static List<String> createDefaultCipherSuiteListFips(List<String> defaultCipherSuiteList) {
        ArrayList<String> cs = new ArrayList<String>(defaultCipherSuiteList);
        FipsUtils.removeNonFipsCipherSuites(cs);
        cs.trimToSize();
        return Collections.unmodifiableList(cs);
    }

    private static Map<String, Integer> createSupportedCipherSuiteMap() {
        HashMap<String, Integer> cs = new HashMap<String, Integer>(){

            @Override
            public Integer put(String key, Integer value) {
                if (null != super.put(key, value)) {
                    throw new IllegalStateException("Duplicate names in supported-cipher-suites");
                }
                return null;
            }
        };
        cs.put("TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", 19);
        cs.put("TLS_DHE_DSS_WITH_AES_128_CBC_SHA", 50);
        cs.put("TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", 64);
        cs.put("TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", 162);
        cs.put("TLS_DHE_DSS_WITH_AES_256_CBC_SHA", 56);
        cs.put("TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", 106);
        cs.put("TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", 163);
        cs.put("TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", 22);
        cs.put("TLS_DHE_RSA_WITH_AES_128_CBC_SHA", 51);
        cs.put("TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", 103);
        cs.put("TLS_DHE_RSA_WITH_AES_128_CCM", 49310);
        cs.put("TLS_DHE_RSA_WITH_AES_128_CCM_8", 49314);
        cs.put("TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", 158);
        cs.put("TLS_DHE_RSA_WITH_AES_256_CBC_SHA", 57);
        cs.put("TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", 107);
        cs.put("TLS_DHE_RSA_WITH_AES_256_CCM", 49311);
        cs.put("TLS_DHE_RSA_WITH_AES_256_CCM_8", 49315);
        cs.put("TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", 159);
        cs.put("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", 49160);
        cs.put("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", 49161);
        cs.put("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", 49187);
        cs.put("TLS_ECDHE_ECDSA_WITH_AES_128_CCM", 49324);
        cs.put("TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8", 49326);
        cs.put("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", 49195);
        cs.put("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", 49162);
        cs.put("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", 49188);
        cs.put("TLS_ECDHE_ECDSA_WITH_AES_256_CCM", 49325);
        cs.put("TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8", 49327);
        cs.put("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", 49196);
        cs.put("TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", 52393);
        cs.put("TLS_ECDHE_ECDSA_WITH_NULL_SHA", 49158);
        cs.put("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", 49170);
        cs.put("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", 49171);
        cs.put("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", 49191);
        cs.put("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", 49199);
        cs.put("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", 49172);
        cs.put("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", 49192);
        cs.put("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", 49200);
        cs.put("TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", 52392);
        cs.put("TLS_ECDHE_RSA_WITH_NULL_SHA", 49168);
        cs.put("TLS_RSA_WITH_3DES_EDE_CBC_SHA", 10);
        cs.put("TLS_RSA_WITH_AES_128_CBC_SHA", 47);
        cs.put("TLS_RSA_WITH_AES_128_CBC_SHA256", 60);
        cs.put("TLS_RSA_WITH_AES_128_CCM", 49308);
        cs.put("TLS_RSA_WITH_AES_128_CCM_8", 49312);
        cs.put("TLS_RSA_WITH_AES_128_GCM_SHA256", 156);
        cs.put("TLS_RSA_WITH_AES_256_CBC_SHA", 53);
        cs.put("TLS_RSA_WITH_AES_256_CBC_SHA256", 61);
        cs.put("TLS_RSA_WITH_AES_256_CCM", 49309);
        cs.put("TLS_RSA_WITH_AES_256_CCM_8", 49313);
        cs.put("TLS_RSA_WITH_AES_256_GCM_SHA384", 157);
        cs.put("TLS_RSA_WITH_NULL_SHA", 2);
        cs.put("TLS_RSA_WITH_NULL_SHA256", 59);
        cs.put("TLS_ECC_WITH_SM4_SM3", 57363);
        cs.put("TLS_ECDHE_WITH_SM4_SM3", 57361);
        return Collections.unmodifiableMap(cs);
    }

    private static Map<String, Integer> createSupportedCipherSuiteMapFips(Map<String, Integer> supportedCipherSuites) {
        HashMap<String, Integer> cs = new HashMap<String, Integer>(supportedCipherSuites);
        FipsUtils.removeNonFipsCipherSuites(cs.keySet());
        return Collections.unmodifiableMap(cs);
    }

    private static Map<String, ProtocolVersion> createSupportedProtocols() {
        HashMap<String, ProtocolVersion> ps = new HashMap<String, ProtocolVersion>();
        ps.put("TLSv1", ProtocolVersion.TLSv10);
        ps.put("GMTLSv1.1", ProtocolVersion.GMTLSv11);
        ps.put("TLSv1.1", ProtocolVersion.TLSv11);
        ps.put("TLSv1.2", ProtocolVersion.TLSv12);
        return Collections.unmodifiableMap(ps);
    }

    ProvSSLContextSpi(boolean isInFipsMode, TlsCryptoProvider cryptoProvider, String[] defaultProtocols) {
        this.isInFipsMode = isInFipsMode;
        this.cryptoProvider = cryptoProvider;
        this.defaultProtocols = defaultProtocols;
        this.supportedCipherSuites = isInFipsMode ? SUPPORTED_CIPHERSUITE_MAP_FIPS : SUPPORTED_CIPHERSUITE_MAP;
        this.defaultCipherSuites = isInFipsMode ? DEFAULT_CIPHERSUITE_LIST_FIPS : DEFAULT_CIPHERSUITE_LIST;
    }

    int[] convertCipherSuites(String[] suites) {
        int[] result = new int[suites.length];
        for (int i = 0; i < suites.length; ++i) {
            result[i] = this.supportedCipherSuites.get(suites[i]);
        }
        return result;
    }

    ProvSSLSessionContext createSSLSessionContext() {
        return new ProvSSLSessionContext(this, this.crypto);
    }

    String getCipherSuiteString(int suite) {
        if (TlsUtils.isValidUint16(suite)) {
            for (Map.Entry<String, Integer> entry : this.supportedCipherSuites.entrySet()) {
                if (entry.getValue() != suite) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    String[] getDefaultCipherSuites() {
        return this.defaultCipherSuites.toArray(new String[this.defaultCipherSuites.size()]);
    }

    String[] getDefaultProtocols() {
        return this.defaultProtocols;
    }

    ProtocolVersion getMaximumVersion(String[] protocols) {
        ProtocolVersion max = null;
        if (protocols != null) {
            for (String protocol : protocols) {
                ProtocolVersion v;
                if (protocol == null || (v = supportedProtocols.get(protocol)) == null || max != null && !v.isLaterVersionOf(max)) continue;
                max = v;
            }
        }
        return max;
    }

    ProtocolVersion getMinimumVersion(String[] protocols) {
        ProtocolVersion min = null;
        if (protocols != null) {
            for (String protocol : protocols) {
                ProtocolVersion v;
                if (protocol == null || (v = supportedProtocols.get(protocol)) == null || min != null && !min.isLaterVersionOf(v)) continue;
                min = v;
            }
        }
        return min;
    }

    String getProtocolString(ProtocolVersion v) {
        if (v != null) {
            for (Map.Entry<String, ProtocolVersion> entry : supportedProtocols.entrySet()) {
                if (!v.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    String[] getSupportedCipherSuites() {
        return this.supportedCipherSuites.keySet().toArray(new String[this.supportedCipherSuites.size()]);
    }

    String[] getSupportedProtocols() {
        return supportedProtocols.keySet().toArray(new String[supportedProtocols.size()]);
    }

    boolean isFips() {
        return this.isInFipsMode;
    }

    boolean isSupportedCipherSuites(String[] suites) {
        if (suites == null) {
            return false;
        }
        for (String suite : suites) {
            if (suite != null && this.supportedCipherSuites.containsKey(suite)) continue;
            return false;
        }
        return true;
    }

    boolean isSupportedProtocols(String[] protocols) {
        if (protocols == null) {
            return false;
        }
        for (String protocol : protocols) {
            if (protocol != null && supportedProtocols.containsKey(protocol)) continue;
            return false;
        }
        return true;
    }

    void validateNegotiatedCipherSuite(int cipherSuite) {
        String cs = this.getCipherSuiteString(cipherSuite);
        if (cs == null || !this.supportedCipherSuites.containsKey(cs) || this.isInFipsMode && !FipsUtils.isFipsCipherSuite(cs)) {
            throw new IllegalStateException("SSL connection negotiated unsupported ciphersuite: " + cipherSuite);
        }
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("SSLContext has not been initialized.");
        }
    }

    @Override
    protected synchronized SSLEngine engineCreateSSLEngine() {
        this.checkInitialized();
        return new ProvSSLEngine(this, this.createContextData());
    }

    @Override
    protected synchronized SSLEngine engineCreateSSLEngine(String host, int port) {
        this.checkInitialized();
        return new ProvSSLEngine(this, this.createContextData(), host, port);
    }

    @Override
    protected synchronized SSLSessionContext engineGetClientSessionContext() {
        return this.clientSessionContext;
    }

    @Override
    protected SSLParameters engineGetDefaultSSLParameters() {
        SSLParameters r = new SSLParameters();
        r.setCipherSuites(this.getDefaultCipherSuites());
        r.setProtocols(this.getDefaultProtocols());
        return r;
    }

    @Override
    protected synchronized SSLSessionContext engineGetServerSessionContext() {
        return this.serverSessionContext;
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        this.checkInitialized();
        return new ProvSSLServerSocketFactory(this);
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        this.checkInitialized();
        return new ProvSSLSocketFactory(this);
    }

    @Override
    protected SSLParameters engineGetSupportedSSLParameters() {
        SSLParameters r = new SSLParameters();
        r.setCipherSuites(this.getSupportedCipherSuites());
        r.setProtocols(this.getSupportedProtocols());
        return r;
    }

    @Override
    protected synchronized void engineInit(KeyManager[] kms, TrustManager[] tms, SecureRandom sr) throws KeyManagementException {
        this.initialized = false;
        this.crypto = this.cryptoProvider.create(sr);
        this.km = this.selectKeyManager(kms);
        this.encKm = this.selectEncKeyManager(kms);
        this.tm = this.selectTrustManager(tms);
        this.clientSessionContext = this.createSSLSessionContext();
        this.serverSessionContext = this.createSSLSessionContext();
        this.initialized = true;
    }

    protected ContextData createContextData() {
        return new ContextData(this.crypto, this.km, this.encKm, this.tm, this.clientSessionContext, this.serverSessionContext);
    }

    protected X509KeyManager findX509KeyManager(KeyManager[] kms) {
        if (kms != null) {
            for (KeyManager km : kms) {
                if (!(km instanceof X509KeyManager)) continue;
                return (X509KeyManager)km;
            }
        }
        return null;
    }

    protected X509KeyManager findX509EncKeyManager(KeyManager[] kms) {
        boolean isFirstPass = false;
        if (kms != null) {
            for (KeyManager km : kms) {
                if (!(km instanceof X509KeyManager)) continue;
                if (isFirstPass) {
                    return (X509KeyManager)km;
                }
                isFirstPass = true;
            }
        }
        return null;
    }

    protected X509TrustManager findX509TrustManager(TrustManager[] tms) {
        if (tms != null) {
            for (TrustManager tm : tms) {
                if (!(tm instanceof X509TrustManager)) continue;
                return (X509TrustManager)tm;
            }
        }
        return null;
    }

    protected X509KeyManager selectKeyManager(KeyManager[] kms) throws KeyManagementException {
        if (kms == null) {
            try {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(null, null);
                kms = kmf.getKeyManagers();
            }
            catch (GeneralSecurityException e) {
                throw new KeyManagementException(e);
            }
        }
        return this.findX509KeyManager(kms);
    }

    protected X509KeyManager selectEncKeyManager(KeyManager[] kms) throws KeyManagementException {
        if (kms == null) {
            try {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(null, null);
                kms = kmf.getKeyManagers();
            }
            catch (GeneralSecurityException e) {
                throw new KeyManagementException(e);
            }
        }
        return this.findX509EncKeyManager(kms);
    }

    protected X509TrustManager selectTrustManager(TrustManager[] tms) throws KeyManagementException {
        if (tms == null) {
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init((KeyStore)null);
                tms = tmf.getTrustManagers();
            }
            catch (GeneralSecurityException e) {
                throw new KeyManagementException(e);
            }
        }
        return this.findX509TrustManager(tms);
    }
}

