/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.net.ssl.SSLParameters;
import org.bouncycastle.jsse.provider.JsseUtils_8;
import org.bouncycastle.jsse.provider.ProvSSLParameters;

abstract class SSLParametersUtil {
    private static final Method getAlgorithmConstraints;
    private static final Method setAlgorithmConstraints;
    private static final Method getEndpointIdentificationAlgorithm;
    private static final Method setEndpointIdentificationAlgorithm;
    private static final Method getServerNames;
    private static final Method setServerNames;
    private static final Method getUseCipherSuitesOrder;
    private static final Method setUseCipherSuitesOrder;

    SSLParametersUtil() {
    }

    private static Method findMethod(Method[] methods, String name) {
        if (methods != null) {
            for (Method m : methods) {
                if (!m.getName().equals(name)) continue;
                return m;
            }
        }
        return null;
    }

    private static Class<?> getClassPrivileged(final String className) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    ClassLoader loader = SSLParametersUtil.class.getClassLoader();
                    if (loader != null) {
                        return loader.loadClass(className);
                    }
                    return Class.forName(className);
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    private static Method[] getMethodsPrivileged(final Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                try {
                    return clazz.getMethods();
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    private static Object invokeGetterPrivileged(final Object obj, final Method method) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return method.invoke(obj, new Object[0]);
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    private static void invokeSetterPrivileged(final Object obj, final Method method, final Object arg) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    method.invoke(obj, arg);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    static SSLParameters toSSLParameters(ProvSSLParameters provSslParameters) {
        SSLParameters r = new SSLParameters();
        r.setCipherSuites(provSslParameters.getCipherSuites());
        r.setProtocols(provSslParameters.getProtocols());
        if (setAlgorithmConstraints != null) {
            SSLParametersUtil.invokeSetterPrivileged(r, setAlgorithmConstraints, provSslParameters.getAlgorithmConstraints());
        }
        if (setEndpointIdentificationAlgorithm != null) {
            SSLParametersUtil.invokeSetterPrivileged(r, setEndpointIdentificationAlgorithm, provSslParameters.getEndpointIdentificationAlgorithm());
        }
        if (setServerNames != null) {
            SSLParametersUtil.invokeSetterPrivileged(r, setServerNames, JsseUtils_8.exportSNIServerNames(provSslParameters.getServerNames()));
        }
        if (setUseCipherSuitesOrder != null) {
            SSLParametersUtil.invokeSetterPrivileged(r, setUseCipherSuitesOrder, provSslParameters.getUseCipherSuitesOrder());
        }
        if (provSslParameters.getNeedClientAuth()) {
            r.setNeedClientAuth(true);
        } else if (provSslParameters.getWantClientAuth()) {
            r.setWantClientAuth(true);
        } else {
            r.setWantClientAuth(false);
        }
        return r;
    }

    static ProvSSLParameters toProvSSLParameters(SSLParameters sslParameters) {
        ProvSSLParameters r = new ProvSSLParameters();
        r.setCipherSuites(sslParameters.getCipherSuites());
        r.setProtocols(sslParameters.getProtocols());
        if (getAlgorithmConstraints != null) {
            r.setAlgorithmConstraints(SSLParametersUtil.invokeGetterPrivileged(sslParameters, getAlgorithmConstraints));
        }
        if (getEndpointIdentificationAlgorithm != null) {
            r.setEndpointIdentificationAlgorithm((String)SSLParametersUtil.invokeGetterPrivileged(sslParameters, getEndpointIdentificationAlgorithm));
        }
        if (getServerNames != null) {
            r.setServerNames(JsseUtils_8.importSNIServerNames(SSLParametersUtil.invokeGetterPrivileged(sslParameters, getServerNames)));
        }
        if (getUseCipherSuitesOrder != null) {
            r.setUseCipherSuitesOrder((Boolean)SSLParametersUtil.invokeGetterPrivileged(sslParameters, getUseCipherSuitesOrder));
        }
        if (sslParameters.getNeedClientAuth()) {
            r.setNeedClientAuth(true);
        } else if (sslParameters.getWantClientAuth()) {
            r.setWantClientAuth(true);
        } else {
            r.setWantClientAuth(false);
        }
        return r;
    }

    static {
        Class<?> sslParametersClazz = SSLParametersUtil.getClassPrivileged("javax.net.ssl.SSLParameters");
        Method[] methods = SSLParametersUtil.getMethodsPrivileged(sslParametersClazz);
        getAlgorithmConstraints = SSLParametersUtil.findMethod(methods, "getAlgorithmConstraints");
        setAlgorithmConstraints = SSLParametersUtil.findMethod(methods, "setAlgorithmConstraints");
        getEndpointIdentificationAlgorithm = SSLParametersUtil.findMethod(methods, "getEndpointIdentificationAlgorithm");
        setEndpointIdentificationAlgorithm = SSLParametersUtil.findMethod(methods, "setEndpointIdentificationAlgorithm");
        getServerNames = SSLParametersUtil.findMethod(methods, "getServerNames");
        setServerNames = SSLParametersUtil.findMethod(methods, "setServerNames");
        getUseCipherSuitesOrder = SSLParametersUtil.findMethod(methods, "getUseCipherSuitesOrder");
        setUseCipherSuitesOrder = SSLParametersUtil.findMethod(methods, "setUseCipherSuitesOrder");
    }
}

