/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import org.bouncycastle.jsse.provider.FipsUtils;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.crypto.DHStandardGroups;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.util.Arrays;

abstract class SupportedGroups {
    private static Logger LOG = Logger.getLogger(SupportedGroups.class.getName());
    private static final String PROPERTY_NAME = "jdk.tls.namedGroups";
    private static final boolean provDisableChar2 = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.ec.disableChar2", false);
    private static final int[] provJdkTlsNamedGroups = SupportedGroups.getJdkTlsNamedGroups(provDisableChar2);
    private static final int[] defaultClientNamedGroups = new int[]{23, 0, 24, 25, 256, 257, 258};

    SupportedGroups() {
    }

    private static int getDefaultCurve(int minimumCurveBits) {
        return minimumCurveBits <= 256 ? 23 : (minimumCurveBits <= 384 ? 24 : (minimumCurveBits <= 521 ? 25 : (!provDisableChar2 && minimumCurveBits <= 571 ? 14 : -1)));
    }

    private static TlsDHConfig getDefaultDHConfig(int minimumFiniteFieldBits) {
        return minimumFiniteFieldBits <= 1024 ? new TlsDHConfig(DHStandardGroups.rfc2409_1024) : (minimumFiniteFieldBits <= 1536 ? new TlsDHConfig(DHStandardGroups.rfc3526_1536) : TlsDHUtils.createNamedDHConfig(SupportedGroups.getDefaultFiniteField(minimumFiniteFieldBits)));
    }

    private static int getDefaultFiniteField(int minimumFiniteFieldBits) {
        return minimumFiniteFieldBits <= 2048 ? 256 : (minimumFiniteFieldBits <= 3072 ? 257 : (minimumFiniteFieldBits <= 4096 ? 258 : (minimumFiniteFieldBits <= 6144 ? 259 : (minimumFiniteFieldBits <= 8192 ? 260 : -1))));
    }

    private static int[] getJdkTlsNamedGroups(boolean provDisableChar2) {
        String prop = PropertyUtils.getStringSystemProperty(PROPERTY_NAME);
        if (prop == null) {
            return null;
        }
        String[] entries = JsseUtils.stripQuotes(prop.trim()).toLowerCase(Locale.ENGLISH).split(",");
        int[] result = new int[entries.length];
        int count = 0;
        for (String entry : entries) {
            String name = entry.trim();
            if (name.length() < 1) continue;
            int namedGroup = NamedGroup.getByName(name.trim());
            if (namedGroup < 0) {
                LOG.warning("'jdk.tls.namedGroups' contains unrecognised NamedGroup: " + name);
                continue;
            }
            if (provDisableChar2 && NamedGroup.isChar2Curve(namedGroup)) {
                LOG.warning("'jdk.tls.namedGroups' contains disabled characteristic-2 curve: " + name);
                continue;
            }
            result[count++] = namedGroup;
        }
        if (count < result.length) {
            result = Arrays.copyOf((int[])result, (int)count);
        }
        if (result.length < 1) {
            LOG.severe("'jdk.tls.namedGroups' contained no usable NamedGroup values");
        }
        return result;
    }

    static Vector getClientSupportedGroups(boolean isFips, boolean offeringDH, boolean offeringEC) {
        int[] namedGroups = provJdkTlsNamedGroups != null ? provJdkTlsNamedGroups : defaultClientNamedGroups;
        Vector<Integer> result = new Vector<Integer>();
        for (int namedGroup : namedGroups) {
            if ((!offeringDH || !NamedGroup.refersToASpecificFiniteField(namedGroup)) && (!offeringEC || !NamedGroup.refersToASpecificCurve(namedGroup)) || isFips && !FipsUtils.isFipsNamedGroup(namedGroup)) continue;
            result.addElement(namedGroup);
        }
        return result;
    }

    static int getServerDefaultCurve(boolean isFips, int minimumCurveBits) {
        int[] serverSupportedGroups = provJdkTlsNamedGroups;
        if (serverSupportedGroups == null) {
            if (isFips) {
                return FipsUtils.getFipsDefaultCurve(minimumCurveBits);
            }
            return SupportedGroups.getDefaultCurve(minimumCurveBits);
        }
        for (int namedGroup : serverSupportedGroups) {
            if (NamedGroup.getCurveBits(namedGroup) < minimumCurveBits || isFips && !FipsUtils.isFipsNamedGroup(namedGroup)) continue;
            return namedGroup;
        }
        return -1;
    }

    static TlsDHConfig getServerDefaultDHConfig(boolean isFips, int minimumFiniteFieldBits) {
        int[] serverSupportedGroups = provJdkTlsNamedGroups;
        if (serverSupportedGroups == null) {
            if (isFips) {
                return TlsDHUtils.createNamedDHConfig(FipsUtils.getFipsDefaultFiniteField(minimumFiniteFieldBits));
            }
            return SupportedGroups.getDefaultDHConfig(minimumFiniteFieldBits);
        }
        for (int namedGroup : serverSupportedGroups) {
            if (NamedGroup.getFiniteFieldBits(namedGroup) < minimumFiniteFieldBits || isFips && !FipsUtils.isFipsNamedGroup(namedGroup)) continue;
            return new TlsDHConfig(namedGroup);
        }
        return null;
    }

    static int getServerMaximumNegotiableCurveBits(boolean isFips, int[] clientSupportedGroups) {
        int[] serverSupportedGroups = provJdkTlsNamedGroups;
        if (clientSupportedGroups == null) {
            if (serverSupportedGroups == null) {
                return isFips ? FipsUtils.getFipsMaximumCurveBits() : (provDisableChar2 ? NamedGroup.getMaximumPrimeCurveBits() : NamedGroup.getMaximumCurveBits());
            }
            int maxBits = 0;
            for (int i = 0; i < serverSupportedGroups.length; ++i) {
                int namedGroup = serverSupportedGroups[i];
                if (isFips && !FipsUtils.isFipsNamedGroup(namedGroup)) continue;
                maxBits = Math.max(maxBits, NamedGroup.getCurveBits(namedGroup));
            }
            return maxBits;
        }
        int maxBits = 0;
        for (int i = 0; i < clientSupportedGroups.length; ++i) {
            int namedGroup = clientSupportedGroups[i];
            if (provDisableChar2 && NamedGroup.isChar2Curve(namedGroup) || serverSupportedGroups != null && !Arrays.contains((int[])serverSupportedGroups, (int)namedGroup) || isFips && !FipsUtils.isFipsNamedGroup(namedGroup)) continue;
            maxBits = Math.max(maxBits, NamedGroup.getCurveBits(namedGroup));
        }
        return maxBits;
    }

    static int getServerMaximumNegotiableFiniteFieldBits(boolean isFips, int[] clientSupportedGroups) {
        int[] serverSupportedGroups = provJdkTlsNamedGroups;
        if (clientSupportedGroups == null) {
            if (serverSupportedGroups == null) {
                return isFips ? FipsUtils.getFipsMaximumFiniteFieldBits() : NamedGroup.getMaximumFiniteFieldBits();
            }
            int maxBits = 0;
            for (int i = 0; i < serverSupportedGroups.length; ++i) {
                int namedGroup = serverSupportedGroups[i];
                if (isFips && !FipsUtils.isFipsNamedGroup(namedGroup)) continue;
                maxBits = Math.max(maxBits, NamedGroup.getFiniteFieldBits(namedGroup));
            }
            return maxBits;
        }
        int maxBits = 0;
        for (int i = 0; i < clientSupportedGroups.length; ++i) {
            int namedGroup = clientSupportedGroups[i];
            if (serverSupportedGroups != null && !Arrays.contains((int[])serverSupportedGroups, (int)namedGroup) || isFips && !FipsUtils.isFipsNamedGroup(namedGroup)) continue;
            maxBits = Math.max(maxBits, NamedGroup.getFiniteFieldBits(namedGroup));
        }
        return maxBits;
    }

    static int getServerSelectedCurve(boolean isFips, int minimumCurveBits, int[] clientSupportedGroups) {
        int[] serverSupportedGroups = provJdkTlsNamedGroups;
        for (int i = 0; i < clientSupportedGroups.length; ++i) {
            int namedGroup = clientSupportedGroups[i];
            if (provDisableChar2 && NamedGroup.isChar2Curve(namedGroup) || serverSupportedGroups != null && !Arrays.contains((int[])serverSupportedGroups, (int)namedGroup) || NamedGroup.getCurveBits(namedGroup) < minimumCurveBits || isFips && !FipsUtils.isFipsNamedGroup(namedGroup)) continue;
            return namedGroup;
        }
        return -1;
    }

    static int getServerSelectedFiniteField(boolean isFips, int minimumFiniteFieldBits, int[] clientSupportedGroups) {
        int[] serverSupportedGroups = provJdkTlsNamedGroups;
        for (int i = 0; i < clientSupportedGroups.length; ++i) {
            int namedGroup = clientSupportedGroups[i];
            if (serverSupportedGroups != null && !Arrays.contains((int[])serverSupportedGroups, (int)namedGroup) || NamedGroup.getFiniteFieldBits(namedGroup) < minimumFiniteFieldBits || isFips && !FipsUtils.isFipsNamedGroup(namedGroup)) continue;
            return namedGroup;
        }
        return -1;
    }
}

