/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider.test;

import java.security.AccessController;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.bouncycastle.jsse.provider.test.CipherSuitesTestCase;
import org.bouncycastle.jsse.provider.test.CipherSuitesTestConfig;
import org.bouncycastle.jsse.provider.test.TestUtils;

public class CipherSuitesTestSuite
extends TestSuite {
    static final boolean hasSslParameters;

    private static Class loadClass(Class sourceClass, final String className) {
        try {
            ClassLoader loader = sourceClass.getClassLoader();
            if (loader != null) {
                return loader.loadClass(className);
            }
            return AccessController.doPrivileged(new PrivilegedAction<Class>(){

                @Override
                public Class run() {
                    try {
                        return Class.forName(className);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public CipherSuitesTestSuite() {
        super("CipherSuites");
    }

    public static Test suite() throws Exception {
        Object[] cipherSuites;
        String javaVersion = System.getProperty("java.version");
        boolean oldJDK = javaVersion.startsWith("1.5") || javaVersion.startsWith("1.6");
        BouncyCastleProvider bc = new BouncyCastleProvider();
        BouncyCastleJsseProvider bcjsse = oldJDK ? new BouncyCastleJsseProvider((Provider)bc) : new BouncyCastleJsseProvider();
        Security.removeProvider("BC");
        Security.insertProviderAt((Provider)bc, 1);
        Security.removeProvider("BCJSSE");
        Security.insertProviderAt(bcjsse, 2);
        CipherSuitesTestSuite testSuite = new CipherSuitesTestSuite();
        char[] serverPassword = "serverPassword".toCharArray();
        KeyPair caKeyPairDSA = TestUtils.generateDSAKeyPair();
        KeyPair caKeyPairEC = TestUtils.generateECKeyPair();
        KeyPair caKeyPairRSA = TestUtils.generateRSAKeyPair();
        X509Certificate caCertDSA = TestUtils.generateRootCert(caKeyPairDSA);
        X509Certificate caCertEC = TestUtils.generateRootCert(caKeyPairEC);
        X509Certificate caCertRSA = TestUtils.generateRootCert(caKeyPairRSA);
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        ks.setKeyEntry("serverDSA", caKeyPairDSA.getPrivate(), serverPassword, new X509Certificate[]{caCertDSA});
        ks.setKeyEntry("serverEC", caKeyPairEC.getPrivate(), serverPassword, new X509Certificate[]{caCertEC});
        ks.setKeyEntry("serverRSA", caKeyPairRSA.getPrivate(), serverPassword, new X509Certificate[]{caCertRSA});
        KeyStore ts = KeyStore.getInstance("JKS");
        ts.load(null, null);
        ts.setCertificateEntry("caDSA", caCertDSA);
        ts.setCertificateEntry("caEC", caCertEC);
        ts.setCertificateEntry("caRSA", caCertRSA);
        SSLContext sslContext = SSLContext.getInstance("TLS", "BCJSSE");
        if (hasSslParameters) {
            cipherSuites = sslContext.getSupportedSSLParameters().getCipherSuites();
        } else {
            TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
            trustMgrFact.init(ts);
            sslContext.init(null, trustMgrFact.getTrustManagers(), SecureRandom.getInstance("DEFAULT", "BC"));
            cipherSuites = sslContext.getSocketFactory().getSupportedCipherSuites();
        }
        Arrays.sort(cipherSuites);
        for (Object cipherSuite : cipherSuites) {
            CipherSuitesTestConfig config = new CipherSuitesTestConfig();
            config.cipherSuite = cipherSuite;
            config.clientTrustStore = ts;
            config.serverKeyStore = ks;
            config.serverPassword = serverPassword;
            testSuite.addTest((Test)new CipherSuitesTestCase(config));
        }
        return testSuite;
    }

    static {
        Class clazz = null;
        try {
            clazz = CipherSuitesTestSuite.loadClass(CipherSuitesTestSuite.class, "javax.net.ssl.SSLParameters");
        }
        catch (Exception e) {
            clazz = null;
        }
        hasSslParameters = clazz != null;
    }
}

