/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.CertificateStatusRequest;
import org.bouncycastle.tls.HeartbeatExtension;
import org.bouncycastle.tls.ServerNameList;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.TrustedAuthority;
import org.bouncycastle.util.Integers;

public class TlsExtensionsUtils {
    public static final Integer EXT_client_certificate_type = Integers.valueOf((int)19);
    public static final Integer EXT_client_certificate_url = Integers.valueOf((int)2);
    public static final Integer EXT_encrypt_then_mac = Integers.valueOf((int)22);
    public static final Integer EXT_extended_master_secret = Integers.valueOf((int)23);
    public static final Integer EXT_heartbeat = Integers.valueOf((int)15);
    public static final Integer EXT_max_fragment_length = Integers.valueOf((int)1);
    public static final Integer EXT_padding = Integers.valueOf((int)21);
    public static final Integer EXT_server_certificate_type = Integers.valueOf((int)20);
    public static final Integer EXT_server_name = Integers.valueOf((int)0);
    public static final Integer EXT_status_request = Integers.valueOf((int)5);
    public static final Integer EXT_supported_groups = Integers.valueOf((int)10);
    public static final Integer EXT_truncated_hmac = Integers.valueOf((int)4);
    public static final Integer EXT_trusted_ca_keys = Integers.valueOf((int)3);

    public static Hashtable ensureExtensionsInitialised(Hashtable extensions) {
        return extensions == null ? new Hashtable() : extensions;
    }

    public static void addClientCertificateTypeExtensionClient(Hashtable extensions, short[] certificateTypes) throws IOException {
        extensions.put(EXT_client_certificate_type, TlsExtensionsUtils.createCertificateTypeExtensionClient(certificateTypes));
    }

    public static void addClientCertificateTypeExtensionServer(Hashtable extensions, short certificateType) throws IOException {
        extensions.put(EXT_client_certificate_type, TlsExtensionsUtils.createCertificateTypeExtensionServer(certificateType));
    }

    public static void addClientCertificateURLExtension(Hashtable extensions) {
        extensions.put(EXT_client_certificate_url, TlsExtensionsUtils.createClientCertificateURLExtension());
    }

    public static void addEncryptThenMACExtension(Hashtable extensions) {
        extensions.put(EXT_encrypt_then_mac, TlsExtensionsUtils.createEncryptThenMACExtension());
    }

    public static void addExtendedMasterSecretExtension(Hashtable extensions) {
        extensions.put(EXT_extended_master_secret, TlsExtensionsUtils.createExtendedMasterSecretExtension());
    }

    public static void addHeartbeatExtension(Hashtable extensions, HeartbeatExtension heartbeatExtension) throws IOException {
        extensions.put(EXT_heartbeat, TlsExtensionsUtils.createHeartbeatExtension(heartbeatExtension));
    }

    public static void addMaxFragmentLengthExtension(Hashtable extensions, short maxFragmentLength) throws IOException {
        extensions.put(EXT_max_fragment_length, TlsExtensionsUtils.createMaxFragmentLengthExtension(maxFragmentLength));
    }

    public static void addPaddingExtension(Hashtable extensions, int dataLength) throws IOException {
        extensions.put(EXT_padding, TlsExtensionsUtils.createPaddingExtension(dataLength));
    }

    public static void addServerCertificateTypeExtensionClient(Hashtable extensions, short[] certificateTypes) throws IOException {
        extensions.put(EXT_server_certificate_type, TlsExtensionsUtils.createCertificateTypeExtensionClient(certificateTypes));
    }

    public static void addServerCertificateTypeExtensionServer(Hashtable extensions, short certificateType) throws IOException {
        extensions.put(EXT_server_certificate_type, TlsExtensionsUtils.createCertificateTypeExtensionServer(certificateType));
    }

    public static void addServerNameExtension(Hashtable extensions, ServerNameList serverNameList) throws IOException {
        extensions.put(EXT_server_name, TlsExtensionsUtils.createServerNameExtension(serverNameList));
    }

    public static void addStatusRequestExtension(Hashtable extensions, CertificateStatusRequest statusRequest) throws IOException {
        extensions.put(EXT_status_request, TlsExtensionsUtils.createStatusRequestExtension(statusRequest));
    }

    public static void addSupportedGroupsExtension(Hashtable extensions, Vector namedGroups) throws IOException {
        extensions.put(EXT_supported_groups, TlsExtensionsUtils.createSupportedGroupsExtension(namedGroups));
    }

    public static void addTruncatedHMacExtension(Hashtable extensions) {
        extensions.put(EXT_truncated_hmac, TlsExtensionsUtils.createTruncatedHMacExtension());
    }

    public static void addTrustedCAKeysExtensionClient(Hashtable extensions, Vector trustedAuthoritiesList) throws IOException {
        extensions.put(EXT_trusted_ca_keys, TlsExtensionsUtils.createTrustedCAKeysExtensionClient(trustedAuthoritiesList));
    }

    public static void addTrustedCAKeysExtensionServer(Hashtable extensions) {
        extensions.put(EXT_trusted_ca_keys, TlsExtensionsUtils.createTrustedCAKeysExtensionServer());
    }

    public static short[] getClientCertificateTypeExtensionClient(Hashtable extensions) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_client_certificate_type);
        return extensionData == null ? null : TlsExtensionsUtils.readCertificateTypeExtensionClient(extensionData);
    }

    public static short getClientCertificateTypeExtensionServer(Hashtable extensions) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_client_certificate_type);
        return extensionData == null ? (short)-1 : (short)TlsExtensionsUtils.readCertificateTypeExtensionServer(extensionData);
    }

    public static HeartbeatExtension getHeartbeatExtension(Hashtable extensions) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_heartbeat);
        return extensionData == null ? null : TlsExtensionsUtils.readHeartbeatExtension(extensionData);
    }

    public static short getMaxFragmentLengthExtension(Hashtable extensions) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_max_fragment_length);
        return extensionData == null ? (short)-1 : (short)TlsExtensionsUtils.readMaxFragmentLengthExtension(extensionData);
    }

    public static int getPaddingExtension(Hashtable extensions) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_padding);
        return extensionData == null ? -1 : TlsExtensionsUtils.readPaddingExtension(extensionData);
    }

    public static short[] getServerCertificateTypeExtensionClient(Hashtable extensions) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_server_certificate_type);
        return extensionData == null ? null : TlsExtensionsUtils.readCertificateTypeExtensionClient(extensionData);
    }

    public static short getServerCertificateTypeExtensionServer(Hashtable extensions) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_server_certificate_type);
        return extensionData == null ? (short)-1 : (short)TlsExtensionsUtils.readCertificateTypeExtensionServer(extensionData);
    }

    public static ServerNameList getServerNameExtension(Hashtable extensions) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_server_name);
        return extensionData == null ? null : TlsExtensionsUtils.readServerNameExtension(extensionData);
    }

    public static CertificateStatusRequest getStatusRequestExtension(Hashtable extensions) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_status_request);
        return extensionData == null ? null : TlsExtensionsUtils.readStatusRequestExtension(extensionData);
    }

    public static int[] getSupportedGroupsExtension(Hashtable extensions) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_supported_groups);
        return extensionData == null ? null : TlsExtensionsUtils.readSupportedGroupsExtension(extensionData);
    }

    public static Vector getTrustedCAKeysExtensionClient(Hashtable extensions) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_trusted_ca_keys);
        return extensionData == null ? null : TlsExtensionsUtils.readTrustedCAKeysExtensionClient(extensionData);
    }

    public static boolean hasClientCertificateURLExtension(Hashtable extensions) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_client_certificate_url);
        return extensionData == null ? false : TlsExtensionsUtils.readClientCertificateURLExtension(extensionData);
    }

    public static boolean hasEncryptThenMACExtension(Hashtable extensions) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_encrypt_then_mac);
        return extensionData == null ? false : TlsExtensionsUtils.readEncryptThenMACExtension(extensionData);
    }

    public static boolean hasExtendedMasterSecretExtension(Hashtable extensions) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_extended_master_secret);
        return extensionData == null ? false : TlsExtensionsUtils.readExtendedMasterSecretExtension(extensionData);
    }

    public static boolean hasTruncatedHMacExtension(Hashtable extensions) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_truncated_hmac);
        return extensionData == null ? false : TlsExtensionsUtils.readTruncatedHMacExtension(extensionData);
    }

    public static boolean hasTrustedCAKeysExtensionServer(Hashtable extensions) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_trusted_ca_keys);
        return extensionData == null ? false : TlsExtensionsUtils.readTrustedCAKeysExtensionServer(extensionData);
    }

    public static byte[] createCertificateTypeExtensionClient(short[] certificateTypes) throws IOException {
        if (certificateTypes == null || certificateTypes.length < 1 || certificateTypes.length > 255) {
            throw new TlsFatalAlert(80);
        }
        return TlsUtils.encodeUint8ArrayWithUint8Length(certificateTypes);
    }

    public static byte[] createCertificateTypeExtensionServer(short certificateType) throws IOException {
        return TlsUtils.encodeUint8(certificateType);
    }

    public static byte[] createClientCertificateURLExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createEmptyExtensionData() {
        return TlsUtils.EMPTY_BYTES;
    }

    public static byte[] createEncryptThenMACExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createExtendedMasterSecretExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createHeartbeatExtension(HeartbeatExtension heartbeatExtension) throws IOException {
        if (heartbeatExtension == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        heartbeatExtension.encode(buf);
        return buf.toByteArray();
    }

    public static byte[] createMaxFragmentLengthExtension(short maxFragmentLength) throws IOException {
        return TlsUtils.encodeUint8(maxFragmentLength);
    }

    public static byte[] createPaddingExtension(int dataLength) throws IOException {
        TlsUtils.checkUint16(dataLength);
        return new byte[dataLength];
    }

    public static byte[] createServerNameExtension(ServerNameList serverNameList) throws IOException {
        if (serverNameList == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        serverNameList.encode(buf);
        return buf.toByteArray();
    }

    public static byte[] createStatusRequestExtension(CertificateStatusRequest statusRequest) throws IOException {
        if (statusRequest == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        statusRequest.encode(buf);
        return buf.toByteArray();
    }

    public static byte[] createSupportedGroupsExtension(Vector namedGroups) throws IOException {
        if (namedGroups == null || namedGroups.isEmpty()) {
            throw new TlsFatalAlert(80);
        }
        int count = namedGroups.size();
        int[] values = new int[count];
        for (int i = 0; i < count; ++i) {
            values[i] = (Integer)namedGroups.elementAt(i);
        }
        return TlsUtils.encodeUint16ArrayWithUint16Length(values);
    }

    public static byte[] createTruncatedHMacExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createTrustedCAKeysExtensionClient(Vector trustedAuthoritiesList) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        TlsUtils.writeUint16(0, buf);
        for (int i = 0; i < trustedAuthoritiesList.size(); ++i) {
            TrustedAuthority entry = (TrustedAuthority)trustedAuthoritiesList.elementAt(i);
            entry.encode(buf);
        }
        int length = buf.size() - 2;
        TlsUtils.checkUint16(length);
        byte[] extensionData = buf.toByteArray();
        TlsUtils.writeUint16(length, extensionData, 0);
        return extensionData;
    }

    public static byte[] createTrustedCAKeysExtensionServer() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    private static boolean readEmptyExtensionData(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        if (extensionData.length != 0) {
            throw new TlsFatalAlert(47);
        }
        return true;
    }

    public static short[] readCertificateTypeExtensionClient(byte[] extensionData) throws IOException {
        short[] certificateTypes = TlsUtils.decodeUint8ArrayWithUint8Length(extensionData);
        if (certificateTypes.length < 1) {
            throw new TlsFatalAlert(50);
        }
        return certificateTypes;
    }

    public static short readCertificateTypeExtensionServer(byte[] extensionData) throws IOException {
        return TlsUtils.decodeUint8(extensionData);
    }

    public static boolean readClientCertificateURLExtension(byte[] extensionData) throws IOException {
        return TlsExtensionsUtils.readEmptyExtensionData(extensionData);
    }

    public static boolean readEncryptThenMACExtension(byte[] extensionData) throws IOException {
        return TlsExtensionsUtils.readEmptyExtensionData(extensionData);
    }

    public static boolean readExtendedMasterSecretExtension(byte[] extensionData) throws IOException {
        return TlsExtensionsUtils.readEmptyExtensionData(extensionData);
    }

    public static HeartbeatExtension readHeartbeatExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(extensionData);
        HeartbeatExtension heartbeatExtension = HeartbeatExtension.parse(buf);
        TlsProtocol.assertEmpty(buf);
        return heartbeatExtension;
    }

    public static short readMaxFragmentLengthExtension(byte[] extensionData) throws IOException {
        return TlsUtils.decodeUint8(extensionData);
    }

    public static int readPaddingExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        for (int i = 0; i < extensionData.length; ++i) {
            if (extensionData[i] == 0) continue;
            throw new TlsFatalAlert(47);
        }
        return extensionData.length;
    }

    public static ServerNameList readServerNameExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(extensionData);
        ServerNameList serverNameList = ServerNameList.parse(buf);
        TlsProtocol.assertEmpty(buf);
        return serverNameList;
    }

    public static CertificateStatusRequest readStatusRequestExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(extensionData);
        CertificateStatusRequest statusRequest = CertificateStatusRequest.parse(buf);
        TlsProtocol.assertEmpty(buf);
        return statusRequest;
    }

    public static int[] readSupportedGroupsExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(extensionData);
        int length = TlsUtils.readUint16(buf);
        if (length < 2 || (length & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int[] namedGroups = TlsUtils.readUint16Array(length / 2, buf);
        TlsProtocol.assertEmpty(buf);
        return namedGroups;
    }

    public static boolean readTruncatedHMacExtension(byte[] extensionData) throws IOException {
        return TlsExtensionsUtils.readEmptyExtensionData(extensionData);
    }

    public static Vector readTrustedCAKeysExtensionClient(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(extensionData);
        int length = TlsUtils.readUint16(buf);
        if (length != extensionData.length - 2) {
            throw new TlsFatalAlert(50);
        }
        Vector<TrustedAuthority> trusted_authorities_list = new Vector<TrustedAuthority>();
        while (buf.available() > 0) {
            TrustedAuthority entry = TrustedAuthority.parse(buf);
            trusted_authorities_list.addElement(entry);
        }
        return trusted_authorities_list;
    }

    public static boolean readTrustedCAKeysExtensionServer(byte[] extensionData) throws IOException {
        return TlsExtensionsUtils.readEmptyExtensionData(extensionData);
    }
}

