/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DigestInputBuffer;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsSM2Utils;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcSM2TlsCredentialedSignerAndDecryptor;
import org.bouncycastle.util.encoders.Base64;

public class TlsSM2KeyExchange
extends AbstractTlsKeyExchange {
    protected BcSM2TlsCredentialedSignerAndDecryptor serverCredentials = null;
    protected Certificate serverCertificate;
    protected TlsSecret preMasterSecret;
    protected TlsVerifier verifier;

    public TlsSM2KeyExchange(Vector supportedSignatureAlgorithms) {
        super(26, supportedSignatureAlgorithms);
    }

    @Override
    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (!(serverCredentials instanceof BcSM2TlsCredentialedSignerAndDecryptor)) {
            throw new TlsFatalAlert(80);
        }
        this.serverCredentials = (BcSM2TlsCredentialedSignerAndDecryptor)serverCredentials;
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        this.checkServerCertSigAlg(serverCertificate);
        for (TlsCertificate tlsCertificate : serverCertificate.getCertificateList()) {
            System.out.println("IMSSDK, serverCertificate:" + Base64.toBase64String((byte[])tlsCertificate.getEncoded()));
        }
        if (null == serverCertificate.getCertificateAt(1).useInRole(0, this.keyExchange)) {
            throw new TlsFatalAlert(43);
        }
        this.serverCertificate = serverCertificate;
        System.out.println("IMSSDK, keyExchange:" + this.keyExchange);
        this.verifier = serverCertificate.getCertificateAt(0).createVerifier(TlsUtils.getSignatureAlgorithm(this.keyExchange));
    }

    @Override
    public short[] getClientCertificateTypes() {
        return new short[]{1, 2, 64};
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        if (!(clientCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        DigestInputBuffer buf = new DigestInputBuffer();
        buf.write(this.serverCredentials.getCertificate().getCertificateAt(1).getEncoded());
        DigitallySigned digitallySigned = TlsUtils.generateServerKeyExchangeSignature(this.context, this.serverCredentials, buf);
        return digitallySigned.signature;
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        System.out.println("IMSSDK, processServerKeyExchange");
        byte[] signature = TlsUtils.readOpaque16(input);
        System.out.println("IMSSDK, signature:" + Base64.toBase64String((byte[])signature));
        DigitallySigned digitallySigned = new DigitallySigned(new SignatureAndHashAlgorithm(7, 4), signature);
        DigestInputBuffer buf = new DigestInputBuffer();
        byte[] certBytes = this.serverCertificate.getCertificateAt(1).getEncoded();
        byte[] finalCertBytes = new byte[certBytes.length + 3];
        finalCertBytes[0] = (byte)(certBytes.length >>> 16 & 0xFF);
        finalCertBytes[1] = (byte)(certBytes.length >>> 8 & 0xFF);
        finalCertBytes[2] = (byte)(certBytes.length & 0xFF);
        System.arraycopy(certBytes, 0, finalCertBytes, 3, certBytes.length);
        buf.write(finalCertBytes);
        TlsUtils.verifyServerKeyExchangeSignature(this.context, this.verifier, buf, digitallySigned);
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        this.preMasterSecret = TlsSM2Utils.generateEncryptedPreMasterSecret(this.context, this.serverCertificate.getCertificateAt(1), output);
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        byte[] encryptedPreMasterSecret = TlsUtils.readOpaque16(input);
        this.preMasterSecret = this.serverCredentials.decrypt(new TlsCryptoParameters(this.context), encryptedPreMasterSecret);
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        TlsSecret tmp = this.preMasterSecret;
        this.preMasterSecret = null;
        return tmp;
    }
}

