/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.util.Arrays;

public class TlsAEADCipher
implements TlsCipher {
    public static final int NONCE_RFC5288 = 1;
    public static final int NONCE_RFC7905 = 2;
    protected final TlsCryptoParameters cryptoParams;
    protected final int macSize;
    protected final int record_iv_length;
    protected final TlsAEADCipherImpl decryptCipher;
    protected final TlsAEADCipherImpl encryptCipher;
    protected final byte[] encryptImplicitNonce;
    protected final byte[] decryptImplicitNonce;
    protected final int nonceMode;

    public TlsAEADCipher(TlsCryptoParameters cryptoParams, TlsAEADCipherImpl encryptCipher, TlsAEADCipherImpl decryptCipher, int cipherKeySize, int macSize) throws IOException {
        this(cryptoParams, encryptCipher, decryptCipher, cipherKeySize, macSize, 1);
    }

    public TlsAEADCipher(TlsCryptoParameters cryptoParams, TlsAEADCipherImpl encryptCipher, TlsAEADCipherImpl decryptCipher, int cipherKeySize, int macSize, int nonceMode) throws IOException {
        TlsAEADCipherImpl serverCipher;
        TlsAEADCipherImpl clientCipher;
        int fixed_iv_length;
        if (!TlsImplUtils.isTLSv12(cryptoParams)) {
            throw new TlsFatalAlert(80);
        }
        this.nonceMode = nonceMode;
        switch (nonceMode) {
            case 1: {
                fixed_iv_length = 4;
                this.record_iv_length = 8;
                break;
            }
            case 2: {
                fixed_iv_length = 12;
                this.record_iv_length = 0;
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        this.cryptoParams = cryptoParams;
        this.macSize = macSize;
        this.encryptCipher = encryptCipher;
        this.decryptCipher = decryptCipher;
        if (cryptoParams.isServer()) {
            clientCipher = decryptCipher;
            serverCipher = encryptCipher;
        } else {
            clientCipher = encryptCipher;
            serverCipher = decryptCipher;
        }
        int key_block_size = 2 * cipherKeySize + 2 * fixed_iv_length;
        byte[] key_block = TlsImplUtils.calculateKeyBlock(cryptoParams, key_block_size);
        int offset = 0;
        clientCipher.setKey(key_block, offset, cipherKeySize);
        serverCipher.setKey(key_block, offset += cipherKeySize, cipherKeySize);
        byte[] client_write_IV = Arrays.copyOfRange((byte[])key_block, (int)(offset += cipherKeySize), (int)(offset + fixed_iv_length));
        byte[] server_write_IV = Arrays.copyOfRange((byte[])key_block, (int)(offset += fixed_iv_length), (int)(offset + fixed_iv_length));
        if ((offset += fixed_iv_length) != key_block_size) {
            throw new TlsFatalAlert(80);
        }
        if (cryptoParams.isServer()) {
            this.encryptImplicitNonce = server_write_IV;
            this.decryptImplicitNonce = client_write_IV;
        } else {
            this.encryptImplicitNonce = client_write_IV;
            this.decryptImplicitNonce = server_write_IV;
        }
        byte[] dummyNonce = new byte[fixed_iv_length + this.record_iv_length];
        this.encryptCipher.init(dummyNonce, macSize, null);
        this.decryptCipher.init(dummyNonce, macSize, null);
    }

    @Override
    public int getCiphertextLimit(int plaintextLimit) {
        return plaintextLimit + this.macSize + this.record_iv_length;
    }

    @Override
    public int getPlaintextLimit(int ciphertextLimit) {
        return ciphertextLimit - this.macSize - this.record_iv_length;
    }

    @Override
    public byte[] encodePlaintext(long seqNo, short type, byte[] plaintext, int offset, int len) throws IOException {
        byte[] nonce = new byte[this.encryptImplicitNonce.length + this.record_iv_length];
        switch (this.nonceMode) {
            case 1: {
                System.arraycopy(this.encryptImplicitNonce, 0, nonce, 0, this.encryptImplicitNonce.length);
                TlsUtils.writeUint64(seqNo, nonce, this.encryptImplicitNonce.length);
                break;
            }
            case 2: {
                TlsUtils.writeUint64(seqNo, nonce, nonce.length - 8);
                for (int i = 0; i < this.encryptImplicitNonce.length; ++i) {
                    int n = i;
                    nonce[n] = (byte)(nonce[n] ^ this.encryptImplicitNonce[i]);
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        int plaintextOffset = offset;
        int plaintextLength = len;
        int ciphertextLength = this.encryptCipher.getOutputSize(plaintextLength);
        byte[] output = new byte[this.record_iv_length + ciphertextLength];
        if (this.record_iv_length != 0) {
            System.arraycopy(nonce, nonce.length - this.record_iv_length, output, 0, this.record_iv_length);
        }
        int outputPos = this.record_iv_length;
        byte[] additionalData = this.getAdditionalData(seqNo, type, plaintextLength);
        try {
            this.encryptCipher.init(nonce, this.macSize, additionalData);
            outputPos += this.encryptCipher.doFinal(plaintext, plaintextOffset, plaintextLength, output, outputPos);
        }
        catch (Exception e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
        if (outputPos != output.length) {
            throw new TlsFatalAlert(80);
        }
        return output;
    }

    @Override
    public byte[] decodeCiphertext(long seqNo, short type, byte[] ciphertext, int offset, int len) throws IOException {
        if (this.getPlaintextLimit(len) < 0) {
            throw new TlsFatalAlert(50);
        }
        byte[] nonce = new byte[this.decryptImplicitNonce.length + this.record_iv_length];
        switch (this.nonceMode) {
            case 1: {
                System.arraycopy(this.decryptImplicitNonce, 0, nonce, 0, this.decryptImplicitNonce.length);
                System.arraycopy(ciphertext, offset, nonce, nonce.length - this.record_iv_length, this.record_iv_length);
                break;
            }
            case 2: {
                TlsUtils.writeUint64(seqNo, nonce, nonce.length - 8);
                for (int i = 0; i < this.decryptImplicitNonce.length; ++i) {
                    int n = i;
                    nonce[n] = (byte)(nonce[n] ^ this.decryptImplicitNonce[i]);
                }
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
        int ciphertextOffset = offset + this.record_iv_length;
        int ciphertextLength = len - this.record_iv_length;
        int plaintextLength = this.decryptCipher.getOutputSize(ciphertextLength);
        byte[] output = new byte[plaintextLength];
        int outputPos = 0;
        byte[] additionalData = this.getAdditionalData(seqNo, type, plaintextLength);
        try {
            this.decryptCipher.init(nonce, this.macSize, additionalData);
            outputPos += this.decryptCipher.doFinal(ciphertext, ciphertextOffset, ciphertextLength, output, outputPos);
        }
        catch (Exception e) {
            throw new TlsFatalAlert(20, (Throwable)e);
        }
        if (outputPos != output.length) {
            throw new TlsFatalAlert(80);
        }
        return output;
    }

    protected byte[] getAdditionalData(long seqNo, short type, int len) throws IOException {
        byte[] additional_data = new byte[13];
        TlsUtils.writeUint64(seqNo, additional_data, 0);
        TlsUtils.writeUint8(type, additional_data, 8);
        TlsUtils.writeVersion(this.cryptoParams.getServerVersion(), additional_data, 9);
        TlsUtils.writeUint16(len, additional_data, 11);
        return additional_data;
    }
}

