/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.test;

import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.agreement.srp.SRP6VerifierGenerator;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.tls.AlertDescription;
import org.bouncycastle.tls.AlertLevel;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SRPTlsServer;
import org.bouncycastle.tls.SimulatedTlsSRPIdentityManager;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsSRPIdentityManager;
import org.bouncycastle.tls.TlsSRPLoginParameters;
import org.bouncycastle.tls.crypto.SRP6Group;
import org.bouncycastle.tls.crypto.SRP6StandardGroups;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsSRPConfig;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.test.TlsTestUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

class MockSRPTlsServer
extends SRPTlsServer {
    static final SRP6Group TEST_GROUP = SRP6StandardGroups.rfc5054_1024;
    static final byte[] TEST_IDENTITY = Strings.toUTF8ByteArray((String)"client");
    static final byte[] TEST_PASSWORD = Strings.toUTF8ByteArray((String)"password");
    static final byte[] TEST_SALT = Strings.toUTF8ByteArray((String)"salt");
    static final byte[] TEST_SEED_KEY = Strings.toUTF8ByteArray((String)"seed_key");

    MockSRPTlsServer() throws IOException {
        super((TlsCrypto)new BcTlsCrypto(new SecureRandom()), new MyIdentityManager(new BcTlsCrypto(new SecureRandom())));
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS-SRP server raised alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
        if (message != null) {
            out.println("> " + message);
        }
        if (cause != null) {
            cause.printStackTrace(out);
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS-SRP server received alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
    }

    @Override
    public void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        byte[] srpIdentity = this.context.getSecurityParameters().getSRPIdentity();
        if (srpIdentity != null) {
            String name = Strings.fromUTF8ByteArray((byte[])srpIdentity);
            System.out.println("TLS-SRP server completed handshake for SRP identity: " + name);
        }
    }

    @Override
    protected ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.TLSv12;
    }

    @Override
    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion serverVersion = super.getServerVersion();
        System.out.println("TLS-SRP server negotiated " + serverVersion);
        return serverVersion;
    }

    @Override
    protected TlsCredentialedSigner getDSASignerCredentials() throws IOException {
        return TlsTestUtils.loadSignerCredentials(this.context, this.supportedSignatureAlgorithms, (short)2, "x509-server-dsa.pem", "x509-server-key-dsa.pem");
    }

    @Override
    protected TlsCredentialedSigner getRSASignerCredentials() throws IOException {
        return TlsTestUtils.loadSignerCredentials(this.context, this.supportedSignatureAlgorithms, (short)1, "x509-server-rsa-sign.pem", "x509-server-key-rsa-sign.pem");
    }

    static class MyIdentityManager
    implements TlsSRPIdentityManager {
        protected SimulatedTlsSRPIdentityManager unknownIdentityManager;

        MyIdentityManager(TlsCrypto crypto) throws IOException {
            this.unknownIdentityManager = SimulatedTlsSRPIdentityManager.getRFC5054Default(crypto, TEST_GROUP, TEST_SEED_KEY);
        }

        @Override
        public TlsSRPLoginParameters getLoginParameters(byte[] identity) {
            if (Arrays.areEqual((byte[])TEST_IDENTITY, (byte[])identity)) {
                SRP6VerifierGenerator verifierGenerator = new SRP6VerifierGenerator();
                verifierGenerator.init(TEST_GROUP.getN(), TEST_GROUP.getG(), (Digest)new SHA1Digest());
                BigInteger verifier = verifierGenerator.generateVerifier(TEST_SALT, identity, TEST_PASSWORD);
                TlsSRPConfig srpConfig = new TlsSRPConfig();
                srpConfig.setExplicitNG(new BigInteger[]{TEST_GROUP.getN(), TEST_GROUP.getG()});
                return new TlsSRPLoginParameters(srpConfig, verifier, TEST_SALT);
            }
            return this.unknownIdentityManager.getLoginParameters(identity);
        }
    }
}

