/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.tsp;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.DERTaggedObject;

public class Accuracy
extends ASN1Encodable {
    DERInteger seconds;
    DERInteger millis;
    DERInteger micros;
    protected static final int MIN_MILLIS = 1;
    protected static final int MAX_MILLIS = 999;
    protected static final int MIN_MICROS = 1;
    protected static final int MAX_MICROS = 999;

    protected Accuracy() {
    }

    public Accuracy(DERInteger seconds, DERInteger millis, DERInteger micros) {
        this.seconds = seconds;
        if (millis != null && (millis.getValue().intValue() < 1 || millis.getValue().intValue() > 999)) {
            throw new IllegalArgumentException("Invalid millis field : not in (1..999)");
        }
        this.millis = millis;
        if (micros != null && (micros.getValue().intValue() < 1 || micros.getValue().intValue() > 999)) {
            throw new IllegalArgumentException("Invalid micros field : not in (1..999)");
        }
        this.micros = micros;
    }

    public Accuracy(ASN1Sequence seq) {
        this.seconds = null;
        this.millis = null;
        this.micros = null;
        int i = 0;
        while (i < seq.size()) {
            if (seq.getObjectAt(i) instanceof DERInteger) {
                this.seconds = (DERInteger)seq.getObjectAt(i);
            } else if (seq.getObjectAt(i) instanceof DERTaggedObject) {
                DERTaggedObject extra = (DERTaggedObject)seq.getObjectAt(i);
                switch (extra.getTagNo()) {
                    case 0: {
                        this.millis = DERInteger.getInstance(extra, false);
                        if (this.millis.getValue().intValue() >= 1 && this.millis.getValue().intValue() <= 999) break;
                        throw new IllegalArgumentException("Invalid millis field : not in (1..999).");
                    }
                    case 1: {
                        this.micros = DERInteger.getInstance(extra, false);
                        if (this.micros.getValue().intValue() >= 1 && this.micros.getValue().intValue() <= 999) break;
                        throw new IllegalArgumentException("Invalid micros field : not in (1..999).");
                    }
                    default: {
                        throw new IllegalArgumentException("Invalig tag number");
                    }
                }
            }
            ++i;
        }
    }

    public static Accuracy getInstance(Object o) {
        if (o == null || o instanceof Accuracy) {
            return (Accuracy)o;
        }
        if (o instanceof ASN1Sequence) {
            return new Accuracy((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Unknown object in 'Accuracy' factory : " + o.getClass().getName() + ".");
    }

    public DERInteger getSeconds() {
        return this.seconds;
    }

    public DERInteger getMillis() {
        return this.millis;
    }

    public DERInteger getMicros() {
        return this.micros;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.seconds != null) {
            v.add(this.seconds);
        }
        if (this.millis != null) {
            v.add(new DERTaggedObject(false, 0, this.millis));
        }
        if (this.micros != null) {
            v.add(new DERTaggedObject(false, 1, this.micros));
        }
        return new DERSequence(v);
    }
}

