/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider;

import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class FastRandom
extends Random {
    private static final long serialVersionUID = 3609667680271768782L;
    private static SecureRandom sRan = new SecureRandom();
    private static int bufsize = 0x200000;
    private static int ranBlockSize = 16;
    private static byte[] ranbuf = new byte[bufsize];
    private static AtomicInteger ranPos = new AtomicInteger(0);
    private static boolean needRestBuff = false;
    private static Thread randomReseter;

    private static synchronized byte nextByteFromBuffer() {
        int pos = ranPos.getAndAdd(1);
        if (pos >= bufsize) {
            ranPos.set(0);
            pos = 0;
        }
        if (pos == bufsize / 2) {
            needRestBuff = true;
        }
        return ranbuf[pos];
    }

    public void nextBytes(byte[] ran) {
        super.nextBytes(ran);
        byte r = FastRandom.nextByteFromBuffer();
        int i = 0;
        while (i < ran.length) {
            int n = i;
            ran[n] = (byte)(ran[n] ^ r);
            if ((i + 1) % ranBlockSize == 0 && i + 1 < ran.length) {
                r = FastRandom.nextByteFromBuffer();
            }
            ++i;
        }
    }

    public FastRandom() {
        this.startGenerator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startGenerator() {
        SecureRandom secureRandom = sRan;
        synchronized (secureRandom) {
            if (randomReseter == null) {
                sRan.nextBytes(ranbuf);
                randomReseter = new Thread(new RandomBufferRester());
                randomReseter.setName("Random Number Generator");
                randomReseter.setDaemon(true);
                randomReseter.start();
            }
        }
    }

    private class RandomBufferRester
    implements Runnable {
        private RandomBufferRester() {
        }

        public void run() {
            while (true) {
                if (needRestBuff) {
                    byte[] tmpr = new byte[bufsize];
                    sRan.nextBytes(tmpr);
                    ranbuf = tmpr;
                    needRestBuff = false;
                }
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

