/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider;

import cn.com.infosec.asn1.cryptopro.CryptoProObjectIdentifiers;
import cn.com.infosec.asn1.cryptopro.ECGOST3410NamedCurves;
import cn.com.infosec.asn1.nist.NISTNamedCurves;
import cn.com.infosec.asn1.sec.SECNamedCurves;
import cn.com.infosec.asn1.teletrust.TeleTrusTNamedCurves;
import cn.com.infosec.asn1.x9.X962NamedCurves;
import cn.com.infosec.asn1.x9.X9ECParameters;
import cn.com.infosec.crypto.AsymmetricCipherKeyPair;
import cn.com.infosec.crypto.generators.DHBasicKeyPairGenerator;
import cn.com.infosec.crypto.generators.DHParametersGenerator;
import cn.com.infosec.crypto.generators.DSAKeyPairGenerator;
import cn.com.infosec.crypto.generators.DSAParametersGenerator;
import cn.com.infosec.crypto.generators.ECKeyPairGenerator;
import cn.com.infosec.crypto.generators.ElGamalKeyPairGenerator;
import cn.com.infosec.crypto.generators.ElGamalParametersGenerator;
import cn.com.infosec.crypto.generators.GOST3410KeyPairGenerator;
import cn.com.infosec.crypto.generators.RSAKeyPairGenerator;
import cn.com.infosec.crypto.params.DHKeyGenerationParameters;
import cn.com.infosec.crypto.params.DHParameters;
import cn.com.infosec.crypto.params.DHPrivateKeyParameters;
import cn.com.infosec.crypto.params.DHPublicKeyParameters;
import cn.com.infosec.crypto.params.DSAKeyGenerationParameters;
import cn.com.infosec.crypto.params.DSAParameters;
import cn.com.infosec.crypto.params.DSAPrivateKeyParameters;
import cn.com.infosec.crypto.params.DSAPublicKeyParameters;
import cn.com.infosec.crypto.params.ECDomainParameters;
import cn.com.infosec.crypto.params.ECKeyGenerationParameters;
import cn.com.infosec.crypto.params.ECPrivateKeyParameters;
import cn.com.infosec.crypto.params.ECPublicKeyParameters;
import cn.com.infosec.crypto.params.ElGamalKeyGenerationParameters;
import cn.com.infosec.crypto.params.ElGamalParameters;
import cn.com.infosec.crypto.params.ElGamalPrivateKeyParameters;
import cn.com.infosec.crypto.params.ElGamalPublicKeyParameters;
import cn.com.infosec.crypto.params.GOST3410KeyGenerationParameters;
import cn.com.infosec.crypto.params.GOST3410Parameters;
import cn.com.infosec.crypto.params.GOST3410PrivateKeyParameters;
import cn.com.infosec.crypto.params.GOST3410PublicKeyParameters;
import cn.com.infosec.crypto.params.RSAKeyGenerationParameters;
import cn.com.infosec.crypto.params.RSAKeyParameters;
import cn.com.infosec.crypto.params.RSAPrivateCrtKeyParameters;
import cn.com.infosec.jce.provider.EC5Util;
import cn.com.infosec.jce.provider.JCEDHPrivateKey;
import cn.com.infosec.jce.provider.JCEDHPublicKey;
import cn.com.infosec.jce.provider.JCEECPrivateKey;
import cn.com.infosec.jce.provider.JCEECPublicKey;
import cn.com.infosec.jce.provider.JCEElGamalPrivateKey;
import cn.com.infosec.jce.provider.JCEElGamalPublicKey;
import cn.com.infosec.jce.provider.JCERSAPrivateCrtKey;
import cn.com.infosec.jce.provider.JCERSAPublicKey;
import cn.com.infosec.jce.provider.JDKDSAPrivateKey;
import cn.com.infosec.jce.provider.JDKDSAPublicKey;
import cn.com.infosec.jce.provider.JDKGOST3410PrivateKey;
import cn.com.infosec.jce.provider.JDKGOST3410PublicKey;
import cn.com.infosec.jce.provider.ProviderUtil;
import cn.com.infosec.jce.spec.ECNamedCurveSpec;
import cn.com.infosec.jce.spec.ElGamalParameterSpec;
import cn.com.infosec.jce.spec.GOST3410ParameterSpec;
import cn.com.infosec.jce.spec.GOST3410PublicKeyParameterSetSpec;
import cn.com.infosec.math.ec.ECCurve;
import cn.com.infosec.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Hashtable;
import javax.crypto.spec.DHParameterSpec;

public abstract class JDKKeyPairGenerator
extends KeyPairGenerator {
    public JDKKeyPairGenerator(String algorithmName) {
        super(algorithmName);
    }

    public abstract void initialize(int var1, SecureRandom var2);

    public abstract KeyPair generateKeyPair();

    public static class DH
    extends JDKKeyPairGenerator {
        DHKeyGenerationParameters param;
        DHBasicKeyPairGenerator engine = new DHBasicKeyPairGenerator();
        int strength = 1024;
        int certainty = 20;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;

        public DH() {
            super("DH");
        }

        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec");
            }
            DHParameterSpec dhParams = (DHParameterSpec)params;
            this.param = new DHKeyGenerationParameters(random, new DHParameters(dhParams.getP(), dhParams.getG(), null, dhParams.getL()));
            this.engine.init(this.param);
            this.initialised = true;
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                DHParametersGenerator pGen = new DHParametersGenerator();
                pGen.init(this.strength, this.certainty, this.random);
                this.param = new DHKeyGenerationParameters(this.random, pGen.generateParameters());
                this.engine.init(this.param);
                this.initialised = true;
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            DHPublicKeyParameters pub = (DHPublicKeyParameters)pair.getPublic();
            DHPrivateKeyParameters priv = (DHPrivateKeyParameters)pair.getPrivate();
            return new KeyPair(new JCEDHPublicKey(pub), new JCEDHPrivateKey(priv));
        }
    }

    public static class DSA
    extends JDKKeyPairGenerator {
        DSAKeyGenerationParameters param;
        DSAKeyPairGenerator engine = new DSAKeyPairGenerator();
        int strength = 1024;
        int certainty = 20;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;

        public DSA() {
            super("DSA");
        }

        public void initialize(int strength, SecureRandom random) {
            if (strength < 512 || strength > 1024 || strength % 64 != 0) {
                throw new InvalidParameterException("strength must be from 512 - 1024 and a multiple of 64");
            }
            this.strength = strength;
            this.random = random;
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof DSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a DSAParameterSpec");
            }
            DSAParameterSpec dsaParams = (DSAParameterSpec)params;
            this.param = new DSAKeyGenerationParameters(random, new DSAParameters(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG()));
            this.engine.init(this.param);
            this.initialised = true;
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                DSAParametersGenerator pGen = new DSAParametersGenerator();
                pGen.init(this.strength, this.certainty, this.random);
                this.param = new DSAKeyGenerationParameters(this.random, pGen.generateParameters());
                this.engine.init(this.param);
                this.initialised = true;
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            DSAPublicKeyParameters pub = (DSAPublicKeyParameters)pair.getPublic();
            DSAPrivateKeyParameters priv = (DSAPrivateKeyParameters)pair.getPrivate();
            return new KeyPair(new JDKDSAPublicKey(pub), new JDKDSAPrivateKey(priv));
        }
    }

    public static class EC
    extends JDKKeyPairGenerator {
        ECKeyGenerationParameters param;
        ECKeyPairGenerator engine = new ECKeyPairGenerator();
        Object ecParams = null;
        int strength = 239;
        int certainty = 50;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;
        String algorithm;
        private static Hashtable ecParameters = new Hashtable();

        static {
            ecParameters.put(new Integer(192), new ECGenParameterSpec("prime192v1"));
            ecParameters.put(new Integer(239), new ECGenParameterSpec("prime239v1"));
            ecParameters.put(new Integer(256), new ECGenParameterSpec("prime256v1"));
        }

        public EC() {
            super("EC");
            this.algorithm = "EC";
        }

        public EC(String algorithm) {
            super(algorithm);
            this.algorithm = algorithm;
        }

        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
            this.ecParams = ecParameters.get(new Integer(strength));
            if (this.ecParams != null) {
                try {
                    this.initialize((ECGenParameterSpec)this.ecParams, random);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new InvalidParameterException("key size not configurable.");
                }
            } else {
                throw new InvalidParameterException("unknown key size.");
            }
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (params instanceof cn.com.infosec.jce.spec.ECParameterSpec) {
                cn.com.infosec.jce.spec.ECParameterSpec p = (cn.com.infosec.jce.spec.ECParameterSpec)params;
                this.ecParams = params;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params instanceof ECParameterSpec) {
                ECParameterSpec p = (ECParameterSpec)params;
                this.ecParams = params;
                ECCurve curve = EC5Util.convertCurve(p.getCurve());
                ECPoint g = EC5Util.convertPoint(curve, p.getGenerator(), false);
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(curve, g, p.getOrder(), BigInteger.valueOf(p.getCofactor())), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params instanceof ECGenParameterSpec) {
                Object ecP;
                if (this.algorithm.equals("ECGOST3410")) {
                    ecP = ECGOST3410NamedCurves.getByName(((ECGenParameterSpec)params).getName());
                    if (ecP == null) {
                        throw new InvalidAlgorithmParameterException("unknown curve name: " + ((ECGenParameterSpec)params).getName());
                    }
                    this.ecParams = new ECNamedCurveSpec(((ECGenParameterSpec)params).getName(), ((ECDomainParameters)ecP).getCurve(), ((ECDomainParameters)ecP).getG(), ((ECDomainParameters)ecP).getN(), ((ECDomainParameters)ecP).getH(), ((ECDomainParameters)ecP).getSeed());
                } else {
                    ecP = X962NamedCurves.getByName(((ECGenParameterSpec)params).getName());
                    if (ecP == null) {
                        ecP = SECNamedCurves.getByName(((ECGenParameterSpec)params).getName());
                        if (ecP == null) {
                            ecP = NISTNamedCurves.getByName(((ECGenParameterSpec)params).getName());
                        }
                        if (ecP == null) {
                            ecP = TeleTrusTNamedCurves.getByName(((ECGenParameterSpec)params).getName());
                        }
                        if (ecP == null) {
                            throw new InvalidAlgorithmParameterException("unknown curve name: " + ((ECGenParameterSpec)params).getName());
                        }
                    }
                    this.ecParams = new ECNamedCurveSpec(((ECGenParameterSpec)params).getName(), ((X9ECParameters)ecP).getCurve(), ((X9ECParameters)ecP).getG(), ((X9ECParameters)ecP).getN(), ((X9ECParameters)ecP).getH(), ((X9ECParameters)ecP).getSeed());
                }
                ECParameterSpec p = (ECParameterSpec)this.ecParams;
                ECCurve curve = EC5Util.convertCurve(p.getCurve());
                ECPoint g = EC5Util.convertPoint(curve, p.getGenerator(), false);
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(curve, g, p.getOrder(), BigInteger.valueOf(p.getCofactor())), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params == null && ProviderUtil.getEcImplicitlyCa() != null) {
                cn.com.infosec.jce.spec.ECParameterSpec p = ProviderUtil.getEcImplicitlyCa();
                this.ecParams = params;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else {
                if (params == null && ProviderUtil.getEcImplicitlyCa() == null) {
                    throw new InvalidAlgorithmParameterException("null parameter passed by no implicitCA set");
                }
                throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec");
            }
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                throw new IllegalStateException("EC Key Pair Generator not initialised");
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            ECPublicKeyParameters pub = (ECPublicKeyParameters)pair.getPublic();
            ECPrivateKeyParameters priv = (ECPrivateKeyParameters)pair.getPrivate();
            if (this.ecParams instanceof cn.com.infosec.jce.spec.ECParameterSpec) {
                cn.com.infosec.jce.spec.ECParameterSpec p = (cn.com.infosec.jce.spec.ECParameterSpec)this.ecParams;
                return new KeyPair(new JCEECPublicKey(this.algorithm, pub, p), new JCEECPrivateKey(this.algorithm, priv, p));
            }
            if (this.ecParams == null) {
                return new KeyPair(new JCEECPublicKey(this.algorithm, pub), new JCEECPrivateKey(this.algorithm, priv));
            }
            ECParameterSpec p = (ECParameterSpec)this.ecParams;
            return new KeyPair(new JCEECPublicKey(this.algorithm, pub, p), new JCEECPrivateKey(this.algorithm, priv, p));
        }
    }

    public static class ECDH
    extends EC {
        public ECDH() {
            super("ECDH");
        }
    }

    public static class ECDHC
    extends EC {
        public ECDHC() {
            super("ECDHC");
        }
    }

    public static class ECDSA
    extends EC {
        public ECDSA() {
            super("ECDSA");
        }
    }

    public static class ECGOST3410
    extends EC {
        public ECGOST3410() {
            super("ECGOST3410");
        }
    }

    public static class ElGamal
    extends JDKKeyPairGenerator {
        ElGamalKeyGenerationParameters param;
        ElGamalKeyPairGenerator engine = new ElGamalKeyPairGenerator();
        int strength = 1024;
        int certainty = 20;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;

        public ElGamal() {
            super("ElGamal");
        }

        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof ElGamalParameterSpec) && !(params instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec or an ElGamalParameterSpec");
            }
            if (params instanceof ElGamalParameterSpec) {
                ElGamalParameterSpec elParams = (ElGamalParameterSpec)params;
                this.param = new ElGamalKeyGenerationParameters(random, new ElGamalParameters(elParams.getP(), elParams.getG()));
            } else {
                DHParameterSpec dhParams = (DHParameterSpec)params;
                this.param = new ElGamalKeyGenerationParameters(random, new ElGamalParameters(dhParams.getP(), dhParams.getG(), dhParams.getL()));
            }
            this.engine.init(this.param);
            this.initialised = true;
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                ElGamalParametersGenerator pGen = new ElGamalParametersGenerator();
                pGen.init(this.strength, this.certainty, this.random);
                this.param = new ElGamalKeyGenerationParameters(this.random, pGen.generateParameters());
                this.engine.init(this.param);
                this.initialised = true;
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            ElGamalPublicKeyParameters pub = (ElGamalPublicKeyParameters)pair.getPublic();
            ElGamalPrivateKeyParameters priv = (ElGamalPrivateKeyParameters)pair.getPrivate();
            return new KeyPair(new JCEElGamalPublicKey(pub), new JCEElGamalPrivateKey(priv));
        }
    }

    public static class GOST3410
    extends JDKKeyPairGenerator {
        GOST3410KeyGenerationParameters param;
        GOST3410KeyPairGenerator engine = new GOST3410KeyPairGenerator();
        GOST3410ParameterSpec gost3410Params;
        int strength = 1024;
        SecureRandom random = null;
        boolean initialised = false;

        public GOST3410() {
            super("GOST3410");
        }

        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
        }

        private void init(GOST3410ParameterSpec gParams, SecureRandom random) {
            GOST3410PublicKeyParameterSetSpec spec = gParams.getPublicKeyParameters();
            this.param = new GOST3410KeyGenerationParameters(random, new GOST3410Parameters(spec.getP(), spec.getQ(), spec.getA()));
            this.engine.init(this.param);
            this.initialised = true;
            this.gost3410Params = gParams;
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof GOST3410ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a GOST3410ParameterSpec");
            }
            this.init((GOST3410ParameterSpec)params, random);
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                this.init(new GOST3410ParameterSpec(CryptoProObjectIdentifiers.gostR3410_94_CryptoPro_A.getId()), new SecureRandom());
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            GOST3410PublicKeyParameters pub = (GOST3410PublicKeyParameters)pair.getPublic();
            GOST3410PrivateKeyParameters priv = (GOST3410PrivateKeyParameters)pair.getPrivate();
            return new KeyPair(new JDKGOST3410PublicKey(pub, this.gost3410Params), new JDKGOST3410PrivateKey(priv, this.gost3410Params));
        }
    }

    public static class RSA
    extends JDKKeyPairGenerator {
        static final BigInteger defaultPublicExponent = BigInteger.valueOf(65537L);
        static final int defaultTests = 12;
        RSAKeyGenerationParameters param;
        RSAKeyPairGenerator engine = new RSAKeyPairGenerator();

        public RSA() {
            super("RSA");
            this.param = new RSAKeyGenerationParameters(defaultPublicExponent, new SecureRandom(), 2048, 12);
            this.engine.init(this.param);
        }

        public void initialize(int strength, SecureRandom random) {
            this.param = new RSAKeyGenerationParameters(defaultPublicExponent, random, strength, 12);
            this.engine.init(this.param);
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof RSAKeyGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a RSAKeyGenParameterSpec");
            }
            RSAKeyGenParameterSpec rsaParams = (RSAKeyGenParameterSpec)params;
            this.param = new RSAKeyGenerationParameters(rsaParams.getPublicExponent(), random, rsaParams.getKeysize(), 12);
            this.engine.init(this.param);
        }

        public KeyPair generateKeyPair() {
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            RSAKeyParameters pub = (RSAKeyParameters)pair.getPublic();
            RSAPrivateCrtKeyParameters priv = (RSAPrivateCrtKeyParameters)pair.getPrivate();
            return new KeyPair(new JCERSAPublicKey(pub), new JCERSAPrivateCrtKey(priv));
        }
    }
}

