/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.gm;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Object;
import cn.com.infosec.asn1.ASN1Primitive;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.gm.SM2EnvelopedKey;
import cn.com.infosec.asn1.x509.Certificate;

public class CSRResponse
extends ASN1Object {
    private Certificate[] signCertificate;
    private SM2EnvelopedKey encryptedPrivateKey;
    private Certificate[] encryptCertificate;

    private CSRResponse(ASN1Sequence seq) {
        ASN1Sequence signCertSeq = ASN1Sequence.getInstance(seq.getObjectAt(0));
        this.signCertificate = new Certificate[signCertSeq.size()];
        for (int i = 0; i < this.signCertificate.length; ++i) {
            this.signCertificate[i] = Certificate.getInstance(signCertSeq.getObjectAt(i));
        }
        if (seq.size() >= 2) {
            if (seq.size() == 2) {
                ASN1TaggedObject tagged = ASN1TaggedObject.getInstance(seq.getObjectAt(1));
                if (tagged.getTagNo() == 0) {
                    this.encryptedPrivateKey = SM2EnvelopedKey.getInstance(tagged.getObject());
                } else {
                    ASN1Sequence encCertSeq = ASN1Sequence.getInstance(seq.getObjectAt(1));
                    this.signCertificate = new Certificate[encCertSeq.size()];
                    System.arraycopy(this.signCertificate, 0, this.signCertificate, 0, this.signCertificate.length);
                }
            } else {
                this.encryptedPrivateKey = SM2EnvelopedKey.getInstance(ASN1TaggedObject.getInstance(seq.getObjectAt(1)));
                ASN1Sequence encCertSeq = ASN1Sequence.getInstance(seq.getObjectAt(2));
                this.signCertificate = new Certificate[encCertSeq.size()];
                System.arraycopy(this.signCertificate, 0, this.signCertificate, 0, this.signCertificate.length);
            }
        }
    }

    public CSRResponse(Certificate[] signCertificate) {
        this.signCertificate = signCertificate;
    }

    public Certificate[] getSignCertificate() {
        return this.signCertificate;
    }

    public SM2EnvelopedKey getEncryptedPrivateKey() {
        return this.encryptedPrivateKey;
    }

    public void setEncryptedPrivateKey(SM2EnvelopedKey encryptedPrivateKey) {
        this.encryptedPrivateKey = encryptedPrivateKey;
    }

    public Certificate[] getEncryptCertificate() {
        return this.encryptCertificate;
    }

    public void setEncryptCertificate(Certificate[] encryptCertificate) {
        this.encryptCertificate = encryptCertificate;
    }

    public static CSRResponse getInstance(Object o) {
        if (o instanceof CSRResponse) {
            return (CSRResponse)o;
        }
        if (o != null) {
            return new CSRResponse(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DERSequence(this.signCertificate));
        if (this.encryptedPrivateKey != null) {
            this.addOptional(v, 0, this.encryptedPrivateKey);
        }
        if (this.encryptCertificate != null) {
            this.addOptional(v, 1, new DERSequence(this.encryptCertificate));
        }
        return new DERSequence(v);
    }

    private void addOptional(ASN1EncodableVector v, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v.add(new DERTaggedObject(true, tagNo, obj));
        }
    }
}

