/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.gm;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Object;
import cn.com.infosec.asn1.ASN1Primitive;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.gm.GMObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.EncryptionScheme;
import cn.com.infosec.asn1.pkcs.KeyDerivationFunc;
import cn.com.infosec.asn1.pkcs.PBKDF2Params;
import java.util.Enumeration;

public class Q5PBESParameters
extends ASN1Object
implements GMObjectIdentifiers {
    private KeyDerivationFunc func;
    private EncryptionScheme scheme;

    public static Q5PBESParameters getInstance(Object obj) {
        if (obj instanceof Q5PBESParameters) {
            return (Q5PBESParameters)obj;
        }
        if (obj != null) {
            return new Q5PBESParameters(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public Q5PBESParameters(KeyDerivationFunc keyDevFunc, EncryptionScheme encScheme) {
        this.func = keyDevFunc;
        this.scheme = encScheme;
    }

    private Q5PBESParameters(ASN1Sequence obj) {
        Enumeration e = obj.getObjects();
        ASN1Sequence funcSeq = ASN1Sequence.getInstance(((ASN1Encodable)e.nextElement()).toASN1Primitive());
        this.func = funcSeq.getObjectAt(0).equals(id_PBKDF) ? new KeyDerivationFunc(id_PBKDF, PBKDF2Params.getInstance(funcSeq.getObjectAt(1))) : KeyDerivationFunc.getInstance(funcSeq);
        this.scheme = EncryptionScheme.getInstance(e.nextElement());
    }

    public KeyDerivationFunc getKeyDerivationFunc() {
        return this.func;
    }

    public EncryptionScheme getEncryptionScheme() {
        return this.scheme;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.func);
        v.add(this.scheme);
        return new DERSequence(v);
    }
}

