/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.gm;

import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Integer;
import cn.com.infosec.asn1.ASN1Object;
import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1Primitive;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.gm.GMObjectIdentifiers;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.util.Arrays;
import java.math.BigInteger;
import java.util.Enumeration;

public class Q5PBKDFParams
extends ASN1Object
implements GMObjectIdentifiers {
    private static final AlgorithmIdentifier algid_hmacWithSm3 = new AlgorithmIdentifier(hmac_sm3);
    private final ASN1OctetString octStr;
    private final ASN1Integer iterationCount;
    private final ASN1Integer keyLength;
    private final AlgorithmIdentifier prf;

    public static Q5PBKDFParams getInstance(Object obj) {
        if (obj instanceof Q5PBKDFParams) {
            return (Q5PBKDFParams)obj;
        }
        if (obj != null) {
            return new Q5PBKDFParams(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public Q5PBKDFParams(byte[] salt, int iterationCount) {
        this(salt, iterationCount, 0);
    }

    public Q5PBKDFParams(byte[] salt, int iterationCount, int keyLength) {
        this(salt, iterationCount, keyLength, algid_hmacWithSm3);
    }

    private Q5PBKDFParams(byte[] salt, int iterationCount, int keyLength, AlgorithmIdentifier prf) {
        this.octStr = new DEROctetString(Arrays.clone(salt));
        this.iterationCount = new ASN1Integer(iterationCount);
        this.keyLength = keyLength > 0 ? new ASN1Integer(keyLength) : null;
        this.prf = prf;
    }

    private Q5PBKDFParams(byte[] salt, int iterationCount, AlgorithmIdentifier prf) {
        this(salt, iterationCount, 0, prf);
    }

    private Q5PBKDFParams(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.octStr = (ASN1OctetString)e.nextElement();
        this.iterationCount = (ASN1Integer)e.nextElement();
        if (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof ASN1Integer) {
                this.keyLength = ASN1Integer.getInstance(o);
                o = e.hasMoreElements() ? e.nextElement() : null;
            } else {
                this.keyLength = null;
            }
            this.prf = o != null ? AlgorithmIdentifier.getInstance(o) : null;
        } else {
            this.keyLength = null;
            this.prf = null;
        }
    }

    public byte[] getSalt() {
        return this.octStr.getOctets();
    }

    public BigInteger getIterationCount() {
        return this.iterationCount.getValue();
    }

    public BigInteger getKeyLength() {
        if (this.keyLength != null) {
            return this.keyLength.getValue();
        }
        return null;
    }

    public boolean isDefaultPrf() {
        return this.prf == null || this.prf.equals(algid_hmacWithSm3);
    }

    public AlgorithmIdentifier getPrf() {
        return algid_hmacWithSm3;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.octStr);
        v.add(this.iterationCount);
        if (this.keyLength != null) {
            v.add(this.keyLength);
        }
        if (this.prf != null) {
            v.add(this.prf);
        }
        return new DERSequence(v);
    }
}

