/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.pkcs;

import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Integer;
import cn.com.infosec.asn1.ASN1Object;
import cn.com.infosec.asn1.ASN1Primitive;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1Set;
import cn.com.infosec.asn1.BERSequence;
import cn.com.infosec.asn1.cms.EncryptedContentInfo;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import java.util.Enumeration;

public class EnvelopedData
extends ASN1Object
implements PKCSObjectIdentifiers {
    private ASN1Integer version;
    private ASN1Set recipientInfos;
    private EncryptedContentInfo encryptedContentInfo;

    public static EnvelopedData getInstance(Object o) {
        if (o instanceof EnvelopedData) {
            return (EnvelopedData)o;
        }
        if (o != null) {
            return new EnvelopedData(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public EnvelopedData(ASN1Integer _version, ASN1Set _recipientInfos, EncryptedContentInfo _encryptedContentInfo, ASN1Set _certificates, ASN1Set _crls, ASN1Set _signerInfos) {
        this.version = _version;
        this.recipientInfos = _recipientInfos;
        this.encryptedContentInfo = _encryptedContentInfo;
    }

    public EnvelopedData(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.version = (ASN1Integer)e.nextElement();
        this.recipientInfos = (ASN1Set)e.nextElement();
        this.encryptedContentInfo = EncryptedContentInfo.getInstance(e.nextElement());
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public ASN1Set getRecipientInfos() {
        return this.recipientInfos;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(3);
        v.add(this.version);
        v.add(this.recipientInfos);
        v.add(this.encryptedContentInfo);
        return new BERSequence(v);
    }
}

