/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.cert.dane;

import cn.com.infosec.cert.X509CertificateHolder;
import cn.com.infosec.cert.dane.DANEEntry;
import cn.com.infosec.cert.dane.DANEEntrySelector;
import cn.com.infosec.cert.dane.DANEEntrySelectorFactory;
import cn.com.infosec.cert.dane.DANEException;
import cn.com.infosec.operator.DigestCalculator;

public class DANEEntryFactory {
    private final DANEEntrySelectorFactory selectorFactory;

    public DANEEntryFactory(DigestCalculator digestCalculator) {
        this.selectorFactory = new DANEEntrySelectorFactory(digestCalculator);
    }

    public DANEEntry createEntry(String emailAddress, X509CertificateHolder certificate) throws DANEException {
        return this.createEntry(emailAddress, 3, certificate);
    }

    public DANEEntry createEntry(String emailAddress, int certUsage, X509CertificateHolder certificate) throws DANEException {
        if (certUsage < 0 || certUsage > 3) {
            throw new DANEException("unknown certificate usage: " + certUsage);
        }
        DANEEntrySelector entrySelector = this.selectorFactory.createSelector(emailAddress);
        byte[] flags = new byte[]{(byte)certUsage, 0, 0};
        return new DANEEntry(entrySelector.getDomainName(), flags, certificate);
    }
}

